/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.validator.parser.utils.OcspUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.AppearanceCloner;
import it.actalis.ellips.capi.pades.CompareByteRangeSignature;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.StringWrap;
import it.actalis.ellips.capi.pdf.TextContainer;
import it.actalis.vol.utils.Constants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class PadesUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String FONT_REGULAR_RESOURCE = "/font/Lato-Regular.ttf";
    public static final String FONT_BOLD_RESOURCE = "/font/Lato-Bold.ttf";
    public static final String FONT_NAME = "lato";
    private static int b;
    private static boolean c;

    public static boolean isBlockedPdf(PDDocument object) {
        Object object2 = object.getDocumentCatalog().getAcroForm();
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        COSDictionary object32 = object.getDocument().getTrailer();
        if (object32 == null) {
            a.error("[initialize] trailer is null.");
            return false;
        }
        COSDictionary cOSDictionary = (COSDictionary)object32.getDictionaryObject(COSName.ROOT);
        if (cOSDictionary == null) {
            a.error("[initialize] root is null");
            return false;
        }
        cOSDictionary.getDictionaryObject("DSS");
        object2 = object2.getFields();
        if (object2 == null || object2.size() <= 0) {
            a.debug("[findSignature] no fields");
            return false;
        }
        object = PadesUtils.retrieveDssInfo((PDDocument)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            PDField pDField = (PDField)object2.next();
            PadesUtils.a(pDField, linkedList, (PadesDssInfo)object);
        }
        for (PadesSignatureInformation padesSignatureInformation : linkedList) {
            if (padesSignatureInformation.getCertificationLevel() != 1) continue;
            return true;
        }
        return false;
    }

    private static void a(PDField pDField, LinkedList<PadesSignatureInformation> linkedList, PadesDssInfo padesDssInfo) {
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (pDSignatureField.getValue() == null) {
                a.debug("[findSignature] Empty SignatureField ignored.");
            }
            if (PadesUtils.a(pDSignatureField.getCOSObject()) && !PadesUtils.a(string, linkedList)) {
                linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                a.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                PadesUtils.a((PDField)string, linkedList, padesDssInfo);
            }
        }
    }

    public static List<PDSignatureField> parseEmptyField(PDField pDField) {
        LinkedList<PDSignatureField> linkedList = new LinkedList<PDSignatureField>();
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (pDSignatureField.getValue() == null) {
                linkedList.add(pDSignatureField);
                a.debug("[findSignature] Empty SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                linkedList.addAll(PadesUtils.parseEmptyField((PDField)string));
            }
        }
        return linkedList;
    }

    private static boolean a(COSDictionary cOSDictionary) {
        COSString cOSString = (COSString)cOSDictionary.getDictionaryObject(COSName.T);
        if (cOSString != null) {
            a.debug("[initialize][isSignatureField] Signature: " + cOSString.getString());
        } else {
            a.debug("[initialize][isSignatureField] Signature: warning sigName is null");
        }
        cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(COSName.V);
        if (cOSDictionary != null) {
            if ((cOSDictionary = (COSName)cOSDictionary.getDictionaryObject(COSName.getPDFName((String)"SubFilter"))) != null) {
                if (cOSDictionary.getName().equals("adbe.x509.rsa_sha1")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.x509.rsa_sha1");
                    return true;
                }
                if (cOSDictionary.getName().equals("adbe.pkcs7.sha1")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.sha1");
                    return true;
                }
                if (cOSDictionary.getName().equals("adbe.pkcs7.detached")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.detached");
                    return true;
                }
                if (cOSDictionary.getName().equals("ETSI.CAdES.detached")) {
                    a.debug("[initialize][isSignatureField] subfilter: ETSI.CAdES.detached");
                    return true;
                }
                if (cOSDictionary.getName().equals("ETSI.RFC3161")) {
                    a.debug("[initialize][isSignatureField] subfilter: ETSI.RFC3161");
                    return true;
                }
                a.error("[initialize][isSignatureField] unknown subfilter:" + cOSDictionary);
                return true;
            }
            a.debug("[initialize][isSignatureField] Missing subfilter");
        } else {
            a.debug("[initialize][isSignatureField] is empty");
        }
        return false;
    }

    private static boolean a(String string, LinkedList<PadesSignatureInformation> linkedList) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            String string2 = linkedList.get(i).getName();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String createVisualSignatureImage(CapiPDFApparence capiPDFApparence) throws IOException {
        Object object;
        String string = PadesUtils.a(capiPDFApparence);
        int n = capiPDFApparence.getFontSize();
        boolean bl = capiPDFApparence.isScaleFont();
        float f = capiPDFApparence.getWidth();
        float f2 = capiPDFApparence.getHeight();
        BufferedImage bufferedImage = capiPDFApparence.getImage();
        BufferedImage bufferedImage2 = new BufferedImage((int)f, (int)f2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (bufferedImage != null) {
            float f3;
            float f4 = bufferedImage.getWidth();
            float f5 = bufferedImage.getHeight();
            float f6 = f2;
            float f7 = f;
            String string2 = "H";
            if (!capiPDFApparence.isOnly_image()) {
                float f8;
                f3 = f5 / f2;
                float f9 = f4 / f;
                if (f8 > f3) {
                    f6 = f2 / 2.0f;
                    string2 = "V";
                } else {
                    f7 = f / 2.0f;
                    string2 = "H";
                }
            }
            float f10 = f7;
            String string3 = string2;
            int n2 = capiPDFApparence.getResizeMode();
            f7 = f6;
            f6 = f10;
            f3 = 0.0f;
            float f11 = 0.0f;
            if (f6 < f7) {
                f4 = f5 * f6 / f4;
                f5 = f6;
                if (f4 > f7) {
                    f5 = f5 * f7 / f4;
                    f4 = f7;
                }
            } else {
                f5 = f4 * f7 / f5;
                f4 = f7;
                if (f5 > f6) {
                    f4 = f4 * f6 / f5;
                    f5 = f6;
                }
            }
            switch (n2) {
                case 1: {
                    f5 = f6;
                    f4 = f7;
                    f3 = 0.0f;
                    f11 = 0.0f;
                    break;
                }
                case 2: {
                    f3 = (f6 - f5) / 2.0f;
                    f11 = (f7 - f4) / 2.0f;
                    break;
                }
                case 3: {
                    if (string3.equalsIgnoreCase("H")) {
                        f3 = f6 - f5;
                        f11 = (f7 - f4) / 2.0f;
                        break;
                    }
                    f3 = (f6 - f5) / 2.0f;
                    f11 = 0.0f;
                    break;
                }
                case 4: {
                    if (string3.equalsIgnoreCase("H")) {
                        f3 = 0.0f;
                        f11 = (f7 - f4) / 2.0f;
                        break;
                    }
                    f3 = (f6 - f5) / 2.0f;
                    f11 = f7 * 2.0f - f4;
                }
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f11, f5, f4);
            bufferedImage = PadesUtils.a(bufferedImage, capiPDFApparence);
            boolean bl2 = capiPDFApparence.isTextBeforeImage();
            n2 = capiPDFApparence.isOnly_image() ? 1 : 0;
            String string4 = string2;
            f6 = f2;
            f5 = f;
            object = float_;
            Cloneable cloneable = n2 != 0 || !bl2 ? new Point2D.Float(((Rectangle2D.Float)object).x, ((Rectangle2D.Float)object).y) : ("H".equals(string4) ? new Point2D.Float(((Rectangle2D.Float)object).x + f5 / 2.0f, ((Rectangle2D.Float)object).y) : new Point2D.Float(((Rectangle2D.Float)object).x, ((Rectangle2D.Float)object).y + f6 / 2.0f));
            graphics2D.drawImage(bufferedImage.getScaledInstance((int)float_.width, (int)float_.height, 4), (int)cloneable.x, (int)cloneable.y, null);
            if (!capiPDFApparence.isOnly_image()) {
                cloneable = float_;
                float f12 = f2;
                f6 = f;
                boolean bl3 = capiPDFApparence.isTextBeforeImage();
                object = string2;
                Rectangle2D.Float float_2 = "H".equals(object) ? (bl3 ? new Rectangle2D.Float(0.0f, 0.0f, f6 - (((Rectangle2D.Float)cloneable).x + ((Rectangle2D.Float)cloneable).width), f12) : new Rectangle2D.Float(((Rectangle2D.Float)cloneable).x + ((Rectangle2D.Float)cloneable).width, 0.0f, f6 - (((Rectangle2D.Float)cloneable).x + ((Rectangle2D.Float)cloneable).width), f12)) : (bl3 ? new Rectangle2D.Float(0.0f, 0.0f, f6, f12 - (((Rectangle2D.Float)cloneable).y + ((Rectangle2D.Float)cloneable).height)) : new Rectangle2D.Float(0.0f, ((Rectangle2D.Float)cloneable).y + ((Rectangle2D.Float)cloneable).height, f6, f12 - (((Rectangle2D.Float)cloneable).y + ((Rectangle2D.Float)cloneable).height)));
                PadesUtils.a(capiPDFApparence.getPdDocument(), string, float_2, n, bl, graphics2D);
            }
        } else {
            object = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
            PadesUtils.a(capiPDFApparence.getPdDocument(), string, (Rectangle2D.Float)object, n, bl, graphics2D);
        }
        object = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", (OutputStream)object);
        return new String(Base64.encode((byte[])((ByteArrayOutputStream)object).toByteArray()));
    }

    private static void a(PDDocument object, String object2, Rectangle2D.Float float_, int n, boolean bl, Graphics2D graphics2D) throws IOException {
        object = PDType0Font.load((PDDocument)object, (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
        List<String> list = PadesUtils.a((String)object2);
        StringWrap stringWrap = new StringWrap();
        list = stringWrap.performWrap(list, float_.width, (PDFont)object, n);
        try {
            if (bl) {
                while (!PadesUtils.a(list, (PDFont)object, n, float_.width, float_.height) && n < 100) {
                    list = PadesUtils.a((String)object2);
                    list = stringWrap.performWrap(list, float_.width, (PDFont)object, ++n);
                }
            }
            while (PadesUtils.a(list, (PDFont)object, n, float_.width, float_.height) && n > 1) {
                list = PadesUtils.a((String)object2);
                list = stringWrap.performWrap(list, float_.width, (PDFont)object, --n);
            }
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        if (!c) {
            try {
                object = Font.createFont(0, PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont((Font)object);
                c = true;
            }
            catch (FontFormatException fontFormatException) {
                a.error(fontFormatException.getMessage(), (Throwable)fontFormatException);
            }
        }
        graphics2D.setFont(new Font(FONT_NAME, 0, n));
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        int n2 = (int)float_.y;
        for (String string : list) {
            graphics2D.drawString(string, (int)float_.x, n2 += n);
        }
    }

    public static InputStream createVisualSignature(CapiPDFApparence capiPDFApparence) throws IOException {
        ArrayList<CapiPDFApparence> arrayList = new ArrayList<CapiPDFApparence>();
        arrayList.add(capiPDFApparence);
        return PadesUtils.a(capiPDFApparence.getPdDocument(), arrayList);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addAppearanceAnnotations(PDDocument object, List<CapiPDFApparence> list) throws IOException {
        void var1_5;
        Object object2 = PadesUtils.a(object, (List<CapiPDFApparence>)var1_5);
        try {
            ScratchFile scratchFile;
            block16: {
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                Throwable throwable = null;
                try {
                    Object object3 = scratchFile;
                    object2 = object3.createBuffer((InputStream)object2);
                    object2 = new PDFParser((RandomAccessRead)object2, (ScratchFile)object3);
                    object2 = object2.parse();
                    object3 = null;
                    try {
                        AppearanceCloner appearanceCloner = new AppearanceCloner((List<CapiPDFApparence>)var1_5, (PDDocument)object, (PDDocument)object2);
                        appearanceCloner.cloneToOriginalDocument();
                        if (object2 == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            object3 = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (object2 == null) throw throwable4;
                            if (object3 == null) {
                                object2.close();
                                throw throwable4;
                            }
                            try {
                                object2.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)object3).addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    object2.close();
                }
                catch (Throwable throwable6) {
                    try {
                        object2 = throwable6;
                        throwable = throwable6;
                        throw object2;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            scratchFile.close();
                            throw throwable7;
                        }
                        try {
                            scratchFile.close();
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                            throw throwable7;
                        }
                    }
                }
            }
            scratchFile.close();
            return;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private static InputStream a(PDDocument pDDocument, List<CapiPDFApparence> object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDDocument pDDocument2 = new PDDocument();
        Throwable throwable = null;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2;
                CapiPDFApparence capiPDFApparence = (CapiPDFApparence)object.next();
                Object object3 = pDDocument.getPage(capiPDFApparence.getPage() - 1);
                b = object3.getRotation();
                PDPage pDPage = object3;
                Object object4 = capiPDFApparence;
                object3 = pDDocument2;
                capiPDFApparence = pDPage;
                Object object5 = new PDPage(capiPDFApparence.getMediaBox());
                object5.setCropBox(capiPDFApparence.getCropBox());
                object3.addPage((PDPage)object5);
                PDPage pDPage2 = object3;
                PDRectangle pDRectangle = object5.getCropBox();
                object5 = object4;
                object4 = capiPDFApparence;
                object3 = pDRectangle;
                capiPDFApparence = pDPage2;
                if (pDPage2.getDocumentCatalog().getAcroForm() == null) {
                    object2 = new PDAcroForm((PDDocument)capiPDFApparence);
                    capiPDFApparence.getDocumentCatalog().setAcroForm((PDAcroForm)object2);
                } else {
                    object2 = capiPDFApparence.getDocumentCatalog().getAcroForm();
                }
                Object object6 = new PDSignatureField((PDAcroForm)object2);
                PDAnnotationWidget pDAnnotationWidget = (PDAnnotationWidget)object6.getWidgets().get(0);
                Object object7 = object2.getFields();
                object2.setSignaturesExist(true);
                object2.setAppendOnly(true);
                object2.getCOSObject().setDirect(true);
                object7.add(object6);
                object3 = b == 90 || b == 270 ? new Rectangle2D.Float(((CapiPDFApparence)object5).getPosX(), object3.getWidth() - ((CapiPDFApparence)object5).getPosY(), ((CapiPDFApparence)object5).getWidth(), ((CapiPDFApparence)object5).getHeight()) : new Rectangle2D.Float(((CapiPDFApparence)object5).getPosX(), object3.getHeight() - ((CapiPDFApparence)object5).getPosY(), ((CapiPDFApparence)object5).getWidth(), ((CapiPDFApparence)object5).getHeight());
                CapiPDFApparence capiPDFApparence2 = object4;
                object4 = object3;
                object3 = capiPDFApparence2;
                object2 = new PDRectangle();
                object6 = object3.getCropBox();
                float f = object3.getCropBox().getLowerLeftY() - object3.getMediaBox().getLowerLeftY();
                float f2 = object3.getCropBox().getLowerLeftX() - object3.getMediaBox().getLowerLeftX();
                switch (b) {
                    case 90: {
                        object2.setLowerLeftY(((Rectangle2D.Float)object4).x + f2);
                        object2.setUpperRightY(((Rectangle2D.Float)object4).x + ((Rectangle2D.Float)object4).width + f2);
                        object2.setLowerLeftX(((Rectangle2D.Float)object4).y + f);
                        object2.setUpperRightX(((Rectangle2D.Float)object4).y + ((Rectangle2D.Float)object4).height + f);
                        break;
                    }
                    case 180: {
                        object2.setUpperRightX(object6.getWidth() - ((Rectangle2D.Float)object4).x + f2);
                        object2.setLowerLeftX(object6.getWidth() - ((Rectangle2D.Float)object4).x - ((Rectangle2D.Float)object4).width + f2);
                        object2.setLowerLeftY(((Rectangle2D.Float)object4).y + f);
                        object2.setUpperRightY(((Rectangle2D.Float)object4).y + ((Rectangle2D.Float)object4).height + f);
                        break;
                    }
                    case 270: {
                        object2.setLowerLeftY(object6.getHeight() - ((Rectangle2D.Float)object4).x - ((Rectangle2D.Float)object4).width + f2);
                        object2.setUpperRightY(object6.getHeight() - ((Rectangle2D.Float)object4).x + f2);
                        object2.setLowerLeftX(object6.getWidth() - ((Rectangle2D.Float)object4).y - ((Rectangle2D.Float)object4).height + f);
                        object2.setUpperRightX(object6.getWidth() - ((Rectangle2D.Float)object4).y + f);
                        break;
                    }
                    default: {
                        object2.setLowerLeftX(((Rectangle2D.Float)object4).x + f2);
                        object2.setUpperRightX(((Rectangle2D.Float)object4).x + ((Rectangle2D.Float)object4).width + f2);
                        object2.setLowerLeftY(object6.getHeight() - ((Rectangle2D.Float)object4).y - ((Rectangle2D.Float)object4).height + f);
                        object2.setUpperRightY(object6.getHeight() - ((Rectangle2D.Float)object4).y + f);
                    }
                }
                object3 = object2;
                pDAnnotationWidget.setRectangle((PDRectangle)object3);
                object4 = new PDStream((PDDocument)capiPDFApparence);
                object4 = new PDFormXObject((PDStream)object4);
                object2 = new PDResources();
                object4.setResources((PDResources)object2);
                object4.setFormType(1);
                object3 = new PDRectangle(object3.getWidth(), object3.getHeight());
                object2 = null;
                switch (b) {
                    case 90: {
                        object4.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                        object2 = Matrix.getScaleInstance((float)(object3.getWidth() / object3.getHeight()), (float)(object3.getHeight() / object3.getWidth()));
                        break;
                    }
                    case 180: {
                        object4.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                        break;
                    }
                    case 270: {
                        object4.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                        object2 = Matrix.getScaleInstance((float)(object3.getWidth() / object3.getHeight()), (float)(object3.getHeight() / object3.getWidth()));
                    }
                }
                object4.setBBox((PDRectangle)object3);
                object3 = new PDAppearanceDictionary();
                object3.getCOSObject().setDirect(true);
                object4 = new PDAppearanceStream(object4.getCOSObject());
                object3.setNormalAppearance((PDAppearanceStream)object4);
                pDAnnotationWidget.setAppearance((PDAppearanceDictionary)object3);
                PDPageContentStream pDPageContentStream = new PDPageContentStream((PDDocument)capiPDFApparence, (PDAppearanceStream)object4);
                PDAcroForm pDAcroForm = object2;
                object6 = capiPDFApparence;
                object2 = object5;
                object4 = pDAcroForm;
                object3 = pDPageContentStream;
                if (object4 != null) {
                    object3.transform((Matrix)object4);
                }
                object3.saveGraphicsState();
                object7 = PadesUtils.a((CapiPDFApparence)object2);
                f2 = ((CapiPDFApparence)object2).getWidth();
                float f3 = ((CapiPDFApparence)object2).getHeight();
                object4 = ((CapiPDFApparence)object2).getImage();
                if (object4 != null) {
                    float f4;
                    float f5;
                    float f6 = ((BufferedImage)object4).getWidth();
                    float f7 = ((BufferedImage)object4).getHeight();
                    float f8 = f3;
                    float f9 = f2;
                    String string = "H";
                    if (!((CapiPDFApparence)object2).isOnly_image()) {
                        float f10;
                        f5 = f7 / f3;
                        f4 = f6 / f2;
                        if (f10 > f5) {
                            f8 = f3 / 2.0f;
                            string = "V";
                        } else {
                            f9 = f2 / 2.0f;
                            string = "H";
                        }
                    }
                    float f11 = f9;
                    String string2 = string;
                    int n = ((CapiPDFApparence)object2).getResizeMode();
                    f9 = f8;
                    f8 = f11;
                    f5 = 0.0f;
                    f4 = 0.0f;
                    if (f8 < f9) {
                        f6 = f7 * f8 / f6;
                        f7 = f8;
                        if (f6 > f9) {
                            f7 = f7 * f9 / f6;
                            f6 = f9;
                        }
                    } else {
                        f7 = f6 * f9 / f7;
                        f6 = f9;
                        if (f7 > f8) {
                            f6 = f6 * f8 / f7;
                            f7 = f8;
                        }
                    }
                    switch (n) {
                        case 1: {
                            f7 = f8;
                            f6 = f9;
                            if (string2.equalsIgnoreCase("H")) {
                                f5 = 0.0f;
                                f4 = 0.0f;
                                break;
                            }
                            f5 = 0.0f;
                            f4 = f9;
                            break;
                        }
                        case 2: {
                            if (string2.equalsIgnoreCase("H")) {
                                f5 = (f8 - f7) / 2.0f;
                                f4 = (f9 - f6) / 2.0f;
                                break;
                            }
                            f5 = (f8 - f7) / 2.0f;
                            float f12 = f9;
                            f4 = f12 + (f12 - f6) / 2.0f;
                            break;
                        }
                        case 3: {
                            if (string2.equalsIgnoreCase("H")) {
                                f5 = f8 - f7;
                                f4 = (f9 - f6) / 2.0f;
                                break;
                            }
                            f5 = (f8 - f7) / 2.0f;
                            f4 = f9;
                            break;
                        }
                        case 4: {
                            if (string2.equalsIgnoreCase("H")) {
                                f5 = 0.0f;
                                f4 = (f9 - f6) / 2.0f;
                                break;
                            }
                            f5 = (f8 - f7) / 2.0f;
                            f4 = f9 * 2.0f - f6;
                        }
                    }
                    Rectangle2D.Float float_ = new Rectangle2D.Float(f5, f4, f7, f6);
                    Object object8 = object2;
                    Object object9 = object6;
                    object5 = object4;
                    Object object10 = new ByteArrayOutputStream();
                    object5 = PadesUtils.a((BufferedImage)object5, (CapiPDFApparence)object8);
                    ImageIO.write((RenderedImage)object5, "png", (OutputStream)object10);
                    PDImageXObject pDImageXObject = PDImageXObject.createFromByteArray((PDDocument)object9, (byte[])((ByteArrayOutputStream)object10).toByteArray(), (String)"png");
                    boolean bl = ((CapiPDFApparence)object2).isTextBeforeImage();
                    n = ((CapiPDFApparence)object2).isOnly_image() ? 1 : 0;
                    object10 = string;
                    f8 = f3;
                    float f13 = f2;
                    object5 = float_;
                    object4 = n != 0 || !bl ? new Point2D.Float(((Rectangle2D.Float)object5).x, ((Rectangle2D.Float)object5).y) : ("H".equals(object10) ? new Point2D.Float(((Rectangle2D.Float)object5).x + f13 / 2.0f, ((Rectangle2D.Float)object5).y) : new Point2D.Float(((Rectangle2D.Float)object5).x, ((Rectangle2D.Float)object5).y - f8 / 2.0f));
                    object3.drawImage(pDImageXObject, ((Point2D.Float)object4).x, ((Point2D.Float)object4).y, float_.width, float_.height);
                    object3.restoreGraphicsState();
                    if (!((CapiPDFApparence)object2).isOnly_image()) {
                        Rectangle2D.Float float_2 = float_;
                        float f14 = f3;
                        f8 = f2;
                        boolean bl2 = ((CapiPDFApparence)object2).isTextBeforeImage();
                        object5 = string;
                        Rectangle2D.Float float_3 = "H".equals(object5) ? (bl2 ? new Rectangle2D.Float(0.0f, f14, f8 - (float_2.x + float_2.width), f14) : new Rectangle2D.Float(float_2.x + float_2.width, f14, f8 - (float_2.x + float_2.width), f14)) : (bl2 ? new Rectangle2D.Float(0.0f, f14, f8, float_2.y) : new Rectangle2D.Float(0.0f, float_2.y, f8, float_2.y));
                        PadesUtils.a((String)object7, ((CapiPDFApparence)object2).getFontSize(), ((CapiPDFApparence)object2).isScaleFont(), float_3, (PDPageContentStream)object3, (PDDocument)object6);
                    }
                } else {
                    PadesUtils.a((String)object7, ((CapiPDFApparence)object2).getFontSize(), ((CapiPDFApparence)object2).isScaleFont(), new Rectangle2D.Float(0.0f, f3, f2, f3), (PDPageContentStream)object3, (PDDocument)object6);
                }
                object3.close();
            }
            pDDocument2.save((OutputStream)byteArrayOutputStream);
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            pDDocument2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        pDDocument2.close();
                    }
                    throw throwable3;
                }
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                return null;
            }
        }
        pDDocument2.close();
        return object;
    }

    private static BufferedImage a(BufferedImage bufferedImage, CapiPDFApparence capiPDFApparence) {
        if (!capiPDFApparence.isPDFASignature()) {
            return bufferedImage;
        }
        if (capiPDFApparence.isGray()) {
            return PadesUtils.a(bufferedImage);
        }
        return PadesUtils.b(bufferedImage);
    }

    private static void a(String object, int n, boolean bl, Rectangle2D.Float float_, PDPageContentStream pDPageContentStream, PDDocument pDDocument) throws IOException {
        pDDocument = PDType0Font.load((PDDocument)pDDocument, (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
        pDPageContentStream.beginText();
        pDPageContentStream.setNonStrokingColor(Color.black);
        StringWrap stringWrap = new StringWrap();
        pDPageContentStream.setFont((PDFont)pDDocument, (float)n);
        List<String> list = PadesUtils.a((String)object);
        list = stringWrap.performWrap(list, float_.width, (PDFont)pDDocument, n);
        try {
            if (bl) {
                while (!PadesUtils.a(list, (PDFont)pDDocument, n, float_.width, float_.height) && n < 100) {
                    list = PadesUtils.a((String)object);
                    list = stringWrap.performWrap(list, float_.width, (PDFont)pDDocument, ++n);
                }
            }
            while (PadesUtils.a(list, (PDFont)pDDocument, n, float_.width, float_.height) && n > 1) {
                list = PadesUtils.a((String)object);
                list = stringWrap.performWrap(list, float_.width, (PDFont)pDDocument, --n);
            }
            pDPageContentStream.setFont((PDFont)pDDocument, (float)n);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        pDPageContentStream.setLeading((float)n * 1.15f);
        pDPageContentStream.newLineAtOffset(float_.x, float_.y - (float)n);
        for (String string : list) {
            pDPageContentStream.showText(string);
            pDPageContentStream.newLine();
        }
        pDPageContentStream.endText();
    }

    private static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\\r?\\n");
        if (stringArray.length > 1) {
            arrayList.addAll(Arrays.asList(stringArray));
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean a(List<String> object, PDFont pDFont, int n, float f, float f2) throws IOException {
        if ((float)n * 1.15f * (float)object.size() > f2) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!(pDFont.getStringWidth(string) / 1000.0f * (float)n > f)) continue;
            return true;
        }
        return false;
    }

    private static String a(CapiPDFApparence object) {
        String string;
        Object object2;
        Object object3;
        String string2 = "";
        if (((CapiPDFApparence)object).getVisibleLabel() != null) {
            string2 = ((CapiPDFApparence)object).getVisibleLabel();
        } else {
            object3 = ((CapiPDFApparence)object).getName();
            if (!Util.isNullOrEmpty((String)object3)) {
                string2 = string2 + (String)object3;
            }
            if (!((CapiPDFApparence)object).isShowNameOnly()) {
                object2 = ((CapiPDFApparence)object).getOrganization();
                if (object2 != null && !((String)object2).trim().toLowerCase().contains("non presente") && ((String)object2).trim().compareToIgnoreCase("null") != 0) {
                    if (!string2.isEmpty()) {
                        string2 = string2 + "\n";
                    }
                    string2 = string2 + (String)object2;
                }
                if ((string = ((CapiPDFApparence)object).getTitle()) != null && !string.trim().toLowerCase().contains("non presente") && string.trim().compareToIgnoreCase("null") != 0) {
                    if (!string2.isEmpty()) {
                        string2 = string2 + "\n";
                    }
                    string2 = string2 + string;
                }
            }
        }
        if (((CapiPDFApparence)object).isShowDateTime() && !((CapiPDFApparence)object).isShowNameOnly()) {
            if (!string2.isEmpty()) {
                string2 = string2 + "\n";
            }
            object3 = new Date();
            if (((CapiPDFApparence)object).getSigningTimeCal() != null) {
                object3 = ((CapiPDFApparence)object).getSigningTimeCal().getTime();
            }
            object2 = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            string = ((CapiPDFApparence)object).getTimeZone() == null ? "UTC" : ((CapiPDFApparence)object).getTimeZone();
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone(string));
            object = ((DateFormat)object2).format((Date)object3);
            string2 = string2 + (String)object;
        }
        return string2.trim().replace("\t", "    ");
    }

    @Deprecated
    public static PDVisibleSigProperties getPDVisibleSigProperties(CapiPDFApparence object) throws CapiException {
        if (object == null) {
            return null;
        }
        BufferedImage bufferedImage = ((CapiPDFApparence)object).getImage();
        Object object2 = ((CapiPDFApparence)object).getVisibleLabel();
        int n = ((CapiPDFApparence)object).getFontSize();
        float f = ((CapiPDFApparence)object).getPosX();
        float f2 = ((CapiPDFApparence)object).getPosY();
        float f3 = ((CapiPDFApparence)object).getWidth();
        float f4 = ((CapiPDFApparence)object).getHeight();
        String string = ((CapiPDFApparence)object).getName();
        String string2 = ((CapiPDFApparence)object).getOrganization();
        String string3 = ((CapiPDFApparence)object).getTitle();
        String string4 = ((CapiPDFApparence)object).getFieldName();
        boolean bl = ((CapiPDFApparence)object).isShowDateTime();
        int n2 = ((CapiPDFApparence)object).getPage();
        boolean bl2 = ((CapiPDFApparence)object).isOnly_image();
        int n3 = ((CapiPDFApparence)object).getResizeMode();
        boolean bl3 = ((CapiPDFApparence)object).isScaleFont();
        Calendar calendar = ((CapiPDFApparence)object).getSigningTimeCal();
        boolean bl4 = ((CapiPDFApparence)object).isPDFASignature();
        boolean bl5 = ((CapiPDFApparence)object).isGray();
        String string5 = ((CapiPDFApparence)object).getLocation();
        String string6 = ((CapiPDFApparence)object).getReason();
        PDDocument pDDocument = ((CapiPDFApparence)object).getPdDocument();
        int n4 = ((CapiPDFApparence)object).getAnchorCorner();
        boolean bl6 = ((CapiPDFApparence)object).isShowNameOnly();
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            a.error("wrong signature position");
            return null;
        }
        if ((double)f3 <= 0.0 || (double)f4 <= 0.0) {
            a.error("wrong signature size");
            return null;
        }
        PDVisibleSigProperties pDVisibleSigProperties = null;
        int n5 = (int)f3 << 2;
        int n6 = (int)f4 << 2;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 0;
        n <<= 2;
        if (bufferedImage != null) {
            BufferedImage bufferedImage2;
            String string7 = "H";
            if (!bl2) {
                float f5;
                float f6 = bufferedImage.getHeight();
                float f7 = bufferedImage.getWidth();
                f6 /= f4;
                f7 /= f3;
                if (f5 > f6) {
                    n10 = n8 = (int)f4 << 1;
                    string7 = "V";
                } else {
                    n9 = n7 = (int)f3 << 1;
                    string7 = "H";
                }
            }
            String string8 = string7;
            int n11 = n3;
            float f8 = n8;
            float f9 = n7;
            if (bufferedImage == null || f9 <= 0.0f || f8 <= 0.0f) {
                bufferedImage2 = null;
            } else {
                int n12 = bufferedImage.getWidth();
                int n13 = bufferedImage.getHeight();
                int n14 = Math.round(f9);
                int n15 = Math.round(f8);
                BufferedImage bufferedImage3 = !bufferedImage.getColorModel().hasAlpha() ? new BufferedImage(n14, n15, bufferedImage.getType()) : new BufferedImage(n14, n15, 2);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                if (!bufferedImage.getColorModel().hasAlpha()) {
                    graphics2D.setBackground(Color.WHITE);
                    graphics2D.clearRect(0, 0, n14, n15);
                }
                if (n11 == 1) {
                    graphics2D.drawImage(bufferedImage, 0, 0, n14, n15, 0, 0, n12, n13, null);
                    graphics2D.dispose();
                    bufferedImage2 = bufferedImage3;
                } else if (n11 != 5 && n11 > 1) {
                    int n16;
                    int n17;
                    if (n14 < n15) {
                        n17 = n13 * n14 / n12;
                        n16 = n14;
                        if (n17 > n15) {
                            n16 = n14 * n15 / n17;
                            n17 = n15;
                        }
                    } else {
                        n16 = n12 * n15 / n13;
                        n17 = n15;
                        if (n16 > n14) {
                            n17 = n15 * n14 / n16;
                            n16 = n14;
                        }
                    }
                    int n18 = 0;
                    int n19 = 0;
                    if (n11 == 2) {
                        n18 = (n14 - n16) / 2;
                        n19 = (n15 - n17) / 2;
                    } else if (n11 == 3) {
                        if (string8.equalsIgnoreCase("H")) {
                            n18 = n14 - n16;
                            n19 = (n15 - n17) / 2;
                        } else {
                            n18 = (n14 - n16) / 2;
                            n19 = n15 - n17;
                        }
                    } else if (n11 == 4) {
                        if (string8.equalsIgnoreCase("H")) {
                            n19 = (n15 - n17) / 2;
                        } else {
                            n18 = (n14 - n16) / 2;
                        }
                    }
                    graphics2D.drawImage(bufferedImage, n18, n19, n16 + n18, n17 + n19, 0, 0, n12, n13, null);
                    graphics2D.dispose();
                    bufferedImage2 = bufferedImage3;
                } else {
                    bufferedImage2 = bufferedImage;
                }
            }
            bufferedImage = bufferedImage2;
        }
        Object object3 = new Date();
        if (calendar != null) {
            object3 = calendar.getTime();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
        object = ((CapiPDFApparence)object).getTimeZone() == null ? "UTC" : ((CapiPDFApparence)object).getTimeZone();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone((String)object));
        object3 = simpleDateFormat.format((Date)object3);
        Object object4 = "";
        if (object2 != null) {
            object4 = object2;
        } else {
            if (!Util.isNullOrEmpty((String)string)) {
                object4 = (String)object4 + string;
            }
            if (!bl6) {
                if (string2 != null && !string2.trim().toLowerCase().contains("non presente") && string2.trim().compareToIgnoreCase("null") != 0) {
                    if (!((String)object4).isEmpty()) {
                        object4 = (String)object4 + "\n";
                    }
                    object4 = (String)object4 + string2;
                }
                if (string3 != null && !string3.trim().toLowerCase().contains("non presente") && string3.trim().compareToIgnoreCase("null") != 0) {
                    if (!((String)object4).isEmpty()) {
                        object4 = (String)object4 + "\n";
                    }
                    object4 = (String)object4 + string3;
                }
            }
        }
        if (bl && !bl6) {
            if (!((String)object4).isEmpty()) {
                object4 = (String)object4 + "\n";
            }
            object4 = (String)object4 + (String)object3;
        }
        object3 = new BufferedImage(n5, n6, 2);
        object = ((BufferedImage)object3).createGraphics();
        ((Graphics)object).clearRect(0, 0, n5, n6);
        ((Graphics)object).drawRect(0, 0, n5 - 1, n6 - 1);
        ((Graphics2D)object).setComposite(AlphaComposite.Clear);
        ((Graphics)object).fillRect(0, 0, n5, n6);
        ((Graphics2D)object).setComposite(AlphaComposite.Src);
        if (!bl2) {
            object4 = new TextContainer((String)object4, n7, n8, "Arial", 0, n, n4);
            object2 = new BufferedImage(n7, n8, 2);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            graphics2D.drawRect(0, 0, n7 - 1, n8 - 1);
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n7, n8);
            graphics2D.setComposite(AlphaComposite.Src);
            ((TextContainer)object4).paint(graphics2D, bl3);
            ((Graphics)object).drawImage((Image)object2, n9, n10, null);
        }
        if (bufferedImage != null) {
            ((Graphics)object).drawImage(bufferedImage, 0, 0, null);
        }
        if (bl4) {
            object3 = bl5 ? PadesUtils.a((BufferedImage)object3) : PadesUtils.b((BufferedImage)object3);
        }
        try {
            a.debug("[addSigner] page: " + n2);
            object4 = new PDVisibleSignDesigner(pDDocument, (BufferedImage)object3, n2);
            object4.height(f4);
            object4.width(f3);
            float f10 = object4.getPageHeight();
            object4.xAxis(f).yAxis(f10 - f2).signatureFieldName(string4);
            pDVisibleSigProperties = new PDVisibleSigProperties();
            pDVisibleSigProperties.signerName(string);
            pDVisibleSigProperties.signerLocation(string5);
            pDVisibleSigProperties.signatureReason(string6);
            pDVisibleSigProperties.preferredSize(0);
            pDVisibleSigProperties.page(n2);
            pDVisibleSigProperties.visualSignEnabled(true);
            pDVisibleSigProperties.setPdVisibleSignature((PDVisibleSignDesigner)object4);
            pDVisibleSigProperties.buildSignature();
            a.debug("getPDVisibleSigProperties done");
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage());
        }
        return pDVisibleSigProperties;
    }

    private static BufferedImage a(BufferedImage bufferedImage) {
        if (bufferedImage.getType() == 10) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage = PadesUtils.b(bufferedImage);
        ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static BufferedImage b(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        if (bufferedImage.getType() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Object object = bufferedImage2.createGraphics();
        ((Graphics)object).setColor(Color.WHITE);
        ((Graphics)object).fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        ((Graphics)object).dispose();
        object = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
        ((ColorConvertOp)object).filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static COSArray parseArray(COSDictionary cOSDictionary, String string) {
        COSArray cOSArray = null;
        if ((cOSDictionary = cOSDictionary.getItem(string)) != null) {
            if (cOSDictionary instanceof COSArray) {
                cOSArray = (COSArray)cOSDictionary;
            } else if (((COSObject)cOSDictionary).getObject() instanceof COSArray) {
                cOSArray = (COSArray)((COSObject)cOSDictionary).getObject();
            }
        }
        return cOSArray;
    }

    public static PadesDssInfo retrieveDssInfo(PDDocument pDDocument) {
        PadesDssInfo padesDssInfo = null;
        try {
            COSDictionary cOSDictionary = pDDocument.getDocument().getTrailer();
            if (cOSDictionary == null) {
                a.error("[initialize] trailer is null.");
                return null;
            }
            if ((cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(COSName.ROOT)) == null) {
                a.error("[initialize] root is null");
                return null;
            }
            if ((cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject("DSS")) != null) {
                COSArray cOSArray;
                COSArray cOSArray2;
                Object object;
                Object object2;
                padesDssInfo = new PadesDssInfo(pDDocument, cOSDictionary);
                pDDocument = PadesUtils.parseArray(cOSDictionary, "Certs");
                if (pDDocument != null) {
                    for (int i = 0; i < pDDocument.size(); ++i) {
                        COSStream cOSStream = (COSStream)pDDocument.getObject(i);
                        object2 = Util.getBytesFromInputStream((InputStream)cOSStream.createInputStream());
                        object = new Certificate(object2);
                        padesDssInfo.getCerts().add((Certificate)object);
                    }
                }
                if ((cOSArray2 = PadesUtils.parseArray(cOSDictionary, "OCSPs")) != null) {
                    for (int i = 0; i < cOSArray2.size(); ++i) {
                        COSStream cOSStream = (COSStream)cOSArray2.getObject(i);
                        object2 = cOSStream;
                        byte[] byArray = Util.getBytesFromInputStream((InputStream)cOSStream.createInputStream());
                        object = byArray;
                        pDDocument = OcspUtils.getInstaceByBytes((byte[])byArray);
                        if (pDDocument == null) continue;
                        padesDssInfo.getOcsps().add((BasicOCSPResp)pDDocument);
                    }
                }
                if ((cOSArray = PadesUtils.parseArray(cOSDictionary, "CRLs")) != null) {
                    for (int i = 0; i < cOSArray.size(); ++i) {
                        object = (COSStream)cOSArray.getObject(i);
                        pDDocument = new CRL((InputStream)object.createInputStream());
                        padesDssInfo.getCrls().add((CRL)pDDocument);
                    }
                }
            }
        }
        catch (CapiException capiException) {
            a.error("Impossibile Parsare DSS Pdf", (Throwable)capiException);
        }
        catch (IOException iOException) {
            a.error("Impossibile Parsare DSS Pdf", (Throwable)iOException);
        }
        return padesDssInfo;
    }

    public static LinkedList<PadesSignatureInformation> retrieveSignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 0);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        return linkedList;
    }

    public static LinkedList<PadesSignatureInformation> retrieveNotEmptySignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 1);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        object = new CompareByteRangeSignature();
        Collections.sort(linkedList, object);
        return linkedList;
    }

    public static LinkedList<PadesSignatureInformation> retrieveEmptySignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 2);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        return linkedList;
    }

    private static LinkedList<PadesSignatureInformation> a(PDField pDField, PadesDssInfo padesDssInfo, int n) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (n == 0) {
                if ((PadesUtils.a(pDSignatureField.getCOSObject()) || pDSignatureField.getValue() == null) && !PadesUtils.a(string, linkedList)) {
                    linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                    a.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (n == 1) {
                if (PadesUtils.a(pDSignatureField.getCOSObject()) && !PadesUtils.a(string, linkedList)) {
                    linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                    a.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (n == 1 && pDSignatureField.getValue() == null && !PadesUtils.a(string, linkedList)) {
                linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                a.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                linkedList.addAll(PadesUtils.a((PDField)string, padesDssInfo, n));
            }
        }
        return linkedList;
    }

    static {
        c = false;
    }
}

