/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.observable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ObservableList<T>
extends ArrayList<T> {
    private final ArrayList<Runnable> LISTENERS = new ArrayList();

    public ObservableList() {
    }

    public ObservableList(int initialCapacity) {
        super(initialCapacity);
    }

    public ObservableList(Collection<? extends T> c) {
        super(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.LISTENERS;
        synchronized (arrayList) {
            this.LISTENERS.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.LISTENERS;
        synchronized (arrayList) {
            return this.LISTENERS.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<Runnable> arrayList = this.LISTENERS;
        synchronized (arrayList) {
            this.LISTENERS.forEach((? super E r) -> new Thread((Runnable)r).start());
        }
    }

    @Override
    public boolean add(T e) {
        boolean ret = super.add(e);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.notifyListeners();
    }

    public boolean addAll(T ... elements) {
        boolean ret = false;
        for (T element : elements) {
            ret |= super.add(element);
        }
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret = super.addAll(c);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean ret = super.addAll(index, c);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public void clear() {
        super.clear();
        this.notifyListeners();
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public T remove(int index) {
        Object ret = super.remove(index);
        this.notifyListeners();
        return (T)ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = super.removeAll(c);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean ret = super.removeIf(filter);
        if (ret) {
            this.notifyListeners();
        }
        return ret;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.notifyListeners();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        super.replaceAll(operator);
        this.notifyListeners();
    }
}

