/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import esecurity.statistics.utils.AdditionalLogInfo;
import esecurity.statistics.utils.StatisticsInfoUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.JsonLayout;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.logging.log4j.Category;
import it.actalis.ellips.capi.logging.log4j.Layout;
import it.actalis.ellips.capi.logging.log4j.Level;
import it.actalis.ellips.capi.logging.log4j.Logger;
import it.actalis.ellips.capi.logging.log4j.PatternLayout;
import it.actalis.ellips.capi.logging.log4j.spi.LoggingEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class EllipsLogger
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    public static final String DEFAULT_LOG_PATTERN = "%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n";
    protected Layout pattern;
    protected LoggerLevel level;
    protected Level log4jLevel;
    protected LoggerConfig config;
    protected boolean defaultConfig;
    protected LinkedBlockingQueue<String> messageQueue;
    protected Thread loggingThread;
    protected Long lastRollingTime;
    protected Calendar lastDateRolling = Calendar.getInstance();
    protected Category category;

    protected EllipsLogger(String name, String pattern, LoggerLevel level, LoggerConfig config) {
        if (config == null) {
            config = new LoggerConfig();
            this.defaultConfig = true;
        } else {
            this.defaultConfig = false;
        }
        if (pattern == null || pattern.isEmpty()) {
            pattern = DEFAULT_LOG_PATTERN;
        }
        if (level == null) {
            level = LoggerLevel.INFO;
        }
        this.name = name;
        this.category = Logger.getLogger(name);
        this.messageQueue = new LinkedBlockingQueue();
        this.pattern = config.getOutputFormat().equals("JSON") ? new JsonLayout(name) : new PatternLayout(pattern);
        this.level = level;
        this.setLog4jLevel(level);
        this.config = config;
        this.lastRollingTime = 0L;
        this.loggingThread = null;
        this.startLogging();
    }

    protected void startLogging() {
        if (this.isLogging()) {
            return;
        }
        if (this.config.isTimeRollingEnabled()) {
            this.lastRollingTime = System.nanoTime();
        }
        if (this.loggingThread == null) {
            this.loggingThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String message = "";
                    if (EllipsLogger.this.config.isFileAppenderSet() && EllipsLogger.this.config.isDailyRollingEnable()) {
                        long lastModified = EllipsLogger.this.config.getFileAppender().lastModified();
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeInMillis(lastModified);
                        EllipsLogger.this.lastDateRolling = cal;
                    }
                    while (!Thread.interrupted()) {
                        try {
                            message = EllipsLogger.this.messageQueue.take();
                            if (EllipsLogger.this.config.isSpaceRollingEnabled()) {
                                EllipsLogger.this.doFixedWindowRollingPolicy();
                            }
                            if (EllipsLogger.this.config.isTimeRollingEnabled()) {
                                EllipsLogger.this.doTimeBasedRollingPolicy();
                            }
                            if (EllipsLogger.this.config.isDailyRollingEnable()) {
                                EllipsLogger.this.doDailyRollingPolicy();
                            }
                            if (EllipsLogger.this.config.isFileAppenderSet()) {
                                EllipsLoggerFactory.writeToFileAppender(EllipsLogger.this.config.getFileAppender().getAbsolutePath(), message, Charset.forName(EllipsLogger.this.config.getCharset()));
                            }
                            if (EllipsLogger.this.config.isConsoleAppenderSet()) {
                                System.out.println(message);
                            }
                            message = "";
                        }
                        catch (InterruptedException ex) {
                            System.out.println("Logger interruption done: " + EllipsLogger.this.name + " logger");
                            if (message.isEmpty()) continue;
                            EllipsLogger.this.messageQueue.offer(message);
                        }
                        catch (Throwable ex) {
                            if (ex.getMessage() != null) {
                                System.err.println("Error " + ex.getMessage());
                            }
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            });
            this.loggingThread.setDaemon(true);
        }
        this.loggingThread.start();
    }

    protected void update(LoggerConfig config) throws InterruptedException {
        this.update(config, null);
    }

    protected void update(LoggerConfig config, LoggerLevel level) throws InterruptedException {
        if (config == null) {
            config = new LoggerConfig();
            this.defaultConfig = true;
        }
        this.config = config;
        if (level != null) {
            this.setLevel(level);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(boolean defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggerLevel level) {
        this.level = level;
        this.setLog4jLevel(level);
    }

    public String getMessagePattern() {
        if (this.pattern instanceof PatternLayout) {
            return ((PatternLayout)this.pattern).getConversionPattern();
        }
        return "";
    }

    public LoggerConfig getConfig() {
        return this.config;
    }

    public boolean isFileAppenderSet() throws IOException {
        if (this.config == null) {
            System.err.println("Null configuration");
            throw new IOException("Null config");
        }
        return this.config.isFileAppenderSet();
    }

    public boolean isConsoleAppenderSet() throws IOException {
        if (this.config == null) {
            System.err.println("Null configuration");
            throw new IOException("Null config");
        }
        return this.config.isConsoleAppenderSet();
    }

    public boolean isSpaceRollingEnabled() throws IOException {
        if (this.config == null) {
            System.err.println("Null configuration!");
            throw new IOException("Null config");
        }
        return this.config.isSpaceRollingEnabled();
    }

    public boolean isTimeRollingEnabled() throws IOException {
        if (this.config == null) {
            System.err.println("Null configuration!");
            throw new IOException("Null config");
        }
        return this.config.isTimeRollingEnabled();
    }

    public boolean isDailyRollingEnabled() throws IOException {
        if (this.config == null) {
            System.err.println("Null configuration!");
            throw new IOException("Null config");
        }
        return this.config.isDailyRollingEnable();
    }

    public boolean isLogging() {
        if (this.loggingThread == null) {
            return false;
        }
        return this.loggingThread.isAlive() && !this.loggingThread.isInterrupted();
    }

    protected void setLog4jLevel(LoggerLevel lev) {
        this.log4jLevel = this.logLevel2Log4j(lev);
    }

    protected Level logLevel2Log4j(LoggerLevel lev) {
        Level curLog4JLevel = Level.OFF;
        if (lev == null) {
            return curLog4JLevel;
        }
        if (lev == LoggerLevel.TRACE) {
            curLog4JLevel = Level.TRACE;
        } else if (lev == LoggerLevel.DEBUG) {
            curLog4JLevel = Level.DEBUG;
        } else if (lev == LoggerLevel.INFO) {
            curLog4JLevel = Level.INFO;
        } else if (lev == LoggerLevel.WARN) {
            curLog4JLevel = Level.WARN;
        } else if (lev == LoggerLevel.ERROR) {
            curLog4JLevel = Level.ERROR;
        } else if (lev == LoggerLevel.NONE) {
            curLog4JLevel = Level.OFF;
        }
        return curLog4JLevel;
    }

    protected String applyPatternLayout(String str, Throwable exception) {
        return this.applyPatternLayout(str, exception, EllipsLogger.class.getName(), null);
    }

    protected String applyPatternLayout(String str, Throwable exception, LoggerLevel eventLevel) {
        return this.applyPatternLayout(str, exception, EllipsLogger.class.getName(), eventLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applyPatternLayout(String str, Throwable exception, String callerFQCN, LoggerLevel eventLevel) {
        AdditionalLogInfo additionalLogInfo;
        if (str == null) {
            str = "";
        }
        if (!this.config.getOutputFormat().equals("JSON") && (additionalLogInfo = StatisticsInfoUtils.getAdditionalInfo()) != null && additionalLogInfo.getCorrelationId() != null && !additionalLogInfo.getCorrelationId().isEmpty()) {
            str = additionalLogInfo.getCorrelationId() + " - " + str;
        }
        if (this.pattern == null) {
            return str;
        }
        Level currentLevel = this.log4jLevel;
        if (eventLevel != null) {
            currentLevel = this.logLevel2Log4j(eventLevel);
        }
        if (eventLevel == LoggerLevel.ERROR && exception != null && !this.config.getOutputFormat().equals("JSON")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String sStackTrace = sw.toString();
            str = String.format("%s\r\n%s", str, sStackTrace);
        }
        LoggingEvent evt = new LoggingEvent(callerFQCN, this.category, currentLevel, str, exception);
        EllipsLogger ellipsLogger = this;
        synchronized (ellipsLogger) {
            return this.pattern.format(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doFixedWindowRollingPolicy() throws IOException {
        if (!this.config.isFileAppenderSet() || !this.config.isSpaceRollingEnabled()) {
            return false;
        }
        double fileSizeMB = (double)this.config.getFileAppender().length() / 1048576.0;
        if (fileSizeMB < (double)this.config.getSpaceRolling()) {
            return false;
        }
        File file = this.config.getFileAppender();
        synchronized (file) {
            fileSizeMB = (double)this.config.getFileAppender().length() / 1048576.0;
            if (fileSizeMB < (double)this.config.getSpaceRolling()) {
                return false;
            }
            String appenderFolder = this.config.getFileAppender().getParent() + File.separator;
            String activeFileName = this.config.getFileAppender().getName();
            int lastDot = activeFileName.lastIndexOf(46);
            String name = activeFileName;
            String ext = "";
            if (lastDot > 0) {
                name = activeFileName.substring(0, lastDot);
                ext = activeFileName.substring(lastDot);
            }
            String fileNamePattern = String.format("%s%s", appenderFolder, name);
            String extFormat = "";
            extFormat = this.config.isRollingCompressed() ? String.format("%s%s", ext, this.config.getZipExt()) : String.format("%s", ext);
            EllipsLoggerFactory.backupFileAppender(this.config, fileNamePattern, extFormat, this.config.isRollingCompressed());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doTimeBasedRollingPolicy() throws IOException {
        if (!this.config.isFileAppenderSet() || !this.config.isTimeRollingEnabled()) {
            return false;
        }
        long curTime = System.nanoTime();
        long duration = (curTime - this.lastRollingTime) / 1000000L;
        if (duration < this.config.getTimeRolling()) {
            return false;
        }
        Long l = this.lastRollingTime;
        synchronized (l) {
            curTime = System.nanoTime();
            duration = (curTime - this.lastRollingTime) / 1000000L;
            if (duration < this.config.getTimeRolling()) {
                return false;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(this.config.getTimeRollingPattern());
            String formattedDate = sdf.format(new Date());
            String appenderFolder = this.config.getFileAppender().getParent() + File.separator;
            String activeFileName = this.config.getFileAppender().getName();
            int lastDot = activeFileName.lastIndexOf(46);
            String name = activeFileName;
            String ext = "";
            if (lastDot > 0) {
                name = activeFileName.substring(0, lastDot);
                ext = activeFileName.substring(lastDot);
            }
            String extFormat = "";
            extFormat = this.config.isRollingCompressed() ? String.format("%s%s", ext, this.config.getZipExt()) : String.format("%s", ext);
            String fileNamePattern = String.format("%s%s-%s", appenderFolder, name, formattedDate);
            EllipsLoggerFactory.backupFileAppender(this.config.getFileAppender().getAbsolutePath(), fileNamePattern, extFormat, this.config.isRollingCompressed());
            this.lastRollingTime = curTime;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDailyRollingPolicy() throws IOException {
        if (!this.config.isFileAppenderSet() || !this.config.isDailyRollingEnable()) {
            return false;
        }
        Calendar currentDate = Calendar.getInstance();
        if (this.lastDateRolling.get(6) == currentDate.get(6)) {
            return false;
        }
        Calendar calendar = this.lastDateRolling;
        synchronized (calendar) {
            if (this.lastDateRolling.get(6) == currentDate.get(6)) {
                return false;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(this.config.getDailyRollingPattern());
            String formattedDate = sdf.format(this.lastDateRolling.getTime());
            String appenderFolder = this.config.getFileAppender().getParent() + File.separator;
            String activeFileName = this.config.getFileAppender().getName();
            int lastDot = activeFileName.lastIndexOf(46);
            String name = activeFileName;
            String ext = "";
            if (lastDot > 0) {
                name = activeFileName.substring(0, lastDot);
                ext = activeFileName.substring(lastDot);
            }
            String extFormat = "";
            extFormat = this.config.isRollingCompressed() ? String.format("%s%s", ext, this.config.getZipExt()) : String.format("%s", ext);
            String fileNamePattern = String.format("%s%s-%s", appenderFolder, name, formattedDate);
            File zipFile = new File(fileNamePattern + extFormat);
            if (!zipFile.exists()) {
                EllipsLoggerFactory.backupFileAppender(this.config.getFileAppender().getAbsolutePath(), fileNamePattern, extFormat, this.config.isRollingCompressed());
            }
            this.lastDateRolling = currentDate;
            return true;
        }
    }

    protected boolean isDebugFilteredByPackage() {
        LinkedList<String> debugPackages = this.config.getDebugPackages();
        if (debugPackages == null || debugPackages.size() == 0) {
            return false;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length < 4 || stackTraceElements[3] == null) {
            return false;
        }
        LinkedList<String> ignored = this.config.getIgnoredInStackTrace();
        int callerIndex = 3;
        if (ignored != null && ignored.size() > 0) {
            for (int iStack = callerIndex; iStack < stackTraceElements.length; ++iStack) {
                boolean isACaller = true;
                for (int iIgnore = 0; iIgnore < ignored.size(); ++iIgnore) {
                    if (!stackTraceElements[iStack].getClassName().equals(ignored.get(iIgnore))) continue;
                    isACaller = false;
                    break;
                }
                if (!isACaller) continue;
                callerIndex = iStack;
                break;
            }
        }
        String callerFullName = stackTraceElements[callerIndex].getClassName();
        for (int iPack = 0; iPack < debugPackages.size(); ++iPack) {
            String callerPackage;
            String basePack;
            if (callerFullName.equals(debugPackages.get(iPack))) {
                return false;
            }
            if (!(debugPackages.get(iPack).endsWith("*") ? callerFullName.startsWith(basePack = debugPackages.get(iPack).replace("*", "")) : (callerPackage = callerFullName.substring(0, callerFullName.lastIndexOf("."))).equals(debugPackages.get(iPack)))) continue;
            return false;
        }
        return true;
    }

    public boolean isTraceEnabled() {
        return this.level == LoggerLevel.TRACE;
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, null, LoggerLevel.TRACE));
    }

    public void trace(String format, Object arg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.TRACE));
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.TRACE));
    }

    public void trace(String format, Object ... arguments) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.TRACE));
    }

    public void trace(String msg, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, LoggerLevel.TRACE));
    }

    public boolean isDebugEnabled() {
        return this.level == LoggerLevel.TRACE || this.level == LoggerLevel.DEBUG;
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        if (this.isDebugFilteredByPackage()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, null, LoggerLevel.DEBUG));
    }

    public void debug(String format, Object arg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        if (this.isDebugFilteredByPackage()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.DEBUG));
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        if (this.isDebugFilteredByPackage()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.DEBUG));
    }

    public void debug(String format, Object ... arguments) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        if (this.isDebugFilteredByPackage()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.DEBUG));
    }

    public void debug(String msg, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        if (this.isDebugFilteredByPackage()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, LoggerLevel.DEBUG));
    }

    public boolean isInfoEnabled() {
        return this.level == LoggerLevel.TRACE || this.level == LoggerLevel.DEBUG || this.level == LoggerLevel.INFO;
    }

    public void info(String msg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, null, LoggerLevel.INFO));
    }

    public void info(String format, Object arg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.INFO));
    }

    public void info(String format, Object arg1, Object arg2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.INFO));
    }

    public void info(String format, Object ... argArray) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.INFO));
    }

    public void info(String msg, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, LoggerLevel.INFO));
    }

    public boolean isWarnEnabled() {
        return this.level == LoggerLevel.TRACE || this.level == LoggerLevel.DEBUG || this.level == LoggerLevel.INFO || this.level == LoggerLevel.WARN;
    }

    public void warn(String msg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, null, LoggerLevel.WARN));
    }

    public void warn(String format, Object arg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.WARN));
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.WARN));
    }

    public void warn(String format, Object ... argArray) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.WARN));
    }

    public void warn(String msg, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, LoggerLevel.WARN));
    }

    public boolean isErrorEnabled() {
        return this.level == LoggerLevel.TRACE || this.level == LoggerLevel.DEBUG || this.level == LoggerLevel.INFO || this.level == LoggerLevel.WARN || this.level == LoggerLevel.ERROR;
    }

    public void error(String msg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, null, LoggerLevel.ERROR));
    }

    public void error(String format, Object arg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.ERROR));
    }

    public void error(String format, Object arg1, Object arg2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.ERROR));
    }

    public void error(String format, Object ... argArray) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.messageQueue.offer(this.applyPatternLayout(ft.getMessage(), ft.getThrowable(), LoggerLevel.ERROR));
    }

    public void error(String msg, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, LoggerLevel.ERROR));
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] argArray, Throwable t) {
        LoggerLevel eventLevel = LoggerLevel.NONE;
        switch (level) {
            case 0: {
                if (!this.isTraceEnabled()) {
                    return;
                }
                eventLevel = LoggerLevel.TRACE;
                break;
            }
            case 10: {
                if (!this.isDebugEnabled()) {
                    return;
                }
                eventLevel = LoggerLevel.DEBUG;
                break;
            }
            case 20: {
                if (!this.isInfoEnabled()) {
                    return;
                }
                eventLevel = LoggerLevel.INFO;
                break;
            }
            case 30: {
                if (!this.isWarnEnabled()) {
                    return;
                }
                eventLevel = LoggerLevel.WARN;
                break;
            }
            case 40: {
                if (!this.isErrorEnabled()) {
                    return;
                }
                eventLevel = LoggerLevel.ERROR;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.isLogging()) {
            return;
        }
        this.messageQueue.offer(this.applyPatternLayout(msg, t, callerFQCN, eventLevel));
    }

    public void logAtLoggerLevel(String msg) {
        if (this.isTraceEnabled()) {
            this.trace(msg);
        } else if (this.isDebugEnabled()) {
            this.debug(msg);
        } else if (this.isInfoEnabled()) {
            this.info(msg);
        } else if (this.isWarnEnabled()) {
            this.warn(msg);
        } else if (this.isErrorEnabled()) {
            this.error(msg);
        }
    }

    public void rawLog(String rawLog) {
        this.messageQueue.offer(rawLog);
    }
}

