/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.config;

import esecurity.dsd.client.config.ConfigurationProvider;
import esecurity.dsd.client.config.RemoteConfigProvider;
import esecurity.dsd.core.ConfigurationMap;
import esecurity.dsd.core.PropertyContainer;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class FilePropertiesConfigurationProvider
implements ConfigurationProvider {
    private File file;
    private Map<String, Object> properties = null;

    private RemoteConfigProvider getServer(Remote server) {
        String dsnPrefix = server.name().toLowerCase().concat(".");
        PropertyContainer conf = this.getProvidedConfiguration();
        RemoteConfigProvider.Builder builder = RemoteConfigProvider.create(server.name().toLowerCase()).host(conf.getValue(dsnPrefix.concat("host"), String.class).orElse(null)).username(conf.getValue(dsnPrefix.concat("user"), String.class).orElse(null)).password(conf.getValue(dsnPrefix.concat("pwd"), String.class).orElse(null));
        conf.getValue(dsnPrefix.concat("secured"), Boolean.class).ifPresent(builder::useSSL);
        conf.getValue(dsnPrefix.concat("port"), Integer.class).ifPresent(builder::port);
        conf.getValue(dsnPrefix.concat("service"), String.class).ifPresent(builder::servicePrefix);
        conf.getValue(dsnPrefix.concat("connectionTimeout"), Integer.class).ifPresent(builder::connectionTimeoutSecs);
        conf.getValue(dsnPrefix.concat("readTimeout"), Integer.class).ifPresent(builder::readTimeoutSecs);
        conf.getValue(dsnPrefix.concat("writeTimeout"), Integer.class).ifPresent(builder::writeTimeoutSecs);
        return builder.build();
    }

    private Properties internal_getProperties() {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(this.file);){
            properties.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public FilePropertiesConfigurationProvider(Path path) {
        this.file = path.toFile();
    }

    public FilePropertiesConfigurationProvider(String path) {
        this(Paths.get(path, new String[0]));
    }

    private Object parseValue(Object value) {
        if (value != null && value instanceof String) {
            String svalue = value.toString();
            if (Pattern.compile("\\b(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\b").matcher(svalue).find()) {
                return svalue;
            }
            try {
                return NumberFormat.getInstance().parse(svalue);
            }
            catch (Exception e) {
                if ("0".equals(svalue) || "FALSE".equalsIgnoreCase(svalue)) {
                    return Boolean.FALSE;
                }
                if ("1".equals(svalue) || "TRUE".equalsIgnoreCase(svalue)) {
                    return Boolean.TRUE;
                }
                return svalue;
            }
        }
        return value;
    }

    private Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
            Properties source = this.internal_getProperties();
            for (Object k : source.keySet()) {
                String key = k.toString();
                this.properties.put(key, this.parseValue(source.get(key)));
            }
        }
        return this.properties;
    }

    public PropertyContainer getProvidedConfiguration() {
        return new ConfigurationMap(this.getProperties());
    }

    public Set<String> getDefaultProvidedKeys() {
        return Collections.singleton("domain");
    }

    @Override
    public List<RemoteConfigProvider> remoteProviders() {
        return Arrays.asList(this.getServer(Remote.DSN1), this.getServer(Remote.DSN2));
    }

    @Override
    public String domain() {
        return (String)this.getProperties().get("domain");
    }

    static enum Remote {
        DSN1,
        DSN2;

    }
}

