/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.TableBody;
import esecurity.desktop.dom.TableBodyCell;
import esecurity.desktop.dom.TableHead;

public class Table
extends DOMElement {
    private TableHead tableHead;
    private TableBody tableBody;

    public Table(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            Table.createElementWithID("table", id, view);
        }
    }

    public Table(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("table", id, parentId);
    }

    public Table(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("table", id, parent.getId());
    }

    public void setHead(TableHead tableHead) {
        this.tableHead = tableHead;
    }

    public void setBody(TableBody tableBody) {
        this.tableBody = tableBody;
    }

    public TableHead getHead() {
        return this.tableHead;
    }

    public TableBody getBody() {
        return this.tableBody;
    }

    public TableBodyCell getCell(int row, int column) {
        if (this.tableBody != null) {
            return this.tableBody.getCell(row, column);
        }
        return null;
    }

    public void empty() {
        this.tableBody.empty();
    }
}

