/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.crypto.tls.AbstractTlsContext;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.CertificateStatus;
import org.bouncycastle.crypto.tls.CipherSuite;
import org.bouncycastle.crypto.tls.DigitallySigned;
import org.bouncycastle.crypto.tls.NewSessionTicket;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.SessionParameters;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContextImpl;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsSession;
import org.bouncycastle.crypto.tls.TlsSessionImpl;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected byte[] selectedSessionID = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        super(input, output, secureRandom);
    }

    public TlsClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        SessionParameters sessionParameters;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 1;
        this.tlsClientContext = new TlsClientContextImpl(this.secureRandom, this.securityParameters);
        this.securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(tlsClient.shouldUseGMTUnixTime(), this.tlsClientContext.getNonceRandomGenerator());
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        TlsSession sessionToResume = tlsClient.getSessionToResume();
        if (sessionToResume != null && sessionToResume.isResumable() && (sessionParameters = sessionToResume.exportSessionParameters()) != null && sessionParameters.isExtendedMasterSecret()) {
            this.tlsSession = sessionToResume;
            this.sessionParameters = sessionParameters;
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
        this.blockForHandshake();
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.selectedSessionID = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    @Override
    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    @Override
    protected void handleHandshakeMessage(short type, ByteArrayInputStream buf) throws IOException {
        if (this.resumedSession) {
            if (type != 20 || this.connection_state != 2) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            this.connection_state = (short)15;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)13;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.peerCertificate = Certificate.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        if (this.peerCertificate == null || this.peerCertificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        this.keyExchange.processServerCertificate(this.peerCertificate);
                        this.authentication = this.tlsClient.getAuthentication();
                        this.authentication.notifyServerCertificate(this.peerCertificate);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 4: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 13: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 14: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(buf);
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        this.applyMaxFragmentLengthExtension();
                        if (this.resumedSession) {
                            this.securityParameters.masterSecret = Arrays.clone(this.sessionParameters.getMasterSecret());
                            this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
                            break block0;
                        }
                        this.invalidateSession();
                        if (this.selectedSessionID.length <= 0) break block0;
                        this.tlsSession = new TlsSessionImpl(this.selectedSessionID, null);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: 
                    case 7: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        this.recordStream.getHandshakeHash().sealHashAlgorithms();
                        Vector clientSupplementalData = this.tlsClient.getClientSupplementalData();
                        if (clientSupplementalData != null) {
                            this.sendSupplementalDataMessage(clientSupplementalData);
                        }
                        this.connection_state = (short)9;
                        TlsCredentials clientCreds = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            clientCreds = this.authentication.getClientCredentials(this.certificateRequest);
                            if (clientCreds == null) {
                                this.keyExchange.skipClientCredentials();
                                this.sendCertificateMessage(Certificate.EMPTY_CHAIN);
                            } else {
                                this.keyExchange.processClientCredentials(clientCreds);
                                this.sendCertificateMessage(clientCreds.getCertificate());
                            }
                        }
                        this.connection_state = (short)10;
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)11;
                        if (TlsUtils.isSSL(this.getContext())) {
                            TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        }
                        TlsHandshakeHash prepareFinishHash = this.recordStream.prepareToFinish();
                        this.securityParameters.sessionHash = TlsClientProtocol.getCurrentPRFHash(this.getContext(), prepareFinishHash, null);
                        if (!TlsUtils.isSSL(this.getContext())) {
                            TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        }
                        this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
                        if (clientCreds != null && clientCreds instanceof TlsSignerCredentials) {
                            TlsSignerCredentials signerCredentials = (TlsSignerCredentials)clientCreds;
                            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.getContext(), signerCredentials);
                            byte[] hash = signatureAndHashAlgorithm == null ? this.securityParameters.getSessionHash() : prepareFinishHash.getFinalHash(signatureAndHashAlgorithm.getHash());
                            byte[] signature = signerCredentials.generateCertificateSignature(hash);
                            DigitallySigned certificateVerify = new DigitallySigned(signatureAndHashAlgorithm, signature);
                            this.sendCertificateVerifyMessage(certificateVerify);
                            this.connection_state = (short)12;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)13;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: 
                    case 5: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse(this.getContext(), buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.keyExchange.validateCertificateRequest(this.certificateRequest);
                        TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)14;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (this.connection_state != 16) break;
                this.refuseRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)3;
        this.keyExchange = this.tlsClient.getKeyExchange();
        this.keyExchange.init(this.getContext());
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        byte[] renegExtData;
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        if (server_version.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        if (!server_version.equals(this.recordStream.getReadVersion())) {
            throw new TlsFatalAlert(47);
        }
        ProtocolVersion client_version = this.getContext().getClientVersion();
        if (!server_version.isEqualOrEarlierVersionOf(client_version)) {
            throw new TlsFatalAlert(47);
        }
        this.recordStream.setWriteVersion(server_version);
        this.getContextAdmin().setServerVersion(server_version);
        this.tlsClient.notifyServerVersion(server_version);
        this.securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        this.selectedSessionID = TlsUtils.readOpaque8(buf);
        if (this.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySessionID(this.selectedSessionID);
        this.resumedSession = this.selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual(this.selectedSessionID, this.tlsSession.getSessionID());
        int selectedCipherSuite = TlsUtils.readUint16(buf);
        if (!Arrays.contains(this.offeredCipherSuites, selectedCipherSuite) || selectedCipherSuite == 0 || CipherSuite.isSCSV(selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(selectedCipherSuite, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCipherSuite(selectedCipherSuite);
        short selectedCompressionMethod = TlsUtils.readUint8(buf);
        if (!Arrays.contains(this.offeredCompressionMethods, selectedCompressionMethod)) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCompressionMethod(selectedCompressionMethod);
        this.serverExtensions = TlsClientProtocol.readExtensions(buf);
        boolean bl = this.securityParameters.extendedMasterSecret = !TlsUtils.isSSL(this.tlsClientContext) && TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        if (!this.securityParameters.isExtendedMasterSecret() && (this.resumedSession || this.tlsClient.requiresExtendedMasterSecret())) {
            throw new TlsFatalAlert(40);
        }
        if (this.serverExtensions != null) {
            Enumeration e = this.serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if ((renegExtData = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtData, TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(this.secure_renegotiation);
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = this.serverExtensions;
        if (this.resumedSession) {
            if (selectedCipherSuite != this.sessionParameters.getCipherSuite() || selectedCompressionMethod != this.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        this.securityParameters.cipherSuite = selectedCipherSuite;
        this.securityParameters.compressionAlgorithm = selectedCompressionMethod;
        if (sessionServerExtensions != null && !sessionServerExtensions.isEmpty()) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(selectedCipherSuite)) {
                throw new TlsFatalAlert(47);
            }
            this.securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            this.securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
            this.securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (sessionClientExtensions != null) {
            this.tlsClient.processServerExtensions(sessionServerExtensions);
        }
        this.securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 15);
        certificateVerify.encode(message);
        message.writeToRecordStream();
    }

    protected void sendClientHelloMessage() throws IOException {
        boolean noRenegSCSV;
        this.recordStream.setWriteVersion(this.tlsClient.getClientHelloRecordLayerVersion());
        ProtocolVersion client_version = this.tlsClient.getClientVersion();
        if (client_version.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        this.getContextAdmin().setClientVersion(client_version);
        byte[] session_id = TlsUtils.EMPTY_BYTES;
        if (this.tlsSession != null && ((session_id = this.tlsSession.getSessionID()) == null || session_id.length > 32)) {
            session_id = TlsUtils.EMPTY_BYTES;
        }
        boolean fallback = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        if (!(session_id.length <= 0 || this.sessionParameters == null || this.sessionParameters.isExtendedMasterSecret() && Arrays.contains(this.offeredCipherSuites, this.sessionParameters.getCipherSuite()) && Arrays.contains(this.offeredCompressionMethods, this.sessionParameters.getCompressionAlgorithm()))) {
            session_id = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        if (!client_version.isSSL()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        }
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 1);
        TlsUtils.writeVersion(client_version, message);
        message.write(this.securityParameters.getClientRandom());
        TlsUtils.writeOpaque8(session_id, message);
        byte[] renegExtData = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        boolean noRenegExt = null == renegExtData;
        boolean bl = noRenegSCSV = !Arrays.contains(this.offeredCipherSuites, 255);
        if (noRenegExt && noRenegSCSV) {
            this.offeredCipherSuites = Arrays.append(this.offeredCipherSuites, 255);
        }
        if (fallback && !Arrays.contains(this.offeredCipherSuites, 22016)) {
            this.offeredCipherSuites = Arrays.append(this.offeredCipherSuites, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.offeredCipherSuites, message);
        TlsUtils.writeUint8ArrayWithUint8Length(this.offeredCompressionMethods, message);
        TlsClientProtocol.writeExtensions(message, this.clientExtensions);
        message.writeToRecordStream();
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 16);
        this.keyExchange.generateClientKeyExchange(message);
        message.writeToRecordStream();
    }
}

