/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlLiteCdb;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdater;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateReportFileWriter;
import it.actalis.ellips.capi.tsl.rootupdater.UpdaterProgress;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Utils;
import it.arubapec.ca.utils.FileUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class ATSLUpdater {
    public static final String a = System.getProperty("capi.certdb.customurl", "https://updatesfirma.aruba.it/sqlcdb/cert.cdb");
    private static String b = System.getProperty("capi.certdb.customurl.checksum", "https://updatesfirma.aruba.it/sqlcdb/checksum.txt");
    private final UpdateReportFileWriter c;
    private final NetworkConfig d;
    private final ManifestValidator e;
    private final CertDb f;
    private final UpdaterProgress g;
    private final File h;
    private final File i;
    private final CertDB j;

    public static ATSLUpdaterBuilder a() {
        return new ATSLUpdaterBuilder(0);
    }

    private ATSLUpdater(UpdateReportFileWriter updateReportFileWriter, NetworkConfig networkConfig, ManifestValidator manifestValidator, CertDb certDb, UpdaterProgress updaterProgress, File file, File file2, CertDB certDB) {
        this.c = updateReportFileWriter;
        this.d = networkConfig;
        this.e = manifestValidator;
        this.f = certDb;
        this.g = updaterProgress;
        this.h = file;
        this.i = file2;
        this.j = certDB;
    }

    public final boolean b() throws IOException, CapiException {
        this.c.write("\nUPDATE ARUBA TSL");
        this.c.write("--------------");
        this.g.update(0.1, "downloading the root database", "get updated root database from Aruba");
        File file = null;
        int n = 5;
        Object object = new URLCredentials(this.d.getUserProxy(), this.d.getPasswordProxy(), null, null);
        Object object2 = new UrlClient(this.d, RootUpdater.logger);
        while (n > 0) {
            this.g.update((float)(6 - --n) / 10.0f, "downloading the root database", "get updated root database from Aruba");
            try {
                file = ATSLUpdater.a(object2, object);
                if (file == null) continue;
                object = file;
                Object object3 = this;
                object3 = CertDbBuilder.get().setType(CertDbType.SQLLITE).setFile((File)object).setNetworkConfig(((ATSLUpdater)object3).d).setManifestValidator(((ATSLUpdater)object3).e).build();
                this.g.update(0.9, "downloading the root database", "get updated root database from Aruba");
                if (object3 == null || ((CertDb)object3).getServiceCount() <= 0) {
                    return false;
                }
                this.a((CertDb)object3, file);
                object3 = this;
                object = null;
                try {
                    object2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz").format(new Date());
                    object = new BufferedWriter(new FileWriter(((ATSLUpdater)object3).i));
                    object.write((String)object2);
                }
                catch (Throwable throwable) {
                    try {
                        RootUpdater.logger.error("error writing update file: " + throwable.getMessage(), throwable);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        Util.closeQuietly((Closeable)object);
                    }
                }
                Util.closeQuietly((Closeable)object);
                return true;
            }
            finally {
                if (file == null) continue;
                file.delete();
            }
        }
        RootUpdater.logger.error("CertDB update Error");
        return false;
    }

    private static File a(UrlClient object, URLCredentials object2) throws IOException {
        it.actalis.ellips.util.File file;
        FileOutputStream fileOutputStream;
        block6: {
            block5: {
                UrlReturn urlReturn = object.downloadUrl(a, new RequestData(), (URLCredentials)object2);
                if (!"OK".equals(urlReturn.getStatus())) {
                    RootUpdater.logger.error("Error downloading cert.cdb!");
                    return null;
                }
                fileOutputStream = null;
                try {
                    file = TmpFileUtils.createTempFile("ATSL_", ".cdb");
                    fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(urlReturn.getData());
                    object = object.downloadUrl(b, new RequestData(), (URLCredentials)object2);
                    if (object.getStatus().equals("OK")) break block5;
                    RootUpdater.logger.error("Error downloading checksum.txt!");
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                Util.closeQuietly(fileOutputStream);
                return null;
            }
            RootUpdater.logger.debug("atsl cdb downloaded to {}", (Object)file.getAbsolutePath());
            object = new String(object.getData());
            object2 = FileUtils.getMD5(file);
            if (((String)object).trim().equals(((String)object2).trim())) break block6;
            RootUpdater.logger.error("Error md5 do not match!");
            Util.closeQuietly(fileOutputStream);
            return null;
        }
        RootUpdater.logger.debug("checksum ok");
        object = file;
        Util.closeQuietly(fileOutputStream);
        return object;
    }

    private void a(CertDb certDb, File file) throws CapiException, IOException {
        if (this.j != null) {
            CertDBItem[] certDBItemArray = this.j.list(7);
            CertDBItem[] certDBItemArray2 = certDBItemArray;
            certDBItemArray2 = certDBItemArray;
            int n = certDBItemArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = certDBItemArray2[i];
                if (((CertDBItem)object).getSource() != 2) continue;
                object = new X509ServiceDbItem(((CertDBItem)object).getCertificate(), TSLServiceTypeIdentifiers.User);
                certDb.importService((ServiceDbItem)object);
            }
            Utils.copyFile(file, this.h, true);
        } else if (this.f != null) {
            ((SqlLiteCdb)this.f).merge(certDb);
        }
        this.c.write("Update done");
    }

    /* synthetic */ ATSLUpdater(UpdateReportFileWriter updateReportFileWriter, NetworkConfig networkConfig, ManifestValidator manifestValidator, CertDb certDb, UpdaterProgress updaterProgress, File file, File file2, CertDB certDB, byte by) {
        this(updateReportFileWriter, networkConfig, manifestValidator, certDb, updaterProgress, file, file2, certDB);
    }

    public static class ATSLUpdaterBuilder {
        private UpdateReportFileWriter a;
        private NetworkConfig b;
        private ManifestValidator c;
        private CertDb d;
        private UpdaterProgress e;
        private File f;
        private File g;
        private CertDB h;

        private ATSLUpdaterBuilder() {
        }

        public ATSLUpdaterBuilder setReportWriter(UpdateReportFileWriter updateReportFileWriter) {
            this.a = updateReportFileWriter;
            return this;
        }

        public ATSLUpdaterBuilder setNetworkConfig(NetworkConfig networkConfig) {
            this.b = networkConfig;
            return this;
        }

        public ATSLUpdaterBuilder setManifestValidator(ManifestValidator manifestValidator) {
            this.c = manifestValidator;
            return this;
        }

        public ATSLUpdaterBuilder setCdb(CertDb certDb) {
            this.d = certDb;
            return this;
        }

        public ATSLUpdaterBuilder setProgress(UpdaterProgress updaterProgress) {
            this.e = updaterProgress;
            return this;
        }

        public ATSLUpdaterBuilder setCdbFile(File file) {
            this.f = file;
            return this;
        }

        public ATSLUpdaterBuilder setLastUpdFile(File file) {
            this.g = file;
            return this;
        }

        public ATSLUpdaterBuilder setOldFormatCdb(CertDB certDB) {
            this.h = certDB;
            return this;
        }

        public ATSLUpdater build() {
            return new ATSLUpdater(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, 0);
        }

        /* synthetic */ ATSLUpdaterBuilder(byte by) {
            this();
        }
    }
}

