/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.Arrays;

public class CadesParserHelper {
    /*
     * WARNING - void declaration
     */
    public static void parseCadesEnvelope(TransientDocument transientDocument, TransientDocument transientDocument2, StreamSignedEnvelope streamSignedEnvelope, EventHandlerSelector object, DateFormat dateFormat, boolean bl) throws Exception {
        Object object2;
        object = streamSignedEnvelope.getSignedDataProxy().getCertificates();
        LinkedList<Certificate> linkedList = new LinkedList<Certificate>();
        object = ((AbstractSequentialList)object).iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)object.next();
            String string2 = Utils.calculateDigest((InputStream)new ByteArrayInputStream(x509Certificate.getEncoded()), (String)Constants.SHA256);
            RefCertificate refCertificate = new RefCertificate();
            refCertificate.setId(string2);
            refCertificate.setContent(x509Certificate.getEncoded());
            object2 = new Certificate(x509Certificate);
            refCertificate.setCapiCertificate(object2);
            linkedList.add((Certificate)object2);
            transientDocument.addCert(refCertificate);
        }
        object = streamSignedEnvelope.listSigners();
        if (object != null && ((Object)object).length > 0) {
            transientDocument.setSigned(true);
            for (int i = 0; i < ((Object)object).length; ++i) {
                void var8_16;
                void var8_14;
                Object var8_12 = null;
                if (bl) {
                    SignatureInformation signatureInformation = CadesParserHelper.a(transientDocument, streamSignedEnvelope.getSignedDataProxy().getRawSignature(i));
                }
                boolean bl2 = true;
                if (var8_14 == null) {
                    Object object3;
                    SignatureInformation signatureInformation = new SignatureInformation();
                    signatureInformation.setSignatureInfo(streamSignedEnvelope.getSignedDataProxy().getRawSignature(i));
                    signatureInformation.setFormat(SignatureFormat.CADES);
                    signatureInformation.setContainerFormat(ContainerFormat.SELF);
                    signatureInformation.setContainsGraphometricInfo(false);
                    if (streamSignedEnvelope.getSignedDataProxy().getSigningTime(i) != null) {
                        signatureInformation.setSignatureDate(dateFormat.format(streamSignedEnvelope.getSignedDataProxy().getSigningTime(i)));
                    }
                    if ((object2 = streamSignedEnvelope.getSignerCertificate(i)) != null) {
                        object3 = object2.getInternalCert().getEncoded();
                        signatureInformation.setSignerName(object2.getName());
                        object2 = Utils.calculateDigest((InputStream)new ByteArrayInputStream((byte[])object3), (String)Constants.SHA256);
                        signatureInformation.setRefsCertId((String)object2);
                        try {
                            streamSignedEnvelope.verify(i);
                            signatureInformation.setCorrupted(false);
                        }
                        catch (Exception exception) {
                            signatureInformation.setCorrupted(true);
                            bl2 = streamSignedEnvelope.getSignatureVerificationResult(i).isMessageDigestMatchCalculatedValue();
                        }
                    } else {
                        signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    CounterSignedEnvelope counterSignedEnvelope = streamSignedEnvelope.getCounterSignature(i);
                    object3 = counterSignedEnvelope;
                    if (counterSignedEnvelope != null && object3.listSigners() != null && object3.listSigners().length > 0) {
                        CadesParserHelper.a(transientDocument, (CounterSignedEnvelope)object3, signatureInformation, dateFormat);
                    }
                    object2 = streamSignedEnvelope.getSignatureTimeStampToken(i);
                    object3 = streamSignedEnvelope.getSignature(i);
                    if (object2 != null) {
                        object3 = DataHandlerBuilder.get().setBytes(object3).buildInput();
                        signatureInformation.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)transientDocument, (byte[])object2, (InputHandler)object3, (String)"", (DateFormat)dateFormat));
                    }
                } else if (streamSignedEnvelope.getSignerCertificate(i) != null) {
                    try {
                        streamSignedEnvelope.verify(i);
                    }
                    catch (Exception exception) {
                        var8_14.setCorrupted(true);
                        bl2 = streamSignedEnvelope.getSignatureVerificationResult(i).isMessageDigestMatchCalculatedValue();
                    }
                }
                var8_16.addRefDoc(new ReferenceDoc(transientDocument2.getId(), bl2));
                transientDocument.addSignerInfo((SignatureInformation)var8_16);
            }
        }
        for (RefCertificate refCertificate : transientDocument.getCerts()) {
            if (linkedList.contains(refCertificate.getCapiCertificate())) continue;
            linkedList.add(refCertificate.getCapiCertificate());
        }
        for (CRL cRL : streamSignedEnvelope.getSignedDataProxy().getCRLS()) {
            CRLUtils.addRefCrl((LinkedList)transientDocument.getCrls(), (CRL)cRL, linkedList);
        }
        for (BasicOCSPResp basicOCSPResp : streamSignedEnvelope.getSignedDataProxy().getBasicOCSPResponses()) {
            String string = Utils.calculateDigest((InputStream)new ByteArrayInputStream(basicOCSPResp.getEncoded()), (String)Constants.SHA256);
            object2 = new RefOcsp();
            object2.setId(string);
            object2.setContent(basicOCSPResp.getEncoded());
            transientDocument.addOcspresp((RefOcsp)object2);
        }
    }

    private static SignatureInformation a(TransientDocument object, byte[] byArray) {
        for (SignatureInformation signatureInformation : object.getSignerInfo()) {
            if (!Arrays.areEqual((byte[])signatureInformation.getSignatureInfo(), (byte[])byArray)) continue;
            return signatureInformation;
        }
        return null;
    }

    private static void a(TransientDocument transientDocument, CounterSignedEnvelope counterSignedEnvelope, SignatureInformation signatureInformation, DateFormat dateFormat) throws CapiException, CMSException, IOException, NoSuchAlgorithmException, FileNotFoundException, MalformedURLException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        String[] stringArray = counterSignedEnvelope.listSigners();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            SignatureInformation signatureInformation2 = new SignatureInformation();
            signatureInformation2.setSignatureInfo(counterSignedEnvelope.getSignedDataProxy().getRawSignature(i));
            signatureInformation2.setCounterSignature(true);
            signatureInformation2.setFormat(SignatureFormat.CADES);
            signatureInformation2.setContainerFormat(ContainerFormat.SELF);
            signatureInformation2.setContainsGraphometricInfo(false);
            if (counterSignedEnvelope.getSignedDataProxy().getSigningTime(i) != null) {
                signatureInformation2.setSignatureDate(dateFormat.format(counterSignedEnvelope.getSignedDataProxy().getSigningTime(i)));
            }
            if ((object2 = counterSignedEnvelope.getSignerCertificate(i)) != null) {
                object = object2.getDerEncoded();
                signatureInformation2.setSignerName(object2.getName());
                object2 = Utils.calculateDigest((InputStream)new ByteArrayInputStream((byte[])object), (String)Constants.SHA256);
                signatureInformation2.setRefsCertId((String)object2);
                try {
                    counterSignedEnvelope.verify(i);
                    signatureInformation2.setCorrupted(false);
                }
                catch (Exception exception) {
                    signatureInformation2.setCorrupted(true);
                }
            } else {
                signatureInformation2.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
            }
            signatureInformation.addCounterSignaturesInformation(signatureInformation2);
            CounterSignedEnvelope counterSignedEnvelope2 = counterSignedEnvelope.getCounterSignature(i);
            object = counterSignedEnvelope2;
            if (counterSignedEnvelope2 != null && object.listSigners().length > 0) {
                CadesParserHelper.a(transientDocument, (CounterSignedEnvelope)object, signatureInformation2, dateFormat);
            }
            object2 = counterSignedEnvelope.getSignatureTimeStampToken(i);
            object = counterSignedEnvelope.getSignature(i);
            if (object2 == null) continue;
            object = DataHandlerBuilder.get().setBytes(object).buildInput();
            signatureInformation2.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)transientDocument, (byte[])object2, (InputHandler)object, (String)"", (DateFormat)dateFormat));
        }
    }
}

