/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.v5.DigitalIdentityListType;
import esecurity.tsl.v5.DigitalIdentityType;
import esecurity.tsl.v5.ExtensionsListType;
import esecurity.tsl.v5.ServiceHistoryInstanceType;
import esecurity.tsl.v5.TSPServiceType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TslServiceDbItem
extends ServiceDbItem {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final List<ServiceDbItem> history = new ArrayList<ServiceDbItem>();
    private Certificate cert;
    private ExtensionsListType extensions;
    private Date statusStartingTime;
    private TslServiceDbItem parent;
    private String serviceType;
    private String serviceStatus;
    private boolean validSignature;
    private byte[] rawData;

    public TslServiceDbItem(TSPServiceType tSPServiceType) throws CapiException {
        this(tSPServiceType, false);
    }

    public TslServiceDbItem(TSPServiceType tSPServiceType, boolean bl) throws CapiException {
        this.initCert(tSPServiceType.getServiceInformation().getServiceDigitalIdentity());
        this.extensions = tSPServiceType.getServiceInformation().getServiceInformationExtensions();
        this.statusStartingTime = tSPServiceType.getServiceInformation().getStatusStartingTime().toGregorianCalendar().getTime();
        this.serviceType = tSPServiceType.getServiceInformation().getServiceTypeIdentifier();
        this.serviceStatus = tSPServiceType.getServiceInformation().getServiceStatus();
        if (tSPServiceType.getServiceHistory() != null) {
            for (ServiceHistoryInstanceType serviceHistoryInstanceType : tSPServiceType.getServiceHistory().getServiceHistoryInstance()) {
                this.history.add(new TslServiceDbItem(serviceHistoryInstanceType, this));
            }
        }
        this.validSignature = bl;
        this.storeRawData(tSPServiceType);
    }

    private void storeRawData(TSPServiceType tSPServiceType) throws CapiException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Charset.forName("UTF-8"));
            OBJECT_MAPPER.writeValue((Writer)outputStreamWriter, (Object)tSPServiceType);
            byteArrayOutputStream.flush();
            this.rawData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to import service", 1003);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(outputStreamWriter);
                Util.closeQuietly(byteArrayOutputStream);
                throw throwable;
            }
        }
        Util.closeQuietly(outputStreamWriter);
        Util.closeQuietly(byteArrayOutputStream);
        return;
    }

    private TslServiceDbItem(ServiceHistoryInstanceType serviceHistoryInstanceType, TslServiceDbItem tslServiceDbItem) throws CapiException {
        this.parent = tslServiceDbItem;
        this.initCert(serviceHistoryInstanceType.getServiceDigitalIdentity());
        this.extensions = serviceHistoryInstanceType.getServiceInformationExtensions();
        this.statusStartingTime = serviceHistoryInstanceType.getStatusStartingTime().toGregorianCalendar().getTime();
        this.serviceType = serviceHistoryInstanceType.getServiceTypeIdentifier();
        this.serviceStatus = serviceHistoryInstanceType.getServiceStatus();
    }

    private void initCert(DigitalIdentityListType object) throws CapiException {
        for (DigitalIdentityType digitalIdentityType : ((DigitalIdentityListType)object).getDigitalId()) {
            if (digitalIdentityType.getX509Certificate() == null) continue;
            this.cert = new Certificate(digitalIdentityType.getX509Certificate(), false);
            return;
        }
        if (this.cert == null && this.parent != null) {
            this.cert = this.parent.getCert();
            return;
        }
        throw new CapiException("Error Certificate not found.", 1003);
    }

    @Override
    public String getServiceStatus() {
        return this.serviceStatus;
    }

    @Override
    public TSLServiceTypeIdentifiers getServiceType() {
        return TSLServiceTypeIdentifiers.fromUri(this.serviceType);
    }

    @Override
    public Date getStatusStartingTime() {
        return this.statusStartingTime;
    }

    @Override
    public Certificate getCert() {
        return this.cert;
    }

    @Override
    public ExtensionsListType getExtensions() {
        return this.extensions;
    }

    @Override
    public List<ServiceDbItem> getHistory() {
        return this.history;
    }

    @Override
    public boolean isValidSignature() {
        return this.validSignature;
    }

    public byte[] getRowData() {
        return this.rawData;
    }

    public static ObjectMapper getDefaultObjectMapper() {
        return OBJECT_MAPPER;
    }

    @Override
    public void setValidSignature(boolean bl) {
        this.validSignature = bl;
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

