/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import com.amazonaws.util.Base64;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class TimeStampToken {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final ASN1ObjectIdentifier b = new ASN1ObjectIdentifier("0.4.0.19422.1.1");
    private boolean c = false;
    private List<Certificate> d = new ArrayList<Certificate>();
    private Certificate e = null;
    private TimeStampResponse f = null;
    private org.bouncycastle.tsp.TimeStampToken g = null;

    public TimeStampToken(byte[] object) throws CapiException {
        Object object2;
        Object object3 = object;
        try {
            if (!Util.isDerSequence((byte[])object)) {
                object3 = Util.base64Decode((byte[])object);
            }
            this.f = new TimeStampResponse(object3);
            this.g = this.f.getTimeStampToken();
        }
        catch (Exception exception) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(object3);
                object3 = aSN1InputStream;
                object2 = ASN1Sequence.getInstance((Object)aSN1InputStream.readObject());
                this.g = new org.bouncycastle.tsp.TimeStampToken(ContentInfo.getInstance((Object)object2));
            }
            catch (IOException | TSPException throwable) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException(exception.getMessage(), 50040);
            }
        }
        try {
            LinkedList linkedList = new LinkedList(this.g.toCMSSignedData().getCertificates().getMatches((Selector)this.g.getSID()));
            object = linkedList;
            if (!linkedList.isEmpty()) {
                this.e = new Certificate(((X509CertificateHolder)((LinkedList)object).get(0)).getEncoded());
                Collection collection = this.g.toCMSSignedData().getCertificates().getMatches(null);
                object3 = collection;
                for (X509CertificateHolder x509CertificateHolder : collection) {
                    this.d.add(new Certificate(x509CertificateHolder.getEncoded()));
                }
            }
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException(iOException.getMessage(), 50040);
        }
        if (this.g.getTimeStampInfo().getAccuracy() != null && this.g.getTimeStampInfo().getExtensions() != null) {
            object = (DERSequence)this.g.getTimeStampInfo().getExtensions().toASN1Primitive();
            for (int i = 0; i < object.size(); ++i) {
                if (!((ASN1ObjectIdentifier)((DERSequence)object.getObjectAt(i).toASN1Primitive()).getObjectAt(0)).getId().equals("1.3.6.1.5.5.7.1.3")) continue;
                try {
                    X509CertificateHolder x509CertificateHolder;
                    byte[] byArray = ((DEROctetString)((DERSequence)object.getObjectAt(i).toASN1Primitive()).getObjectAt(1)).getOctets();
                    object2 = byArray;
                    x509CertificateHolder = (DLSequence)ASN1Primitive.fromByteArray((byte[])byArray);
                    if (((ASN1ObjectIdentifier)((DLSequence)x509CertificateHolder.getObjectAt(0)).getObjectAt(0).toASN1Primitive()).equals((ASN1Primitive)b)) {
                        this.c = true;
                        return;
                    }
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getTimeStamp() {
        ASN1GeneralizedTime aSN1GeneralizedTime = new ASN1GeneralizedTime(this.g.getTimeStampInfo().getGenTime());
        return aSN1GeneralizedTime.getTime().substring(0, 14) + "Z";
    }

    public String getPolicyId() {
        return this.g.getTimeStampInfo().getPolicy().getId();
    }

    public BigInteger getSerialNumber() {
        return this.g.getTimeStampInfo().getSerialNumber();
    }

    public String getTSAName() {
        return this.g.getTimeStampInfo().getTsa().getName().toString();
    }

    public BigInteger getNonce() {
        return this.g.getTimeStampInfo().getNonce();
    }

    public Accuracy getAccuracy() throws ApiGeneralException {
        return this.g.getTimeStampInfo().getAccuracy();
    }

    public int getStatus() {
        if (this.f != null) {
            return this.f.getStatus();
        }
        return 0;
    }

    public byte[] toByteArray(boolean bl) throws CapiException, IOException {
        return this.toByteArray(bl, false);
    }

    public byte[] toByteArray(boolean bl, boolean bl2) throws CapiException, IOException {
        byte[] byArray;
        if (bl2) {
            byArray = this.g.getEncoded();
        } else if (this.f != null) {
            byArray = this.f.getEncoded();
        } else {
            throw new CapiException("Crypto Exception: TSResp toByteArray from a TST", 50040);
        }
        if (bl) {
            return Base64.encode((byte[])byArray);
        }
        return byArray;
    }

    public String toString() {
        return this.g.toString();
    }

    public Certificate getTSACert() throws CapiException {
        try {
            LinkedList linkedList = new LinkedList(this.g.toCMSSignedData().getCertificates().getMatches((Selector)this.g.getSID()));
            if (linkedList.isEmpty()) {
                return null;
            }
            return new Certificate(((X509CertificateHolder)linkedList.get(0)).getEncoded());
        }
        catch (CapiException | IOException | StoreException throwable) {
            throw new CapiException(throwable.getMessage(), 50040);
        }
    }

    public List<Certificate> listCertificates() throws ApiGeneralException {
        return this.d;
    }

    public boolean compare(byte[] object, boolean bl) {
        a.debug("compare...");
        try {
            if (bl) {
                return java.util.Arrays.equals(this.g.getTimeStampInfo().getMessageImprintDigest(), object);
            }
            object = new ByteArrayInputStream((byte[])object);
            return this.compare((InputStream)object);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean compare(InputStream object) {
        try {
            object = DigestUtils.calculate(DigestAlgorithm.valueFromCadesId(this.g.getTimeStampInfo().getMessageImprintAlgOID().getId()), (InputStream)object);
            byte[] byArray = this.g.getTimeStampInfo().getMessageImprintDigest();
            a.debug("[verify]digest: " + new String(Hex.encode((byte[])byArray)));
            a.debug("[verify]recalc. digest: " + new String(Hex.encode((byte[])object)));
            return Arrays.areEqual((byte[])byArray, (byte[])object);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean verifySignature() throws CapiException {
        if (this.e == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        try {
            a.debug("tsaCert not null");
            SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(new Certificate(this.e.getInternalCert()).getInternalCert());
            return this.g.isSignatureValid(signerInformationVerifier);
        }
        catch (OperatorCreationException | TSPException throwable) {
            a.error(throwable.getMessage(), throwable);
            throw new CapiException("Crypto Exception verifying SignerInfo signature: " + throwable.getMessage(), 50010);
        }
    }

    public byte[] getHashedMessage() {
        return this.g.getTimeStampInfo().getMessageImprintDigest();
    }

    public String getSignerDigestAlg() {
        if (DigestAlgorithm.SHA1.getId().equals(this.g.getTimeStampInfo().getMessageImprintAlgOID().getId())) {
            return "SHA1";
        }
        if (DigestAlgorithm.SHA256.getId().equals(this.g.getTimeStampInfo().getMessageImprintAlgOID().getId())) {
            return "SHA256";
        }
        return this.g.getTimeStampInfo().getMessageImprintAlgOID().getId();
    }

    public boolean hasSigningCertificate() throws CapiException {
        if (this.e == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        TimeStampToken timeStampToken = this;
        return timeStampToken.a(timeStampToken.e.getInternalCert());
    }

    private boolean a(X509Certificate x509Certificate) throws CapiException {
        AttributeTable attributeTable = this.g.getSignedAttributes();
        if (attributeTable == null) {
            a.debug("No signed attribute table found.");
            return false;
        }
        if ((attributeTable = attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate)) == null) {
            a.debug("No signing certificate attribute found.");
            return false;
        }
        try {
            a.debug("Found signing certificate attribute V1");
            attributeTable = SigningCertificate.getInstance((Object)attributeTable.getAttrValues().getObjectAt(0));
            attributeTable = ESSCertID.getInstance((Object)attributeTable.getCerts()[0]);
            a.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID((ESSCertID)attributeTable, x509Certificate);
        }
        catch (CapiException capiException) {
            throw new CapiException("Cannot parse ESSCertID", 3010, capiException);
        }
        a.debug("ESSCertID V1 successfully validated.");
        return true;
    }

    public boolean hasSigningCertificateV2() throws CapiException {
        if (this.e == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        TimeStampToken timeStampToken = this;
        return timeStampToken.b(timeStampToken.e.getInternalCert()) != null;
    }

    public String getSigningCertificateV2HashAlg() throws CapiException {
        if (this.e == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        TimeStampToken timeStampToken = this;
        return timeStampToken.b(timeStampToken.e.getInternalCert());
    }

    private String b(X509Certificate x509Certificate) throws CapiException {
        Object object = this.g.getSignedAttributes();
        if (object == null) {
            a.debug("No signed attribute table found.");
            return null;
        }
        if ((object = object.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) == null) {
            a.debug("No signing certificate attribute V2 found.");
            return null;
        }
        a.debug("Found signing certificate attribute V2.");
        object = (ASN1Sequence)object.getAttrValues().getObjectAt(0);
        ESSCertIDv2 eSSCertIDv2 = SigningCertificateV2.getInstance((Object)object);
        try {
            eSSCertIDv2 = eSSCertIDv2.getCerts();
            eSSCertIDv2 = eSSCertIDv2[0];
        }
        catch (Exception exception) {
            a.debug("Cannot instantiate ESSCertIDv2: Exception " + exception.getMessage() + ". Retrying...");
            object = ASN1Sequence.getInstance((Object)object.getObjectAt(0));
            if (object.size() <= 0) {
                throw new CapiException("Cannot parse ESSCertIDv2", 3010);
            }
            if ((object = ASN1Sequence.getInstance((Object)object.getObjectAt(0))).size() == 1) {
                a.debug("ESSCertIDv2 contains only SHA256 Hash");
                object = ASN1OctetString.getInstance((Object)object.getObjectAt(0).toASN1Primitive()).getOctets();
                eSSCertIDv2 = new ESSCertIDv2(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), (byte[])object);
            }
            eSSCertIDv2 = ESSCertIDv2.getInstance((Object)object);
        }
        if (eSSCertIDv2 != null) {
            a.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID(eSSCertIDv2, x509Certificate);
            a.debug("ESSCertID V2 successfully validated.");
            return eSSCertIDv2.getHashAlgorithm().getAlgorithm().getId();
        }
        throw new CapiException("Cannot parse ESSCertIDv2", 3010);
    }

    public Date getDate() {
        try {
            Object object = this.getTimeStamp();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(timeZone);
            object = simpleDateFormat.parse(((String)object).trim());
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isEIDASCompliance() {
        return this.c;
    }

    public String getSignerEncryptionAlg() {
        return this.g.toCMSSignedData().getSignerInfos().get(this.g.getSID()).getEncryptionAlgOID();
    }

    public org.bouncycastle.tsp.TimeStampToken getInternalTst() {
        return this.g;
    }
}

