/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cmd.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import esecurity.dsd.client.cmd.Command;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.http.AdminHTTPClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Parameters(separators="=: ", commandDescription="Create a domain or copy from another.")
public class CommandCreateDomain
implements Command {
    @Parameter(names={"domain"}, description="Specify domain name.", required=true)
    private String domain = null;
    @Parameter(names={"replica"}, description="Specify domain name of the replica.")
    private String replica = null;
    @Parameter(names={"withData"}, description="If true create a clone, false copy only the domain structure.")
    private boolean withData = false;
    @Parameter(names={"private"}, description="List of private keys.")
    List<String> privateKeys = new ArrayList<String>();
    @DynamicParameter(names={"-K"}, description="Map of key and values")
    private Map<String, String> keys = new HashMap<String, String>();

    @Override
    public void execute(LocalConfigurationProvider lcp) {
        AdminHTTPClient adminHTTPClient = new AdminHTTPClient(lcp);
        if (this.replica != null) {
            adminHTTPClient.copyDomain(this.domain, this.replica, this.withData, this.privateKeys.toArray(new String[this.privateKeys.size()]));
        } else {
            JsonObject json = new JsonObject();
            this.keys.forEach((k, v) -> json.addProperty(k, v));
            adminHTTPClient.createDomain(this.domain, (JsonElement)json, this.privateKeys.toArray(new String[this.privateKeys.size()]));
        }
    }

    @Override
    public String getCommand() {
        return "create";
    }
}

