/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.validator.parser.utils.OcspUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.AppearanceCloner;
import it.actalis.ellips.capi.pades.CompareByteRangeSignature;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.StringWrap;
import it.actalis.ellips.capi.pdf.TextContainer;
import it.actalis.vol.utils.Constants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class PadesUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String FONT_REGULAR_RESOURCE = "/font/Lato-Regular.ttf";
    public static final String FONT_BOLD_RESOURCE = "/font/Lato-Bold.ttf";
    public static final String FONT_NAME = "lato";
    private static int b;
    private static boolean c;

    public static boolean isBlockedPdf(PDDocument object) {
        Object object2 = object.getDocumentCatalog().getAcroForm();
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        COSDictionary object32 = object.getDocument().getTrailer();
        if (object32 == null) {
            a.error("[initialize] trailer is null.");
            return false;
        }
        COSDictionary cOSDictionary = (COSDictionary)object32.getDictionaryObject(COSName.ROOT);
        if (cOSDictionary == null) {
            a.error("[initialize] root is null");
            return false;
        }
        cOSDictionary.getDictionaryObject("DSS");
        object2 = object2.getFields();
        if (object2 == null || object2.size() <= 0) {
            a.debug("[findSignature] no fields");
            return false;
        }
        object = PadesUtils.retrieveDssInfo((PDDocument)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            PDField pDField = (PDField)object2.next();
            PadesUtils.a(pDField, linkedList, (PadesDssInfo)object);
        }
        for (PadesSignatureInformation padesSignatureInformation : linkedList) {
            if (padesSignatureInformation.getCertificationLevel() != 1) continue;
            return true;
        }
        return false;
    }

    private static void a(PDField pDField, LinkedList<PadesSignatureInformation> linkedList, PadesDssInfo padesDssInfo) {
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (pDSignatureField.getValue() == null) {
                a.debug("[findSignature] Empty SignatureField ignored.");
            }
            if (PadesUtils.a(pDSignatureField.getCOSObject()) && !PadesUtils.a(string, linkedList)) {
                linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                a.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                PadesUtils.a((PDField)string, linkedList, padesDssInfo);
            }
        }
    }

    public static List<PDSignatureField> parseEmptyField(PDField pDField) {
        LinkedList<PDSignatureField> linkedList = new LinkedList<PDSignatureField>();
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (pDSignatureField.getValue() == null) {
                linkedList.add(pDSignatureField);
                a.debug("[findSignature] Empty SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                linkedList.addAll(PadesUtils.parseEmptyField((PDField)string));
            }
        }
        return linkedList;
    }

    private static boolean a(COSDictionary cOSDictionary) {
        COSString cOSString = (COSString)cOSDictionary.getDictionaryObject(COSName.T);
        if (cOSString != null) {
            a.debug("[initialize][isSignatureField] Signature: " + cOSString.getString());
        } else {
            a.debug("[initialize][isSignatureField] Signature: warning sigName is null");
        }
        cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(COSName.V);
        if (cOSDictionary != null) {
            if ((cOSDictionary = (COSName)cOSDictionary.getDictionaryObject(COSName.getPDFName((String)"SubFilter"))) != null) {
                if (cOSDictionary.getName().equals("adbe.x509.rsa_sha1")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.x509.rsa_sha1");
                    return true;
                }
                if (cOSDictionary.getName().equals("adbe.pkcs7.sha1")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.sha1");
                    return true;
                }
                if (cOSDictionary.getName().equals("adbe.pkcs7.detached")) {
                    a.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.detached");
                    return true;
                }
                if (cOSDictionary.getName().equals("ETSI.CAdES.detached")) {
                    a.debug("[initialize][isSignatureField] subfilter: ETSI.CAdES.detached");
                    return true;
                }
                if (cOSDictionary.getName().equals("ETSI.RFC3161")) {
                    a.debug("[initialize][isSignatureField] subfilter: ETSI.RFC3161");
                    return true;
                }
                a.error("[initialize][isSignatureField] unknown subfilter:" + cOSDictionary);
                return true;
            }
            a.debug("[initialize][isSignatureField] Missing subfilter");
        } else {
            a.debug("[initialize][isSignatureField] is empty");
        }
        return false;
    }

    private static boolean a(String string, LinkedList<PadesSignatureInformation> linkedList) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            String string2 = linkedList.get(i).getName();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String createVisualSignatureImage(CapiPDFApparence object) throws IOException {
        String string3 = PadesUtils.a((CapiPDFApparence)object);
        float f = ((CapiPDFApparence)object).getWidth();
        float f2 = ((CapiPDFApparence)object).getHeight();
        int n = ((CapiPDFApparence)object).getFontSize();
        boolean bl = ((CapiPDFApparence)object).isScaleFont();
        BufferedImage bufferedImage = ((CapiPDFApparence)object).getImage();
        StringWrap stringWrap = new StringWrap();
        BufferedImage bufferedImage2 = new BufferedImage((int)f, (int)f2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (bufferedImage != null) {
            float f3 = bufferedImage.getWidth();
            float f4 = bufferedImage.getHeight();
            float f5 = f2;
            float f6 = f;
            List<String> list = "H";
            if (!((CapiPDFApparence)object).isOnly_image()) {
                float f7;
                float f8 = f4 / f2;
                float f9 = f3 / f;
                if (f7 > f8) {
                    f5 = f2 / 2.0f;
                    list = "V";
                } else {
                    f6 = f / 2.0f;
                    list = "H";
                }
            }
            float f10 = f6;
            String string2 = list;
            int n2 = ((CapiPDFApparence)object).getResizeMode();
            f6 = f5;
            f5 = f10;
            float f11 = 0.0f;
            float f12 = 0.0f;
            if (f5 < f6) {
                f3 = f4 * f5 / f3;
                f4 = f5;
                if (f3 > f6) {
                    f4 = f4 * f6 / f3;
                    f3 = f6;
                }
            } else {
                f4 = f3 * f6 / f4;
                f3 = f6;
                if (f4 > f5) {
                    f3 = f3 * f5 / f4;
                    f4 = f5;
                }
            }
            switch (n2) {
                case 1: {
                    f4 = f5;
                    f3 = f6;
                    f11 = 0.0f;
                    f12 = 0.0f;
                    break;
                }
                case 2: {
                    f11 = (f5 - f4) / 2.0f;
                    f12 = (f6 - f3) / 2.0f;
                    break;
                }
                case 3: {
                    if (string2.equalsIgnoreCase("H")) {
                        f11 = f5 - f4;
                        f12 = (f6 - f3) / 2.0f;
                        break;
                    }
                    f11 = (f5 - f4) / 2.0f;
                    f12 = 0.0f;
                    break;
                }
                case 4: {
                    if (string2.equalsIgnoreCase("H")) {
                        f11 = 0.0f;
                        f12 = (f6 - f3) / 2.0f;
                        break;
                    }
                    f11 = (f5 - f4) / 2.0f;
                    f12 = f6 * 2.0f - f3;
                }
            }
            Object object2 = new a(f11, f12, f4, f3);
            if (((CapiPDFApparence)object).isPDFASignature()) {
                bufferedImage = ((CapiPDFApparence)object).isGray() ? PadesUtils.a(bufferedImage) : PadesUtils.b(bufferedImage);
            }
            graphics2D.drawImage(bufferedImage.getScaledInstance((int)((RectangularShape)object2).getWidth(), (int)((RectangularShape)object2).getHeight(), 4), (int)((RectangularShape)object2).getX(), (int)((RectangularShape)object2).getY(), null);
            if (!((CapiPDFApparence)object).isOnly_image()) {
                a a2 = ((String)((Object)list)).equals("H") ? new a((float)(((RectangularShape)object2).getX() + ((RectangularShape)object2).getWidth()), 0.0, ((RectangularShape)object2).getX() + ((RectangularShape)object2).getWidth(), f2) : new a(0.0, ((RectangularShape)object2).getY() + ((RectangularShape)object2).getHeight(), f, (double)f2 - (((RectangularShape)object2).getY() + ((RectangularShape)object2).getHeight()));
                object = PDType0Font.load((PDDocument)((CapiPDFApparence)object).getPdDocument(), (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
                list = PadesUtils.a(string3);
                list = stringWrap.performWrap(list, (float)((RectangularShape)a2).getWidth(), (PDFont)object, n);
                try {
                    if (bl) {
                        while (!PadesUtils.a(list, (PDFont)object, n, (float)((RectangularShape)a2).getWidth(), (float)((RectangularShape)a2).getHeight()) && n < 100) {
                            list = PadesUtils.a(string3);
                            list = stringWrap.performWrap(list, (float)((RectangularShape)a2).getWidth(), (PDFont)object, ++n);
                        }
                    }
                    while (PadesUtils.a(list, (PDFont)object, n, (float)((RectangularShape)a2).getWidth(), (float)((RectangularShape)a2).getHeight()) && n > 1) {
                        list = PadesUtils.a(string3);
                        list = stringWrap.performWrap(list, (float)((RectangularShape)a2).getWidth(), (PDFont)object, --n);
                    }
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
                if (!c) {
                    try {
                        object2 = Font.createFont(0, PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont((Font)object2);
                        c = true;
                    }
                    catch (FontFormatException fontFormatException) {
                        a.error(fontFormatException.getMessage(), (Throwable)fontFormatException);
                    }
                }
                graphics2D.setFont(new Font(FONT_NAME, 0, n));
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.BLACK);
                int n3 = (int)((RectangularShape)a2).getY();
                for (String string3 : list) {
                    graphics2D.drawString(string3, (int)((RectangularShape)a2).getX(), n3 += n);
                }
            }
        } else {
            a a3 = new a(0.0, 0.0, f, f2);
            PDType0Font pDType0Font = PDType0Font.load((PDDocument)((CapiPDFApparence)object).getPdDocument(), (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
            List<String> list = PadesUtils.a(string3);
            list = stringWrap.performWrap(list, (float)a3.getWidth(), (PDFont)pDType0Font, n);
            try {
                if (bl) {
                    while (!PadesUtils.a(list, (PDFont)pDType0Font, n, (float)a3.getWidth(), (float)a3.getHeight()) && n < 100) {
                        list = PadesUtils.a(string3);
                        list = stringWrap.performWrap(list, (float)a3.getWidth(), (PDFont)pDType0Font, ++n);
                    }
                }
                while (PadesUtils.a(list, (PDFont)pDType0Font, n, (float)a3.getWidth(), (float)a3.getHeight()) && n > 1) {
                    list = PadesUtils.a(string3);
                    list = stringWrap.performWrap(list, (float)a3.getWidth(), (PDFont)pDType0Font, --n);
                }
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
            graphics2D.setFont(new Font(FONT_NAME, 0, n));
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setColor(Color.BLACK);
            int n4 = 0;
            for (String string4 : list) {
                graphics2D.drawString(string4, (int)a3.getX(), n4 += n);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        return new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray()));
    }

    public static InputStream createVisualSignature(CapiPDFApparence capiPDFApparence) throws IOException {
        ArrayList<CapiPDFApparence> arrayList = new ArrayList<CapiPDFApparence>();
        arrayList.add(capiPDFApparence);
        return PadesUtils.a(capiPDFApparence.getPdDocument(), arrayList);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addAppearanceAnnotations(PDDocument object, List<CapiPDFApparence> list) throws IOException {
        void var1_5;
        Object object2 = PadesUtils.a(object, (List<CapiPDFApparence>)var1_5);
        try {
            ScratchFile scratchFile;
            block16: {
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                Throwable throwable = null;
                try {
                    Object object3 = scratchFile;
                    object2 = object3.createBuffer((InputStream)object2);
                    object2 = new PDFParser((RandomAccessRead)object2, (ScratchFile)object3);
                    object2 = object2.parse();
                    object3 = null;
                    try {
                        AppearanceCloner appearanceCloner = new AppearanceCloner((List<CapiPDFApparence>)var1_5, (PDDocument)object, (PDDocument)object2);
                        appearanceCloner.cloneToOriginalDocument();
                        if (object2 == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            object3 = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (object2 == null) throw throwable4;
                            if (object3 == null) {
                                object2.close();
                                throw throwable4;
                            }
                            try {
                                object2.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)object3).addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    object2.close();
                }
                catch (Throwable throwable6) {
                    try {
                        object2 = throwable6;
                        throwable = throwable6;
                        throw object2;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            scratchFile.close();
                            throw throwable7;
                        }
                        try {
                            scratchFile.close();
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                            throw throwable7;
                        }
                    }
                }
            }
            scratchFile.close();
            return;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private static InputStream a(PDDocument pDDocument, List<CapiPDFApparence> object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDDocument pDDocument2 = new PDDocument();
        Throwable throwable = null;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3 = (CapiPDFApparence)object.next();
                Object object4 = pDDocument.getPage(((CapiPDFApparence)object3).getPage() - 1);
                b = object4.getRotation();
                PDPage pDPage = object4;
                CapiPDFApparence capiPDFApparence = object3;
                object4 = pDDocument2;
                object3 = pDPage;
                Object object5 = new PDPage(object3.getMediaBox());
                object4.addPage((PDPage)object5);
                PDPage pDPage2 = object4;
                PDRectangle pDRectangle = object5.getCropBox();
                object5 = capiPDFApparence;
                capiPDFApparence = object3.getCropBox();
                object4 = pDRectangle;
                object3 = pDPage2;
                if (pDPage2.getDocumentCatalog().getAcroForm() == null) {
                    object2 = new PDAcroForm((PDDocument)object3);
                    object3.getDocumentCatalog().setAcroForm((PDAcroForm)object2);
                } else {
                    object2 = object3.getDocumentCatalog().getAcroForm();
                }
                Object object6 = new PDSignatureField((PDAcroForm)object2);
                Object object7 = (PDAnnotationWidget)object6.getWidgets().get(0);
                Object object8 = object2.getFields();
                object2.setSignaturesExist(true);
                object2.setAppendOnly(true);
                object2.getCOSObject().setDirect(true);
                object8.add(object6);
                object4 = b == 90 || b == 270 ? new a(((CapiPDFApparence)object5).getPosX(), object4.getWidth() - ((CapiPDFApparence)object5).getPosY(), ((CapiPDFApparence)object5).getWidth(), ((CapiPDFApparence)object5).getHeight()) : new a(((CapiPDFApparence)object5).getPosX(), object4.getHeight() - ((CapiPDFApparence)object5).getPosY(), ((CapiPDFApparence)object5).getWidth(), ((CapiPDFApparence)object5).getHeight());
                CapiPDFApparence capiPDFApparence2 = capiPDFApparence;
                capiPDFApparence = object4;
                object4 = capiPDFApparence2;
                float f = (float)((RectangularShape)((Object)capiPDFApparence)).getX();
                float f2 = (float)((RectangularShape)((Object)capiPDFApparence)).getY();
                float f3 = (float)((RectangularShape)((Object)capiPDFApparence)).getWidth();
                float f4 = (float)((RectangularShape)((Object)capiPDFApparence)).getHeight();
                PDRectangle pDRectangle2 = new PDRectangle();
                switch (b) {
                    case 90: {
                        pDRectangle2.setLowerLeftY(f);
                        pDRectangle2.setUpperRightY(f + f3);
                        pDRectangle2.setLowerLeftX(f2);
                        pDRectangle2.setUpperRightX(f2 + f4);
                        break;
                    }
                    case 180: {
                        pDRectangle2.setUpperRightX(object4.getWidth() - f);
                        pDRectangle2.setLowerLeftX(object4.getWidth() - f - f3);
                        pDRectangle2.setLowerLeftY(f2);
                        pDRectangle2.setUpperRightY(f2 + f4);
                        break;
                    }
                    case 270: {
                        pDRectangle2.setLowerLeftY(object4.getHeight() - f - f3);
                        pDRectangle2.setUpperRightY(object4.getHeight() - f);
                        pDRectangle2.setLowerLeftX(object4.getWidth() - f2 - f4);
                        pDRectangle2.setUpperRightX(object4.getWidth() - f2);
                        break;
                    }
                    default: {
                        pDRectangle2.setLowerLeftX(f);
                        pDRectangle2.setUpperRightX(f + f3);
                        pDRectangle2.setLowerLeftY(object4.getHeight() - f2 - f4);
                        pDRectangle2.setUpperRightY(object4.getHeight() - f2);
                    }
                }
                object4 = pDRectangle2;
                object7.setRectangle((PDRectangle)object4);
                PDStream pDStream = new PDStream((PDDocument)object3);
                pDStream = new PDFormXObject(pDStream);
                object2 = new PDResources();
                pDStream.setResources((PDResources)object2);
                pDStream.setFormType(1);
                object4 = new PDRectangle(object4.getWidth(), object4.getHeight());
                object2 = null;
                switch (b) {
                    case 90: {
                        pDStream.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                        object2 = Matrix.getScaleInstance((float)(object4.getWidth() / object4.getHeight()), (float)(object4.getHeight() / object4.getWidth()));
                        break;
                    }
                    case 180: {
                        pDStream.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                        break;
                    }
                    case 270: {
                        pDStream.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                        object2 = Matrix.getScaleInstance((float)(object4.getWidth() / object4.getHeight()), (float)(object4.getHeight() / object4.getWidth()));
                    }
                }
                pDStream.setBBox((PDRectangle)object4);
                object4 = new PDAppearanceDictionary();
                object4.getCOSObject().setDirect(true);
                pDStream = new PDAppearanceStream(pDStream.getCOSObject());
                object4.setNormalAppearance((PDAppearanceStream)pDStream);
                object7.setAppearance((PDAppearanceDictionary)object4);
                PDPageContentStream pDPageContentStream = new PDPageContentStream((PDDocument)object3, (PDAppearanceStream)pDStream);
                PDAcroForm pDAcroForm = object2;
                object6 = object3;
                object2 = object5;
                pDStream = pDAcroForm;
                object4 = pDPageContentStream;
                if (pDStream != null) {
                    object4.transform((Matrix)pDStream);
                }
                object4.saveGraphicsState();
                object8 = PadesUtils.a((CapiPDFApparence)object2);
                float f5 = ((CapiPDFApparence)object2).getWidth();
                float f6 = ((CapiPDFApparence)object2).getHeight();
                object3 = ((CapiPDFApparence)object2).getImage();
                if (object3 != null) {
                    float f7;
                    float f8 = ((BufferedImage)object3).getWidth();
                    float f9 = ((BufferedImage)object3).getHeight();
                    float f10 = f6;
                    float f11 = f5;
                    String string = "H";
                    if (!((CapiPDFApparence)object2).isOnly_image()) {
                        float f12;
                        float f13 = f9 / f6;
                        f7 = f8 / f5;
                        if (f12 > f13) {
                            f10 = f6 / 2.0f;
                            string = "V";
                        } else {
                            f11 = f5 / 2.0f;
                            string = "H";
                        }
                    }
                    String string2 = string;
                    int n = ((CapiPDFApparence)object2).getResizeMode();
                    f7 = f10;
                    f10 = f9;
                    f9 = f8;
                    float f14 = 0.0f;
                    float f15 = 0.0f;
                    if (f11 < f7) {
                        f9 = f10 * f11 / f9;
                        f10 = f11;
                        if (f9 > f7) {
                            f10 = f10 * f7 / f9;
                            f9 = f7;
                        }
                    } else {
                        f10 = f9 * f7 / f10;
                        f9 = f7;
                        if (f10 > f11) {
                            f9 = f9 * f11 / f10;
                            f10 = f11;
                        }
                    }
                    switch (n) {
                        case 1: {
                            f10 = f11;
                            f9 = f7;
                            if (string2.equalsIgnoreCase("H")) {
                                f14 = 0.0f;
                                f15 = 0.0f;
                                break;
                            }
                            f14 = 0.0f;
                            f15 = f7;
                            break;
                        }
                        case 2: {
                            if (string2.equalsIgnoreCase("H")) {
                                f14 = (f11 - f10) / 2.0f;
                                f15 = (f7 - f9) / 2.0f;
                                break;
                            }
                            f14 = (f11 - f10) / 2.0f;
                            float f16 = f7;
                            f15 = f16 + (f16 - f9) / 2.0f;
                            break;
                        }
                        case 3: {
                            if (string2.equalsIgnoreCase("H")) {
                                f14 = f11 - f10;
                                f15 = (f7 - f9) / 2.0f;
                                break;
                            }
                            f14 = (f11 - f10) / 2.0f;
                            f15 = f7;
                            break;
                        }
                        case 4: {
                            if (string2.equalsIgnoreCase("H")) {
                                f14 = 0.0f;
                                f15 = (f7 - f9) / 2.0f;
                                break;
                            }
                            f14 = (f11 - f10) / 2.0f;
                            f15 = f7 * 2.0f - f9;
                        }
                    }
                    object5 = new a(f14, f15, f10, f9);
                    Object object9 = object2;
                    Object object10 = object6;
                    object7 = object3;
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    if (((CapiPDFApparence)object9).isPDFASignature()) {
                        object7 = ((CapiPDFApparence)object9).isGray() ? PadesUtils.a((BufferedImage)object7) : PadesUtils.b((BufferedImage)object7);
                    }
                    ImageIO.write((RenderedImage)object7, "png", byteArrayOutputStream2);
                    object3 = PDImageXObject.createFromByteArray((PDDocument)object10, (byte[])byteArrayOutputStream2.toByteArray(), (String)"png");
                    object4.drawImage((PDImageXObject)object3, (float)((RectangularShape)object5).getX(), (float)((RectangularShape)object5).getY(), (float)((RectangularShape)object5).getWidth(), (float)((RectangularShape)object5).getHeight());
                    object4.restoreGraphicsState();
                    if (!((CapiPDFApparence)object2).isOnly_image()) {
                        object3 = string.equals("H") ? new a((float)(((RectangularShape)object5).getX() + ((RectangularShape)object5).getWidth()), f6, (double)f5 - (((RectangularShape)object5).getX() + ((RectangularShape)object5).getWidth()), f6) : new a(0.0, ((RectangularShape)object5).getY(), f5, ((RectangularShape)object5).getY());
                        PadesUtils.a((String)object8, ((CapiPDFApparence)object2).getFontSize(), ((CapiPDFApparence)object2).isScaleFont(), (Rectangle2D)object3, (PDPageContentStream)object4, (PDDocument)object6);
                    }
                } else {
                    PadesUtils.a((String)object8, ((CapiPDFApparence)object2).getFontSize(), ((CapiPDFApparence)object2).isScaleFont(), new a(0.0, f6, f5, f6), (PDPageContentStream)object4, (PDDocument)object6);
                }
                object4.close();
            }
            pDDocument2.save((OutputStream)byteArrayOutputStream);
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            pDDocument2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        pDDocument2.close();
                    }
                    throw throwable3;
                }
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                return null;
            }
        }
        pDDocument2.close();
        return object;
    }

    private static void a(String object, int n, boolean bl, Rectangle2D rectangle2D, PDPageContentStream pDPageContentStream, PDDocument pDDocument) throws IOException {
        pDDocument = PDType0Font.load((PDDocument)pDDocument, (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
        pDPageContentStream.beginText();
        pDPageContentStream.setNonStrokingColor(Color.black);
        StringWrap stringWrap = new StringWrap();
        pDPageContentStream.setFont((PDFont)pDDocument, (float)n);
        List<String> list = PadesUtils.a((String)object);
        list = stringWrap.performWrap(list, (float)rectangle2D.getWidth(), (PDFont)pDDocument, n);
        try {
            if (bl) {
                while (!PadesUtils.a(list, (PDFont)pDDocument, n, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()) && n < 100) {
                    list = PadesUtils.a((String)object);
                    list = stringWrap.performWrap(list, (float)rectangle2D.getWidth(), (PDFont)pDDocument, ++n);
                }
            }
            while (PadesUtils.a(list, (PDFont)pDDocument, n, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()) && n > 1) {
                list = PadesUtils.a((String)object);
                list = stringWrap.performWrap(list, (float)rectangle2D.getWidth(), (PDFont)pDDocument, --n);
            }
            pDPageContentStream.setFont((PDFont)pDDocument, (float)n);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        pDPageContentStream.setLeading((float)n * 1.15f);
        pDPageContentStream.newLineAtOffset((float)rectangle2D.getX(), (float)rectangle2D.getY() - (float)n);
        for (String string : list) {
            pDPageContentStream.showText(string);
            pDPageContentStream.newLine();
        }
        pDPageContentStream.endText();
    }

    private static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\\r?\\n");
        if (stringArray.length > 1) {
            arrayList.addAll(Arrays.asList(stringArray));
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean a(List<String> object, PDFont pDFont, int n, float f, float f2) throws IOException {
        if ((float)n * 1.15f * (float)object.size() > f2) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!(pDFont.getStringWidth(string) / 1000.0f * (float)n > f)) continue;
            return true;
        }
        return false;
    }

    private static String a(CapiPDFApparence object) {
        String string;
        Object object2;
        Object object3;
        String string2 = "";
        if (((CapiPDFApparence)object).getVisibleLabel() != null) {
            string2 = ((CapiPDFApparence)object).getVisibleLabel();
        } else {
            object3 = ((CapiPDFApparence)object).getName();
            if (!Util.isNullOrEmpty((String)object3)) {
                string2 = string2 + (String)object3;
            }
            if (!((CapiPDFApparence)object).isShowNameOnly()) {
                object2 = ((CapiPDFApparence)object).getOrganization();
                if (object2 != null && !((String)object2).trim().toLowerCase().contains("non presente") && ((String)object2).trim().compareToIgnoreCase("null") != 0) {
                    if (!string2.isEmpty()) {
                        string2 = string2 + "\n";
                    }
                    string2 = string2 + (String)object2;
                }
                if ((string = ((CapiPDFApparence)object).getTitle()) != null && !string.trim().toLowerCase().contains("non presente") && string.trim().compareToIgnoreCase("null") != 0) {
                    if (!string2.isEmpty()) {
                        string2 = string2 + "\n";
                    }
                    string2 = string2 + string;
                }
            }
        }
        if (((CapiPDFApparence)object).isShowDateTime() && !((CapiPDFApparence)object).isShowNameOnly()) {
            if (!string2.isEmpty()) {
                string2 = string2 + "\n";
            }
            object3 = new Date();
            if (((CapiPDFApparence)object).getSigningTimeCal() != null) {
                object3 = ((CapiPDFApparence)object).getSigningTimeCal().getTime();
            }
            object2 = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            string = ((CapiPDFApparence)object).getTimeZone() == null ? "UTC" : ((CapiPDFApparence)object).getTimeZone();
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone(string));
            object = ((DateFormat)object2).format((Date)object3);
            string2 = string2 + (String)object;
        }
        return string2.trim().replace("\t", "    ");
    }

    @Deprecated
    public static PDVisibleSigProperties getPDVisibleSigProperties(CapiPDFApparence object) throws CapiException {
        if (object == null) {
            return null;
        }
        BufferedImage bufferedImage = ((CapiPDFApparence)object).getImage();
        Object object2 = ((CapiPDFApparence)object).getVisibleLabel();
        int n = ((CapiPDFApparence)object).getFontSize();
        float f = ((CapiPDFApparence)object).getPosX();
        float f2 = ((CapiPDFApparence)object).getPosY();
        float f3 = ((CapiPDFApparence)object).getWidth();
        float f4 = ((CapiPDFApparence)object).getHeight();
        String string = ((CapiPDFApparence)object).getName();
        String string2 = ((CapiPDFApparence)object).getOrganization();
        String string3 = ((CapiPDFApparence)object).getTitle();
        String string4 = ((CapiPDFApparence)object).getFieldName();
        boolean bl = ((CapiPDFApparence)object).isShowDateTime();
        int n2 = ((CapiPDFApparence)object).getPage();
        boolean bl2 = ((CapiPDFApparence)object).isOnly_image();
        int n3 = ((CapiPDFApparence)object).getResizeMode();
        boolean bl3 = ((CapiPDFApparence)object).isScaleFont();
        Calendar calendar = ((CapiPDFApparence)object).getSigningTimeCal();
        boolean bl4 = ((CapiPDFApparence)object).isPDFASignature();
        boolean bl5 = ((CapiPDFApparence)object).isGray();
        String string5 = ((CapiPDFApparence)object).getLocation();
        String string6 = ((CapiPDFApparence)object).getReason();
        PDDocument pDDocument = ((CapiPDFApparence)object).getPdDocument();
        int n4 = ((CapiPDFApparence)object).getAnchorCorner();
        boolean bl6 = ((CapiPDFApparence)object).isShowNameOnly();
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            a.error("wrong signature position");
            return null;
        }
        if ((double)f3 <= 0.0 || (double)f4 <= 0.0) {
            a.error("wrong signature size");
            return null;
        }
        PDVisibleSigProperties pDVisibleSigProperties = null;
        int n5 = (int)f3 << 2;
        int n6 = (int)f4 << 2;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 0;
        n <<= 2;
        if (bufferedImage != null) {
            BufferedImage bufferedImage2;
            String string7 = "H";
            if (!bl2) {
                float f5;
                float f6 = bufferedImage.getHeight();
                float f7 = bufferedImage.getWidth();
                f6 /= f4;
                f7 /= f3;
                if (f5 > f6) {
                    n10 = n8 = (int)f4 << 1;
                    string7 = "V";
                } else {
                    n9 = n7 = (int)f3 << 1;
                    string7 = "H";
                }
            }
            String string8 = string7;
            int n11 = n3;
            float f8 = n8;
            float f9 = n7;
            if (bufferedImage == null || f9 <= 0.0f || f8 <= 0.0f) {
                bufferedImage2 = null;
            } else {
                int n12 = bufferedImage.getWidth();
                int n13 = bufferedImage.getHeight();
                int n14 = Math.round(f9);
                int n15 = Math.round(f8);
                BufferedImage bufferedImage3 = !bufferedImage.getColorModel().hasAlpha() ? new BufferedImage(n14, n15, bufferedImage.getType()) : new BufferedImage(n14, n15, 2);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                if (!bufferedImage.getColorModel().hasAlpha()) {
                    graphics2D.setBackground(Color.WHITE);
                    graphics2D.clearRect(0, 0, n14, n15);
                }
                if (n11 == 1) {
                    graphics2D.drawImage(bufferedImage, 0, 0, n14, n15, 0, 0, n12, n13, null);
                    graphics2D.dispose();
                    bufferedImage2 = bufferedImage3;
                } else if (n11 != 5 && n11 > 1) {
                    int n16;
                    int n17;
                    if (n14 < n15) {
                        n17 = n13 * n14 / n12;
                        n16 = n14;
                        if (n17 > n15) {
                            n16 = n14 * n15 / n17;
                            n17 = n15;
                        }
                    } else {
                        n16 = n12 * n15 / n13;
                        n17 = n15;
                        if (n16 > n14) {
                            n17 = n15 * n14 / n16;
                            n16 = n14;
                        }
                    }
                    int n18 = 0;
                    int n19 = 0;
                    if (n11 == 2) {
                        n18 = (n14 - n16) / 2;
                        n19 = (n15 - n17) / 2;
                    } else if (n11 == 3) {
                        if (string8.equalsIgnoreCase("H")) {
                            n18 = n14 - n16;
                            n19 = (n15 - n17) / 2;
                        } else {
                            n18 = (n14 - n16) / 2;
                            n19 = n15 - n17;
                        }
                    } else if (n11 == 4) {
                        if (string8.equalsIgnoreCase("H")) {
                            n19 = (n15 - n17) / 2;
                        } else {
                            n18 = (n14 - n16) / 2;
                        }
                    }
                    graphics2D.drawImage(bufferedImage, n18, n19, n16 + n18, n17 + n19, 0, 0, n12, n13, null);
                    graphics2D.dispose();
                    bufferedImage2 = bufferedImage3;
                } else {
                    bufferedImage2 = bufferedImage;
                }
            }
            bufferedImage = bufferedImage2;
        }
        Object object3 = new Date();
        if (calendar != null) {
            object3 = calendar.getTime();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
        object = ((CapiPDFApparence)object).getTimeZone() == null ? "UTC" : ((CapiPDFApparence)object).getTimeZone();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone((String)object));
        object3 = simpleDateFormat.format((Date)object3);
        Object object4 = "";
        if (object2 != null) {
            object4 = object2;
        } else {
            if (!Util.isNullOrEmpty((String)string)) {
                object4 = (String)object4 + string;
            }
            if (!bl6) {
                if (string2 != null && !string2.trim().toLowerCase().contains("non presente") && string2.trim().compareToIgnoreCase("null") != 0) {
                    if (!((String)object4).isEmpty()) {
                        object4 = (String)object4 + "\n";
                    }
                    object4 = (String)object4 + string2;
                }
                if (string3 != null && !string3.trim().toLowerCase().contains("non presente") && string3.trim().compareToIgnoreCase("null") != 0) {
                    if (!((String)object4).isEmpty()) {
                        object4 = (String)object4 + "\n";
                    }
                    object4 = (String)object4 + string3;
                }
            }
        }
        if (bl && !bl6) {
            if (!((String)object4).isEmpty()) {
                object4 = (String)object4 + "\n";
            }
            object4 = (String)object4 + (String)object3;
        }
        object3 = new BufferedImage(n5, n6, 2);
        object = ((BufferedImage)object3).createGraphics();
        ((Graphics)object).clearRect(0, 0, n5, n6);
        ((Graphics)object).drawRect(0, 0, n5 - 1, n6 - 1);
        ((Graphics2D)object).setComposite(AlphaComposite.Clear);
        ((Graphics)object).fillRect(0, 0, n5, n6);
        ((Graphics2D)object).setComposite(AlphaComposite.Src);
        if (!bl2) {
            object4 = new TextContainer((String)object4, n7, n8, "Arial", 0, n, n4);
            object2 = new BufferedImage(n7, n8, 2);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            graphics2D.drawRect(0, 0, n7 - 1, n8 - 1);
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n7, n8);
            graphics2D.setComposite(AlphaComposite.Src);
            ((TextContainer)object4).paint(graphics2D, bl3);
            ((Graphics)object).drawImage((Image)object2, n9, n10, null);
        }
        if (bufferedImage != null) {
            ((Graphics)object).drawImage(bufferedImage, 0, 0, null);
        }
        if (bl4) {
            object3 = bl5 ? PadesUtils.a((BufferedImage)object3) : PadesUtils.b((BufferedImage)object3);
        }
        try {
            a.debug("[addSigner] page: " + n2);
            object4 = new PDVisibleSignDesigner(pDDocument, (BufferedImage)object3, n2);
            object4.height(f4);
            object4.width(f3);
            float f10 = object4.getPageHeight();
            object4.xAxis(f).yAxis(f10 - f2).signatureFieldName(string4);
            pDVisibleSigProperties = new PDVisibleSigProperties();
            pDVisibleSigProperties.signerName(string);
            pDVisibleSigProperties.signerLocation(string5);
            pDVisibleSigProperties.signatureReason(string6);
            pDVisibleSigProperties.preferredSize(0);
            pDVisibleSigProperties.page(n2);
            pDVisibleSigProperties.visualSignEnabled(true);
            pDVisibleSigProperties.setPdVisibleSignature((PDVisibleSignDesigner)object4);
            pDVisibleSigProperties.buildSignature();
            a.debug("getPDVisibleSigProperties done");
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage());
        }
        return pDVisibleSigProperties;
    }

    private static BufferedImage a(BufferedImage bufferedImage) {
        if (bufferedImage.getType() == 10) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage = PadesUtils.b(bufferedImage);
        ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static BufferedImage b(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        if (bufferedImage.getType() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Object object = bufferedImage2.createGraphics();
        ((Graphics)object).setColor(Color.WHITE);
        ((Graphics)object).fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        ((Graphics)object).dispose();
        object = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
        ((ColorConvertOp)object).filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static COSArray parseArray(COSDictionary cOSDictionary, String string) {
        COSArray cOSArray = null;
        if ((cOSDictionary = cOSDictionary.getItem(string)) != null) {
            if (cOSDictionary instanceof COSArray) {
                cOSArray = (COSArray)cOSDictionary;
            } else if (((COSObject)cOSDictionary).getObject() instanceof COSArray) {
                cOSArray = (COSArray)((COSObject)cOSDictionary).getObject();
            }
        }
        return cOSArray;
    }

    public static PadesDssInfo retrieveDssInfo(PDDocument pDDocument) {
        PadesDssInfo padesDssInfo = null;
        try {
            COSDictionary cOSDictionary = pDDocument.getDocument().getTrailer();
            if (cOSDictionary == null) {
                a.error("[initialize] trailer is null.");
                return null;
            }
            if ((cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(COSName.ROOT)) == null) {
                a.error("[initialize] root is null");
                return null;
            }
            if ((cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject("DSS")) != null) {
                COSArray cOSArray;
                COSArray cOSArray2;
                Object object;
                Object object2;
                padesDssInfo = new PadesDssInfo(pDDocument, cOSDictionary);
                pDDocument = PadesUtils.parseArray(cOSDictionary, "Certs");
                if (pDDocument != null) {
                    for (int i = 0; i < pDDocument.size(); ++i) {
                        COSStream cOSStream = (COSStream)pDDocument.getObject(i);
                        object2 = Util.getBytesFromInputStream((InputStream)cOSStream.createInputStream());
                        object = new Certificate(object2);
                        padesDssInfo.getCerts().add(object.getInternalCert());
                    }
                }
                if ((cOSArray2 = PadesUtils.parseArray(cOSDictionary, "OCSPs")) != null) {
                    for (int i = 0; i < cOSArray2.size(); ++i) {
                        COSStream cOSStream = (COSStream)cOSArray2.getObject(i);
                        object2 = cOSStream;
                        byte[] byArray = Util.getBytesFromInputStream((InputStream)cOSStream.createInputStream());
                        object = byArray;
                        pDDocument = OcspUtils.getInstaceByBytes((byte[])byArray);
                        if (pDDocument == null) continue;
                        padesDssInfo.getOcsps().add((BasicOCSPResp)pDDocument);
                    }
                }
                if ((cOSArray = PadesUtils.parseArray(cOSDictionary, "CRLs")) != null) {
                    for (int i = 0; i < cOSArray.size(); ++i) {
                        object = (COSStream)cOSArray.getObject(i);
                        pDDocument = new CRL((InputStream)object.createInputStream());
                        padesDssInfo.getCrls().add((CRL)pDDocument);
                    }
                }
            }
        }
        catch (CapiException capiException) {
            a.error("Impossibile Parsare DSS Pdf", (Throwable)capiException);
        }
        catch (IOException iOException) {
            a.error("Impossibile Parsare DSS Pdf", (Throwable)iOException);
        }
        return padesDssInfo;
    }

    public static LinkedList<PadesSignatureInformation> retrieveSignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 0);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        return linkedList;
    }

    public static LinkedList<PadesSignatureInformation> retrieveNotEmptySignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 1);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        object = new CompareByteRangeSignature();
        Collections.sort(linkedList, object);
        return linkedList;
    }

    public static LinkedList<PadesSignatureInformation> retrieveEmptySignatures(PDDocument object) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo((PDDocument)object);
        if ((object = object.getDocumentCatalog().getAcroForm()) == null) {
            return linkedList;
        }
        if ((object = object.getFields()) == null || object.size() <= 0) {
            a.debug("[findSignature] no fields");
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDField)object.next();
            object2 = PadesUtils.a(object2, padesDssInfo, 2);
            linkedList.addAll((Collection<PadesSignatureInformation>)object2);
        }
        return linkedList;
    }

    private static LinkedList<PadesSignatureInformation> a(PDField pDField, PadesDssInfo padesDssInfo, int n) {
        LinkedList<PadesSignatureInformation> linkedList = new LinkedList<PadesSignatureInformation>();
        if (pDField instanceof PDSignatureField) {
            PDSignatureField pDSignatureField = (PDSignatureField)pDField;
            String string = pDSignatureField.getFullyQualifiedName();
            a.debug("[findSignature] Found Signature Name: " + string);
            if (n == 0) {
                if ((PadesUtils.a(pDSignatureField.getCOSObject()) || pDSignatureField.getValue() == null) && !PadesUtils.a(string, linkedList)) {
                    linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                    a.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (n == 1) {
                if (PadesUtils.a(pDSignatureField.getCOSObject()) && !PadesUtils.a(string, linkedList)) {
                    linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                    a.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (n == 1 && pDSignatureField.getValue() == null && !PadesUtils.a(string, linkedList)) {
                linkedList.add(new PadesSignatureInformation(pDSignatureField, padesDssInfo));
                a.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pDField instanceof PDNonTerminalField) {
            for (String string : ((PDNonTerminalField)pDField).getChildren()) {
                linkedList.addAll(PadesUtils.a((PDField)string, padesDssInfo, n));
            }
        }
        return linkedList;
    }

    static {
        c = false;
    }

    private static final class a
    extends Rectangle2D {
        private double a;
        private double b;
        private double c;
        private double d;

        public a(double d, double d2, double d3, double d4) {
            this.a = d;
            this.b = d2;
            this.c = d3;
            this.d = d4;
        }

        @Override
        public final void setRect(double d, double d2, double d3, double d4) {
            this.a = d;
            this.b = d2;
            this.c = d3;
            this.d = d4;
        }

        @Override
        public final int outcode(double d, double d2) {
            return 0;
        }

        @Override
        public final Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public final Rectangle2D createUnion(Rectangle2D rectangle2D) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public final double getX() {
            return this.a;
        }

        @Override
        public final double getY() {
            return this.b;
        }

        @Override
        public final double getWidth() {
            return this.c;
        }

        @Override
        public final double getHeight() {
            return this.d;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }
    }
}

