/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.cades.CadesStepSignatureETSICMSSignedDataCheck;
import esecurity.validator.steps.core.StepCertificatePresence;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class CadesStepSignatureETSICompliance
extends SingleValidationSubStepImpl {
    public CadesStepSignatureETSICompliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new StepCertificatePresence());
        this.subSteps.add(new CadesStepSignatureETSICMSSignedDataCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        MessageLevel messageLevel;
        if (validationContextParameters != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getSignerInfoData() != null && validationContextParameters.getSignature().getSignerInfoData().getSignerInfo() != null && validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null) {
            messageLevel = validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < messageLevel.size(); ++i) {
                String string = messageLevel.getObjectAt(i) instanceof DERSequence ? ((DERSequence)messageLevel.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)messageLevel.getObjectAt(i)).getObjectAt(0).toString();
                if (string.equals(CMSAttributes.messageDigest.getId())) {
                    bl = true;
                }
                if (!string.equals(CMSAttributes.contentType.getId())) continue;
                bl2 = true;
            }
            if (!validationContextParameters.getSignature().isCounterSignature() && !bl2 || !bl) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
            }
        } else if (validationContextParameters != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getSignerInfoData() != null && validationContextParameters.getSignature().getSignerInfoData().getSignerInfo() != null && validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getUnauthenticatedAttributes() != null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
        }
        messageLevel = StepsUtils.retrieveWorstLevel(linkedList);
        Date date = validationContextParameters.getCalculatedValidationDate().getDate();
        if (messageLevel == MessageLevel.ERROR) {
            if (date.before(Constants.DPCM_AGID_121_2019)) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.ES0005_NOCNIPA45, new Object[0]);
            }
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
        }
        if (messageLevel == MessageLevel.WARNING) {
            if (date.before(Constants.DPCM_AGID_121_2019)) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.WS0001_NOCNIPA45VALID, new Object[0]);
            }
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.WS0002_NOEIDAS, new Object[0]);
        }
        return null;
    }
}

