/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class PreparedToken
extends TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private X509Certificate b = null;
    private byte[] c = null;
    private int d = -1;
    private byte[] e = null;
    private boolean f = false;

    @Override
    public void initializeLib(String[] stringArray) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    @Override
    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    @Override
    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    public PreparedToken(X509Certificate x509Certificate) throws CapiException {
        a.info("Prepared Token Initialized");
        if (x509Certificate == null) {
            throw new CapiException("Invalid Cert Parameter", 50040);
        }
        this.b = x509Certificate;
    }

    public PreparedToken(X509Certificate serializable, byte[] byArray, byte[] byArray2) throws CapiException {
        a.info("Prepared Token Initialized");
        this.b = serializable;
        this.c = byArray;
        this.e = byArray2;
        try {
            Signature signature = Signature.getInstance("RSA", ProvUtils.bcProvider);
            serializable = serializable.getPublicKey();
            signature.initVerify((PublicKey)serializable);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new CapiException("Firma Specificata non valida", 50040);
            }
            return;
        }
        catch (Exception exception) {
            throw new CapiException("Firma Specificata non valida", 50040, exception);
        }
    }

    @Override
    public String[] getLibInfo() {
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Prepared Token";
        stringArray2[1] = "Ellips Prepared Token";
        stringArray2[2] = "1.0";
        stringArray2[3] = "ArubaPEC S.p.A.";
        return stringArray2;
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    @Override
    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return "0";
    }

    @Override
    public void finalizeLib() {
        try {
            this.closeSession();
            return;
        }
        catch (CapiException capiException) {
            a.debug("Error closing session: " + capiException.getMessage());
            return;
        }
    }

    @Override
    public int getFreeSpace() throws CapiException {
        return -1;
    }

    @Override
    public void changePIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    @Override
    public void changePUK(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    @Override
    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    @Override
    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    @Override
    public void unblockPIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    @Override
    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    @Override
    public int getMinPINLen() throws CapiException {
        return 0;
    }

    @Override
    public void openSession(boolean bl, String string) throws CapiException {
        this.f = true;
    }

    @Override
    public void openSession(boolean bl, String string, int n) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    @Override
    public void openSessionAuthPath(boolean bl) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
    }

    @Override
    public void closeSession() throws CapiException {
        this.f = false;
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        return this.f;
    }

    @Override
    public byte[] getData(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    @Override
    public void setData(String string, byte[] byArray, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    @Override
    public String getCert(String string) throws CapiException {
        try {
            return Base64.toBase64String((byte[])this.b.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CapiException("Unable do encode Cert", 50040, certificateEncodingException);
        }
    }

    @Override
    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    @Override
    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    @Override
    public boolean canImport() {
        return false;
    }

    @Override
    public boolean canExport(String string) {
        return false;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public void genKeyPair(String string, KeyAlgo keyAlgo, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    @Override
    public PrivateKey expCred(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    @Override
    public PublicKey getPublicKey(String string) throws CapiException {
        return this.b.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey(String object) throws CapiException {
        if (this.b == null) {
            return null;
        }
        Certificate certificate = new Certificate(this.b);
        object = new Actalis_PrivateKey((String)object);
        ((Actalis_PrivateKey)object).setPublicInfo((RSAPublicKey)certificate.getInternalCert().getPublicKey());
        ((Actalis_PrivateKey)object).setCryptoDev(this);
        return object;
    }

    @Override
    public void instCert(String string, Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    @Override
    public int getKeyUsage(String string, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public int getKeyLength(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public byte[] doSign(byte[] byArray, String string, int n) throws CapiException {
        if (this.e != null) {
            if (!Arrays.areEqual((byte[])byArray, (byte[])this.c)) {
                throw new CapiException("Signature not Match", 50040);
            }
            return this.e;
        }
        this.c = byArray;
        this.d = n;
        return byArray;
    }

    @Override
    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    @Override
    public String[] listObjects(String stringArray, byte by) throws CapiException {
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "PREPARED1";
        return stringArray;
    }

    @Override
    public void deleteObject(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public byte getObjectType(String string) throws CapiException {
        return 2;
    }

    @Override
    public String getObjectID(String string) throws CapiException {
        return string;
    }

    @Override
    public int getObjectSize(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void renameObject(String string, String string2, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void setCert(String string, Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
    }

    @Override
    public void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
    }

    @Override
    public boolean exist(String string) throws CapiException {
        return "PREPARED1".equals(string);
    }

    @Override
    public String generateID(String[] stringArray) {
        return "PREPARED TOKEN";
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(String string, X500Name x500Name) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resetToken(String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] getDataToSign() {
        return this.c;
    }

    public int getMode() {
        return this.d;
    }
}

