/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticsInfoUtils;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisProvider;
import it.actalis.vol.utils.Constants;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi;
import org.slf4j.Logger;

public class Actalis_RSACipher
extends CipherSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE_RSA_X_509 = 3;
    public static final int DECRYPT_MODE_RSA_X_509 = 4;
    public boolean isENCRYPT_MODE_RSA_X_509 = false;
    public boolean isDECRYPT_MODE_RSA_X_509 = false;
    private int b;
    private short c = 0;
    private String d = null;
    private Actalis_PrivateKey e = null;

    public Actalis_RSACipher() {
        super((AsymmetricBlockCipher)new RSAEngine());
        a.debug("constructor OK");
        this.c = 0;
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        switch (this.c) {
            case 1: {
                a.debug("engineSetMode device: " + string);
                return;
            }
            case 0: {
                a.debug("engineSetMode: " + string);
            }
            case 2: {
                a.debug("engineSetMode BouncyCastle  :" + string);
                super.engineSetMode(string);
            }
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        switch (this.c) {
            case 1: {
                a.debug("engineSetPadding device: " + string);
                return;
            }
            case 0: {
                a.debug("engineSetPadding: " + string);
            }
            case 2: {
                a.debug("engineSetPadding BouncyCastle: " + string);
                super.engineSetPadding(string);
            }
        }
    }

    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        a.debug("engineInit AlgParSpec");
        this.engineInit(n, key, secureRandom);
    }

    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        a.debug("engineInit AlgParamet");
        this.engineInit(n, key, secureRandom);
    }

    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        a.debug("engineInit check?");
        this.b = n;
        try {
            if (key instanceof Actalis_PrivateKey) {
                a.debug("engineInit is act_privatekey");
                this.c = 1;
                this.e = (Actalis_PrivateKey)key;
                this.d = this.e.getAlias();
            } else {
                a.debug("engineInit is NOT act_privatekey");
                this.c = (short)2;
                this.d = null;
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new InvalidKeyException("Unable to init RSA key: " + exception.toString());
        }
        switch (this.c) {
            case 0: {
                throw new InvalidKeyException("Invalid use device.");
            }
            case 1: {
                return;
            }
            case 2: {
                a.debug("call BouncyCastle engineInit");
                a.debug("opmode " + n);
                if (key instanceof PublicKey) {
                    a.debug("key is public");
                } else {
                    a.debug("key is private");
                }
                try {
                    super.engineInit(n, key, null, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    a.debug(invalidAlgorithmParameterException.getMessage(), (Throwable)invalidAlgorithmParameterException);
                    throw new InvalidKeyException("InvalidAlgorithmParameterException: " + invalidAlgorithmParameterException.toString());
                }
                a.debug("BouncyCastle engineInit checked");
            }
        }
    }

    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.c != 1) {
            a.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(byArray, n, n2);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.c != 1) {
            a.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetBlockSize() {
        if (this.c != 1) {
            a.debug("engineGetBlockSize call BouncyCastle");
            return super.engineGetBlockSize();
        }
        throw new RuntimeException("Method not supported.");
    }

    public byte[] engineGetIV() {
        if (this.c != 1) {
            a.debug("engineGetIV call BouncyCastle");
            return super.engineGetIV();
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetOutputSize(int n) {
        if (this.c != 1) {
            a.debug("engineGetOutputSize: BouncyCastle ");
            return super.engineGetOutputSize(n);
        }
        return 0;
    }

    public byte[] engineDoFinal(byte[] object, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (this.c == 2) {
            a.debug("engineDoFinal: BouncyCastle inpLen=" + n2);
            return super.engineDoFinal(object, n, n2);
        }
        if (this.c != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(object, n, byArray, 0, n2);
        a.debug("engineDoFinal: device: MODE: " + this.b);
        if (this.b == 1) {
            Actalis_RSACipher actalis_RSACipher = this;
            byte[] byArray2 = byArray;
            object = (Object)actalis_RSACipher;
            return actalis_RSACipher.a(byArray2, 1);
        }
        Actalis_RSACipher actalis_RSACipher = this;
        byte[] byArray3 = byArray;
        object = (Object)actalis_RSACipher;
        return actalis_RSACipher.b(byArray3, 2);
    }

    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.c == 2) {
            a.debug("engineDoFinal-2: BouncyCastle");
            return super.engineDoFinal(byArray, n, n2, byArray2, n3);
        }
        if (this.c != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        a.debug("engineDoFinal-2");
        byArray = this.engineDoFinal(byArray, n, n2);
        try {
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new IllegalBlockSizeException("Buffer to short to hold result.");
        }
        return byArray.length;
    }

    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public AlgorithmParameters getParameters() {
        throw new RuntimeException("Method not supported.");
    }

    public void set_RSA_X_509_EncryptMode() {
        this.isENCRYPT_MODE_RSA_X_509 = true;
    }

    public void set_RSA_X_509_DecryptMode() {
        this.isDECRYPT_MODE_RSA_X_509 = true;
    }

    private byte[] a(byte[] byArray, int n) {
        a.debug("[encrypt] hash.length " + byArray.length);
        a.debug("[encrypt] theProv?");
        ActalisProvider actalisProvider = (ActalisProvider)Security.getProvider("Actalis");
        a.debug("[encrypt] theProv = " + actalisProvider);
        a.debug("engineSign: Actalis_RSACipher");
        StatisticsInfoUtils.start(StatisticKeyEnum.SIGN_TIME);
        try {
            a.debug("[encrypt] theProv.doSign ?");
            byArray = this.isENCRYPT_MODE_RSA_X_509 ? this.e.getCryptoDev().doSign(byArray, this.d, 3) : this.e.getCryptoDev().doSign(byArray, this.d, 1);
            a.debug("[encrypt] theProv.doSign ok");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CapiError(capiException);
        }
        finally {
            StatisticsInfoUtils.end(StatisticKeyEnum.SIGN_TIME);
        }
        if (byArray == null) {
            throw new CapiError("Invalid signature", 3003);
        }
        return byArray;
    }

    private byte[] b(byte[] byArray, int n) {
        a.debug("[decrypt] signature.length " + byArray.length);
        ActalisProvider actalisProvider = (ActalisProvider)Security.getProvider("Actalis");
        a.debug("[decrypt] theProv = " + actalisProvider);
        a.debug("[decrypt] mode = " + 2);
        try {
            a.debug("[decrypt] theProv.doDecrypt ?");
            byArray = this.isDECRYPT_MODE_RSA_X_509 ? this.e.getCryptoDev().doDecrypt(byArray, this.d, 4) : this.e.getCryptoDev().doDecrypt(byArray, this.d, 2);
            a.debug("[decrypt] theProv.doDecrypt ok");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CapiError(capiException);
        }
        if (byArray == null) {
            throw new CapiError("Invalid decryption", 3103);
        }
        a.debug("[decrypt] hash.length " + byArray.length);
        return byArray;
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof Actalis_PrivateKey) {
            key = (Actalis_PrivateKey)key;
            if ((key = ((Actalis_PrivateKey)key).getPublicInfo()) == null || !(key instanceof RSAPublicKey)) {
                throw new IllegalArgumentException("Actalis_PrivateKey does not hava an RSAPublicKey! : " + (key == null ? "null" : key.getClass().getName()));
            }
            key = (RSAPublicKey)key;
            return key.getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            key = (RSAPrivateKey)key;
            return key.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            key = (RSAPublicKey)key;
            return key.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }
}

