/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import org.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import org.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.Resultant;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUSigningKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUSigningPublicKeyParameters pub = null;
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> bases = new ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>>();
        for (int k = this.params.B; k >= 0; --k) {
            bases.add(executor.submit(new BasisGenerationTask()));
        }
        executor.shutdown();
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        for (int k = this.params.B; k >= 0; --k) {
            Future basis = (Future)bases.get(k);
            try {
                basises.add((NTRUSigningPrivateKeyParameters.Basis)basis.get());
                if (k != this.params.B) continue;
                pub = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)basis.get()).h, this.params.getSigningParameters());
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        AsymmetricCipherKeyPair kp = new AsymmetricCipherKeyPair(pub, priv);
        return kp;
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters pub = null;
        for (int k = this.params.B; k >= 0; --k) {
            NTRUSigningPrivateKeyParameters.Basis basis = this.generateBoundedBasis();
            basises.add(basis);
            if (k != 0) continue;
            pub = new NTRUSigningPublicKeyParameters(basis.h, this.params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        return new AsymmetricCipherKeyPair(pub, priv);
    }

    private void minimizeFG(IntegerPolynomial f, IntegerPolynomial g, IntegerPolynomial F, IntegerPolynomial G, int N) {
        int E = 0;
        for (int j = 0; j < N; ++j) {
            E += 2 * N * (f.coeffs[j] * f.coeffs[j] + g.coeffs[j] * g.coeffs[j]);
        }
        E -= 4;
        IntegerPolynomial u = (IntegerPolynomial)f.clone();
        IntegerPolynomial v = (IntegerPolynomial)g.clone();
        int k = 0;
        int maxAdjustment = N;
        for (int j = 0; k < maxAdjustment && j < N; ++j) {
            int D1;
            int D = 0;
            for (int i = 0; i < N; ++i) {
                D1 = F.coeffs[i] * f.coeffs[i];
                int D2 = G.coeffs[i] * g.coeffs[i];
                int D3 = 4 * N * (D1 + D2);
                D += D3;
            }
            D1 = 4 * (F.sumCoeffs() + G.sumCoeffs());
            if ((D -= D1) > E) {
                F.sub(u);
                G.sub(v);
                ++k;
                j = 0;
            } else if (D < -E) {
                F.add(u);
                G.add(v);
                ++k;
                j = 0;
            }
            u.rotate1();
            v.rotate1();
        }
    }

    private FGBasis generateBasis() {
        IntegerPolynomial h;
        IntegerPolynomial fPrime;
        BigIntPolynomial C;
        BigIntEuclidean r;
        Resultant rg;
        IntegerPolynomial gInt;
        DenseTernaryPolynomial g;
        DenseTernaryPolynomial f;
        IntegerPolynomial fq;
        IntegerPolynomial fInt;
        int N = this.params.N;
        int q = this.params.q;
        int d = this.params.d;
        int d1 = this.params.d1;
        int d2 = this.params.d2;
        int d3 = this.params.d3;
        int basisType = this.params.basisType;
        int _2n1 = 2 * N + 1;
        boolean primeCheck = this.params.primeCheck;
        do {
            f = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d + 1, d, CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d2, d3 + 1, d3, CryptoServicesRegistrar.getSecureRandom());
            fInt = f.toIntegerPolynomial();
        } while (primeCheck && fInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || (fq = fInt.invertFq(q)) == null);
        Resultant rf = fInt.resultant();
        while (true) {
            g = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d + 1, d, CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d2, d3 + 1, d3, CryptoServicesRegistrar.getSecureRandom());
            gInt = g.toIntegerPolynomial();
            if (primeCheck && gInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || gInt.invertFq(q) == null) continue;
            rg = gInt.resultant();
            r = BigIntEuclidean.calculate(rf.res, rg.res);
            if (r.gcd.equals(BigInteger.ONE)) break;
        }
        BigIntPolynomial A = (BigIntPolynomial)rf.rho.clone();
        A.mult(r.x.multiply(BigInteger.valueOf(q)));
        BigIntPolynomial B = (BigIntPolynomial)rg.rho.clone();
        B.mult(r.y.multiply(BigInteger.valueOf(-q)));
        if (this.params.keyGenAlg == 0) {
            int[] fRevCoeffs = new int[N];
            int[] gRevCoeffs = new int[N];
            fRevCoeffs[0] = fInt.coeffs[0];
            gRevCoeffs[0] = gInt.coeffs[0];
            for (int i = 1; i < N; ++i) {
                fRevCoeffs[i] = fInt.coeffs[N - i];
                gRevCoeffs[i] = gInt.coeffs[N - i];
            }
            IntegerPolynomial fRev = new IntegerPolynomial(fRevCoeffs);
            IntegerPolynomial gRev = new IntegerPolynomial(gRevCoeffs);
            IntegerPolynomial t = f.mult(fRev);
            t.add(g.mult(gRev));
            Resultant rt = t.resultant();
            C = fRev.mult(B);
            C.add(gRev.mult(A));
            C = C.mult(rt.rho);
            C.div(rt.res);
        } else {
            int log10N = 0;
            for (int i = 1; i < N; i *= 10) {
                ++log10N;
            }
            BigDecimalPolynomial fInv = rf.rho.div(new BigDecimal(rf.res), B.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial gInv = rg.rho.div(new BigDecimal(rg.res), A.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial Cdec = fInv.mult(B);
            Cdec.add(gInv.mult(A));
            Cdec.halve();
            C = Cdec.round();
        }
        BigIntPolynomial F = (BigIntPolynomial)B.clone();
        F.sub(f.mult(C));
        BigIntPolynomial G = (BigIntPolynomial)A.clone();
        G.sub(g.mult(C));
        IntegerPolynomial FInt = new IntegerPolynomial(F);
        IntegerPolynomial GInt = new IntegerPolynomial(G);
        this.minimizeFG(fInt, gInt, FInt, GInt, N);
        if (basisType == 0) {
            fPrime = FInt;
            h = g.mult(fq, q);
        } else {
            fPrime = g;
            h = FInt.mult(fq, q);
        }
        h.modPositive(q);
        return new FGBasis(f, fPrime, h, FInt, GInt, this.params);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis basis;
        while (!(basis = this.generateBasis()).isNormOk()) {
        }
        return basis;
    }

    public class FGBasis
    extends NTRUSigningPrivateKeyParameters.Basis {
        public IntegerPolynomial F;
        public IntegerPolynomial G;

        FGBasis(Polynomial f, Polynomial fPrime, IntegerPolynomial h, IntegerPolynomial F, IntegerPolynomial G, NTRUSigningKeyGenerationParameters params) {
            super(f, fPrime, h, params);
            this.F = F;
            this.G = G;
        }

        boolean isNormOk() {
            double keyNormBoundSq = this.params.keyNormBoundSq;
            int q = this.params.q;
            return (double)this.F.centeredNormSq(q) < keyNormBoundSq && (double)this.G.centeredNormSq(q) < keyNormBoundSq;
        }
    }

    private class BasisGenerationTask
    implements Callable<NTRUSigningPrivateKeyParameters.Basis> {
        private BasisGenerationTask() {
        }

        @Override
        public NTRUSigningPrivateKeyParameters.Basis call() throws Exception {
            return NTRUSigningKeyPairGenerator.this.generateBoundedBasis();
        }
    }
}

