/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.tls.TlsCloseable;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsPeer;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private volatile TlsCloseable closeHandle;

    @Override
    public void cancel() throws IOException {
        TlsCloseable closeHandle = this.closeHandle;
        if (null != closeHandle) {
            closeHandle.close();
        }
    }

    @Override
    public void notifyCloseHandle(TlsCloseable closeHandle) {
        this.closeHandle = closeHandle;
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }
}

