/* application.c generated by valac 0.19.0, the Vala compiler
 * generated from application.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <xfconf/xfconf.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <libxfce4util/libxfce4util.h>
#include <signal.h>


#define XNP_TYPE_APPLICATION (xnp_application_get_type ())
#define XNP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_APPLICATION, XnpApplication))
#define XNP_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_APPLICATION, XnpApplicationClass))
#define XNP_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_APPLICATION))
#define XNP_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_APPLICATION))
#define XNP_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_APPLICATION, XnpApplicationClass))

typedef struct _XnpApplication XnpApplication;
typedef struct _XnpApplicationClass XnpApplicationClass;
typedef struct _XnpApplicationPrivate XnpApplicationPrivate;

#define XNP_TYPE_WINDOW_MONITOR (xnp_window_monitor_get_type ())
#define XNP_WINDOW_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitor))
#define XNP_WINDOW_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitorClass))
#define XNP_IS_WINDOW_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW_MONITOR))
#define XNP_IS_WINDOW_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW_MONITOR))
#define XNP_WINDOW_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitorClass))

typedef struct _XnpWindowMonitor XnpWindowMonitor;
typedef struct _XnpWindowMonitorClass XnpWindowMonitorClass;

#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _XnpWindowMonitorPrivate XnpWindowMonitorPrivate;
typedef struct _Block1Data Block1Data;

struct _XnpApplication {
	GObject parent_instance;
	XnpApplicationPrivate * priv;
};

struct _XnpApplicationClass {
	GObjectClass parent_class;
};

struct _XnpApplicationPrivate {
	GSList* window_monitor_list;
	GSList* window_list;
	gchar* _notes_path;
	gchar* _config_file;
	XfconfChannel* xfconf_channel;
};

struct _XnpNote {
	GtkScrolledWindow parent_instance;
	XnpNotePrivate * priv;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkScrolledWindowClass parent_class;
};

struct _XnpWindowMonitor {
	GObject parent_instance;
	XnpWindowMonitorPrivate * priv;
	XnpWindow* window;
};

struct _XnpWindowMonitorClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	XnpApplication * self;
	GtkMenu* menu;
};


static gpointer xnp_application_parent_class = NULL;

GType xnp_application_get_type (void) G_GNUC_CONST;
GType xnp_window_monitor_get_type (void) G_GNUC_CONST;
GType xnp_window_get_type (void) G_GNUC_CONST;
#define XNP_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_APPLICATION, XnpApplicationPrivate))
enum  {
	XNP_APPLICATION_DUMMY_PROPERTY,
	XNP_APPLICATION_NOTES_PATH,
	XNP_APPLICATION_CONFIG_FILE
};
void xnp_application_save_windows_configuration (XnpApplication* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
XnpApplication* xnp_application_new (const gchar* config_file);
XnpApplication* xnp_application_construct (GType object_type, const gchar* config_file);
XnpApplication* xnp_application_new_with_notes_path (const gchar* config_file, const gchar* notes_path);
XnpApplication* xnp_application_construct_with_notes_path (GType object_type, const gchar* config_file, const gchar* notes_path);
static void xnp_application_update_notes_path (XnpApplication* self);
const gchar* xnp_application_get_notes_path (XnpApplication* self);
static void xnp_application_update_color (XnpApplication* self);
void xnp_theme_set_background_color (const gchar* color);
static void xnp_application_quit (XnpApplication* self);
void xnp_application_save_notes (XnpApplication* self);
XnpWindow* xnp_application_create_window (XnpApplication* self, const gchar* name);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
void xnp_window_set_above (XnpWindow* self, gboolean value);
void xnp_window_set_sticky (XnpWindow* self, gboolean value);
static gboolean xnp_application_window_name_exists (XnpApplication* self, const gchar* name);
void xnp_window_set_name (XnpWindow* self, const gchar* value);
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2);
void xnp_window_set_window_list (XnpWindow* self, GSList* list);
const gchar* xnp_window_get_name (XnpWindow* self);
static void xnp_application_load_window_data (XnpApplication* self, XnpWindow* window);
static void xnp_application_window_monitor_list_add (XnpApplication* self, XnpWindow* window);
static void __lambda23_ (XnpApplication* self, XnpWindow* win, const gchar* action);
static void xnp_application_rename_window (XnpApplication* self, XnpWindow* window);
static void xnp_application_set_data_value (XnpApplication* self, GObject* object, const gchar* data, gboolean val);
static void xnp_application_delete_window (XnpApplication* self, XnpWindow* window);
static void xnp_application_refresh_notes (XnpApplication* self, XnpWindow* window);
void xnp_application_open_settings_dialog (XnpApplication* self);
void xnp_application_open_about_dialog (XnpApplication* self);
static void ___lambda23__xnp_window_action (XnpWindow* _sender, const gchar* action, gpointer self);
GType xnp_note_get_type (void) G_GNUC_CONST;
static void __lambda25_ (XnpApplication* self, XnpWindow* win, XnpNote* note);
static gboolean xnp_application_get_data_value (XnpApplication* self, GObject* object, const gchar* data);
static void xnp_application_save_note (XnpApplication* self, XnpWindow* window, XnpNote* note);
static void ___lambda25__xnp_window_save_data (XnpWindow* _sender, XnpNote* note, gpointer self);
static void __lambda26_ (XnpApplication* self, XnpWindow* win, XnpNote* note);
GType xnp_hypertext_view_get_type (void) G_GNUC_CONST;
const gchar* xnp_note_get_name (XnpNote* self);
static void ___lambda26__xnp_window_note_inserted (XnpWindow* _sender, XnpNote* note, gpointer self);
static void __lambda27_ (XnpApplication* self, XnpWindow* win, XnpNote* note);
static void ___lambda27__xnp_window_note_deleted (XnpWindow* _sender, XnpNote* note, gpointer self);
static void __lambda28_ (XnpApplication* self, XnpWindow* win, XnpNote* note, const gchar* old_name);
static gboolean xnp_application_name_is_valid (XnpApplication* self, const gchar* name);
void xnp_note_set_name (XnpNote* self, const gchar* value);
static void ___lambda28__xnp_window_note_renamed (XnpWindow* _sender, XnpNote* note, const gchar* old_name, gpointer self);
XnpNote* xnp_window_insert_note (XnpWindow* self);
const gchar* xnp_application_get_config_file (XnpApplication* self);
void xnp_window_move_note (XnpWindow* self, const gchar* note_name, gint page);
void xnp_window_set_current_page (XnpWindow* self, gint page);
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height);
gchar** xnp_window_get_note_names (XnpWindow* self, int* result_length1);
gint xnp_window_get_current_page (XnpWindow* self);
gboolean xnp_window_get_above (XnpWindow* self);
gboolean xnp_window_get_sticky (XnpWindow* self);
void xnp_window_save_notes (XnpWindow* self);
static void xnp_application_window_monitor_list_remove (XnpApplication* self, XnpWindow* window);
gint xnp_window_get_n_pages (XnpWindow* self);
void xnp_window_set_show_refresh_button (XnpWindow* self, gboolean value);
XnpWindowMonitor* xnp_window_monitor_new (XnpWindow* window, GFile* file);
XnpWindowMonitor* xnp_window_monitor_construct (GType object_type, XnpWindow* window, GFile* file);
static void __lambda22_ (XnpApplication* self, XnpWindow* window);
static void ___lambda22__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender, XnpWindow* window, gpointer self);
static XnpWindowMonitor* xnp_application_window_monitor_list_lookup (XnpApplication* self, XnpWindow* window);
void xnp_application_show_hide_notes (XnpApplication* self);
void xnp_window_hide (XnpWindow* self);
static void __lambda24_ (XnpApplication* self, GtkAboutDialog* dialog, const gchar* uri);
static void ___lambda24__gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const gchar* link_, gpointer self);
GtkMenu* xnp_application_context_menu (XnpApplication* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda29_ (Block1Data* _data1_);
static void __lambda30_ (XnpApplication* self, GtkWidget* w);
static void ___lambda30__gtk_callback (GtkWidget* widget, gpointer self);
static void ____lambda31_ (XnpApplication* self, GtkMenuItem* i);
static void _____lambda31__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda32_ (XnpApplication* self);
static void ___lambda32__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda29__gtk_widget_show (GtkWidget* _sender, gpointer self);
void xnp_application_set_notes_path (XnpApplication* self, const gchar* value);
static void xnp_application_set_config_file (XnpApplication* self, const gchar* value);
static GObject * xnp_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _xnp_application_quit_xfce_posix_signal_handler_callback (gint signal, gpointer self);
static void _xnp_application___lambda33_ (XnpApplication* self);
static void __xnp_application___lambda33__xfconf_channel_property_changed (XfconfChannel* _sender, const gchar* p0, GValue* p1, gpointer self);
static void _xnp_application___lambda34_ (XnpApplication* self);
static void __xnp_application___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _xnp_application___lambda35_ (XnpApplication* self);
static void __xnp_application___lambda35__xfconf_channel_property_changed (XfconfChannel* _sender, const gchar* p0, GValue* p1, gpointer self);
static void xnp_application_finalize (GObject* obj);
static void _vala_xnp_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_xnp_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


XnpApplication* xnp_application_construct (GType object_type, const gchar* config_file) {
	XnpApplication * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (config_file != NULL, NULL);
	_tmp0_ = config_file;
	self = (XnpApplication*) g_object_new (object_type, "config-file", _tmp0_, NULL);
	return self;
}


XnpApplication* xnp_application_new (const gchar* config_file) {
	return xnp_application_construct (XNP_TYPE_APPLICATION, config_file);
}


XnpApplication* xnp_application_construct_with_notes_path (GType object_type, const gchar* config_file, const gchar* notes_path) {
	XnpApplication * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (config_file != NULL, NULL);
	g_return_val_if_fail (notes_path != NULL, NULL);
	_tmp0_ = config_file;
	_tmp1_ = notes_path;
	self = (XnpApplication*) g_object_new (object_type, "config-file", _tmp0_, "notes-path", _tmp1_, NULL);
	return self;
}


XnpApplication* xnp_application_new_with_notes_path (const gchar* config_file, const gchar* notes_path) {
	return xnp_application_construct_with_notes_path (XNP_TYPE_APPLICATION, config_file, notes_path);
}


static void xnp_application_update_notes_path (XnpApplication* self) {
	XfconfChannel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* new_notes_path;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* dirname;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gint _tmp22_ = 0;
	gboolean _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = self->priv->_notes_path;
	_tmp2_ = xfconf_channel_get_string (_tmp0_, "/global/notes-path", _tmp1_);
	new_notes_path = _tmp2_;
	_tmp3_ = self->priv->_notes_path;
	_tmp4_ = new_notes_path;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		_g_free0 (new_notes_path);
		return;
	}
	{
		const gchar* _tmp5_;
		GDir* _tmp6_ = NULL;
		GDir* dir;
		GDir* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp5_ = new_notes_path;
		_tmp6_ = g_dir_open (_tmp5_, (guint) 0, &_inner_error_);
		dir = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp7_ = dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_ = NULL;
			GtkMessageDialog* _tmp10_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp11_;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			GtkMessageDialog* _tmp14_;
			GtkMessageDialog* _tmp15_;
			XfconfChannel* _tmp16_;
			const gchar* _tmp17_;
			_tmp9_ = _ ("Select notes path");
			_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp9_);
			g_object_ref_sink (_tmp10_);
			error_dialog = _tmp10_;
			_tmp11_ = error_dialog;
			_tmp12_ = _ ("The selected directory (%s) for the new notes path already contains fi" \
"les. You must select or create an empty directory.");
			_tmp13_ = new_notes_path;
			gtk_message_dialog_format_secondary_text (_tmp11_, _tmp12_, _tmp13_);
			_tmp14_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp14_);
			_tmp15_ = error_dialog;
			gtk_object_destroy ((GtkObject*) _tmp15_);
			_tmp16_ = self->priv->xfconf_channel;
			_tmp17_ = self->priv->_notes_path;
			xfconf_channel_set_string (_tmp16_, "/global/notes-path", _tmp17_);
			_g_object_unref0 (error_dialog);
			_g_dir_close0 (dir);
			_g_free0 (new_notes_path);
			return;
		}
		_g_dir_close0 (dir);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (new_notes_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = new_notes_path;
	_tmp19_ = g_path_get_dirname (_tmp18_);
	dirname = _tmp19_;
	_tmp21_ = dirname;
	_tmp22_ = g_mkdir_with_parents (_tmp21_, 0700);
	if (_tmp22_ != 0) {
		_tmp20_ = TRUE;
	} else {
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_ = 0;
		_tmp23_ = self->priv->_notes_path;
		_tmp24_ = new_notes_path;
		_tmp25_ = g_rename (_tmp23_, _tmp24_);
		_tmp20_ = _tmp25_ != 0;
	}
	_tmp26_ = _tmp20_;
	if (_tmp26_) {
		const gchar* _tmp27_ = NULL;
		GtkMessageDialog* _tmp28_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp29_;
		const gchar* _tmp30_ = NULL;
		gint _tmp31_;
		const gchar* _tmp32_ = NULL;
		GtkMessageDialog* _tmp33_;
		GtkMessageDialog* _tmp34_;
		XfconfChannel* _tmp35_;
		const gchar* _tmp36_;
		_tmp27_ = _ ("Select notes path");
		_tmp28_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp27_);
		g_object_ref_sink (_tmp28_);
		error_dialog = _tmp28_;
		_tmp29_ = error_dialog;
		_tmp30_ = _ ("Unable to select directory for new notes path: %s");
		_tmp31_ = errno;
		_tmp32_ = g_strerror (_tmp31_);
		gtk_message_dialog_format_secondary_text (_tmp29_, _tmp30_, _tmp32_);
		_tmp33_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp33_);
		_tmp34_ = error_dialog;
		gtk_object_destroy ((GtkObject*) _tmp34_);
		_tmp35_ = self->priv->xfconf_channel;
		_tmp36_ = self->priv->_notes_path;
		xfconf_channel_set_string (_tmp35_, "/global/notes-path", _tmp36_);
		_g_object_unref0 (error_dialog);
		_g_free0 (dirname);
		_g_free0 (new_notes_path);
		return;
	}
	_g_free0 (dirname);
	_g_free0 (new_notes_path);
}


static void xnp_application_update_color (XnpApplication* self) {
	XfconfChannel* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* color;
	const gchar* _tmp2_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = xfconf_channel_get_string (_tmp0_, "/global/background-color", "#F7EB96");
	color = _tmp1_;
	_tmp2_ = color;
	if (g_strcmp0 (_tmp2_, "GTK+") == 0) {
		GtkInvisible* _tmp3_;
		GtkInvisible* style_widget;
		GtkInvisible* _tmp4_;
		GtkStyle* _tmp5_ = NULL;
		GdkColor* _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_ = NULL;
		_tmp3_ = (GtkInvisible*) gtk_invisible_new ();
		g_object_ref_sink (_tmp3_);
		style_widget = _tmp3_;
		_tmp4_ = style_widget;
		_tmp5_ = gtk_widget_get_style ((GtkWidget*) _tmp4_);
		_tmp6_ = _tmp5_->bg;
		_tmp6__length1 = -1;
		_tmp7_ = gdk_color_to_string (&_tmp6_[GTK_STATE_NORMAL]);
		_g_free0 (color);
		color = _tmp7_;
		_g_object_unref0 (style_widget);
	}
	_tmp8_ = color;
	xnp_theme_set_background_color (_tmp8_);
	_g_free0 (color);
}


static void xnp_application_quit (XnpApplication* self) {
	g_return_if_fail (self != NULL);
	xnp_application_save_notes (self);
	gtk_main_quit ();
}


/**
 * create_window:
 *
 * Creates a new Xnp.Window and stores it inside window_list.
 * If a name is given, it assumes it can load existing notes.
 */
static void __lambda23_ (XnpApplication* self, XnpWindow* win, const gchar* action) {
	const gchar* _tmp0_;
	g_return_if_fail (win != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	if (g_strcmp0 (_tmp0_, "rename") == 0) {
		XnpWindow* _tmp1_;
		XnpWindow* _tmp2_;
		_tmp1_ = win;
		xnp_application_rename_window (self, _tmp1_);
		_tmp2_ = win;
		xnp_application_set_data_value (self, (GObject*) _tmp2_, "internal-change", TRUE);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = action;
		if (g_strcmp0 (_tmp3_, "delete") == 0) {
			XnpWindow* _tmp4_;
			XnpWindow* _tmp5_;
			_tmp4_ = win;
			xnp_application_delete_window (self, _tmp4_);
			_tmp5_ = win;
			xnp_application_set_data_value (self, (GObject*) _tmp5_, "internal-change", TRUE);
		} else {
			const gchar* _tmp6_;
			_tmp6_ = action;
			if (g_strcmp0 (_tmp6_, "create-new-window") == 0) {
				XnpWindow* _tmp7_ = NULL;
				XnpWindow* new_win;
				XnpWindow* _tmp8_;
				XnpWindow* _tmp9_;
				_tmp7_ = xnp_application_create_window (self, NULL);
				new_win = _tmp7_;
				_tmp8_ = new_win;
				gtk_widget_show ((GtkWidget*) _tmp8_);
				_tmp9_ = win;
				xnp_application_set_data_value (self, (GObject*) _tmp9_, "internal-change", TRUE);
				_g_object_unref0 (new_win);
			} else {
				const gchar* _tmp10_;
				_tmp10_ = action;
				if (g_strcmp0 (_tmp10_, "refresh-notes") == 0) {
					XnpWindow* _tmp11_;
					_tmp11_ = win;
					xnp_application_refresh_notes (self, _tmp11_);
				} else {
					const gchar* _tmp12_;
					_tmp12_ = action;
					if (g_strcmp0 (_tmp12_, "properties") == 0) {
						xnp_application_open_settings_dialog (self);
					} else {
						const gchar* _tmp13_;
						_tmp13_ = action;
						if (g_strcmp0 (_tmp13_, "about") == 0) {
							xnp_application_open_about_dialog (self);
						}
					}
				}
			}
		}
	}
}


static void ___lambda23__xnp_window_action (XnpWindow* _sender, const gchar* action, gpointer self) {
	__lambda23_ (self, _sender, action);
}


static void __lambda25_ (XnpApplication* self, XnpWindow* win, XnpNote* note) {
	XnpWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = win;
	_tmp1_ = xnp_application_get_data_value (self, (GObject*) _tmp0_, "external-change");
	if (!_tmp1_) {
		XnpWindow* _tmp2_;
		XnpWindow* _tmp3_;
		XnpNote* _tmp4_;
		_tmp2_ = win;
		xnp_application_set_data_value (self, (GObject*) _tmp2_, "internal-change", TRUE);
		_tmp3_ = win;
		_tmp4_ = note;
		xnp_application_save_note (self, _tmp3_, _tmp4_);
	}
}


static void ___lambda25__xnp_window_save_data (XnpWindow* _sender, XnpNote* note, gpointer self) {
	__lambda25_ (self, _sender, note);
}


static void __lambda26_ (XnpApplication* self, XnpWindow* win, XnpNote* note) {
	XfconfChannel* _tmp0_;
	XnpNote* _tmp1_;
	XnpHypertextView* _tmp2_;
	const gchar* _tmp3_;
	XnpWindow* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	XnpNote* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = note;
	_tmp2_ = _tmp1_->text_view;
	xfconf_g_property_bind (_tmp0_, "/global/font-description", G_TYPE_STRING, _tmp2_, "font");
	_tmp3_ = self->priv->_notes_path;
	_tmp4_ = win;
	_tmp5_ = xnp_window_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = note;
	_tmp8_ = xnp_note_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s/%s/%s", _tmp3_, _tmp6_, _tmp9_);
	path = _tmp10_;
	{
		XnpWindow* _tmp11_;
		g_file_set_contents (path, "", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = win;
		xnp_application_set_data_value (self, (GObject*) _tmp11_, "internal-change", TRUE);
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


static void ___lambda26__xnp_window_note_inserted (XnpWindow* _sender, XnpNote* note, gpointer self) {
	__lambda26_ (self, _sender, note);
}


static void __lambda27_ (XnpApplication* self, XnpWindow* win, XnpNote* note) {
	const gchar* _tmp0_;
	XnpWindow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	XnpNote* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* path;
	XnpWindow* _tmp8_;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = win;
	_tmp2_ = xnp_window_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = note;
	_tmp5_ = xnp_note_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp3_, _tmp6_);
	path = _tmp7_;
	g_unlink (path);
	_tmp8_ = win;
	xnp_application_set_data_value (self, (GObject*) _tmp8_, "internal-change", TRUE);
	_g_free0 (path);
}


static void ___lambda27__xnp_window_note_deleted (XnpWindow* _sender, XnpNote* note, gpointer self) {
	__lambda27_ (self, _sender, note);
}


static void __lambda28_ (XnpApplication* self, XnpWindow* win, XnpNote* note, const gchar* old_name) {
	XnpNote* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp6_;
	XnpWindow* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* old_path;
	const gchar* _tmp12_;
	XnpWindow* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	XnpNote* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* new_path;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	XnpWindow* _tmp22_;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (old_name != NULL);
	_tmp0_ = note;
	_tmp1_ = xnp_note_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = xnp_application_name_is_valid (self, _tmp2_);
	if (!_tmp3_) {
		XnpNote* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = note;
		_tmp5_ = old_name;
		xnp_note_set_name (_tmp4_, _tmp5_);
		return;
	}
	_tmp6_ = self->priv->_notes_path;
	_tmp7_ = win;
	_tmp8_ = xnp_window_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = old_name;
	_tmp11_ = g_strdup_printf ("%s/%s/%s", _tmp6_, _tmp9_, _tmp10_);
	old_path = _tmp11_;
	_tmp12_ = self->priv->_notes_path;
	_tmp13_ = win;
	_tmp14_ = xnp_window_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = note;
	_tmp17_ = xnp_note_get_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%s/%s/%s", _tmp12_, _tmp15_, _tmp18_);
	new_path = _tmp19_;
	_tmp20_ = old_path;
	_tmp21_ = new_path;
	g_rename (_tmp20_, _tmp21_);
	_tmp22_ = win;
	xnp_application_set_data_value (self, (GObject*) _tmp22_, "internal-change", TRUE);
	_g_free0 (new_path);
	_g_free0 (old_path);
}


static void ___lambda28__xnp_window_note_renamed (XnpWindow* _sender, XnpNote* note, const gchar* old_name, gpointer self) {
	__lambda28_ (self, _sender, note, old_name);
}


XnpWindow* xnp_application_create_window (XnpApplication* self, const gchar* name) {
	XnpWindow* result = NULL;
	XnpWindow* _tmp0_;
	XnpWindow* window;
	const gchar* _tmp1_;
	const gchar* _tmp19_;
	XnpWindow* _tmp39_;
	XnpWindow* _tmp40_;
	XnpWindow* _tmp41_;
	GSList* _tmp42_;
	const gchar* _tmp46_;
	XnpWindow* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_ = NULL;
	gchar* window_path;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	gboolean _tmp55_;
	XnpWindow* _tmp65_;
	XfconfChannel* _tmp66_;
	XnpWindow* _tmp67_;
	XfconfChannel* _tmp68_;
	XnpWindow* _tmp69_;
	XnpWindow* _tmp70_;
	XnpWindow* _tmp71_;
	XnpWindow* _tmp72_;
	XnpWindow* _tmp73_;
	XnpWindow* _tmp74_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xnp_window_new ();
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ == NULL) {
		XnpWindow* _tmp2_;
		XfconfChannel* _tmp3_;
		gboolean _tmp4_ = FALSE;
		XnpWindow* _tmp5_;
		XfconfChannel* _tmp6_;
		gboolean _tmp7_ = FALSE;
		XfconfChannel* _tmp8_;
		gint32 _tmp9_ = 0;
		gint width;
		XfconfChannel* _tmp10_;
		gint32 _tmp11_ = 0;
		gint height;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		gboolean _tmp15_;
		_tmp2_ = window;
		_tmp3_ = self->priv->xfconf_channel;
		_tmp4_ = xfconf_channel_get_bool (_tmp3_, "/new-window/always-on-top", FALSE);
		xnp_window_set_above (_tmp2_, _tmp4_);
		_tmp5_ = window;
		_tmp6_ = self->priv->xfconf_channel;
		_tmp7_ = xfconf_channel_get_bool (_tmp6_, "/new-window/sticky", TRUE);
		xnp_window_set_sticky (_tmp5_, _tmp7_);
		_tmp8_ = self->priv->xfconf_channel;
		_tmp9_ = xfconf_channel_get_int (_tmp8_, "/new-window/width", (gint32) 0);
		width = (gint) _tmp9_;
		_tmp10_ = self->priv->xfconf_channel;
		_tmp11_ = xfconf_channel_get_int (_tmp10_, "/new-window/height", (gint32) 0);
		height = (gint) _tmp11_;
		_tmp13_ = width;
		if (_tmp13_ > 0) {
			gint _tmp14_;
			_tmp14_ = height;
			_tmp12_ = _tmp14_ > 0;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			XnpWindow* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = window;
			_tmp17_ = width;
			_tmp18_ = height;
			gtk_window_resize ((GtkWindow*) _tmp16_, _tmp17_, _tmp18_);
		}
	}
	_tmp19_ = name;
	if (_tmp19_ == NULL) {
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* window_name;
		GSList* _tmp22_;
		guint _tmp23_ = 0U;
		gint len;
		XnpWindow* _tmp35_;
		const gchar* _tmp36_;
		_tmp20_ = _ ("Notes");
		_tmp21_ = g_strdup (_tmp20_);
		window_name = _tmp21_;
		_tmp22_ = self->priv->window_list;
		_tmp23_ = g_slist_length (_tmp22_);
		len = (gint) _tmp23_;
		{
			gint id;
			id = 1;
			{
				gboolean _tmp24_;
				_tmp24_ = TRUE;
				while (TRUE) {
					gboolean _tmp25_;
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					const gchar* _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp25_ = _tmp24_;
					if (!_tmp25_) {
						gint _tmp26_;
						_tmp26_ = id;
						id = _tmp26_ + 1;
					}
					_tmp24_ = FALSE;
					_tmp27_ = id;
					_tmp28_ = len;
					if (!(_tmp27_ <= (_tmp28_ + 1))) {
						break;
					}
					_tmp29_ = id;
					if (_tmp29_ > 1) {
						const gchar* _tmp30_ = NULL;
						gint _tmp31_;
						gchar* _tmp32_ = NULL;
						_tmp30_ = _ ("Notes %d");
						_tmp31_ = id;
						_tmp32_ = g_strdup_printf (_tmp30_, _tmp31_);
						_g_free0 (window_name);
						window_name = _tmp32_;
					}
					_tmp33_ = window_name;
					_tmp34_ = xnp_application_window_name_exists (self, _tmp33_);
					if (!_tmp34_) {
						break;
					}
				}
			}
		}
		_tmp35_ = window;
		_tmp36_ = window_name;
		xnp_window_set_name (_tmp35_, _tmp36_);
		_g_free0 (window_name);
	} else {
		XnpWindow* _tmp37_;
		const gchar* _tmp38_;
		_tmp37_ = window;
		_tmp38_ = name;
		xnp_window_set_name (_tmp37_, _tmp38_);
	}
	_tmp39_ = window;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	_tmp41_ = window;
	self->priv->window_list = g_slist_insert_sorted (self->priv->window_list, _tmp40_, (GCompareFunc) xnp_window_compare_func);
	_tmp42_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp42_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp43_;
			XnpWindow* win = NULL;
			_tmp43_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp43_;
			{
				XnpWindow* _tmp44_;
				GSList* _tmp45_;
				_tmp44_ = win;
				_tmp45_ = self->priv->window_list;
				xnp_window_set_window_list (_tmp44_, _tmp45_);
				_g_object_unref0 (win);
			}
		}
	}
	_tmp46_ = self->priv->_notes_path;
	_tmp47_ = window;
	_tmp48_ = xnp_window_get_name (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%s/%s", _tmp46_, _tmp49_);
	window_path = _tmp50_;
	_tmp52_ = name;
	if (_tmp52_ == NULL) {
		_tmp51_ = TRUE;
	} else {
		const gchar* _tmp53_;
		gboolean _tmp54_ = FALSE;
		_tmp53_ = window_path;
		_tmp54_ = g_file_test (_tmp53_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS);
		_tmp51_ = !_tmp54_;
	}
	_tmp55_ = _tmp51_;
	if (_tmp55_) {
		{
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* note_path;
			const gchar* _tmp60_;
			XnpWindow* _tmp61_;
			_tmp56_ = window_path;
			g_mkdir_with_parents (_tmp56_, 0700);
			_tmp57_ = window_path;
			_tmp58_ = _ ("Notes");
			_tmp59_ = g_strdup_printf ("%s/%s", _tmp57_, _tmp58_);
			note_path = _tmp59_;
			_tmp60_ = note_path;
			g_file_set_contents (_tmp60_, "", (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (note_path);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				_g_free0 (note_path);
				_g_free0 (window_path);
				_g_object_unref0 (window);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp61_ = window;
			xnp_application_load_window_data (self, _tmp61_);
			_g_free0 (note_path);
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp62_;
			const gchar* _tmp63_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp62_ = e;
			_tmp63_ = _tmp62_->message;
			g_critical ("application.vala:223: Unable to initialize a notes group: %s", _tmp63_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (window_path);
			_g_object_unref0 (window);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		XnpWindow* _tmp64_;
		_tmp64_ = window;
		xnp_application_load_window_data (self, _tmp64_);
	}
	_tmp65_ = window;
	xnp_application_window_monitor_list_add (self, _tmp65_);
	_tmp66_ = self->priv->xfconf_channel;
	_tmp67_ = window;
	xfconf_g_property_bind (_tmp66_, "/global/skip-taskbar-hint", G_TYPE_BOOLEAN, _tmp67_, "skip-taskbar-hint");
	_tmp68_ = self->priv->xfconf_channel;
	_tmp69_ = window;
	xfconf_g_property_bind (_tmp68_, "/global/tabs-position", G_TYPE_INT, _tmp69_, "tabs-position");
	_tmp70_ = window;
	g_signal_connect_object (_tmp70_, "action", (GCallback) ___lambda23__xnp_window_action, self, 0);
	_tmp71_ = window;
	g_signal_connect_object (_tmp71_, "save-data", (GCallback) ___lambda25__xnp_window_save_data, self, 0);
	_tmp72_ = window;
	g_signal_connect_object (_tmp72_, "note-inserted", (GCallback) ___lambda26__xnp_window_note_inserted, self, 0);
	_tmp73_ = window;
	g_signal_connect_object (_tmp73_, "note-deleted", (GCallback) ___lambda27__xnp_window_note_deleted, self, 0);
	_tmp74_ = window;
	g_signal_connect_object (_tmp74_, "note-renamed", (GCallback) ___lambda28__xnp_window_note_renamed, self, 0);
	result = window;
	_g_free0 (window_path);
	return result;
}


/**
 * load_window_data:
 *
 * Load existing notes and configuration inside the window.
 */
static void xnp_application_load_window_data (XnpApplication* self, XnpWindow* window) {
	gchar* name = NULL;
	const gchar* _tmp0_;
	XnpWindow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* path;
	GKeyFile* _tmp36_;
	GKeyFile* keyfile;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = window;
	_tmp2_ = xnp_window_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp3_);
	path = _tmp4_;
	{
		const gchar* _tmp5_;
		GDir* _tmp6_ = NULL;
		GDir* dir;
		_tmp5_ = path;
		_tmp6_ = g_dir_open (_tmp5_, (guint) 0, &_inner_error_);
		dir = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			GDir* _tmp7_;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = dir;
			_tmp8_ = g_dir_read_name (_tmp7_);
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			{
				gchar* contents = NULL;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GFile* _tmp15_ = NULL;
				GFile* _tmp16_;
				GFile* file;
				GFile* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				XnpWindow* _tmp21_;
				XnpNote* _tmp22_ = NULL;
				XnpNote* note;
				XnpNote* _tmp23_;
				const gchar* _tmp24_;
				XnpNote* _tmp25_;
				XnpHypertextView* _tmp26_;
				GtkTextBuffer* _tmp27_ = NULL;
				GtkTextBuffer* _tmp28_;
				GtkTextBuffer* buffer;
				GtkTextBuffer* _tmp29_;
				const gchar* _tmp30_;
				XfconfChannel* _tmp31_;
				XnpNote* _tmp32_;
				XnpHypertextView* _tmp33_;
				_tmp11_ = path;
				_tmp12_ = name;
				_tmp13_ = g_strdup_printf ("%s/%s", _tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				file = _tmp16_;
				_tmp17_ = file;
				_tmp18_ = g_file_get_path (_tmp17_);
				_tmp19_ = _tmp18_;
				g_file_get_contents (_tmp19_, &_tmp20_, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp20_;
				_g_free0 (_tmp19_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					_g_free0 (contents);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch5_g_file_error;
					}
					_g_object_unref0 (file);
					_g_free0 (contents);
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp21_ = window;
				_tmp22_ = xnp_window_insert_note (_tmp21_);
				note = _tmp22_;
				_tmp23_ = note;
				_tmp24_ = name;
				xnp_note_set_name (_tmp23_, _tmp24_);
				_tmp25_ = note;
				_tmp26_ = _tmp25_->text_view;
				_tmp27_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp26_);
				_tmp28_ = _g_object_ref0 (_tmp27_);
				buffer = _tmp28_;
				_tmp29_ = buffer;
				_tmp30_ = contents;
				gtk_text_buffer_set_text (_tmp29_, _tmp30_, -1);
				_tmp31_ = self->priv->xfconf_channel;
				_tmp32_ = note;
				_tmp33_ = _tmp32_->text_view;
				xfconf_g_property_bind (_tmp31_, "/global/font-description", G_TYPE_STRING, _tmp33_, "font");
				_g_object_unref0 (buffer);
				_g_object_unref0 (note);
				_g_object_unref0 (file);
				_g_free0 (contents);
			}
			goto __finally5;
			__catch5_g_file_error:
			{
				GError* e = NULL;
				GError* _tmp34_;
				const gchar* _tmp35_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp34_ = e;
				_tmp35_ = _tmp34_->message;
				g_warning ("application.vala:325: %s", _tmp35_);
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_dir_close0 (dir);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch4_g_file_error;
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp36_ = g_key_file_new ();
	keyfile = _tmp36_;
	{
		GKeyFile* _tmp37_;
		const gchar* _tmp38_;
		GKeyFile* _tmp39_;
		XnpWindow* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gint _tmp43_ = 0;
		gint winx;
		GKeyFile* _tmp44_;
		XnpWindow* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gint _tmp48_ = 0;
		gint winy;
		GKeyFile* _tmp49_;
		XnpWindow* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gint _tmp53_ = 0;
		gint width;
		GKeyFile* _tmp54_;
		XnpWindow* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gint _tmp58_ = 0;
		gint height;
		GKeyFile* _tmp59_;
		XnpWindow* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gsize _tmp63_;
		gchar** _tmp64_ = NULL;
		gchar** tabs_order;
		gint tabs_order_length1;
		gint _tabs_order_size_;
		GKeyFile* _tmp65_;
		XnpWindow* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		gint _tmp69_ = 0;
		gint last_page;
		GKeyFile* _tmp70_;
		XnpWindow* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		gboolean _tmp74_ = FALSE;
		gboolean above;
		GKeyFile* _tmp75_;
		XnpWindow* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gboolean _tmp79_ = FALSE;
		gboolean sticky;
		GKeyFile* _tmp80_;
		XnpWindow* _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		gint _tmp84_ = 0;
		gint _tmp85_;
		gdouble opacity;
		GKeyFile* _tmp86_;
		XnpWindow* _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		gboolean _tmp90_ = FALSE;
		gboolean visible;
		XnpWindow* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		XnpWindow* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		XnpWindow* _tmp107_;
		gint _tmp108_;
		XnpWindow* _tmp109_;
		gboolean _tmp110_;
		XnpWindow* _tmp111_;
		gboolean _tmp112_;
		XnpWindow* _tmp113_;
		gdouble _tmp114_;
		gboolean _tmp115_;
		_tmp37_ = keyfile;
		_tmp38_ = self->priv->_config_file;
		g_key_file_load_from_file (_tmp37_, _tmp38_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp39_ = keyfile;
		_tmp40_ = window;
		_tmp41_ = xnp_window_get_name (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_key_file_get_integer (_tmp39_, _tmp42_, "PosX", &_inner_error_);
		winx = _tmp43_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp44_ = keyfile;
		_tmp45_ = window;
		_tmp46_ = xnp_window_get_name (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_key_file_get_integer (_tmp44_, _tmp47_, "PosY", &_inner_error_);
		winy = _tmp48_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp49_ = keyfile;
		_tmp50_ = window;
		_tmp51_ = xnp_window_get_name (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_key_file_get_integer (_tmp49_, _tmp52_, "Width", &_inner_error_);
		width = _tmp53_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp54_ = keyfile;
		_tmp55_ = window;
		_tmp56_ = xnp_window_get_name (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_key_file_get_integer (_tmp54_, _tmp57_, "Height", &_inner_error_);
		height = _tmp58_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp59_ = keyfile;
		_tmp60_ = window;
		_tmp61_ = xnp_window_get_name (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp64_ = g_key_file_get_string_list (_tmp59_, _tmp62_, "TabsOrder", &_tmp63_, &_inner_error_);
		tabs_order = _tmp64_;
		tabs_order_length1 = _tmp63_;
		_tabs_order_size_ = tabs_order_length1;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp65_ = keyfile;
		_tmp66_ = window;
		_tmp67_ = xnp_window_get_name (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_key_file_get_integer (_tmp65_, _tmp68_, "LastTab", &_inner_error_);
		last_page = _tmp69_;
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch6_g_error;
		}
		_tmp70_ = keyfile;
		_tmp71_ = window;
		_tmp72_ = xnp_window_get_name (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_key_file_get_boolean (_tmp70_, _tmp73_, "Above", &_inner_error_);
		above = _tmp74_;
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch6_g_error;
		}
		_tmp75_ = keyfile;
		_tmp76_ = window;
		_tmp77_ = xnp_window_get_name (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_key_file_get_boolean (_tmp75_, _tmp78_, "Sticky", &_inner_error_);
		sticky = _tmp79_;
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch6_g_error;
		}
		_tmp80_ = keyfile;
		_tmp81_ = window;
		_tmp82_ = xnp_window_get_name (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_key_file_get_integer (_tmp80_, _tmp83_, "Transparency", &_inner_error_);
		_tmp85_ = _tmp84_;
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch6_g_error;
		}
		opacity = 1 - (((gdouble) _tmp85_) / 100);
		_tmp86_ = keyfile;
		_tmp87_ = window;
		_tmp88_ = xnp_window_get_name (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = g_key_file_get_boolean (_tmp86_, _tmp89_, "Visible", &_inner_error_);
		visible = _tmp90_;
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch6_g_error;
		}
		_tmp91_ = window;
		_tmp92_ = winx;
		_tmp93_ = winy;
		gtk_window_move ((GtkWindow*) _tmp91_, _tmp92_, _tmp93_);
		_tmp94_ = window;
		_tmp95_ = width;
		_tmp96_ = height;
		gtk_window_resize ((GtkWindow*) _tmp94_, _tmp95_, _tmp96_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp97_;
				_tmp97_ = TRUE;
				while (TRUE) {
					gboolean _tmp98_;
					gint _tmp100_;
					gchar** _tmp101_;
					gint _tmp101__length1;
					XnpWindow* _tmp102_;
					gchar** _tmp103_;
					gint _tmp103__length1;
					gint _tmp104_;
					const gchar* _tmp105_;
					gint _tmp106_;
					_tmp98_ = _tmp97_;
					if (!_tmp98_) {
						gint _tmp99_;
						_tmp99_ = i;
						i = _tmp99_ + 1;
					}
					_tmp97_ = FALSE;
					_tmp100_ = i;
					_tmp101_ = tabs_order;
					_tmp101__length1 = tabs_order_length1;
					if (!(_tmp100_ < _tmp101__length1)) {
						break;
					}
					_tmp102_ = window;
					_tmp103_ = tabs_order;
					_tmp103__length1 = tabs_order_length1;
					_tmp104_ = i;
					_tmp105_ = _tmp103_[_tmp104_];
					_tmp106_ = i;
					xnp_window_move_note (_tmp102_, _tmp105_, _tmp106_);
				}
			}
		}
		_tmp107_ = window;
		_tmp108_ = last_page;
		xnp_window_set_current_page (_tmp107_, _tmp108_);
		_tmp109_ = window;
		_tmp110_ = above;
		xnp_window_set_above (_tmp109_, _tmp110_);
		_tmp111_ = window;
		_tmp112_ = sticky;
		xnp_window_set_sticky (_tmp111_, _tmp112_);
		_tmp113_ = window;
		_tmp114_ = opacity;
		gtk_window_set_opacity ((GtkWindow*) _tmp113_, _tmp114_);
		_tmp115_ = visible;
		if (_tmp115_) {
			XnpWindow* _tmp116_;
			_tmp116_ = window;
			gtk_widget_show ((GtkWidget*) _tmp116_);
		}
		tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		XnpWindow* _tmp117_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp117_ = window;
		gtk_widget_show ((GtkWidget*) _tmp117_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (keyfile);
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (keyfile);
	_g_free0 (path);
	_g_free0 (name);
}


/**
 * save_windows_configuration:
 *
 * Save window configuration inside rc file.
 */
void xnp_application_save_windows_configuration (XnpApplication* self) {
	GKeyFile* _tmp0_;
	GKeyFile* keyfile;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		GSList* _tmp1_;
		GKeyFile* _tmp72_;
		gchar* _tmp73_ = NULL;
		gchar* contents;
		const gchar* _tmp74_;
		_tmp1_ = self->priv->window_list;
		{
			GSList* win_collection = NULL;
			GSList* win_it = NULL;
			win_collection = _tmp1_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* _tmp2_;
				XnpWindow* win = NULL;
				_tmp2_ = _g_object_ref0 ((XnpWindow*) win_it->data);
				win = _tmp2_;
				{
					gint winx = 0;
					gint winy = 0;
					gint width = 0;
					gint height = 0;
					XnpWindow* _tmp3_;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					XnpWindow* _tmp8_;
					gint _tmp9_ = 0;
					gchar** _tmp10_ = NULL;
					gchar** tabs_order;
					gint tabs_order_length1;
					gint _tabs_order_size_;
					XnpWindow* _tmp11_;
					gint _tmp12_ = 0;
					gint last_page;
					XnpWindow* _tmp13_;
					gdouble _tmp14_;
					gdouble _tmp15_;
					gint transparency;
					XnpWindow* _tmp16_;
					gboolean _tmp17_ = FALSE;
					gboolean visible;
					GKeyFile* _tmp18_;
					XnpWindow* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gint _tmp22_;
					GKeyFile* _tmp23_;
					XnpWindow* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					GKeyFile* _tmp28_;
					XnpWindow* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gint _tmp32_;
					GKeyFile* _tmp33_;
					XnpWindow* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gint _tmp37_;
					GKeyFile* _tmp38_;
					XnpWindow* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar** _tmp42_;
					gint _tmp42__length1;
					GKeyFile* _tmp43_;
					XnpWindow* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gint _tmp47_;
					GKeyFile* _tmp48_;
					XnpWindow* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					XnpWindow* _tmp52_;
					gboolean _tmp53_;
					gboolean _tmp54_;
					GKeyFile* _tmp55_;
					XnpWindow* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					XnpWindow* _tmp59_;
					gboolean _tmp60_;
					gboolean _tmp61_;
					GKeyFile* _tmp62_;
					XnpWindow* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					gint _tmp66_;
					GKeyFile* _tmp67_;
					XnpWindow* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gboolean _tmp71_;
					_tmp3_ = win;
					xnp_window_get_geometry (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
					winx = _tmp4_;
					winy = _tmp5_;
					width = _tmp6_;
					height = _tmp7_;
					_tmp8_ = win;
					_tmp10_ = xnp_window_get_note_names (_tmp8_, &_tmp9_);
					tabs_order = _tmp10_;
					tabs_order_length1 = _tmp9_;
					_tabs_order_size_ = tabs_order_length1;
					_tmp11_ = win;
					_tmp12_ = xnp_window_get_current_page (_tmp11_);
					last_page = _tmp12_;
					_tmp13_ = win;
					_tmp14_ = gtk_window_get_opacity ((GtkWindow*) _tmp13_);
					_tmp15_ = _tmp14_;
					transparency = (gint) ((1 - _tmp15_) * 100);
					_tmp16_ = win;
					_tmp17_ = gtk_widget_get_visible ((GtkWidget*) _tmp16_);
					visible = _tmp17_;
					_tmp18_ = keyfile;
					_tmp19_ = win;
					_tmp20_ = xnp_window_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = winx;
					g_key_file_set_integer (_tmp18_, _tmp21_, "PosX", _tmp22_);
					_tmp23_ = keyfile;
					_tmp24_ = win;
					_tmp25_ = xnp_window_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = winy;
					g_key_file_set_integer (_tmp23_, _tmp26_, "PosY", _tmp27_);
					_tmp28_ = keyfile;
					_tmp29_ = win;
					_tmp30_ = xnp_window_get_name (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = width;
					g_key_file_set_integer (_tmp28_, _tmp31_, "Width", _tmp32_);
					_tmp33_ = keyfile;
					_tmp34_ = win;
					_tmp35_ = xnp_window_get_name (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = height;
					g_key_file_set_integer (_tmp33_, _tmp36_, "Height", _tmp37_);
					_tmp38_ = keyfile;
					_tmp39_ = win;
					_tmp40_ = xnp_window_get_name (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = tabs_order;
					_tmp42__length1 = tabs_order_length1;
					g_key_file_set_string_list (_tmp38_, _tmp41_, "TabsOrder", (const gchar* const*) _tmp42_, _tmp42__length1);
					_tmp43_ = keyfile;
					_tmp44_ = win;
					_tmp45_ = xnp_window_get_name (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = last_page;
					g_key_file_set_integer (_tmp43_, _tmp46_, "LastTab", _tmp47_);
					_tmp48_ = keyfile;
					_tmp49_ = win;
					_tmp50_ = xnp_window_get_name (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = win;
					_tmp53_ = xnp_window_get_above (_tmp52_);
					_tmp54_ = _tmp53_;
					g_key_file_set_boolean (_tmp48_, _tmp51_, "Above", _tmp54_);
					_tmp55_ = keyfile;
					_tmp56_ = win;
					_tmp57_ = xnp_window_get_name (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = win;
					_tmp60_ = xnp_window_get_sticky (_tmp59_);
					_tmp61_ = _tmp60_;
					g_key_file_set_boolean (_tmp55_, _tmp58_, "Sticky", _tmp61_);
					_tmp62_ = keyfile;
					_tmp63_ = win;
					_tmp64_ = xnp_window_get_name (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = transparency;
					g_key_file_set_double (_tmp62_, _tmp65_, "Transparency", (gdouble) _tmp66_);
					_tmp67_ = keyfile;
					_tmp68_ = win;
					_tmp69_ = xnp_window_get_name (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = visible;
					g_key_file_set_boolean (_tmp67_, _tmp70_, "Visible", _tmp71_);
					tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (win);
				}
			}
		}
		_tmp72_ = keyfile;
		_tmp73_ = g_key_file_to_data (_tmp72_, NULL, NULL);
		contents = _tmp73_;
		_tmp74_ = self->priv->_config_file;
		g_file_set_contents (_tmp74_, contents, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch7_g_file_error;
			}
			_g_free0 (contents);
			_g_key_file_free0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (contents);
	}
	goto __finally7;
	__catch7_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp75_;
		GError* _tmp76_;
		const gchar* _tmp77_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp75_ = self->priv->_config_file;
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		g_message ("application.vala:394: Unable to save window configuration from %s: %s", _tmp75_, _tmp77_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (keyfile);
}


/**
 * save_notes:
 *
 * Save the contents of every existing notes.
 */
void xnp_application_save_notes (XnpApplication* self) {
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				XnpWindow* _tmp3_;
				_tmp2_ = win;
				xnp_application_set_data_value (self, (GObject*) _tmp2_, "external-change", FALSE);
				_tmp3_ = win;
				xnp_window_save_notes (_tmp3_);
				_g_object_unref0 (win);
			}
		}
	}
}


/**
 * save_note:
 *
 * Save the contents of the given note.
 */
static void xnp_application_save_note (XnpApplication* self, XnpWindow* window, XnpNote* note) {
	const gchar* _tmp0_;
	XnpWindow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	XnpNote* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = window;
	_tmp2_ = xnp_window_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = note;
	_tmp5_ = xnp_note_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp3_, _tmp6_);
	path = _tmp7_;
	{
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		XnpNote* _tmp8_;
		XnpHypertextView* _tmp9_;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextBuffer* _tmp11_;
		GtkTextBuffer* buffer;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* contents;
		_tmp8_ = note;
		_tmp9_ = _tmp8_->text_view;
		_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp9_);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		buffer = _tmp11_;
		gtk_text_buffer_get_bounds (buffer, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = start;
		_tmp15_ = end;
		_tmp16_ = gtk_text_buffer_get_text (buffer, &_tmp14_, &_tmp15_, TRUE);
		contents = _tmp16_;
		g_file_set_contents (path, contents, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			_g_object_unref0 (buffer);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (contents);
			_g_object_unref0 (buffer);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (contents);
		_g_object_unref0 (buffer);
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("application.vala:425: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


/**
 * rename_window:
 *
 * Renames the window name.
 */
static void xnp_application_rename_window (XnpApplication* self, XnpWindow* window) {
	const gchar* _tmp0_ = NULL;
	XnpWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* dialog;
	GtkDialog* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	GtkBox* content_area;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkBox* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* entry;
	GtkEntry* _tmp12_;
	XnpWindow* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GtkEntry* _tmp16_;
	GtkBox* _tmp17_;
	GtkEntry* _tmp18_;
	GtkBox* _tmp19_;
	GtkDialog* _tmp20_;
	gint _tmp21_ = 0;
	gint res;
	GtkDialog* _tmp22_;
	gint _tmp23_;
	GtkDialog* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = _ ("Rename group");
	_tmp1_ = window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	_tmp4_ = gtk_dialog_get_content_area (_tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_BOX, GtkBox));
	content_area = _tmp5_;
	_tmp6_ = dialog;
	gtk_dialog_set_default_response (_tmp6_, (gint) GTK_RESPONSE_OK);
	_tmp7_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp7_, FALSE);
	_tmp8_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp8_, GTK_STOCK_EDIT);
	_tmp9_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp9_, (guint) 4);
	_tmp10_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 6);
	_tmp11_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp11_);
	entry = _tmp11_;
	_tmp12_ = entry;
	_tmp13_ = window;
	_tmp14_ = xnp_window_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_entry_set_text (_tmp12_, _tmp15_);
	_tmp16_ = entry;
	gtk_entry_set_activates_default (_tmp16_, TRUE);
	_tmp17_ = content_area;
	_tmp18_ = entry;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	_tmp20_ = dialog;
	_tmp21_ = gtk_dialog_run (_tmp20_);
	res = _tmp21_;
	_tmp22_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp22_);
	_tmp23_ = res;
	if (_tmp23_ == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* name;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = entry;
		_tmp25_ = gtk_entry_get_text (_tmp24_);
		_tmp26_ = _tmp25_;
		name = _tmp26_;
		_tmp27_ = name;
		_tmp28_ = xnp_application_window_name_exists (self, _tmp27_);
		if (_tmp28_) {
			XnpWindow* _tmp29_;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			GtkMessageDialog* _tmp32_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp33_;
			GtkMessageDialog* _tmp34_;
			_tmp29_ = window;
			_tmp30_ = _ ("The name %s is already in use");
			_tmp31_ = name;
			_tmp32_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp29_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp30_, _tmp31_);
			g_object_ref_sink (_tmp32_);
			error_dialog = _tmp32_;
			_tmp33_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp33_);
			_tmp34_ = error_dialog;
			gtk_object_destroy ((GtkObject*) _tmp34_);
			_g_object_unref0 (error_dialog);
		} else {
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_;
			XnpWindow* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* old_path;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* new_path;
			XnpWindow* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			XnpWindow* _tmp49_;
			XnpWindow* _tmp50_;
			XnpWindow* _tmp51_;
			_tmp35_ = name;
			_tmp36_ = xnp_application_name_is_valid (self, _tmp35_);
			if (!_tmp36_) {
				_g_object_unref0 (entry);
				_g_object_unref0 (content_area);
				_g_object_unref0 (dialog);
				return;
			}
			_tmp37_ = self->priv->_notes_path;
			_tmp38_ = window;
			_tmp39_ = xnp_window_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf ("%s/%s", _tmp37_, _tmp40_);
			old_path = _tmp41_;
			_tmp42_ = self->priv->_notes_path;
			_tmp43_ = name;
			_tmp44_ = g_strdup_printf ("%s/%s", _tmp42_, _tmp43_);
			new_path = _tmp44_;
			_tmp45_ = window;
			_tmp46_ = name;
			xnp_window_set_name (_tmp45_, _tmp46_);
			_tmp47_ = old_path;
			_tmp48_ = new_path;
			g_rename (_tmp47_, _tmp48_);
			_tmp49_ = window;
			self->priv->window_list = g_slist_sort (self->priv->window_list, (GCompareFunc) xnp_window_compare_func);
			_tmp50_ = window;
			xnp_application_window_monitor_list_remove (self, _tmp50_);
			_tmp51_ = window;
			xnp_application_window_monitor_list_add (self, _tmp51_);
			_g_free0 (new_path);
			_g_free0 (old_path);
		}
	}
	_tmp52_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp52_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


/**
 * delete_window:
 *
 * Delete the window.
 */
static void xnp_application_delete_window (XnpApplication* self, XnpWindow* window) {
	XnpWindow* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* name = NULL;
	const gchar* _tmp10_;
	XnpWindow* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* path;
	XnpWindow* _tmp26_;
	XnpWindow* _tmp27_;
	XnpWindow* _tmp28_;
	GSList* _tmp29_;
	guint _tmp30_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	_tmp1_ = xnp_window_get_n_pages (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ >= 1) {
		XnpWindow* _tmp3_;
		const gchar* _tmp4_ = NULL;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp6_;
		gint _tmp7_ = 0;
		gint res;
		GtkMessageDialog* _tmp8_;
		gint _tmp9_;
		_tmp3_ = window;
		_tmp4_ = _ ("Are you sure you want to delete this group?");
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp4_);
		g_object_ref_sink (_tmp5_);
		dialog = _tmp5_;
		_tmp6_ = dialog;
		_tmp7_ = gtk_dialog_run ((GtkDialog*) _tmp6_);
		res = _tmp7_;
		_tmp8_ = dialog;
		gtk_object_destroy ((GtkObject*) _tmp8_);
		_tmp9_ = res;
		if (_tmp9_ != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp10_ = self->priv->_notes_path;
	_tmp11_ = window;
	_tmp12_ = xnp_window_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%s/%s", _tmp10_, _tmp13_);
	path = _tmp14_;
	{
		const gchar* _tmp15_;
		GDir* _tmp16_ = NULL;
		GDir* dir;
		const gchar* _tmp25_;
		_tmp15_ = path;
		_tmp16_ = g_dir_open (_tmp15_, (guint) 0, &_inner_error_);
		dir = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			GDir* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* filename;
			const gchar* _tmp24_;
			_tmp17_ = dir;
			_tmp18_ = g_dir_read_name (_tmp17_);
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (name);
			name = _tmp19_;
			_tmp20_ = name;
			if (!(_tmp20_ != NULL)) {
				break;
			}
			_tmp21_ = path;
			_tmp22_ = name;
			_tmp23_ = g_strdup_printf ("%s/%s", _tmp21_, _tmp22_);
			filename = _tmp23_;
			_tmp24_ = filename;
			g_unlink (_tmp24_);
			_g_free0 (filename);
		}
		_tmp25_ = path;
		g_rmdir (_tmp25_);
		_g_dir_close0 (dir);
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp26_ = window;
	xnp_application_window_monitor_list_remove (self, _tmp26_);
	_tmp27_ = window;
	self->priv->window_list = g_slist_remove (self->priv->window_list, _tmp27_);
	_tmp28_ = window;
	gtk_object_destroy ((GtkObject*) _tmp28_);
	_tmp29_ = self->priv->window_list;
	_tmp30_ = g_slist_length (_tmp29_);
	if (_tmp30_ >= ((guint) 1)) {
		GSList* _tmp31_;
		_tmp31_ = self->priv->window_list;
		{
			GSList* win_collection = NULL;
			GSList* win_it = NULL;
			win_collection = _tmp31_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* _tmp32_;
				XnpWindow* win = NULL;
				_tmp32_ = _g_object_ref0 ((XnpWindow*) win_it->data);
				win = _tmp32_;
				{
					XnpWindow* _tmp33_;
					GSList* _tmp34_;
					_tmp33_ = win;
					_tmp34_ = self->priv->window_list;
					xnp_window_set_window_list (_tmp33_, _tmp34_);
					_g_object_unref0 (win);
				}
			}
		}
	} else {
		XnpWindow* _tmp35_ = NULL;
		XnpWindow* new_win;
		XnpWindow* _tmp36_;
		_tmp35_ = xnp_application_create_window (self, NULL);
		new_win = _tmp35_;
		_tmp36_ = new_win;
		gtk_widget_show ((GtkWidget*) _tmp36_);
		_g_object_unref0 (new_win);
	}
	_g_free0 (path);
	_g_free0 (name);
}


/**
 * refresh_notes:
 *
 * Prompt for reloading notes from disk.
 */
static void xnp_application_refresh_notes (XnpApplication* self, XnpWindow* window) {
	XnpWindow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	XnpWindow* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp6_;
	XnpWindow* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkMessageDialog* _tmp13_;
	gint _tmp14_ = 0;
	gint res;
	GtkMessageDialog* _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	_tmp1_ = _ ("The group \"%s\" has been modified on the disk");
	_tmp2_ = window;
	_tmp3_ = xnp_window_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp1_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	_tmp7_ = window;
	_tmp8_ = xnp_window_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_window_set_title ((GtkWindow*) _tmp6_, _tmp9_);
	_tmp10_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp10_, "xfce4-notes-plugin");
	_tmp11_ = dialog;
	_tmp12_ = _ ("Do you want to reload the group?");
	gtk_message_dialog_format_secondary_text (_tmp11_, "%s", _tmp12_);
	_tmp13_ = dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	res = _tmp14_;
	_tmp15_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp15_);
	_tmp16_ = res;
	if (_tmp16_ == ((gint) GTK_RESPONSE_YES)) {
		XnpWindow* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* name;
		XnpWindow* _tmp21_;
		XnpWindow* _tmp22_;
		XnpWindow* _tmp23_;
		const gchar* _tmp24_;
		XnpWindow* _tmp25_ = NULL;
		XnpWindow* win;
		XnpWindow* _tmp26_;
		_tmp17_ = window;
		_tmp18_ = xnp_window_get_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		name = _tmp20_;
		_tmp21_ = window;
		xnp_application_window_monitor_list_remove (self, _tmp21_);
		_tmp22_ = window;
		self->priv->window_list = g_slist_remove (self->priv->window_list, _tmp22_);
		_tmp23_ = window;
		gtk_object_destroy ((GtkObject*) _tmp23_);
		_tmp24_ = name;
		_tmp25_ = xnp_application_create_window (self, _tmp24_);
		win = _tmp25_;
		_tmp26_ = win;
		gtk_widget_show ((GtkWidget*) _tmp26_);
		_g_object_unref0 (win);
		_g_free0 (name);
	} else {
		XnpWindow* _tmp27_;
		XnpWindow* _tmp28_;
		XnpWindow* _tmp29_;
		_tmp27_ = window;
		xnp_application_set_data_value (self, (GObject*) _tmp27_, "external-change", FALSE);
		_tmp28_ = window;
		xnp_window_set_show_refresh_button (_tmp28_, FALSE);
		_tmp29_ = window;
		xnp_window_save_notes (_tmp29_);
	}
	_g_object_unref0 (dialog);
}


/**
 * window_monitor_list_add:
 *
 * Creates an Xnp.WindowMonitor object and stores it inside window_monitor_list.
 */
static void __lambda22_ (XnpApplication* self, XnpWindow* window) {
	XnpWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	_tmp1_ = xnp_application_get_data_value (self, (GObject*) _tmp0_, "internal-change");
	if (_tmp1_) {
		XnpWindow* _tmp2_;
		_tmp2_ = window;
		xnp_application_set_data_value (self, (GObject*) _tmp2_, "internal-change", FALSE);
	} else {
		XnpWindow* _tmp3_;
		XnpWindow* _tmp4_;
		_tmp3_ = window;
		xnp_application_set_data_value (self, (GObject*) _tmp3_, "external-change", TRUE);
		_tmp4_ = window;
		xnp_window_set_show_refresh_button (_tmp4_, TRUE);
	}
}


static void ___lambda22__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender, XnpWindow* window, gpointer self) {
	__lambda22_ (self, window);
}


static void xnp_application_window_monitor_list_add (XnpApplication* self, XnpWindow* window) {
	const gchar* _tmp0_;
	XnpWindow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_;
	GFile* file;
	XnpWindow* _tmp8_;
	XnpWindowMonitor* _tmp9_;
	XnpWindowMonitor* monitor;
	XnpWindowMonitor* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = window;
	_tmp2_ = xnp_window_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	file = _tmp7_;
	_tmp8_ = window;
	_tmp9_ = xnp_window_monitor_new (_tmp8_, file);
	monitor = _tmp9_;
	g_signal_connect_object (monitor, "window-updated", (GCallback) ___lambda22__xnp_window_monitor_window_updated, self, 0);
	_tmp10_ = _g_object_ref0 (monitor);
	self->priv->window_monitor_list = g_slist_prepend (self->priv->window_monitor_list, _tmp10_);
	_g_object_unref0 (monitor);
	_g_object_unref0 (file);
}


/**
 * window_monitor_list_remove:
 *
 * Removes a monitor from window_monitor_list matching @window.
 */
static void xnp_application_window_monitor_list_remove (XnpApplication* self, XnpWindow* window) {
	XnpWindow* _tmp0_;
	XnpWindowMonitor* _tmp1_ = NULL;
	XnpWindowMonitor* monitor;
	XnpWindowMonitor* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	_tmp1_ = xnp_application_window_monitor_list_lookup (self, _tmp0_);
	monitor = _tmp1_;
	_tmp2_ = monitor;
	if (_tmp2_ != NULL) {
		XnpWindowMonitor* _tmp3_;
		XnpWindowMonitor* _tmp4_;
		_tmp3_ = monitor;
		self->priv->window_monitor_list = g_slist_remove (self->priv->window_monitor_list, _tmp3_);
		_tmp4_ = monitor;
		g_object_unref ((GObject*) _tmp4_);
		_g_object_unref0 (monitor);
		monitor = NULL;
	}
	_g_object_unref0 (monitor);
}


/**
 * window_monitor_list_lookup:
 *
 * Returns the window_monitor object that contains @window from the window_monitor_list.
 */
static XnpWindowMonitor* xnp_application_window_monitor_list_lookup (XnpApplication* self, XnpWindow* window) {
	XnpWindowMonitor* result = NULL;
	XnpWindowMonitor* window_monitor;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	window_monitor = NULL;
	_tmp0_ = self->priv->window_monitor_list;
	{
		GSList* monitor_collection = NULL;
		GSList* monitor_it = NULL;
		monitor_collection = _tmp0_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			XnpWindowMonitor* _tmp1_;
			XnpWindowMonitor* monitor = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindowMonitor*) monitor_it->data);
			monitor = _tmp1_;
			{
				XnpWindowMonitor* _tmp2_;
				XnpWindow* _tmp3_;
				XnpWindow* _tmp4_;
				_tmp2_ = monitor;
				_tmp3_ = _tmp2_->window;
				_tmp4_ = window;
				if (_tmp3_ == _tmp4_) {
					XnpWindowMonitor* _tmp5_;
					XnpWindowMonitor* _tmp6_;
					_tmp5_ = monitor;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (window_monitor);
					window_monitor = _tmp6_;
					_g_object_unref0 (monitor);
					break;
				}
				_g_object_unref0 (monitor);
			}
		}
	}
	result = window_monitor;
	return result;
}


/**
 * get_data_value:
 *
 * Convenience function to return a GObject data boolean value.
 */
static gboolean xnp_application_get_data_value (XnpApplication* self, GObject* object, const gchar* data) {
	gboolean result = FALSE;
	GObject* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = object;
	_tmp1_ = data;
	_tmp2_ = g_object_get_data (_tmp0_, _tmp1_);
	result = (gboolean) ((gintptr) _tmp2_);
	return result;
}


/**
 * set_data_value:
 *
 * Convenience function to set a GObject data boolean value.
 */
static void xnp_application_set_data_value (XnpApplication* self, GObject* object, const gchar* data, gboolean val) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	void* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = object;
	_tmp1_ = data;
	_tmp2_ = val;
	_tmp3_ = GINT_TO_POINTER ((gint) _tmp2_);
	g_object_set_data_full (_tmp0_, _tmp1_, _tmp3_, NULL);
}


/**
 * window_name_exists:
 *
 * Verify if the given name already exists in the window list.
 */
static gboolean xnp_application_window_name_exists (XnpApplication* self, const gchar* name) {
	gboolean result = FALSE;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = name;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = TRUE;
					_g_object_unref0 (win);
					return result;
				}
				_g_object_unref0 (win);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * name_is_valid:
 *
 * Verify if the given name is valid for window and notes.
 */
static gboolean xnp_application_name_is_valid (XnpApplication* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean res;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_regex_match_simple ("^[^*|/\\:\"<>?]+$", _tmp0_, 0, 0);
	res = _tmp1_;
	_tmp2_ = res;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GtkMessageDialog* _tmp10_;
		GtkMessageDialog* _tmp11_;
		_tmp3_ = _ ("The name \"%s\" is invalid.");
		_tmp4_ = name;
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp3_, _tmp4_);
		g_object_ref_sink (_tmp5_);
		error_dialog = _tmp5_;
		_tmp6_ = error_dialog;
		_tmp7_ = _ ("The invalid characters are: %s");
		_tmp8_ = g_strdup_printf (_tmp7_, "<tt>*|/\\:\"&lt;&gt;?</tt>");
		_tmp9_ = _tmp8_;
		gtk_message_dialog_format_secondary_markup (_tmp6_, "%s", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp10_);
		_tmp11_ = error_dialog;
		gtk_object_destroy ((GtkObject*) _tmp11_);
		_g_object_unref0 (error_dialog);
	}
	result = res;
	return result;
}


/**
 * show_hide_notes:
 *
 * Show all the notes or hide them if they are all shown.
 */
void xnp_application_show_hide_notes (XnpApplication* self) {
	gboolean invisible_found;
	gboolean visible_found;
	gboolean active_found;
	GSList* _tmp0_;
	GSList* _tmp7_;
	g_return_if_fail (self != NULL);
	invisible_found = FALSE;
	visible_found = FALSE;
	active_found = FALSE;
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				XnpWindow* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp2_ = win;
				g_object_get ((GtkWindow*) _tmp2_, "is-active", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					active_found = TRUE;
				}
				_tmp5_ = win;
				_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
				if (!_tmp6_) {
					invisible_found = TRUE;
				} else {
					visible_found = TRUE;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp7_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp7_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp8_;
			XnpWindow* win = NULL;
			_tmp8_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp8_;
			{
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_;
				gboolean _tmp12_;
				_tmp10_ = active_found;
				if (!_tmp10_) {
					gboolean _tmp11_;
					_tmp11_ = visible_found;
					_tmp9_ = _tmp11_;
				} else {
					_tmp9_ = FALSE;
				}
				_tmp12_ = _tmp9_;
				if (_tmp12_) {
					XnpWindow* _tmp13_;
					gboolean _tmp14_ = FALSE;
					_tmp13_ = win;
					_tmp14_ = gtk_widget_get_visible ((GtkWidget*) _tmp13_);
					if (_tmp14_) {
						XnpWindow* _tmp15_;
						_tmp15_ = win;
						gtk_window_present ((GtkWindow*) _tmp15_);
					}
				} else {
					gboolean _tmp16_;
					_tmp16_ = invisible_found;
					if (_tmp16_) {
						XnpWindow* _tmp17_;
						_tmp17_ = win;
						gtk_widget_show ((GtkWidget*) _tmp17_);
					} else {
						XnpWindow* _tmp18_;
						_tmp18_ = win;
						xnp_window_hide (_tmp18_);
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
}


/**
 * open_settings_dialog:
 *
 * Open the settings dialog.
 */
void xnp_application_open_settings_dialog (XnpApplication* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_spawn_command_line_async ("xfce4-notes-settings", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp0_ = NULL;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Unable to open the settings dialog");
		_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp0_);
		g_object_ref_sink (_tmp1_);
		error_dialog = _tmp1_;
		_tmp2_ = error_dialog;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		gtk_message_dialog_format_secondary_text (_tmp2_, "%s", _tmp4_);
		_tmp5_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp5_);
		_tmp6_ = error_dialog;
		gtk_object_destroy ((GtkObject*) _tmp6_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * open_about_dialog:
 *
 * Open the about dialog.
 */
static void __lambda24_ (XnpApplication* self, GtkAboutDialog* dialog, const gchar* uri) {
	gchar* command = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (uri != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		_tmp0_ = uri;
		_tmp1_ = g_strdup_printf ("exo-open %s", _tmp0_);
		_g_free0 (command);
		command = _tmp1_;
		_tmp2_ = command;
		g_spawn_command_line_async (_tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_g_free0 (command);
		return;
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		_tmp3_ = uri;
		_tmp4_ = g_strdup_printf ("firefox %s", _tmp3_);
		_g_free0 (command);
		command = _tmp4_;
		_tmp5_ = command;
		g_spawn_command_line_async (_tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		_g_free0 (command);
		return;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (command);
}


static void ___lambda24__gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const gchar* link_, gpointer self) {
	__lambda24_ (self, about, link_);
}


void xnp_application_open_about_dialog (XnpApplication* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_about_dialog_set_url_hook (___lambda24__gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	_tmp0_ = g_strdup ("(c) 2006-2010 Mike Massonnet");
	_tmp1_ = g_strdup ("(c) 2003 Jakob Henriksson");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = _ ("Notes");
	_tmp4_ = _ ("Ideal for your quick notes");
	_tmp5_ = xfce_get_license_text (XFCE_LICENSE_TEXT_GPL);
	_tmp6_ = _ ("translator-credits");
	gtk_show_about_dialog (NULL, "program-name", _tmp3_, "logo-icon-name", "xfce4-notes-plugin", "comments", _tmp4_, "version", PACKAGE_VERSION, "copyright", "Copyright © 2003-2010 The Xfce development team", "license", _tmp5_, "website", "http://goodies.xfce.org/projects/panel-plugins/xfce4-notes-plugin", "website-label", "goodies.xfce.org", "authors", authors, "translator-credits", _tmp6_, NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


/**
 * context_menu:
 *
 * Provides a GtkMenu to be used for right click context menus
 * like in trayicons. Its items are destroyed/refreshed every
 * time the menu is shown.
 */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		XnpApplication * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda30_ (XnpApplication* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	gtk_object_destroy ((GtkObject*) _tmp0_);
}


static void ___lambda30__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda30_ (self, widget);
}


static void ____lambda31_ (XnpApplication* self, GtkMenuItem* i) {
	GtkMenuItem* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	XnpWindow* _tmp2_;
	XnpWindow* w;
	g_return_if_fail (i != NULL);
	_tmp0_ = i;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "window");
	_tmp2_ = _g_object_ref0 ((XnpWindow*) _tmp1_);
	w = _tmp2_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}


static void _____lambda31__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda31_ (self, _sender);
}


static void __lambda32_ (XnpApplication* self) {
	XnpWindow* _tmp0_ = NULL;
	XnpWindow* new_win;
	_tmp0_ = xnp_application_create_window (self, NULL);
	new_win = _tmp0_;
	gtk_widget_show ((GtkWidget*) new_win);
	_g_object_unref0 (new_win);
}


static void ___lambda32__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda32_ (self);
}


static void __lambda29_ (Block1Data* _data1_) {
	XnpApplication * self;
	GSList* _tmp0_;
	GtkSeparatorMenuItem* _tmp10_;
	GtkSeparatorMenuItem* mi_sep;
	const gchar* _tmp11_ = NULL;
	GtkImageMenuItem* _tmp12_;
	GtkImageMenuItem* mi_add;
	GtkImage* _tmp13_;
	GtkImage* image;
	self = _data1_->self;
	gtk_container_foreach ((GtkContainer*) _data1_->menu, ___lambda30__gtk_callback, self);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GtkMenuItem* _tmp5_;
				GtkMenuItem* mi;
				GtkMenuItem* _tmp6_;
				XnpWindow* _tmp7_;
				GtkMenuItem* _tmp8_;
				GtkMenuItem* _tmp9_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp4_);
				g_object_ref_sink (_tmp5_);
				mi = _tmp5_;
				_tmp6_ = mi;
				_tmp7_ = win;
				g_object_set_data_full ((GObject*) _tmp6_, "window", (void*) _tmp7_, NULL);
				_tmp8_ = mi;
				g_signal_connect_object (_tmp8_, "activate", (GCallback) _____lambda31__gtk_menu_item_activate, self, 0);
				_tmp9_ = mi;
				gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) _tmp9_);
				_g_object_unref0 (mi);
				_g_object_unref0 (win);
			}
		}
	}
	_tmp10_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp10_);
	mi_sep = _tmp10_;
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) ((GtkMenuItem*) mi_sep));
	_tmp11_ = _ ("_Add a new group");
	_tmp12_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp11_);
	g_object_ref_sink (_tmp12_);
	mi_add = _tmp12_;
	g_signal_connect_object ((GtkMenuItem*) mi_add, "activate", (GCallback) ___lambda32__gtk_menu_item_activate, self, 0);
	_tmp13_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp13_);
	image = _tmp13_;
	gtk_image_menu_item_set_image (mi_add, (GtkWidget*) image);
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) ((GtkMenuItem*) mi_add));
	gtk_widget_show_all ((GtkWidget*) _data1_->menu);
	_g_object_unref0 (image);
	_g_object_unref0 (mi_add);
	_g_object_unref0 (mi_sep);
}


static void ___lambda29__gtk_widget_show (GtkWidget* _sender, gpointer self) {
	__lambda29_ (self);
}


GtkMenu* xnp_application_context_menu (XnpApplication* self) {
	GtkMenu* result = NULL;
	Block1Data* _data1_;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_data1_->menu = _tmp0_;
	g_signal_connect_data ((GtkWidget*) _data1_->menu, "show", (GCallback) ___lambda29__gtk_widget_show, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = _g_object_ref0 (_data1_->menu);
	result = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


const gchar* xnp_application_get_notes_path (XnpApplication* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notes_path;
	result = _tmp0_;
	return result;
}


void xnp_application_set_notes_path (XnpApplication* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_notes_path);
	self->priv->_notes_path = _tmp1_;
	g_object_notify ((GObject *) self, "notes-path");
}


const gchar* xnp_application_get_config_file (XnpApplication* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config_file;
	result = _tmp0_;
	return result;
}


static void xnp_application_set_config_file (XnpApplication* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_config_file);
	self->priv->_config_file = _tmp1_;
	g_object_notify ((GObject *) self, "config-file");
}


static void _xnp_application_quit_xfce_posix_signal_handler_callback (gint signal, gpointer self) {
	xnp_application_quit (self);
}


static void _xnp_application___lambda33_ (XnpApplication* self) {
	xnp_application_update_color (self);
}


static void __xnp_application___lambda33__xfconf_channel_property_changed (XfconfChannel* _sender, const gchar* p0, GValue* p1, gpointer self) {
	_xnp_application___lambda33_ (self);
}


static void _xnp_application___lambda34_ (XnpApplication* self) {
	xnp_application_update_color (self);
}


static void __xnp_application___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_xnp_application___lambda34_ (self);
}


static void _xnp_application___lambda35_ (XnpApplication* self) {
	xnp_application_update_notes_path (self);
}


static void __xnp_application___lambda35__xfconf_channel_property_changed (XfconfChannel* _sender, const gchar* p0, GValue* p1, gpointer self) {
	_xnp_application___lambda35_ (self);
}


static GObject * xnp_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpApplication * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* notesgtkrc;
	const gchar* _tmp2_;
	XfconfChannel* _tmp7_;
	XfconfChannel* _tmp8_;
	GtkSettings* _tmp9_ = NULL;
	const gchar* _tmp10_;
	XfconfChannel* _tmp17_;
	gchar* name = NULL;
	gboolean found;
	gboolean _tmp28_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup_printf ("%s/xfce4/xfce4-notes.gtkrc", _tmp0_);
	notesgtkrc = _tmp1_;
	_tmp2_ = notesgtkrc;
	gtk_rc_parse (_tmp2_);
	{
		xfce_posix_signal_handler_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGTERM, _xnp_application_quit_xfce_posix_signal_handler_callback, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGINT, _xnp_application_quit_xfce_posix_signal_handler_callback, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("application.vala:45: Unable to connect to UNIX signals. %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	{
		xfconf_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == XFCONF_ERROR) {
				goto __catch14_xfconf_error;
			}
			_g_free0 (notesgtkrc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally14;
	__catch14_xfconf_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("application.vala:52: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp7_ = xfconf_channel_new_with_property_base ("xfce4-panel", "/plugins/notes");
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = _tmp7_;
	xnp_application_update_color (self);
	_tmp8_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp8_, "property-changed::/global/background-color", (GCallback) __xnp_application___lambda33__xfconf_channel_property_changed, self, 0);
	_tmp9_ = gtk_settings_get_default ();
	g_signal_connect_object ((GObject*) _tmp9_, "notify::gtk-theme-name", (GCallback) __xnp_application___lambda34__g_object_notify, self, 0);
	_tmp10_ = self->priv->_notes_path;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* default_path;
		XfconfChannel* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp11_ = g_get_user_data_dir ();
		_tmp12_ = g_strdup_printf ("%s/notes", _tmp11_);
		default_path = _tmp12_;
		_tmp13_ = self->priv->xfconf_channel;
		_tmp14_ = default_path;
		_tmp15_ = xfconf_channel_get_string (_tmp13_, "/global/notes-path", _tmp14_);
		_tmp16_ = _tmp15_;
		xnp_application_set_notes_path (self, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (default_path);
	}
	_tmp17_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp17_, "property-changed::/global/notes-path", (GCallback) __xnp_application___lambda35__xfconf_channel_property_changed, self, 0);
	found = FALSE;
	{
		const gchar* _tmp18_;
		GDir* _tmp19_ = NULL;
		GDir* dir;
		_tmp18_ = self->priv->_notes_path;
		_tmp19_ = g_dir_open (_tmp18_, (guint) 0, &_inner_error_);
		dir = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		while (TRUE) {
			GDir* _tmp20_;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			XnpWindow* _tmp25_ = NULL;
			XnpWindow* _tmp26_;
			_tmp20_ = dir;
			_tmp21_ = g_dir_read_name (_tmp20_);
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (name);
			name = _tmp22_;
			_tmp23_ = name;
			if (!(_tmp23_ != NULL)) {
				break;
			}
			_tmp24_ = name;
			_tmp25_ = xnp_application_create_window (self, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_object_unref0 (_tmp26_);
			found = TRUE;
		}
		_g_dir_close0 (dir);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = self->priv->_notes_path;
		g_mkdir_with_parents (_tmp27_, 0700);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_free0 (name);
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp28_ = found;
	if (_tmp28_ == FALSE) {
		XnpWindow* _tmp29_ = NULL;
		XnpWindow* _tmp30_;
		_tmp29_ = xnp_application_create_window (self, NULL);
		_tmp30_ = _tmp29_;
		_g_object_unref0 (_tmp30_);
	}
	_g_free0 (name);
	_g_free0 (notesgtkrc);
	return obj;
}


static void xnp_application_class_init (XnpApplicationClass * klass) {
	xnp_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpApplicationPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_NOTES_PATH, g_param_spec_string ("notes-path", "notes-path", "notes-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_CONFIG_FILE, g_param_spec_string ("config-file", "config-file", "config-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void xnp_application_instance_init (XnpApplication * self) {
	self->priv = XNP_APPLICATION_GET_PRIVATE (self);
}


static void xnp_application_finalize (GObject* obj) {
	XnpApplication * self;
	GSList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	xnp_application_save_windows_configuration (self);
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = NULL;
	xfconf_shutdown ();
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				gtk_object_destroy ((GtkObject*) _tmp2_);
				_g_object_unref0 (win);
				win = NULL;
				_g_object_unref0 (win);
			}
		}
	}
	__g_slist_free__g_object_unref0_0 (self->priv->window_monitor_list);
	__g_slist_free__g_object_unref0_0 (self->priv->window_list);
	_g_free0 (self->priv->_notes_path);
	_g_free0 (self->priv->_config_file);
	_g_object_unref0 (self->priv->xfconf_channel);
	G_OBJECT_CLASS (xnp_application_parent_class)->finalize (obj);
}


GType xnp_application_get_type (void) {
	static volatile gsize xnp_application_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpApplication), 0, (GInstanceInitFunc) xnp_application_instance_init, NULL };
		GType xnp_application_type_id;
		xnp_application_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpApplication", &g_define_type_info, 0);
		g_once_init_leave (&xnp_application_type_id__volatile, xnp_application_type_id);
	}
	return xnp_application_type_id__volatile;
}


static void _vala_xnp_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH:
		g_value_set_string (value, xnp_application_get_notes_path (self));
		break;
		case XNP_APPLICATION_CONFIG_FILE:
		g_value_set_string (value, xnp_application_get_config_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_xnp_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH:
		xnp_application_set_notes_path (self, g_value_get_string (value));
		break;
		case XNP_APPLICATION_CONFIG_FILE:
		xnp_application_set_config_file (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



