// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation;
//
// Software distributed under the License is distributed on an "AS
// IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
// implied. See the License for the specific language governing
// rights and limitations under the License.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _ANALOG_REG_REG_H_
#define _ANALOG_REG_REG_H_

#define SYNTH_SYNTH1_ADDRESS                     0x00000000
#define SYNTH_SYNTH1_OFFSET                      0x00000000
#define SYNTH_SYNTH1_PWD_BIAS_MSB                31
#define SYNTH_SYNTH1_PWD_BIAS_LSB                31
#define SYNTH_SYNTH1_PWD_BIAS_MASK               0x80000000
#define SYNTH_SYNTH1_PWD_BIAS_GET(x)             (((x) & SYNTH_SYNTH1_PWD_BIAS_MASK) >> SYNTH_SYNTH1_PWD_BIAS_LSB)
#define SYNTH_SYNTH1_PWD_BIAS_SET(x)             (((x) << SYNTH_SYNTH1_PWD_BIAS_LSB) & SYNTH_SYNTH1_PWD_BIAS_MASK)
#define SYNTH_SYNTH1_PWD_CP_MSB                  30
#define SYNTH_SYNTH1_PWD_CP_LSB                  30
#define SYNTH_SYNTH1_PWD_CP_MASK                 0x40000000
#define SYNTH_SYNTH1_PWD_CP_GET(x)               (((x) & SYNTH_SYNTH1_PWD_CP_MASK) >> SYNTH_SYNTH1_PWD_CP_LSB)
#define SYNTH_SYNTH1_PWD_CP_SET(x)               (((x) << SYNTH_SYNTH1_PWD_CP_LSB) & SYNTH_SYNTH1_PWD_CP_MASK)
#define SYNTH_SYNTH1_PWD_VCMON_MSB               29
#define SYNTH_SYNTH1_PWD_VCMON_LSB               29
#define SYNTH_SYNTH1_PWD_VCMON_MASK              0x20000000
#define SYNTH_SYNTH1_PWD_VCMON_GET(x)            (((x) & SYNTH_SYNTH1_PWD_VCMON_MASK) >> SYNTH_SYNTH1_PWD_VCMON_LSB)
#define SYNTH_SYNTH1_PWD_VCMON_SET(x)            (((x) << SYNTH_SYNTH1_PWD_VCMON_LSB) & SYNTH_SYNTH1_PWD_VCMON_MASK)
#define SYNTH_SYNTH1_PWD_VCO_MSB                 28
#define SYNTH_SYNTH1_PWD_VCO_LSB                 28
#define SYNTH_SYNTH1_PWD_VCO_MASK                0x10000000
#define SYNTH_SYNTH1_PWD_VCO_GET(x)              (((x) & SYNTH_SYNTH1_PWD_VCO_MASK) >> SYNTH_SYNTH1_PWD_VCO_LSB)
#define SYNTH_SYNTH1_PWD_VCO_SET(x)              (((x) << SYNTH_SYNTH1_PWD_VCO_LSB) & SYNTH_SYNTH1_PWD_VCO_MASK)
#define SYNTH_SYNTH1_PWD_PRESC_MSB               27
#define SYNTH_SYNTH1_PWD_PRESC_LSB               27
#define SYNTH_SYNTH1_PWD_PRESC_MASK              0x08000000
#define SYNTH_SYNTH1_PWD_PRESC_GET(x)            (((x) & SYNTH_SYNTH1_PWD_PRESC_MASK) >> SYNTH_SYNTH1_PWD_PRESC_LSB)
#define SYNTH_SYNTH1_PWD_PRESC_SET(x)            (((x) << SYNTH_SYNTH1_PWD_PRESC_LSB) & SYNTH_SYNTH1_PWD_PRESC_MASK)
#define SYNTH_SYNTH1_PWD_LODIV_MSB               26
#define SYNTH_SYNTH1_PWD_LODIV_LSB               26
#define SYNTH_SYNTH1_PWD_LODIV_MASK              0x04000000
#define SYNTH_SYNTH1_PWD_LODIV_GET(x)            (((x) & SYNTH_SYNTH1_PWD_LODIV_MASK) >> SYNTH_SYNTH1_PWD_LODIV_LSB)
#define SYNTH_SYNTH1_PWD_LODIV_SET(x)            (((x) << SYNTH_SYNTH1_PWD_LODIV_LSB) & SYNTH_SYNTH1_PWD_LODIV_MASK)
#define SYNTH_SYNTH1_PWD_LOMIX_MSB               25
#define SYNTH_SYNTH1_PWD_LOMIX_LSB               25
#define SYNTH_SYNTH1_PWD_LOMIX_MASK              0x02000000
#define SYNTH_SYNTH1_PWD_LOMIX_GET(x)            (((x) & SYNTH_SYNTH1_PWD_LOMIX_MASK) >> SYNTH_SYNTH1_PWD_LOMIX_LSB)
#define SYNTH_SYNTH1_PWD_LOMIX_SET(x)            (((x) << SYNTH_SYNTH1_PWD_LOMIX_LSB) & SYNTH_SYNTH1_PWD_LOMIX_MASK)
#define SYNTH_SYNTH1_FORCE_LO_ON_MSB             24
#define SYNTH_SYNTH1_FORCE_LO_ON_LSB             24
#define SYNTH_SYNTH1_FORCE_LO_ON_MASK            0x01000000
#define SYNTH_SYNTH1_FORCE_LO_ON_GET(x)          (((x) & SYNTH_SYNTH1_FORCE_LO_ON_MASK) >> SYNTH_SYNTH1_FORCE_LO_ON_LSB)
#define SYNTH_SYNTH1_FORCE_LO_ON_SET(x)          (((x) << SYNTH_SYNTH1_FORCE_LO_ON_LSB) & SYNTH_SYNTH1_FORCE_LO_ON_MASK)
#define SYNTH_SYNTH1_PWD_LOBUF5G_MSB             23
#define SYNTH_SYNTH1_PWD_LOBUF5G_LSB             23
#define SYNTH_SYNTH1_PWD_LOBUF5G_MASK            0x00800000
#define SYNTH_SYNTH1_PWD_LOBUF5G_GET(x)          (((x) & SYNTH_SYNTH1_PWD_LOBUF5G_MASK) >> SYNTH_SYNTH1_PWD_LOBUF5G_LSB)
#define SYNTH_SYNTH1_PWD_LOBUF5G_SET(x)          (((x) << SYNTH_SYNTH1_PWD_LOBUF5G_LSB) & SYNTH_SYNTH1_PWD_LOBUF5G_MASK)
#define SYNTH_SYNTH1_VCOREGBYPASS_MSB            22
#define SYNTH_SYNTH1_VCOREGBYPASS_LSB            22
#define SYNTH_SYNTH1_VCOREGBYPASS_MASK           0x00400000
#define SYNTH_SYNTH1_VCOREGBYPASS_GET(x)         (((x) & SYNTH_SYNTH1_VCOREGBYPASS_MASK) >> SYNTH_SYNTH1_VCOREGBYPASS_LSB)
#define SYNTH_SYNTH1_VCOREGBYPASS_SET(x)         (((x) << SYNTH_SYNTH1_VCOREGBYPASS_LSB) & SYNTH_SYNTH1_VCOREGBYPASS_MASK)
#define SYNTH_SYNTH1_VCOREGLEVEL_MSB             21
#define SYNTH_SYNTH1_VCOREGLEVEL_LSB             20
#define SYNTH_SYNTH1_VCOREGLEVEL_MASK            0x00300000
#define SYNTH_SYNTH1_VCOREGLEVEL_GET(x)          (((x) & SYNTH_SYNTH1_VCOREGLEVEL_MASK) >> SYNTH_SYNTH1_VCOREGLEVEL_LSB)
#define SYNTH_SYNTH1_VCOREGLEVEL_SET(x)          (((x) << SYNTH_SYNTH1_VCOREGLEVEL_LSB) & SYNTH_SYNTH1_VCOREGLEVEL_MASK)
#define SYNTH_SYNTH1_VCOREGBIAS_MSB              19
#define SYNTH_SYNTH1_VCOREGBIAS_LSB              18
#define SYNTH_SYNTH1_VCOREGBIAS_MASK             0x000c0000
#define SYNTH_SYNTH1_VCOREGBIAS_GET(x)           (((x) & SYNTH_SYNTH1_VCOREGBIAS_MASK) >> SYNTH_SYNTH1_VCOREGBIAS_LSB)
#define SYNTH_SYNTH1_VCOREGBIAS_SET(x)           (((x) << SYNTH_SYNTH1_VCOREGBIAS_LSB) & SYNTH_SYNTH1_VCOREGBIAS_MASK)
#define SYNTH_SYNTH1_SLIDINGIF_MSB               17
#define SYNTH_SYNTH1_SLIDINGIF_LSB               17
#define SYNTH_SYNTH1_SLIDINGIF_MASK              0x00020000
#define SYNTH_SYNTH1_SLIDINGIF_GET(x)            (((x) & SYNTH_SYNTH1_SLIDINGIF_MASK) >> SYNTH_SYNTH1_SLIDINGIF_LSB)
#define SYNTH_SYNTH1_SLIDINGIF_SET(x)            (((x) << SYNTH_SYNTH1_SLIDINGIF_LSB) & SYNTH_SYNTH1_SLIDINGIF_MASK)
#define SYNTH_SYNTH1_SPARE_PWD_MSB               16
#define SYNTH_SYNTH1_SPARE_PWD_LSB               16
#define SYNTH_SYNTH1_SPARE_PWD_MASK              0x00010000
#define SYNTH_SYNTH1_SPARE_PWD_GET(x)            (((x) & SYNTH_SYNTH1_SPARE_PWD_MASK) >> SYNTH_SYNTH1_SPARE_PWD_LSB)
#define SYNTH_SYNTH1_SPARE_PWD_SET(x)            (((x) << SYNTH_SYNTH1_SPARE_PWD_LSB) & SYNTH_SYNTH1_SPARE_PWD_MASK)
#define SYNTH_SYNTH1_CON_VDDVCOREG_MSB           15
#define SYNTH_SYNTH1_CON_VDDVCOREG_LSB           15
#define SYNTH_SYNTH1_CON_VDDVCOREG_MASK          0x00008000
#define SYNTH_SYNTH1_CON_VDDVCOREG_GET(x)        (((x) & SYNTH_SYNTH1_CON_VDDVCOREG_MASK) >> SYNTH_SYNTH1_CON_VDDVCOREG_LSB)
#define SYNTH_SYNTH1_CON_VDDVCOREG_SET(x)        (((x) << SYNTH_SYNTH1_CON_VDDVCOREG_LSB) & SYNTH_SYNTH1_CON_VDDVCOREG_MASK)
#define SYNTH_SYNTH1_CON_IVCOREG_MSB             14
#define SYNTH_SYNTH1_CON_IVCOREG_LSB             14
#define SYNTH_SYNTH1_CON_IVCOREG_MASK            0x00004000
#define SYNTH_SYNTH1_CON_IVCOREG_GET(x)          (((x) & SYNTH_SYNTH1_CON_IVCOREG_MASK) >> SYNTH_SYNTH1_CON_IVCOREG_LSB)
#define SYNTH_SYNTH1_CON_IVCOREG_SET(x)          (((x) << SYNTH_SYNTH1_CON_IVCOREG_LSB) & SYNTH_SYNTH1_CON_IVCOREG_MASK)
#define SYNTH_SYNTH1_CON_IVCOBUF_MSB             13
#define SYNTH_SYNTH1_CON_IVCOBUF_LSB             13
#define SYNTH_SYNTH1_CON_IVCOBUF_MASK            0x00002000
#define SYNTH_SYNTH1_CON_IVCOBUF_GET(x)          (((x) & SYNTH_SYNTH1_CON_IVCOBUF_MASK) >> SYNTH_SYNTH1_CON_IVCOBUF_LSB)
#define SYNTH_SYNTH1_CON_IVCOBUF_SET(x)          (((x) << SYNTH_SYNTH1_CON_IVCOBUF_LSB) & SYNTH_SYNTH1_CON_IVCOBUF_MASK)
#define SYNTH_SYNTH1_SEL_VCMONABUS_MSB           12
#define SYNTH_SYNTH1_SEL_VCMONABUS_LSB           10
#define SYNTH_SYNTH1_SEL_VCMONABUS_MASK          0x00001c00
#define SYNTH_SYNTH1_SEL_VCMONABUS_GET(x)        (((x) & SYNTH_SYNTH1_SEL_VCMONABUS_MASK) >> SYNTH_SYNTH1_SEL_VCMONABUS_LSB)
#define SYNTH_SYNTH1_SEL_VCMONABUS_SET(x)        (((x) << SYNTH_SYNTH1_SEL_VCMONABUS_LSB) & SYNTH_SYNTH1_SEL_VCMONABUS_MASK)
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_MSB          9
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB          9
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK         0x00000200
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_GET(x)       (((x) & SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK) >> SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB)
#define SYNTH_SYNTH1_PWUP_VCOBUF_PD_SET(x)       (((x) << SYNTH_SYNTH1_PWUP_VCOBUF_PD_LSB) & SYNTH_SYNTH1_PWUP_VCOBUF_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LODIV_PD_MSB           8
#define SYNTH_SYNTH1_PWUP_LODIV_PD_LSB           8
#define SYNTH_SYNTH1_PWUP_LODIV_PD_MASK          0x00000100
#define SYNTH_SYNTH1_PWUP_LODIV_PD_GET(x)        (((x) & SYNTH_SYNTH1_PWUP_LODIV_PD_MASK) >> SYNTH_SYNTH1_PWUP_LODIV_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LODIV_PD_SET(x)        (((x) << SYNTH_SYNTH1_PWUP_LODIV_PD_LSB) & SYNTH_SYNTH1_PWUP_LODIV_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_MSB           7
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB           7
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK          0x00000080
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_GET(x)        (((x) & SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK) >> SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LOMIX_PD_SET(x)        (((x) << SYNTH_SYNTH1_PWUP_LOMIX_PD_LSB) & SYNTH_SYNTH1_PWUP_LOMIX_PD_MASK)
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MSB         6
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB         6
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK        0x00000040
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_GET(x)      (((x) & SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK) >> SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB)
#define SYNTH_SYNTH1_PWUP_LOBUF5G_PD_SET(x)      (((x) << SYNTH_SYNTH1_PWUP_LOBUF5G_PD_LSB) & SYNTH_SYNTH1_PWUP_LOBUF5G_PD_MASK)
#define SYNTH_SYNTH1_MONITOR_FB_MSB              5
#define SYNTH_SYNTH1_MONITOR_FB_LSB              5
#define SYNTH_SYNTH1_MONITOR_FB_MASK             0x00000020
#define SYNTH_SYNTH1_MONITOR_FB_GET(x)           (((x) & SYNTH_SYNTH1_MONITOR_FB_MASK) >> SYNTH_SYNTH1_MONITOR_FB_LSB)
#define SYNTH_SYNTH1_MONITOR_FB_SET(x)           (((x) << SYNTH_SYNTH1_MONITOR_FB_LSB) & SYNTH_SYNTH1_MONITOR_FB_MASK)
#define SYNTH_SYNTH1_MONITOR_REF_MSB             4
#define SYNTH_SYNTH1_MONITOR_REF_LSB             4
#define SYNTH_SYNTH1_MONITOR_REF_MASK            0x00000010
#define SYNTH_SYNTH1_MONITOR_REF_GET(x)          (((x) & SYNTH_SYNTH1_MONITOR_REF_MASK) >> SYNTH_SYNTH1_MONITOR_REF_LSB)
#define SYNTH_SYNTH1_MONITOR_REF_SET(x)          (((x) << SYNTH_SYNTH1_MONITOR_REF_LSB) & SYNTH_SYNTH1_MONITOR_REF_MASK)
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_MSB         3
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB         3
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK        0x00000008
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_GET(x)      (((x) & SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK) >> SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB)
#define SYNTH_SYNTH1_MONITOR_FB_DIV2_SET(x)      (((x) << SYNTH_SYNTH1_MONITOR_FB_DIV2_LSB) & SYNTH_SYNTH1_MONITOR_FB_DIV2_MASK)
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_MSB         2
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB         2
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK        0x00000004
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_GET(x)      (((x) & SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK) >> SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB)
#define SYNTH_SYNTH1_MONITOR_VC2HIGH_SET(x)      (((x) << SYNTH_SYNTH1_MONITOR_VC2HIGH_LSB) & SYNTH_SYNTH1_MONITOR_VC2HIGH_MASK)
#define SYNTH_SYNTH1_MONITOR_VC2LOW_MSB          1
#define SYNTH_SYNTH1_MONITOR_VC2LOW_LSB          1
#define SYNTH_SYNTH1_MONITOR_VC2LOW_MASK         0x00000002
#define SYNTH_SYNTH1_MONITOR_VC2LOW_GET(x)       (((x) & SYNTH_SYNTH1_MONITOR_VC2LOW_MASK) >> SYNTH_SYNTH1_MONITOR_VC2LOW_LSB)
#define SYNTH_SYNTH1_MONITOR_VC2LOW_SET(x)       (((x) << SYNTH_SYNTH1_MONITOR_VC2LOW_LSB) & SYNTH_SYNTH1_MONITOR_VC2LOW_MASK)
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MSB   0
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB   0
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK  0x00000001
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_GET(x) (((x) & SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK) >> SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB)
#define SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_SET(x) (((x) << SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_LSB) & SYNTH_SYNTH1_MONITOR_SYNTHLOCKVCOK_MASK)

#define SYNTH_SYNTH2_ADDRESS                     0x00000004
#define SYNTH_SYNTH2_OFFSET                      0x00000004
#define SYNTH_SYNTH2_VC_CAL_REF_MSB              31
#define SYNTH_SYNTH2_VC_CAL_REF_LSB              29
#define SYNTH_SYNTH2_VC_CAL_REF_MASK             0xe0000000
#define SYNTH_SYNTH2_VC_CAL_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_CAL_REF_MASK) >> SYNTH_SYNTH2_VC_CAL_REF_LSB)
#define SYNTH_SYNTH2_VC_CAL_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_CAL_REF_LSB) & SYNTH_SYNTH2_VC_CAL_REF_MASK)
#define SYNTH_SYNTH2_VC_HI_REF_MSB               28
#define SYNTH_SYNTH2_VC_HI_REF_LSB               26
#define SYNTH_SYNTH2_VC_HI_REF_MASK              0x1c000000
#define SYNTH_SYNTH2_VC_HI_REF_GET(x)            (((x) & SYNTH_SYNTH2_VC_HI_REF_MASK) >> SYNTH_SYNTH2_VC_HI_REF_LSB)
#define SYNTH_SYNTH2_VC_HI_REF_SET(x)            (((x) << SYNTH_SYNTH2_VC_HI_REF_LSB) & SYNTH_SYNTH2_VC_HI_REF_MASK)
#define SYNTH_SYNTH2_VC_MID_REF_MSB              25
#define SYNTH_SYNTH2_VC_MID_REF_LSB              23
#define SYNTH_SYNTH2_VC_MID_REF_MASK             0x03800000
#define SYNTH_SYNTH2_VC_MID_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_MID_REF_MASK) >> SYNTH_SYNTH2_VC_MID_REF_LSB)
#define SYNTH_SYNTH2_VC_MID_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_MID_REF_LSB) & SYNTH_SYNTH2_VC_MID_REF_MASK)
#define SYNTH_SYNTH2_VC_LOW_REF_MSB              22
#define SYNTH_SYNTH2_VC_LOW_REF_LSB              20
#define SYNTH_SYNTH2_VC_LOW_REF_MASK             0x00700000
#define SYNTH_SYNTH2_VC_LOW_REF_GET(x)           (((x) & SYNTH_SYNTH2_VC_LOW_REF_MASK) >> SYNTH_SYNTH2_VC_LOW_REF_LSB)
#define SYNTH_SYNTH2_VC_LOW_REF_SET(x)           (((x) << SYNTH_SYNTH2_VC_LOW_REF_LSB) & SYNTH_SYNTH2_VC_LOW_REF_MASK)
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MSB        19
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB        15
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK       0x000f8000
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_GET(x)     (((x) & SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK) >> SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB)
#define SYNTH_SYNTH2_LOOP_3RD_ORDER_R_SET(x)     (((x) << SYNTH_SYNTH2_LOOP_3RD_ORDER_R_LSB) & SYNTH_SYNTH2_LOOP_3RD_ORDER_R_MASK)
#define SYNTH_SYNTH2_LOOP_CP_MSB                 14
#define SYNTH_SYNTH2_LOOP_CP_LSB                 10
#define SYNTH_SYNTH2_LOOP_CP_MASK                0x00007c00
#define SYNTH_SYNTH2_LOOP_CP_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_CP_MASK) >> SYNTH_SYNTH2_LOOP_CP_LSB)
#define SYNTH_SYNTH2_LOOP_CP_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_CP_LSB) & SYNTH_SYNTH2_LOOP_CP_MASK)
#define SYNTH_SYNTH2_LOOP_RS_MSB                 9
#define SYNTH_SYNTH2_LOOP_RS_LSB                 5
#define SYNTH_SYNTH2_LOOP_RS_MASK                0x000003e0
#define SYNTH_SYNTH2_LOOP_RS_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_RS_MASK) >> SYNTH_SYNTH2_LOOP_RS_LSB)
#define SYNTH_SYNTH2_LOOP_RS_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_RS_LSB) & SYNTH_SYNTH2_LOOP_RS_MASK)
#define SYNTH_SYNTH2_LOOP_CS_MSB                 4
#define SYNTH_SYNTH2_LOOP_CS_LSB                 3
#define SYNTH_SYNTH2_LOOP_CS_MASK                0x00000018
#define SYNTH_SYNTH2_LOOP_CS_GET(x)              (((x) & SYNTH_SYNTH2_LOOP_CS_MASK) >> SYNTH_SYNTH2_LOOP_CS_LSB)
#define SYNTH_SYNTH2_LOOP_CS_SET(x)              (((x) << SYNTH_SYNTH2_LOOP_CS_LSB) & SYNTH_SYNTH2_LOOP_CS_MASK)
#define SYNTH_SYNTH2_SPARE_BITS_MSB              2
#define SYNTH_SYNTH2_SPARE_BITS_LSB              0
#define SYNTH_SYNTH2_SPARE_BITS_MASK             0x00000007
#define SYNTH_SYNTH2_SPARE_BITS_GET(x)           (((x) & SYNTH_SYNTH2_SPARE_BITS_MASK) >> SYNTH_SYNTH2_SPARE_BITS_LSB)
#define SYNTH_SYNTH2_SPARE_BITS_SET(x)           (((x) << SYNTH_SYNTH2_SPARE_BITS_LSB) & SYNTH_SYNTH2_SPARE_BITS_MASK)

#define SYNTH_SYNTH3_ADDRESS                     0x00000008
#define SYNTH_SYNTH3_OFFSET                      0x00000008
#define SYNTH_SYNTH3_DIS_CLK_XTAL_MSB            31
#define SYNTH_SYNTH3_DIS_CLK_XTAL_LSB            31
#define SYNTH_SYNTH3_DIS_CLK_XTAL_MASK           0x80000000
#define SYNTH_SYNTH3_DIS_CLK_XTAL_GET(x)         (((x) & SYNTH_SYNTH3_DIS_CLK_XTAL_MASK) >> SYNTH_SYNTH3_DIS_CLK_XTAL_LSB)
#define SYNTH_SYNTH3_DIS_CLK_XTAL_SET(x)         (((x) << SYNTH_SYNTH3_DIS_CLK_XTAL_LSB) & SYNTH_SYNTH3_DIS_CLK_XTAL_MASK)
#define SYNTH_SYNTH3_SEL_CLK_DIV2_MSB            30
#define SYNTH_SYNTH3_SEL_CLK_DIV2_LSB            30
#define SYNTH_SYNTH3_SEL_CLK_DIV2_MASK           0x40000000
#define SYNTH_SYNTH3_SEL_CLK_DIV2_GET(x)         (((x) & SYNTH_SYNTH3_SEL_CLK_DIV2_MASK) >> SYNTH_SYNTH3_SEL_CLK_DIV2_LSB)
#define SYNTH_SYNTH3_SEL_CLK_DIV2_SET(x)         (((x) << SYNTH_SYNTH3_SEL_CLK_DIV2_LSB) & SYNTH_SYNTH3_SEL_CLK_DIV2_MASK)
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MSB       29
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB       24
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK      0x3f000000
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_GET(x)    (((x) & SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK) >> SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB)
#define SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_SET(x)    (((x) << SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_LSB) & SYNTH_SYNTH3_WAIT_SHORTR_PWRUP_MASK)
#define SYNTH_SYNTH3_WAIT_PWRUP_MSB              23
#define SYNTH_SYNTH3_WAIT_PWRUP_LSB              18
#define SYNTH_SYNTH3_WAIT_PWRUP_MASK             0x00fc0000
#define SYNTH_SYNTH3_WAIT_PWRUP_GET(x)           (((x) & SYNTH_SYNTH3_WAIT_PWRUP_MASK) >> SYNTH_SYNTH3_WAIT_PWRUP_LSB)
#define SYNTH_SYNTH3_WAIT_PWRUP_SET(x)           (((x) << SYNTH_SYNTH3_WAIT_PWRUP_LSB) & SYNTH_SYNTH3_WAIT_PWRUP_MASK)
#define SYNTH_SYNTH3_WAIT_CAL_BIN_MSB            17
#define SYNTH_SYNTH3_WAIT_CAL_BIN_LSB            12
#define SYNTH_SYNTH3_WAIT_CAL_BIN_MASK           0x0003f000
#define SYNTH_SYNTH3_WAIT_CAL_BIN_GET(x)         (((x) & SYNTH_SYNTH3_WAIT_CAL_BIN_MASK) >> SYNTH_SYNTH3_WAIT_CAL_BIN_LSB)
#define SYNTH_SYNTH3_WAIT_CAL_BIN_SET(x)         (((x) << SYNTH_SYNTH3_WAIT_CAL_BIN_LSB) & SYNTH_SYNTH3_WAIT_CAL_BIN_MASK)
#define SYNTH_SYNTH3_WAIT_CAL_LIN_MSB            11
#define SYNTH_SYNTH3_WAIT_CAL_LIN_LSB            6
#define SYNTH_SYNTH3_WAIT_CAL_LIN_MASK           0x00000fc0
#define SYNTH_SYNTH3_WAIT_CAL_LIN_GET(x)         (((x) & SYNTH_SYNTH3_WAIT_CAL_LIN_MASK) >> SYNTH_SYNTH3_WAIT_CAL_LIN_LSB)
#define SYNTH_SYNTH3_WAIT_CAL_LIN_SET(x)         (((x) << SYNTH_SYNTH3_WAIT_CAL_LIN_LSB) & SYNTH_SYNTH3_WAIT_CAL_LIN_MASK)
#define SYNTH_SYNTH3_WAIT_VC_CHECK_MSB           5
#define SYNTH_SYNTH3_WAIT_VC_CHECK_LSB           0
#define SYNTH_SYNTH3_WAIT_VC_CHECK_MASK          0x0000003f
#define SYNTH_SYNTH3_WAIT_VC_CHECK_GET(x)        (((x) & SYNTH_SYNTH3_WAIT_VC_CHECK_MASK) >> SYNTH_SYNTH3_WAIT_VC_CHECK_LSB)
#define SYNTH_SYNTH3_WAIT_VC_CHECK_SET(x)        (((x) << SYNTH_SYNTH3_WAIT_VC_CHECK_LSB) & SYNTH_SYNTH3_WAIT_VC_CHECK_MASK)

#define SYNTH_SYNTH4_ADDRESS                     0x0000000c
#define SYNTH_SYNTH4_OFFSET                      0x0000000c
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MSB       31
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB       31
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK      0x80000000
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_GET(x)    (((x) & SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK) >> SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB)
#define SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_SET(x)    (((x) << SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_LSB) & SYNTH_SYNTH4_DIS_LIN_CAPSEARCH_MASK)
#define SYNTH_SYNTH4_DIS_LOSTVC_MSB              30
#define SYNTH_SYNTH4_DIS_LOSTVC_LSB              30
#define SYNTH_SYNTH4_DIS_LOSTVC_MASK             0x40000000
#define SYNTH_SYNTH4_DIS_LOSTVC_GET(x)           (((x) & SYNTH_SYNTH4_DIS_LOSTVC_MASK) >> SYNTH_SYNTH4_DIS_LOSTVC_LSB)
#define SYNTH_SYNTH4_DIS_LOSTVC_SET(x)           (((x) << SYNTH_SYNTH4_DIS_LOSTVC_LSB) & SYNTH_SYNTH4_DIS_LOSTVC_MASK)
#define SYNTH_SYNTH4_ALWAYS_SHORTR_MSB           29
#define SYNTH_SYNTH4_ALWAYS_SHORTR_LSB           29
#define SYNTH_SYNTH4_ALWAYS_SHORTR_MASK          0x20000000
#define SYNTH_SYNTH4_ALWAYS_SHORTR_GET(x)        (((x) & SYNTH_SYNTH4_ALWAYS_SHORTR_MASK) >> SYNTH_SYNTH4_ALWAYS_SHORTR_LSB)
#define SYNTH_SYNTH4_ALWAYS_SHORTR_SET(x)        (((x) << SYNTH_SYNTH4_ALWAYS_SHORTR_LSB) & SYNTH_SYNTH4_ALWAYS_SHORTR_MASK)
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MSB     28
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB     28
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK    0x10000000
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_GET(x)  (((x) & SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK) >> SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB)
#define SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_SET(x)  (((x) << SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_LSB) & SYNTH_SYNTH4_SHORTR_UNTIL_LOCKED_MASK)
#define SYNTH_SYNTH4_FORCE_PINVC_MSB             27
#define SYNTH_SYNTH4_FORCE_PINVC_LSB             27
#define SYNTH_SYNTH4_FORCE_PINVC_MASK            0x08000000
#define SYNTH_SYNTH4_FORCE_PINVC_GET(x)          (((x) & SYNTH_SYNTH4_FORCE_PINVC_MASK) >> SYNTH_SYNTH4_FORCE_PINVC_LSB)
#define SYNTH_SYNTH4_FORCE_PINVC_SET(x)          (((x) << SYNTH_SYNTH4_FORCE_PINVC_LSB) & SYNTH_SYNTH4_FORCE_PINVC_MASK)
#define SYNTH_SYNTH4_FORCE_VCOCAP_MSB            26
#define SYNTH_SYNTH4_FORCE_VCOCAP_LSB            26
#define SYNTH_SYNTH4_FORCE_VCOCAP_MASK           0x04000000
#define SYNTH_SYNTH4_FORCE_VCOCAP_GET(x)         (((x) & SYNTH_SYNTH4_FORCE_VCOCAP_MASK) >> SYNTH_SYNTH4_FORCE_VCOCAP_LSB)
#define SYNTH_SYNTH4_FORCE_VCOCAP_SET(x)         (((x) << SYNTH_SYNTH4_FORCE_VCOCAP_LSB) & SYNTH_SYNTH4_FORCE_VCOCAP_MASK)
#define SYNTH_SYNTH4_VCOCAP_OVR_MSB              25
#define SYNTH_SYNTH4_VCOCAP_OVR_LSB              18
#define SYNTH_SYNTH4_VCOCAP_OVR_MASK             0x03fc0000
#define SYNTH_SYNTH4_VCOCAP_OVR_GET(x)           (((x) & SYNTH_SYNTH4_VCOCAP_OVR_MASK) >> SYNTH_SYNTH4_VCOCAP_OVR_LSB)
#define SYNTH_SYNTH4_VCOCAP_OVR_SET(x)           (((x) << SYNTH_SYNTH4_VCOCAP_OVR_LSB) & SYNTH_SYNTH4_VCOCAP_OVR_MASK)
#define SYNTH_SYNTH4_VCOCAPPULLUP_MSB            17
#define SYNTH_SYNTH4_VCOCAPPULLUP_LSB            17
#define SYNTH_SYNTH4_VCOCAPPULLUP_MASK           0x00020000
#define SYNTH_SYNTH4_VCOCAPPULLUP_GET(x)         (((x) & SYNTH_SYNTH4_VCOCAPPULLUP_MASK) >> SYNTH_SYNTH4_VCOCAPPULLUP_LSB)
#define SYNTH_SYNTH4_VCOCAPPULLUP_SET(x)         (((x) << SYNTH_SYNTH4_VCOCAPPULLUP_LSB) & SYNTH_SYNTH4_VCOCAPPULLUP_MASK)
#define SYNTH_SYNTH4_REFDIVSEL_MSB               16
#define SYNTH_SYNTH4_REFDIVSEL_LSB               15
#define SYNTH_SYNTH4_REFDIVSEL_MASK              0x00018000
#define SYNTH_SYNTH4_REFDIVSEL_GET(x)            (((x) & SYNTH_SYNTH4_REFDIVSEL_MASK) >> SYNTH_SYNTH4_REFDIVSEL_LSB)
#define SYNTH_SYNTH4_REFDIVSEL_SET(x)            (((x) << SYNTH_SYNTH4_REFDIVSEL_LSB) & SYNTH_SYNTH4_REFDIVSEL_MASK)
#define SYNTH_SYNTH4_PFDDELAY_MSB                14
#define SYNTH_SYNTH4_PFDDELAY_LSB                14
#define SYNTH_SYNTH4_PFDDELAY_MASK               0x00004000
#define SYNTH_SYNTH4_PFDDELAY_GET(x)             (((x) & SYNTH_SYNTH4_PFDDELAY_MASK) >> SYNTH_SYNTH4_PFDDELAY_LSB)
#define SYNTH_SYNTH4_PFDDELAY_SET(x)             (((x) << SYNTH_SYNTH4_PFDDELAY_LSB) & SYNTH_SYNTH4_PFDDELAY_MASK)
#define SYNTH_SYNTH4_PFD_DISABLE_MSB             13
#define SYNTH_SYNTH4_PFD_DISABLE_LSB             13
#define SYNTH_SYNTH4_PFD_DISABLE_MASK            0x00002000
#define SYNTH_SYNTH4_PFD_DISABLE_GET(x)          (((x) & SYNTH_SYNTH4_PFD_DISABLE_MASK) >> SYNTH_SYNTH4_PFD_DISABLE_LSB)
#define SYNTH_SYNTH4_PFD_DISABLE_SET(x)          (((x) << SYNTH_SYNTH4_PFD_DISABLE_LSB) & SYNTH_SYNTH4_PFD_DISABLE_MASK)
#define SYNTH_SYNTH4_PRESCSEL_MSB                12
#define SYNTH_SYNTH4_PRESCSEL_LSB                11
#define SYNTH_SYNTH4_PRESCSEL_MASK               0x00001800
#define SYNTH_SYNTH4_PRESCSEL_GET(x)             (((x) & SYNTH_SYNTH4_PRESCSEL_MASK) >> SYNTH_SYNTH4_PRESCSEL_LSB)
#define SYNTH_SYNTH4_PRESCSEL_SET(x)             (((x) << SYNTH_SYNTH4_PRESCSEL_LSB) & SYNTH_SYNTH4_PRESCSEL_MASK)
#define SYNTH_SYNTH4_RESET_PRESC_MSB             10
#define SYNTH_SYNTH4_RESET_PRESC_LSB             10
#define SYNTH_SYNTH4_RESET_PRESC_MASK            0x00000400
#define SYNTH_SYNTH4_RESET_PRESC_GET(x)          (((x) & SYNTH_SYNTH4_RESET_PRESC_MASK) >> SYNTH_SYNTH4_RESET_PRESC_LSB)
#define SYNTH_SYNTH4_RESET_PRESC_SET(x)          (((x) << SYNTH_SYNTH4_RESET_PRESC_LSB) & SYNTH_SYNTH4_RESET_PRESC_MASK)
#define SYNTH_SYNTH4_SDM_DISABLE_MSB             9
#define SYNTH_SYNTH4_SDM_DISABLE_LSB             9
#define SYNTH_SYNTH4_SDM_DISABLE_MASK            0x00000200
#define SYNTH_SYNTH4_SDM_DISABLE_GET(x)          (((x) & SYNTH_SYNTH4_SDM_DISABLE_MASK) >> SYNTH_SYNTH4_SDM_DISABLE_LSB)
#define SYNTH_SYNTH4_SDM_DISABLE_SET(x)          (((x) << SYNTH_SYNTH4_SDM_DISABLE_LSB) & SYNTH_SYNTH4_SDM_DISABLE_MASK)
#define SYNTH_SYNTH4_SDM_MODE_MSB                8
#define SYNTH_SYNTH4_SDM_MODE_LSB                8
#define SYNTH_SYNTH4_SDM_MODE_MASK               0x00000100
#define SYNTH_SYNTH4_SDM_MODE_GET(x)             (((x) & SYNTH_SYNTH4_SDM_MODE_MASK) >> SYNTH_SYNTH4_SDM_MODE_LSB)
#define SYNTH_SYNTH4_SDM_MODE_SET(x)             (((x) << SYNTH_SYNTH4_SDM_MODE_LSB) & SYNTH_SYNTH4_SDM_MODE_MASK)
#define SYNTH_SYNTH4_SDM_DITHER_MSB              7
#define SYNTH_SYNTH4_SDM_DITHER_LSB              6
#define SYNTH_SYNTH4_SDM_DITHER_MASK             0x000000c0
#define SYNTH_SYNTH4_SDM_DITHER_GET(x)           (((x) & SYNTH_SYNTH4_SDM_DITHER_MASK) >> SYNTH_SYNTH4_SDM_DITHER_LSB)
#define SYNTH_SYNTH4_SDM_DITHER_SET(x)           (((x) << SYNTH_SYNTH4_SDM_DITHER_LSB) & SYNTH_SYNTH4_SDM_DITHER_MASK)
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_MSB           5
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB           5
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK          0x00000020
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_GET(x)        (((x) & SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK) >> SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB)
#define SYNTH_SYNTH4_PSCOUNT_FBSEL_SET(x)        (((x) << SYNTH_SYNTH4_PSCOUNT_FBSEL_LSB) & SYNTH_SYNTH4_PSCOUNT_FBSEL_MASK)
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MSB        4
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB        4
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK       0x00000010
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_GET(x)     (((x) & SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK) >> SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB)
#define SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_SET(x)     (((x) << SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_LSB) & SYNTH_SYNTH4_SEL_CLKXTAL_EDGE_MASK)
#define SYNTH_SYNTH4_SPARE_MISC_MSB              3
#define SYNTH_SYNTH4_SPARE_MISC_LSB              2
#define SYNTH_SYNTH4_SPARE_MISC_MASK             0x0000000c
#define SYNTH_SYNTH4_SPARE_MISC_GET(x)           (((x) & SYNTH_SYNTH4_SPARE_MISC_MASK) >> SYNTH_SYNTH4_SPARE_MISC_LSB)
#define SYNTH_SYNTH4_SPARE_MISC_SET(x)           (((x) << SYNTH_SYNTH4_SPARE_MISC_LSB) & SYNTH_SYNTH4_SPARE_MISC_MASK)
#define SYNTH_SYNTH4_LONGSHIFTSEL_MSB            1
#define SYNTH_SYNTH4_LONGSHIFTSEL_LSB            1
#define SYNTH_SYNTH4_LONGSHIFTSEL_MASK           0x00000002
#define SYNTH_SYNTH4_LONGSHIFTSEL_GET(x)         (((x) & SYNTH_SYNTH4_LONGSHIFTSEL_MASK) >> SYNTH_SYNTH4_LONGSHIFTSEL_LSB)
#define SYNTH_SYNTH4_LONGSHIFTSEL_SET(x)         (((x) << SYNTH_SYNTH4_LONGSHIFTSEL_LSB) & SYNTH_SYNTH4_LONGSHIFTSEL_MASK)
#define SYNTH_SYNTH4_FORCE_SHIFTREG_MSB          0
#define SYNTH_SYNTH4_FORCE_SHIFTREG_LSB          0
#define SYNTH_SYNTH4_FORCE_SHIFTREG_MASK         0x00000001
#define SYNTH_SYNTH4_FORCE_SHIFTREG_GET(x)       (((x) & SYNTH_SYNTH4_FORCE_SHIFTREG_MASK) >> SYNTH_SYNTH4_FORCE_SHIFTREG_LSB)
#define SYNTH_SYNTH4_FORCE_SHIFTREG_SET(x)       (((x) << SYNTH_SYNTH4_FORCE_SHIFTREG_LSB) & SYNTH_SYNTH4_FORCE_SHIFTREG_MASK)

#define SYNTH_SYNTH5_ADDRESS                     0x00000010
#define SYNTH_SYNTH5_OFFSET                      0x00000010
#define SYNTH_SYNTH5_LOOP_IP0_MSB                31
#define SYNTH_SYNTH5_LOOP_IP0_LSB                28
#define SYNTH_SYNTH5_LOOP_IP0_MASK               0xf0000000
#define SYNTH_SYNTH5_LOOP_IP0_GET(x)             (((x) & SYNTH_SYNTH5_LOOP_IP0_MASK) >> SYNTH_SYNTH5_LOOP_IP0_LSB)
#define SYNTH_SYNTH5_LOOP_IP0_SET(x)             (((x) << SYNTH_SYNTH5_LOOP_IP0_LSB) & SYNTH_SYNTH5_LOOP_IP0_MASK)
#define SYNTH_SYNTH5_SLOPE_IP_MSB                27
#define SYNTH_SYNTH5_SLOPE_IP_LSB                25
#define SYNTH_SYNTH5_SLOPE_IP_MASK               0x0e000000
#define SYNTH_SYNTH5_SLOPE_IP_GET(x)             (((x) & SYNTH_SYNTH5_SLOPE_IP_MASK) >> SYNTH_SYNTH5_SLOPE_IP_LSB)
#define SYNTH_SYNTH5_SLOPE_IP_SET(x)             (((x) << SYNTH_SYNTH5_SLOPE_IP_LSB) & SYNTH_SYNTH5_SLOPE_IP_MASK)
#define SYNTH_SYNTH5_CPBIAS_MSB                  24
#define SYNTH_SYNTH5_CPBIAS_LSB                  23
#define SYNTH_SYNTH5_CPBIAS_MASK                 0x01800000
#define SYNTH_SYNTH5_CPBIAS_GET(x)               (((x) & SYNTH_SYNTH5_CPBIAS_MASK) >> SYNTH_SYNTH5_CPBIAS_LSB)
#define SYNTH_SYNTH5_CPBIAS_SET(x)               (((x) << SYNTH_SYNTH5_CPBIAS_LSB) & SYNTH_SYNTH5_CPBIAS_MASK)
#define SYNTH_SYNTH5_CPSTEERING_EN_MSB           22
#define SYNTH_SYNTH5_CPSTEERING_EN_LSB           22
#define SYNTH_SYNTH5_CPSTEERING_EN_MASK          0x00400000
#define SYNTH_SYNTH5_CPSTEERING_EN_GET(x)        (((x) & SYNTH_SYNTH5_CPSTEERING_EN_MASK) >> SYNTH_SYNTH5_CPSTEERING_EN_LSB)
#define SYNTH_SYNTH5_CPSTEERING_EN_SET(x)        (((x) << SYNTH_SYNTH5_CPSTEERING_EN_LSB) & SYNTH_SYNTH5_CPSTEERING_EN_MASK)
#define SYNTH_SYNTH5_CPLOWLK_MSB                 21
#define SYNTH_SYNTH5_CPLOWLK_LSB                 21
#define SYNTH_SYNTH5_CPLOWLK_MASK                0x00200000
#define SYNTH_SYNTH5_CPLOWLK_GET(x)              (((x) & SYNTH_SYNTH5_CPLOWLK_MASK) >> SYNTH_SYNTH5_CPLOWLK_LSB)
#define SYNTH_SYNTH5_CPLOWLK_SET(x)              (((x) << SYNTH_SYNTH5_CPLOWLK_LSB) & SYNTH_SYNTH5_CPLOWLK_MASK)
#define SYNTH_SYNTH5_LOOPLEAKCUR_MSB             20
#define SYNTH_SYNTH5_LOOPLEAKCUR_LSB             17
#define SYNTH_SYNTH5_LOOPLEAKCUR_MASK            0x001e0000
#define SYNTH_SYNTH5_LOOPLEAKCUR_GET(x)          (((x) & SYNTH_SYNTH5_LOOPLEAKCUR_MASK) >> SYNTH_SYNTH5_LOOPLEAKCUR_LSB)
#define SYNTH_SYNTH5_LOOPLEAKCUR_SET(x)          (((x) << SYNTH_SYNTH5_LOOPLEAKCUR_LSB) & SYNTH_SYNTH5_LOOPLEAKCUR_MASK)
#define SYNTH_SYNTH5_CAPRANGE1_MSB               16
#define SYNTH_SYNTH5_CAPRANGE1_LSB               13
#define SYNTH_SYNTH5_CAPRANGE1_MASK              0x0001e000
#define SYNTH_SYNTH5_CAPRANGE1_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE1_MASK) >> SYNTH_SYNTH5_CAPRANGE1_LSB)
#define SYNTH_SYNTH5_CAPRANGE1_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE1_LSB) & SYNTH_SYNTH5_CAPRANGE1_MASK)
#define SYNTH_SYNTH5_CAPRANGE2_MSB               12
#define SYNTH_SYNTH5_CAPRANGE2_LSB               9
#define SYNTH_SYNTH5_CAPRANGE2_MASK              0x00001e00
#define SYNTH_SYNTH5_CAPRANGE2_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE2_MASK) >> SYNTH_SYNTH5_CAPRANGE2_LSB)
#define SYNTH_SYNTH5_CAPRANGE2_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE2_LSB) & SYNTH_SYNTH5_CAPRANGE2_MASK)
#define SYNTH_SYNTH5_CAPRANGE3_MSB               8
#define SYNTH_SYNTH5_CAPRANGE3_LSB               5
#define SYNTH_SYNTH5_CAPRANGE3_MASK              0x000001e0
#define SYNTH_SYNTH5_CAPRANGE3_GET(x)            (((x) & SYNTH_SYNTH5_CAPRANGE3_MASK) >> SYNTH_SYNTH5_CAPRANGE3_LSB)
#define SYNTH_SYNTH5_CAPRANGE3_SET(x)            (((x) << SYNTH_SYNTH5_CAPRANGE3_LSB) & SYNTH_SYNTH5_CAPRANGE3_MASK)
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MSB       4
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB       4
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK      0x00000010
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_GET(x)    (((x) & SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK) >> SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB)
#define SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_SET(x)    (((x) << SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_LSB) & SYNTH_SYNTH5_FORCE_LOBUF5GTUNE_MASK)
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MSB         3
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB         2
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK        0x0000000c
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_GET(x)      (((x) & SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK) >> SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB)
#define SYNTH_SYNTH5_LOBUF5GTUNE_OVR_SET(x)      (((x) << SYNTH_SYNTH5_LOBUF5GTUNE_OVR_LSB) & SYNTH_SYNTH5_LOBUF5GTUNE_OVR_MASK)
#define SYNTH_SYNTH5_SPARE_MSB                   1
#define SYNTH_SYNTH5_SPARE_LSB                   0
#define SYNTH_SYNTH5_SPARE_MASK                  0x00000003
#define SYNTH_SYNTH5_SPARE_GET(x)                (((x) & SYNTH_SYNTH5_SPARE_MASK) >> SYNTH_SYNTH5_SPARE_LSB)
#define SYNTH_SYNTH5_SPARE_SET(x)                (((x) << SYNTH_SYNTH5_SPARE_LSB) & SYNTH_SYNTH5_SPARE_MASK)

#define SYNTH_SYNTH6_ADDRESS                     0x00000014
#define SYNTH_SYNTH6_OFFSET                      0x00000014
#define SYNTH_SYNTH6_IRCP_MSB                    31
#define SYNTH_SYNTH6_IRCP_LSB                    29
#define SYNTH_SYNTH6_IRCP_MASK                   0xe0000000
#define SYNTH_SYNTH6_IRCP_GET(x)                 (((x) & SYNTH_SYNTH6_IRCP_MASK) >> SYNTH_SYNTH6_IRCP_LSB)
#define SYNTH_SYNTH6_IRCP_SET(x)                 (((x) << SYNTH_SYNTH6_IRCP_LSB) & SYNTH_SYNTH6_IRCP_MASK)
#define SYNTH_SYNTH6_IRVCMON_MSB                 28
#define SYNTH_SYNTH6_IRVCMON_LSB                 26
#define SYNTH_SYNTH6_IRVCMON_MASK                0x1c000000
#define SYNTH_SYNTH6_IRVCMON_GET(x)              (((x) & SYNTH_SYNTH6_IRVCMON_MASK) >> SYNTH_SYNTH6_IRVCMON_LSB)
#define SYNTH_SYNTH6_IRVCMON_SET(x)              (((x) << SYNTH_SYNTH6_IRVCMON_LSB) & SYNTH_SYNTH6_IRVCMON_MASK)
#define SYNTH_SYNTH6_IRSPARE_MSB                 25
#define SYNTH_SYNTH6_IRSPARE_LSB                 23
#define SYNTH_SYNTH6_IRSPARE_MASK                0x03800000
#define SYNTH_SYNTH6_IRSPARE_GET(x)              (((x) & SYNTH_SYNTH6_IRSPARE_MASK) >> SYNTH_SYNTH6_IRSPARE_LSB)
#define SYNTH_SYNTH6_IRSPARE_SET(x)              (((x) << SYNTH_SYNTH6_IRSPARE_LSB) & SYNTH_SYNTH6_IRSPARE_MASK)
#define SYNTH_SYNTH6_ICPRESC_MSB                 22
#define SYNTH_SYNTH6_ICPRESC_LSB                 20
#define SYNTH_SYNTH6_ICPRESC_MASK                0x00700000
#define SYNTH_SYNTH6_ICPRESC_GET(x)              (((x) & SYNTH_SYNTH6_ICPRESC_MASK) >> SYNTH_SYNTH6_ICPRESC_LSB)
#define SYNTH_SYNTH6_ICPRESC_SET(x)              (((x) << SYNTH_SYNTH6_ICPRESC_LSB) & SYNTH_SYNTH6_ICPRESC_MASK)
#define SYNTH_SYNTH6_ICLODIV_MSB                 19
#define SYNTH_SYNTH6_ICLODIV_LSB                 17
#define SYNTH_SYNTH6_ICLODIV_MASK                0x000e0000
#define SYNTH_SYNTH6_ICLODIV_GET(x)              (((x) & SYNTH_SYNTH6_ICLODIV_MASK) >> SYNTH_SYNTH6_ICLODIV_LSB)
#define SYNTH_SYNTH6_ICLODIV_SET(x)              (((x) << SYNTH_SYNTH6_ICLODIV_LSB) & SYNTH_SYNTH6_ICLODIV_MASK)
#define SYNTH_SYNTH6_ICLOMIX_MSB                 16
#define SYNTH_SYNTH6_ICLOMIX_LSB                 14
#define SYNTH_SYNTH6_ICLOMIX_MASK                0x0001c000
#define SYNTH_SYNTH6_ICLOMIX_GET(x)              (((x) & SYNTH_SYNTH6_ICLOMIX_MASK) >> SYNTH_SYNTH6_ICLOMIX_LSB)
#define SYNTH_SYNTH6_ICLOMIX_SET(x)              (((x) << SYNTH_SYNTH6_ICLOMIX_LSB) & SYNTH_SYNTH6_ICLOMIX_MASK)
#define SYNTH_SYNTH6_ICSPAREA_MSB                13
#define SYNTH_SYNTH6_ICSPAREA_LSB                11
#define SYNTH_SYNTH6_ICSPAREA_MASK               0x00003800
#define SYNTH_SYNTH6_ICSPAREA_GET(x)             (((x) & SYNTH_SYNTH6_ICSPAREA_MASK) >> SYNTH_SYNTH6_ICSPAREA_LSB)
#define SYNTH_SYNTH6_ICSPAREA_SET(x)             (((x) << SYNTH_SYNTH6_ICSPAREA_LSB) & SYNTH_SYNTH6_ICSPAREA_MASK)
#define SYNTH_SYNTH6_ICSPAREB_MSB                10
#define SYNTH_SYNTH6_ICSPAREB_LSB                8
#define SYNTH_SYNTH6_ICSPAREB_MASK               0x00000700
#define SYNTH_SYNTH6_ICSPAREB_GET(x)             (((x) & SYNTH_SYNTH6_ICSPAREB_MASK) >> SYNTH_SYNTH6_ICSPAREB_LSB)
#define SYNTH_SYNTH6_ICSPAREB_SET(x)             (((x) << SYNTH_SYNTH6_ICSPAREB_LSB) & SYNTH_SYNTH6_ICSPAREB_MASK)
#define SYNTH_SYNTH6_ICVCO_MSB                   7
#define SYNTH_SYNTH6_ICVCO_LSB                   5
#define SYNTH_SYNTH6_ICVCO_MASK                  0x000000e0
#define SYNTH_SYNTH6_ICVCO_GET(x)                (((x) & SYNTH_SYNTH6_ICVCO_MASK) >> SYNTH_SYNTH6_ICVCO_LSB)
#define SYNTH_SYNTH6_ICVCO_SET(x)                (((x) << SYNTH_SYNTH6_ICVCO_LSB) & SYNTH_SYNTH6_ICVCO_MASK)
#define SYNTH_SYNTH6_VCOBUFBIAS_MSB              4
#define SYNTH_SYNTH6_VCOBUFBIAS_LSB              3
#define SYNTH_SYNTH6_VCOBUFBIAS_MASK             0x00000018
#define SYNTH_SYNTH6_VCOBUFBIAS_GET(x)           (((x) & SYNTH_SYNTH6_VCOBUFBIAS_MASK) >> SYNTH_SYNTH6_VCOBUFBIAS_LSB)
#define SYNTH_SYNTH6_VCOBUFBIAS_SET(x)           (((x) << SYNTH_SYNTH6_VCOBUFBIAS_LSB) & SYNTH_SYNTH6_VCOBUFBIAS_MASK)
#define SYNTH_SYNTH6_SPARE_BIAS_MSB              2
#define SYNTH_SYNTH6_SPARE_BIAS_LSB              0
#define SYNTH_SYNTH6_SPARE_BIAS_MASK             0x00000007
#define SYNTH_SYNTH6_SPARE_BIAS_GET(x)           (((x) & SYNTH_SYNTH6_SPARE_BIAS_MASK) >> SYNTH_SYNTH6_SPARE_BIAS_LSB)
#define SYNTH_SYNTH6_SPARE_BIAS_SET(x)           (((x) << SYNTH_SYNTH6_SPARE_BIAS_LSB) & SYNTH_SYNTH6_SPARE_BIAS_MASK)

#define SYNTH_SYNTH7_ADDRESS                     0x00000018
#define SYNTH_SYNTH7_OFFSET                      0x00000018
#define SYNTH_SYNTH7_SYNTH_ON_MSB                31
#define SYNTH_SYNTH7_SYNTH_ON_LSB                31
#define SYNTH_SYNTH7_SYNTH_ON_MASK               0x80000000
#define SYNTH_SYNTH7_SYNTH_ON_GET(x)             (((x) & SYNTH_SYNTH7_SYNTH_ON_MASK) >> SYNTH_SYNTH7_SYNTH_ON_LSB)
#define SYNTH_SYNTH7_SYNTH_ON_SET(x)             (((x) << SYNTH_SYNTH7_SYNTH_ON_LSB) & SYNTH_SYNTH7_SYNTH_ON_MASK)
#define SYNTH_SYNTH7_SYNTH_SM_STATE_MSB          30
#define SYNTH_SYNTH7_SYNTH_SM_STATE_LSB          27
#define SYNTH_SYNTH7_SYNTH_SM_STATE_MASK         0x78000000
#define SYNTH_SYNTH7_SYNTH_SM_STATE_GET(x)       (((x) & SYNTH_SYNTH7_SYNTH_SM_STATE_MASK) >> SYNTH_SYNTH7_SYNTH_SM_STATE_LSB)
#define SYNTH_SYNTH7_SYNTH_SM_STATE_SET(x)       (((x) << SYNTH_SYNTH7_SYNTH_SM_STATE_LSB) & SYNTH_SYNTH7_SYNTH_SM_STATE_MASK)
#define SYNTH_SYNTH7_CAP_SEARCH_MSB              26
#define SYNTH_SYNTH7_CAP_SEARCH_LSB              26
#define SYNTH_SYNTH7_CAP_SEARCH_MASK             0x04000000
#define SYNTH_SYNTH7_CAP_SEARCH_GET(x)           (((x) & SYNTH_SYNTH7_CAP_SEARCH_MASK) >> SYNTH_SYNTH7_CAP_SEARCH_LSB)
#define SYNTH_SYNTH7_CAP_SEARCH_SET(x)           (((x) << SYNTH_SYNTH7_CAP_SEARCH_LSB) & SYNTH_SYNTH7_CAP_SEARCH_MASK)
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MSB        25
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB        25
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK       0x02000000
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_GET(x)     (((x) & SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK) >> SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB)
#define SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_SET(x)     (((x) << SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_LSB) & SYNTH_SYNTH7_SYNTH_LOCK_VC_OK_MASK)
#define SYNTH_SYNTH7_PIN_VC_MSB                  24
#define SYNTH_SYNTH7_PIN_VC_LSB                  24
#define SYNTH_SYNTH7_PIN_VC_MASK                 0x01000000
#define SYNTH_SYNTH7_PIN_VC_GET(x)               (((x) & SYNTH_SYNTH7_PIN_VC_MASK) >> SYNTH_SYNTH7_PIN_VC_LSB)
#define SYNTH_SYNTH7_PIN_VC_SET(x)               (((x) << SYNTH_SYNTH7_PIN_VC_LSB) & SYNTH_SYNTH7_PIN_VC_MASK)
#define SYNTH_SYNTH7_VCO_CAP_ST_MSB              23
#define SYNTH_SYNTH7_VCO_CAP_ST_LSB              16
#define SYNTH_SYNTH7_VCO_CAP_ST_MASK             0x00ff0000
#define SYNTH_SYNTH7_VCO_CAP_ST_GET(x)           (((x) & SYNTH_SYNTH7_VCO_CAP_ST_MASK) >> SYNTH_SYNTH7_VCO_CAP_ST_LSB)
#define SYNTH_SYNTH7_VCO_CAP_ST_SET(x)           (((x) << SYNTH_SYNTH7_VCO_CAP_ST_LSB) & SYNTH_SYNTH7_VCO_CAP_ST_MASK)
#define SYNTH_SYNTH7_SHORT_R_MSB                 15
#define SYNTH_SYNTH7_SHORT_R_LSB                 15
#define SYNTH_SYNTH7_SHORT_R_MASK                0x00008000
#define SYNTH_SYNTH7_SHORT_R_GET(x)              (((x) & SYNTH_SYNTH7_SHORT_R_MASK) >> SYNTH_SYNTH7_SHORT_R_LSB)
#define SYNTH_SYNTH7_SHORT_R_SET(x)              (((x) << SYNTH_SYNTH7_SHORT_R_LSB) & SYNTH_SYNTH7_SHORT_R_MASK)
#define SYNTH_SYNTH7_RESET_RFD_MSB               14
#define SYNTH_SYNTH7_RESET_RFD_LSB               14
#define SYNTH_SYNTH7_RESET_RFD_MASK              0x00004000
#define SYNTH_SYNTH7_RESET_RFD_GET(x)            (((x) & SYNTH_SYNTH7_RESET_RFD_MASK) >> SYNTH_SYNTH7_RESET_RFD_LSB)
#define SYNTH_SYNTH7_RESET_RFD_SET(x)            (((x) << SYNTH_SYNTH7_RESET_RFD_LSB) & SYNTH_SYNTH7_RESET_RFD_MASK)
#define SYNTH_SYNTH7_RESET_PFD_MSB               13
#define SYNTH_SYNTH7_RESET_PFD_LSB               13
#define SYNTH_SYNTH7_RESET_PFD_MASK              0x00002000
#define SYNTH_SYNTH7_RESET_PFD_GET(x)            (((x) & SYNTH_SYNTH7_RESET_PFD_MASK) >> SYNTH_SYNTH7_RESET_PFD_LSB)
#define SYNTH_SYNTH7_RESET_PFD_SET(x)            (((x) << SYNTH_SYNTH7_RESET_PFD_LSB) & SYNTH_SYNTH7_RESET_PFD_MASK)
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_MSB        12
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB        12
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK       0x00001000
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_GET(x)     (((x) & SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK) >> SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB)
#define SYNTH_SYNTH7_RESET_PSCOUNTERS_SET(x)     (((x) << SYNTH_SYNTH7_RESET_PSCOUNTERS_LSB) & SYNTH_SYNTH7_RESET_PSCOUNTERS_MASK)
#define SYNTH_SYNTH7_RESET_SDM_B_MSB             11
#define SYNTH_SYNTH7_RESET_SDM_B_LSB             11
#define SYNTH_SYNTH7_RESET_SDM_B_MASK            0x00000800
#define SYNTH_SYNTH7_RESET_SDM_B_GET(x)          (((x) & SYNTH_SYNTH7_RESET_SDM_B_MASK) >> SYNTH_SYNTH7_RESET_SDM_B_LSB)
#define SYNTH_SYNTH7_RESET_SDM_B_SET(x)          (((x) << SYNTH_SYNTH7_RESET_SDM_B_LSB) & SYNTH_SYNTH7_RESET_SDM_B_MASK)
#define SYNTH_SYNTH7_VC2HIGH_MSB                 10
#define SYNTH_SYNTH7_VC2HIGH_LSB                 10
#define SYNTH_SYNTH7_VC2HIGH_MASK                0x00000400
#define SYNTH_SYNTH7_VC2HIGH_GET(x)              (((x) & SYNTH_SYNTH7_VC2HIGH_MASK) >> SYNTH_SYNTH7_VC2HIGH_LSB)
#define SYNTH_SYNTH7_VC2HIGH_SET(x)              (((x) << SYNTH_SYNTH7_VC2HIGH_LSB) & SYNTH_SYNTH7_VC2HIGH_MASK)
#define SYNTH_SYNTH7_VC2LOW_MSB                  9
#define SYNTH_SYNTH7_VC2LOW_LSB                  9
#define SYNTH_SYNTH7_VC2LOW_MASK                 0x00000200
#define SYNTH_SYNTH7_VC2LOW_GET(x)               (((x) & SYNTH_SYNTH7_VC2LOW_MASK) >> SYNTH_SYNTH7_VC2LOW_LSB)
#define SYNTH_SYNTH7_VC2LOW_SET(x)               (((x) << SYNTH_SYNTH7_VC2LOW_LSB) & SYNTH_SYNTH7_VC2LOW_MASK)
#define SYNTH_SYNTH7_LOOP_IP_MSB                 8
#define SYNTH_SYNTH7_LOOP_IP_LSB                 5
#define SYNTH_SYNTH7_LOOP_IP_MASK                0x000001e0
#define SYNTH_SYNTH7_LOOP_IP_GET(x)              (((x) & SYNTH_SYNTH7_LOOP_IP_MASK) >> SYNTH_SYNTH7_LOOP_IP_LSB)
#define SYNTH_SYNTH7_LOOP_IP_SET(x)              (((x) << SYNTH_SYNTH7_LOOP_IP_LSB) & SYNTH_SYNTH7_LOOP_IP_MASK)
#define SYNTH_SYNTH7_LOBUF5GTUNE_MSB             4
#define SYNTH_SYNTH7_LOBUF5GTUNE_LSB             3
#define SYNTH_SYNTH7_LOBUF5GTUNE_MASK            0x00000018
#define SYNTH_SYNTH7_LOBUF5GTUNE_GET(x)          (((x) & SYNTH_SYNTH7_LOBUF5GTUNE_MASK) >> SYNTH_SYNTH7_LOBUF5GTUNE_LSB)
#define SYNTH_SYNTH7_LOBUF5GTUNE_SET(x)          (((x) << SYNTH_SYNTH7_LOBUF5GTUNE_LSB) & SYNTH_SYNTH7_LOBUF5GTUNE_MASK)
#define SYNTH_SYNTH7_SPARE_READ_MSB              2
#define SYNTH_SYNTH7_SPARE_READ_LSB              0
#define SYNTH_SYNTH7_SPARE_READ_MASK             0x00000007
#define SYNTH_SYNTH7_SPARE_READ_GET(x)           (((x) & SYNTH_SYNTH7_SPARE_READ_MASK) >> SYNTH_SYNTH7_SPARE_READ_LSB)
#define SYNTH_SYNTH7_SPARE_READ_SET(x)           (((x) << SYNTH_SYNTH7_SPARE_READ_LSB) & SYNTH_SYNTH7_SPARE_READ_MASK)

#define SYNTH_SYNTH8_ADDRESS                     0x0000001c
#define SYNTH_SYNTH8_OFFSET                      0x0000001c
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_MSB        31
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB        31
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK       0x80000000
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_GET(x)     (((x) & SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK) >> SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB)
#define SYNTH_SYNTH8_LOADSYNTHCHANNEL_SET(x)     (((x) << SYNTH_SYNTH8_LOADSYNTHCHANNEL_LSB) & SYNTH_SYNTH8_LOADSYNTHCHANNEL_MASK)
#define SYNTH_SYNTH8_FRACMODE_MSB                30
#define SYNTH_SYNTH8_FRACMODE_LSB                30
#define SYNTH_SYNTH8_FRACMODE_MASK               0x40000000
#define SYNTH_SYNTH8_FRACMODE_GET(x)             (((x) & SYNTH_SYNTH8_FRACMODE_MASK) >> SYNTH_SYNTH8_FRACMODE_LSB)
#define SYNTH_SYNTH8_FRACMODE_SET(x)             (((x) << SYNTH_SYNTH8_FRACMODE_LSB) & SYNTH_SYNTH8_FRACMODE_MASK)
#define SYNTH_SYNTH8_AMODEREFSEL_MSB             29
#define SYNTH_SYNTH8_AMODEREFSEL_LSB             28
#define SYNTH_SYNTH8_AMODEREFSEL_MASK            0x30000000
#define SYNTH_SYNTH8_AMODEREFSEL_GET(x)          (((x) & SYNTH_SYNTH8_AMODEREFSEL_MASK) >> SYNTH_SYNTH8_AMODEREFSEL_LSB)
#define SYNTH_SYNTH8_AMODEREFSEL_SET(x)          (((x) << SYNTH_SYNTH8_AMODEREFSEL_LSB) & SYNTH_SYNTH8_AMODEREFSEL_MASK)
#define SYNTH_SYNTH8_SPARE_MSB                   27
#define SYNTH_SYNTH8_SPARE_LSB                   27
#define SYNTH_SYNTH8_SPARE_MASK                  0x08000000
#define SYNTH_SYNTH8_SPARE_GET(x)                (((x) & SYNTH_SYNTH8_SPARE_MASK) >> SYNTH_SYNTH8_SPARE_LSB)
#define SYNTH_SYNTH8_SPARE_SET(x)                (((x) << SYNTH_SYNTH8_SPARE_LSB) & SYNTH_SYNTH8_SPARE_MASK)
#define SYNTH_SYNTH8_CHANSEL_MSB                 26
#define SYNTH_SYNTH8_CHANSEL_LSB                 18
#define SYNTH_SYNTH8_CHANSEL_MASK                0x07fc0000
#define SYNTH_SYNTH8_CHANSEL_GET(x)              (((x) & SYNTH_SYNTH8_CHANSEL_MASK) >> SYNTH_SYNTH8_CHANSEL_LSB)
#define SYNTH_SYNTH8_CHANSEL_SET(x)              (((x) << SYNTH_SYNTH8_CHANSEL_LSB) & SYNTH_SYNTH8_CHANSEL_MASK)
#define SYNTH_SYNTH8_CHANFRAC_MSB                17
#define SYNTH_SYNTH8_CHANFRAC_LSB                1
#define SYNTH_SYNTH8_CHANFRAC_MASK               0x0003fffe
#define SYNTH_SYNTH8_CHANFRAC_GET(x)             (((x) & SYNTH_SYNTH8_CHANFRAC_MASK) >> SYNTH_SYNTH8_CHANFRAC_LSB)
#define SYNTH_SYNTH8_CHANFRAC_SET(x)             (((x) << SYNTH_SYNTH8_CHANFRAC_LSB) & SYNTH_SYNTH8_CHANFRAC_MASK)
#define SYNTH_SYNTH8_FORCE_FRACLSB_MSB           0
#define SYNTH_SYNTH8_FORCE_FRACLSB_LSB           0
#define SYNTH_SYNTH8_FORCE_FRACLSB_MASK          0x00000001
#define SYNTH_SYNTH8_FORCE_FRACLSB_GET(x)        (((x) & SYNTH_SYNTH8_FORCE_FRACLSB_MASK) >> SYNTH_SYNTH8_FORCE_FRACLSB_LSB)
#define SYNTH_SYNTH8_FORCE_FRACLSB_SET(x)        (((x) << SYNTH_SYNTH8_FORCE_FRACLSB_LSB) & SYNTH_SYNTH8_FORCE_FRACLSB_MASK)

#define RF5G_RF5G1_ADDRESS                       0x00000020
#define RF5G_RF5G1_OFFSET                        0x00000020
#define RF5G_RF5G1_PDTXLO5_MSB                   31
#define RF5G_RF5G1_PDTXLO5_LSB                   31
#define RF5G_RF5G1_PDTXLO5_MASK                  0x80000000
#define RF5G_RF5G1_PDTXLO5_GET(x)                (((x) & RF5G_RF5G1_PDTXLO5_MASK) >> RF5G_RF5G1_PDTXLO5_LSB)
#define RF5G_RF5G1_PDTXLO5_SET(x)                (((x) << RF5G_RF5G1_PDTXLO5_LSB) & RF5G_RF5G1_PDTXLO5_MASK)
#define RF5G_RF5G1_PDTXMIX5_MSB                  30
#define RF5G_RF5G1_PDTXMIX5_LSB                  30
#define RF5G_RF5G1_PDTXMIX5_MASK                 0x40000000
#define RF5G_RF5G1_PDTXMIX5_GET(x)               (((x) & RF5G_RF5G1_PDTXMIX5_MASK) >> RF5G_RF5G1_PDTXMIX5_LSB)
#define RF5G_RF5G1_PDTXMIX5_SET(x)               (((x) << RF5G_RF5G1_PDTXMIX5_LSB) & RF5G_RF5G1_PDTXMIX5_MASK)
#define RF5G_RF5G1_PDTXBUF5_MSB                  29
#define RF5G_RF5G1_PDTXBUF5_LSB                  29
#define RF5G_RF5G1_PDTXBUF5_MASK                 0x20000000
#define RF5G_RF5G1_PDTXBUF5_GET(x)               (((x) & RF5G_RF5G1_PDTXBUF5_MASK) >> RF5G_RF5G1_PDTXBUF5_LSB)
#define RF5G_RF5G1_PDTXBUF5_SET(x)               (((x) << RF5G_RF5G1_PDTXBUF5_LSB) & RF5G_RF5G1_PDTXBUF5_MASK)
#define RF5G_RF5G1_PDPADRV5_MSB                  28
#define RF5G_RF5G1_PDPADRV5_LSB                  28
#define RF5G_RF5G1_PDPADRV5_MASK                 0x10000000
#define RF5G_RF5G1_PDPADRV5_GET(x)               (((x) & RF5G_RF5G1_PDPADRV5_MASK) >> RF5G_RF5G1_PDPADRV5_LSB)
#define RF5G_RF5G1_PDPADRV5_SET(x)               (((x) << RF5G_RF5G1_PDPADRV5_LSB) & RF5G_RF5G1_PDPADRV5_MASK)
#define RF5G_RF5G1_PDPAOUT5_MSB                  27
#define RF5G_RF5G1_PDPAOUT5_LSB                  27
#define RF5G_RF5G1_PDPAOUT5_MASK                 0x08000000
#define RF5G_RF5G1_PDPAOUT5_GET(x)               (((x) & RF5G_RF5G1_PDPAOUT5_MASK) >> RF5G_RF5G1_PDPAOUT5_LSB)
#define RF5G_RF5G1_PDPAOUT5_SET(x)               (((x) << RF5G_RF5G1_PDPAOUT5_LSB) & RF5G_RF5G1_PDPAOUT5_MASK)
#define RF5G_RF5G1_TUNE_PADRV5_MSB               26
#define RF5G_RF5G1_TUNE_PADRV5_LSB               24
#define RF5G_RF5G1_TUNE_PADRV5_MASK              0x07000000
#define RF5G_RF5G1_TUNE_PADRV5_GET(x)            (((x) & RF5G_RF5G1_TUNE_PADRV5_MASK) >> RF5G_RF5G1_TUNE_PADRV5_LSB)
#define RF5G_RF5G1_TUNE_PADRV5_SET(x)            (((x) << RF5G_RF5G1_TUNE_PADRV5_LSB) & RF5G_RF5G1_TUNE_PADRV5_MASK)
#define RF5G_RF5G1_PWDTXPKD_MSB                  23
#define RF5G_RF5G1_PWDTXPKD_LSB                  21
#define RF5G_RF5G1_PWDTXPKD_MASK                 0x00e00000
#define RF5G_RF5G1_PWDTXPKD_GET(x)               (((x) & RF5G_RF5G1_PWDTXPKD_MASK) >> RF5G_RF5G1_PWDTXPKD_LSB)
#define RF5G_RF5G1_PWDTXPKD_SET(x)               (((x) << RF5G_RF5G1_PWDTXPKD_LSB) & RF5G_RF5G1_PWDTXPKD_MASK)
#define RF5G_RF5G1_DB5_MSB                       20
#define RF5G_RF5G1_DB5_LSB                       18
#define RF5G_RF5G1_DB5_MASK                      0x001c0000
#define RF5G_RF5G1_DB5_GET(x)                    (((x) & RF5G_RF5G1_DB5_MASK) >> RF5G_RF5G1_DB5_LSB)
#define RF5G_RF5G1_DB5_SET(x)                    (((x) << RF5G_RF5G1_DB5_LSB) & RF5G_RF5G1_DB5_MASK)
#define RF5G_RF5G1_OB5_MSB                       17
#define RF5G_RF5G1_OB5_LSB                       15
#define RF5G_RF5G1_OB5_MASK                      0x00038000
#define RF5G_RF5G1_OB5_GET(x)                    (((x) & RF5G_RF5G1_OB5_MASK) >> RF5G_RF5G1_OB5_LSB)
#define RF5G_RF5G1_OB5_SET(x)                    (((x) << RF5G_RF5G1_OB5_LSB) & RF5G_RF5G1_OB5_MASK)
#define RF5G_RF5G1_TX5_ATB_SEL_MSB               14
#define RF5G_RF5G1_TX5_ATB_SEL_LSB               12
#define RF5G_RF5G1_TX5_ATB_SEL_MASK              0x00007000
#define RF5G_RF5G1_TX5_ATB_SEL_GET(x)            (((x) & RF5G_RF5G1_TX5_ATB_SEL_MASK) >> RF5G_RF5G1_TX5_ATB_SEL_LSB)
#define RF5G_RF5G1_TX5_ATB_SEL_SET(x)            (((x) << RF5G_RF5G1_TX5_ATB_SEL_LSB) & RF5G_RF5G1_TX5_ATB_SEL_MASK)
#define RF5G_RF5G1_PDLO5DIV_MSB                  11
#define RF5G_RF5G1_PDLO5DIV_LSB                  11
#define RF5G_RF5G1_PDLO5DIV_MASK                 0x00000800
#define RF5G_RF5G1_PDLO5DIV_GET(x)               (((x) & RF5G_RF5G1_PDLO5DIV_MASK) >> RF5G_RF5G1_PDLO5DIV_LSB)
#define RF5G_RF5G1_PDLO5DIV_SET(x)               (((x) << RF5G_RF5G1_PDLO5DIV_LSB) & RF5G_RF5G1_PDLO5DIV_MASK)
#define RF5G_RF5G1_PDLO5MIX_MSB                  10
#define RF5G_RF5G1_PDLO5MIX_LSB                  10
#define RF5G_RF5G1_PDLO5MIX_MASK                 0x00000400
#define RF5G_RF5G1_PDLO5MIX_GET(x)               (((x) & RF5G_RF5G1_PDLO5MIX_MASK) >> RF5G_RF5G1_PDLO5MIX_LSB)
#define RF5G_RF5G1_PDLO5MIX_SET(x)               (((x) << RF5G_RF5G1_PDLO5MIX_LSB) & RF5G_RF5G1_PDLO5MIX_MASK)
#define RF5G_RF5G1_PDQBUF5_MSB                   9
#define RF5G_RF5G1_PDQBUF5_LSB                   9
#define RF5G_RF5G1_PDQBUF5_MASK                  0x00000200
#define RF5G_RF5G1_PDQBUF5_GET(x)                (((x) & RF5G_RF5G1_PDQBUF5_MASK) >> RF5G_RF5G1_PDQBUF5_LSB)
#define RF5G_RF5G1_PDQBUF5_SET(x)                (((x) << RF5G_RF5G1_PDQBUF5_LSB) & RF5G_RF5G1_PDQBUF5_MASK)
#define RF5G_RF5G1_PDLO5AGC_MSB                  8
#define RF5G_RF5G1_PDLO5AGC_LSB                  8
#define RF5G_RF5G1_PDLO5AGC_MASK                 0x00000100
#define RF5G_RF5G1_PDLO5AGC_GET(x)               (((x) & RF5G_RF5G1_PDLO5AGC_MASK) >> RF5G_RF5G1_PDLO5AGC_LSB)
#define RF5G_RF5G1_PDLO5AGC_SET(x)               (((x) << RF5G_RF5G1_PDLO5AGC_LSB) & RF5G_RF5G1_PDLO5AGC_MASK)
#define RF5G_RF5G1_PDREGLO5_MSB                  7
#define RF5G_RF5G1_PDREGLO5_LSB                  7
#define RF5G_RF5G1_PDREGLO5_MASK                 0x00000080
#define RF5G_RF5G1_PDREGLO5_GET(x)               (((x) & RF5G_RF5G1_PDREGLO5_MASK) >> RF5G_RF5G1_PDREGLO5_LSB)
#define RF5G_RF5G1_PDREGLO5_SET(x)               (((x) << RF5G_RF5G1_PDREGLO5_LSB) & RF5G_RF5G1_PDREGLO5_MASK)
#define RF5G_RF5G1_LO5_ATB_SEL_MSB               6
#define RF5G_RF5G1_LO5_ATB_SEL_LSB               4
#define RF5G_RF5G1_LO5_ATB_SEL_MASK              0x00000070
#define RF5G_RF5G1_LO5_ATB_SEL_GET(x)            (((x) & RF5G_RF5G1_LO5_ATB_SEL_MASK) >> RF5G_RF5G1_LO5_ATB_SEL_LSB)
#define RF5G_RF5G1_LO5_ATB_SEL_SET(x)            (((x) << RF5G_RF5G1_LO5_ATB_SEL_LSB) & RF5G_RF5G1_LO5_ATB_SEL_MASK)
#define RF5G_RF5G1_LO5CONTROL_MSB                3
#define RF5G_RF5G1_LO5CONTROL_LSB                3
#define RF5G_RF5G1_LO5CONTROL_MASK               0x00000008
#define RF5G_RF5G1_LO5CONTROL_GET(x)             (((x) & RF5G_RF5G1_LO5CONTROL_MASK) >> RF5G_RF5G1_LO5CONTROL_LSB)
#define RF5G_RF5G1_LO5CONTROL_SET(x)             (((x) << RF5G_RF5G1_LO5CONTROL_LSB) & RF5G_RF5G1_LO5CONTROL_MASK)
#define RF5G_RF5G1_REGLO_BYPASS5_MSB             2
#define RF5G_RF5G1_REGLO_BYPASS5_LSB             2
#define RF5G_RF5G1_REGLO_BYPASS5_MASK            0x00000004
#define RF5G_RF5G1_REGLO_BYPASS5_GET(x)          (((x) & RF5G_RF5G1_REGLO_BYPASS5_MASK) >> RF5G_RF5G1_REGLO_BYPASS5_LSB)
#define RF5G_RF5G1_REGLO_BYPASS5_SET(x)          (((x) << RF5G_RF5G1_REGLO_BYPASS5_LSB) & RF5G_RF5G1_REGLO_BYPASS5_MASK)
#define RF5G_RF5G1_SPARE_MSB                     1
#define RF5G_RF5G1_SPARE_LSB                     0
#define RF5G_RF5G1_SPARE_MASK                    0x00000003
#define RF5G_RF5G1_SPARE_GET(x)                  (((x) & RF5G_RF5G1_SPARE_MASK) >> RF5G_RF5G1_SPARE_LSB)
#define RF5G_RF5G1_SPARE_SET(x)                  (((x) << RF5G_RF5G1_SPARE_LSB) & RF5G_RF5G1_SPARE_MASK)

#define RF5G_RF5G2_ADDRESS                       0x00000024
#define RF5G_RF5G2_OFFSET                        0x00000024
#define RF5G_RF5G2_AGCLO_B_MSB                   31
#define RF5G_RF5G2_AGCLO_B_LSB                   29
#define RF5G_RF5G2_AGCLO_B_MASK                  0xe0000000
#define RF5G_RF5G2_AGCLO_B_GET(x)                (((x) & RF5G_RF5G2_AGCLO_B_MASK) >> RF5G_RF5G2_AGCLO_B_LSB)
#define RF5G_RF5G2_AGCLO_B_SET(x)                (((x) << RF5G_RF5G2_AGCLO_B_LSB) & RF5G_RF5G2_AGCLO_B_MASK)
#define RF5G_RF5G2_RX5_ATB_SEL_MSB               28
#define RF5G_RF5G2_RX5_ATB_SEL_LSB               26
#define RF5G_RF5G2_RX5_ATB_SEL_MASK              0x1c000000
#define RF5G_RF5G2_RX5_ATB_SEL_GET(x)            (((x) & RF5G_RF5G2_RX5_ATB_SEL_MASK) >> RF5G_RF5G2_RX5_ATB_SEL_LSB)
#define RF5G_RF5G2_RX5_ATB_SEL_SET(x)            (((x) << RF5G_RF5G2_RX5_ATB_SEL_LSB) & RF5G_RF5G2_RX5_ATB_SEL_MASK)
#define RF5G_RF5G2_PDCMOSLO5_MSB                 25
#define RF5G_RF5G2_PDCMOSLO5_LSB                 25
#define RF5G_RF5G2_PDCMOSLO5_MASK                0x02000000
#define RF5G_RF5G2_PDCMOSLO5_GET(x)              (((x) & RF5G_RF5G2_PDCMOSLO5_MASK) >> RF5G_RF5G2_PDCMOSLO5_LSB)
#define RF5G_RF5G2_PDCMOSLO5_SET(x)              (((x) << RF5G_RF5G2_PDCMOSLO5_LSB) & RF5G_RF5G2_PDCMOSLO5_MASK)
#define RF5G_RF5G2_PDVGM5_MSB                    24
#define RF5G_RF5G2_PDVGM5_LSB                    24
#define RF5G_RF5G2_PDVGM5_MASK                   0x01000000
#define RF5G_RF5G2_PDVGM5_GET(x)                 (((x) & RF5G_RF5G2_PDVGM5_MASK) >> RF5G_RF5G2_PDVGM5_LSB)
#define RF5G_RF5G2_PDVGM5_SET(x)                 (((x) << RF5G_RF5G2_PDVGM5_LSB) & RF5G_RF5G2_PDVGM5_MASK)
#define RF5G_RF5G2_PDCSLNA5_MSB                  23
#define RF5G_RF5G2_PDCSLNA5_LSB                  23
#define RF5G_RF5G2_PDCSLNA5_MASK                 0x00800000
#define RF5G_RF5G2_PDCSLNA5_GET(x)               (((x) & RF5G_RF5G2_PDCSLNA5_MASK) >> RF5G_RF5G2_PDCSLNA5_LSB)
#define RF5G_RF5G2_PDCSLNA5_SET(x)               (((x) << RF5G_RF5G2_PDCSLNA5_LSB) & RF5G_RF5G2_PDCSLNA5_MASK)
#define RF5G_RF5G2_PDRFVGA5_MSB                  22
#define RF5G_RF5G2_PDRFVGA5_LSB                  22
#define RF5G_RF5G2_PDRFVGA5_MASK                 0x00400000
#define RF5G_RF5G2_PDRFVGA5_GET(x)               (((x) & RF5G_RF5G2_PDRFVGA5_MASK) >> RF5G_RF5G2_PDRFVGA5_LSB)
#define RF5G_RF5G2_PDRFVGA5_SET(x)               (((x) << RF5G_RF5G2_PDRFVGA5_LSB) & RF5G_RF5G2_PDRFVGA5_MASK)
#define RF5G_RF5G2_PDREGFE5_MSB                  21
#define RF5G_RF5G2_PDREGFE5_LSB                  21
#define RF5G_RF5G2_PDREGFE5_MASK                 0x00200000
#define RF5G_RF5G2_PDREGFE5_GET(x)               (((x) & RF5G_RF5G2_PDREGFE5_MASK) >> RF5G_RF5G2_PDREGFE5_LSB)
#define RF5G_RF5G2_PDREGFE5_SET(x)               (((x) << RF5G_RF5G2_PDREGFE5_LSB) & RF5G_RF5G2_PDREGFE5_MASK)
#define RF5G_RF5G2_TUNE_RFVGA5_MSB               20
#define RF5G_RF5G2_TUNE_RFVGA5_LSB               18
#define RF5G_RF5G2_TUNE_RFVGA5_MASK              0x001c0000
#define RF5G_RF5G2_TUNE_RFVGA5_GET(x)            (((x) & RF5G_RF5G2_TUNE_RFVGA5_MASK) >> RF5G_RF5G2_TUNE_RFVGA5_LSB)
#define RF5G_RF5G2_TUNE_RFVGA5_SET(x)            (((x) << RF5G_RF5G2_TUNE_RFVGA5_LSB) & RF5G_RF5G2_TUNE_RFVGA5_MASK)
#define RF5G_RF5G2_BRFVGA5_MSB                   17
#define RF5G_RF5G2_BRFVGA5_LSB                   15
#define RF5G_RF5G2_BRFVGA5_MASK                  0x00038000
#define RF5G_RF5G2_BRFVGA5_GET(x)                (((x) & RF5G_RF5G2_BRFVGA5_MASK) >> RF5G_RF5G2_BRFVGA5_LSB)
#define RF5G_RF5G2_BRFVGA5_SET(x)                (((x) << RF5G_RF5G2_BRFVGA5_LSB) & RF5G_RF5G2_BRFVGA5_MASK)
#define RF5G_RF5G2_BCSLNA5_MSB                   14
#define RF5G_RF5G2_BCSLNA5_LSB                   12
#define RF5G_RF5G2_BCSLNA5_MASK                  0x00007000
#define RF5G_RF5G2_BCSLNA5_GET(x)                (((x) & RF5G_RF5G2_BCSLNA5_MASK) >> RF5G_RF5G2_BCSLNA5_LSB)
#define RF5G_RF5G2_BCSLNA5_SET(x)                (((x) << RF5G_RF5G2_BCSLNA5_LSB) & RF5G_RF5G2_BCSLNA5_MASK)
#define RF5G_RF5G2_BVGM5_MSB                     11
#define RF5G_RF5G2_BVGM5_LSB                     9
#define RF5G_RF5G2_BVGM5_MASK                    0x00000e00
#define RF5G_RF5G2_BVGM5_GET(x)                  (((x) & RF5G_RF5G2_BVGM5_MASK) >> RF5G_RF5G2_BVGM5_LSB)
#define RF5G_RF5G2_BVGM5_SET(x)                  (((x) << RF5G_RF5G2_BVGM5_LSB) & RF5G_RF5G2_BVGM5_MASK)
#define RF5G_RF5G2_REGFE_BYPASS5_MSB             8
#define RF5G_RF5G2_REGFE_BYPASS5_LSB             8
#define RF5G_RF5G2_REGFE_BYPASS5_MASK            0x00000100
#define RF5G_RF5G2_REGFE_BYPASS5_GET(x)          (((x) & RF5G_RF5G2_REGFE_BYPASS5_MASK) >> RF5G_RF5G2_REGFE_BYPASS5_LSB)
#define RF5G_RF5G2_REGFE_BYPASS5_SET(x)          (((x) << RF5G_RF5G2_REGFE_BYPASS5_LSB) & RF5G_RF5G2_REGFE_BYPASS5_MASK)
#define RF5G_RF5G2_LNA5_ATTENMODE_MSB            7
#define RF5G_RF5G2_LNA5_ATTENMODE_LSB            6
#define RF5G_RF5G2_LNA5_ATTENMODE_MASK           0x000000c0
#define RF5G_RF5G2_LNA5_ATTENMODE_GET(x)         (((x) & RF5G_RF5G2_LNA5_ATTENMODE_MASK) >> RF5G_RF5G2_LNA5_ATTENMODE_LSB)
#define RF5G_RF5G2_LNA5_ATTENMODE_SET(x)         (((x) << RF5G_RF5G2_LNA5_ATTENMODE_LSB) & RF5G_RF5G2_LNA5_ATTENMODE_MASK)
#define RF5G_RF5G2_ENABLE_PCA_MSB                5
#define RF5G_RF5G2_ENABLE_PCA_LSB                5
#define RF5G_RF5G2_ENABLE_PCA_MASK               0x00000020
#define RF5G_RF5G2_ENABLE_PCA_GET(x)             (((x) & RF5G_RF5G2_ENABLE_PCA_MASK) >> RF5G_RF5G2_ENABLE_PCA_LSB)
#define RF5G_RF5G2_ENABLE_PCA_SET(x)             (((x) << RF5G_RF5G2_ENABLE_PCA_LSB) & RF5G_RF5G2_ENABLE_PCA_MASK)
#define RF5G_RF5G2_TUNE_LO_MSB                   4
#define RF5G_RF5G2_TUNE_LO_LSB                   2
#define RF5G_RF5G2_TUNE_LO_MASK                  0x0000001c
#define RF5G_RF5G2_TUNE_LO_GET(x)                (((x) & RF5G_RF5G2_TUNE_LO_MASK) >> RF5G_RF5G2_TUNE_LO_LSB)
#define RF5G_RF5G2_TUNE_LO_SET(x)                (((x) << RF5G_RF5G2_TUNE_LO_LSB) & RF5G_RF5G2_TUNE_LO_MASK)
#define RF5G_RF5G2_SPARE_MSB                     1
#define RF5G_RF5G2_SPARE_LSB                     0
#define RF5G_RF5G2_SPARE_MASK                    0x00000003
#define RF5G_RF5G2_SPARE_GET(x)                  (((x) & RF5G_RF5G2_SPARE_MASK) >> RF5G_RF5G2_SPARE_LSB)
#define RF5G_RF5G2_SPARE_SET(x)                  (((x) << RF5G_RF5G2_SPARE_LSB) & RF5G_RF5G2_SPARE_MASK)

#define RF2G_RF2G1_ADDRESS                       0x00000028
#define RF2G_RF2G1_OFFSET                        0x00000028
#define RF2G_RF2G1_BLNA1_MSB                     31
#define RF2G_RF2G1_BLNA1_LSB                     29
#define RF2G_RF2G1_BLNA1_MASK                    0xe0000000
#define RF2G_RF2G1_BLNA1_GET(x)                  (((x) & RF2G_RF2G1_BLNA1_MASK) >> RF2G_RF2G1_BLNA1_LSB)
#define RF2G_RF2G1_BLNA1_SET(x)                  (((x) << RF2G_RF2G1_BLNA1_LSB) & RF2G_RF2G1_BLNA1_MASK)
#define RF2G_RF2G1_BLNA1F_MSB                    28
#define RF2G_RF2G1_BLNA1F_LSB                    26
#define RF2G_RF2G1_BLNA1F_MASK                   0x1c000000
#define RF2G_RF2G1_BLNA1F_GET(x)                 (((x) & RF2G_RF2G1_BLNA1F_MASK) >> RF2G_RF2G1_BLNA1F_LSB)
#define RF2G_RF2G1_BLNA1F_SET(x)                 (((x) << RF2G_RF2G1_BLNA1F_LSB) & RF2G_RF2G1_BLNA1F_MASK)
#define RF2G_RF2G1_BLNA1BUF_MSB                  25
#define RF2G_RF2G1_BLNA1BUF_LSB                  23
#define RF2G_RF2G1_BLNA1BUF_MASK                 0x03800000
#define RF2G_RF2G1_BLNA1BUF_GET(x)               (((x) & RF2G_RF2G1_BLNA1BUF_MASK) >> RF2G_RF2G1_BLNA1BUF_LSB)
#define RF2G_RF2G1_BLNA1BUF_SET(x)               (((x) << RF2G_RF2G1_BLNA1BUF_LSB) & RF2G_RF2G1_BLNA1BUF_MASK)
#define RF2G_RF2G1_BLNA2_MSB                     22
#define RF2G_RF2G1_BLNA2_LSB                     20
#define RF2G_RF2G1_BLNA2_MASK                    0x00700000
#define RF2G_RF2G1_BLNA2_GET(x)                  (((x) & RF2G_RF2G1_BLNA2_MASK) >> RF2G_RF2G1_BLNA2_LSB)
#define RF2G_RF2G1_BLNA2_SET(x)                  (((x) << RF2G_RF2G1_BLNA2_LSB) & RF2G_RF2G1_BLNA2_MASK)
#define RF2G_RF2G1_DB_MSB                        19
#define RF2G_RF2G1_DB_LSB                        17
#define RF2G_RF2G1_DB_MASK                       0x000e0000
#define RF2G_RF2G1_DB_GET(x)                     (((x) & RF2G_RF2G1_DB_MASK) >> RF2G_RF2G1_DB_LSB)
#define RF2G_RF2G1_DB_SET(x)                     (((x) << RF2G_RF2G1_DB_LSB) & RF2G_RF2G1_DB_MASK)
#define RF2G_RF2G1_OB_MSB                        16
#define RF2G_RF2G1_OB_LSB                        14
#define RF2G_RF2G1_OB_MASK                       0x0001c000
#define RF2G_RF2G1_OB_GET(x)                     (((x) & RF2G_RF2G1_OB_MASK) >> RF2G_RF2G1_OB_LSB)
#define RF2G_RF2G1_OB_SET(x)                     (((x) << RF2G_RF2G1_OB_LSB) & RF2G_RF2G1_OB_MASK)
#define RF2G_RF2G1_FE_ATB_SEL_MSB                13
#define RF2G_RF2G1_FE_ATB_SEL_LSB                11
#define RF2G_RF2G1_FE_ATB_SEL_MASK               0x00003800
#define RF2G_RF2G1_FE_ATB_SEL_GET(x)             (((x) & RF2G_RF2G1_FE_ATB_SEL_MASK) >> RF2G_RF2G1_FE_ATB_SEL_LSB)
#define RF2G_RF2G1_FE_ATB_SEL_SET(x)             (((x) << RF2G_RF2G1_FE_ATB_SEL_LSB) & RF2G_RF2G1_FE_ATB_SEL_MASK)
#define RF2G_RF2G1_RF_ATB_SEL_MSB                10
#define RF2G_RF2G1_RF_ATB_SEL_LSB                8
#define RF2G_RF2G1_RF_ATB_SEL_MASK               0x00000700
#define RF2G_RF2G1_RF_ATB_SEL_GET(x)             (((x) & RF2G_RF2G1_RF_ATB_SEL_MASK) >> RF2G_RF2G1_RF_ATB_SEL_LSB)
#define RF2G_RF2G1_RF_ATB_SEL_SET(x)             (((x) << RF2G_RF2G1_RF_ATB_SEL_LSB) & RF2G_RF2G1_RF_ATB_SEL_MASK)
#define RF2G_RF2G1_SELLNA_MSB                    7
#define RF2G_RF2G1_SELLNA_LSB                    7
#define RF2G_RF2G1_SELLNA_MASK                   0x00000080
#define RF2G_RF2G1_SELLNA_GET(x)                 (((x) & RF2G_RF2G1_SELLNA_MASK) >> RF2G_RF2G1_SELLNA_LSB)
#define RF2G_RF2G1_SELLNA_SET(x)                 (((x) << RF2G_RF2G1_SELLNA_LSB) & RF2G_RF2G1_SELLNA_MASK)
#define RF2G_RF2G1_LOCONTROL_MSB                 6
#define RF2G_RF2G1_LOCONTROL_LSB                 6
#define RF2G_RF2G1_LOCONTROL_MASK                0x00000040
#define RF2G_RF2G1_LOCONTROL_GET(x)              (((x) & RF2G_RF2G1_LOCONTROL_MASK) >> RF2G_RF2G1_LOCONTROL_LSB)
#define RF2G_RF2G1_LOCONTROL_SET(x)              (((x) << RF2G_RF2G1_LOCONTROL_LSB) & RF2G_RF2G1_LOCONTROL_MASK)
#define RF2G_RF2G1_SHORTLNA2_MSB                 5
#define RF2G_RF2G1_SHORTLNA2_LSB                 5
#define RF2G_RF2G1_SHORTLNA2_MASK                0x00000020
#define RF2G_RF2G1_SHORTLNA2_GET(x)              (((x) & RF2G_RF2G1_SHORTLNA2_MASK) >> RF2G_RF2G1_SHORTLNA2_LSB)
#define RF2G_RF2G1_SHORTLNA2_SET(x)              (((x) << RF2G_RF2G1_SHORTLNA2_LSB) & RF2G_RF2G1_SHORTLNA2_MASK)
#define RF2G_RF2G1_SPARE_MSB                     4
#define RF2G_RF2G1_SPARE_LSB                     0
#define RF2G_RF2G1_SPARE_MASK                    0x0000001f
#define RF2G_RF2G1_SPARE_GET(x)                  (((x) & RF2G_RF2G1_SPARE_MASK) >> RF2G_RF2G1_SPARE_LSB)
#define RF2G_RF2G1_SPARE_SET(x)                  (((x) << RF2G_RF2G1_SPARE_LSB) & RF2G_RF2G1_SPARE_MASK)

#define RF2G_RF2G2_ADDRESS                       0x0000002c
#define RF2G_RF2G2_OFFSET                        0x0000002c
#define RF2G_RF2G2_PDCGLNA_MSB                   31
#define RF2G_RF2G2_PDCGLNA_LSB                   31
#define RF2G_RF2G2_PDCGLNA_MASK                  0x80000000
#define RF2G_RF2G2_PDCGLNA_GET(x)                (((x) & RF2G_RF2G2_PDCGLNA_MASK) >> RF2G_RF2G2_PDCGLNA_LSB)
#define RF2G_RF2G2_PDCGLNA_SET(x)                (((x) << RF2G_RF2G2_PDCGLNA_LSB) & RF2G_RF2G2_PDCGLNA_MASK)
#define RF2G_RF2G2_PDCGLNABUF_MSB                30
#define RF2G_RF2G2_PDCGLNABUF_LSB                30
#define RF2G_RF2G2_PDCGLNABUF_MASK               0x40000000
#define RF2G_RF2G2_PDCGLNABUF_GET(x)             (((x) & RF2G_RF2G2_PDCGLNABUF_MASK) >> RF2G_RF2G2_PDCGLNABUF_LSB)
#define RF2G_RF2G2_PDCGLNABUF_SET(x)             (((x) << RF2G_RF2G2_PDCGLNABUF_LSB) & RF2G_RF2G2_PDCGLNABUF_MASK)
#define RF2G_RF2G2_PDCSLNA_MSB                   29
#define RF2G_RF2G2_PDCSLNA_LSB                   29
#define RF2G_RF2G2_PDCSLNA_MASK                  0x20000000
#define RF2G_RF2G2_PDCSLNA_GET(x)                (((x) & RF2G_RF2G2_PDCSLNA_MASK) >> RF2G_RF2G2_PDCSLNA_LSB)
#define RF2G_RF2G2_PDCSLNA_SET(x)                (((x) << RF2G_RF2G2_PDCSLNA_LSB) & RF2G_RF2G2_PDCSLNA_MASK)
#define RF2G_RF2G2_PDDIV_MSB                     28
#define RF2G_RF2G2_PDDIV_LSB                     28
#define RF2G_RF2G2_PDDIV_MASK                    0x10000000
#define RF2G_RF2G2_PDDIV_GET(x)                  (((x) & RF2G_RF2G2_PDDIV_MASK) >> RF2G_RF2G2_PDDIV_LSB)
#define RF2G_RF2G2_PDDIV_SET(x)                  (((x) << RF2G_RF2G2_PDDIV_LSB) & RF2G_RF2G2_PDDIV_MASK)
#define RF2G_RF2G2_PDPADRV_MSB                   27
#define RF2G_RF2G2_PDPADRV_LSB                   27
#define RF2G_RF2G2_PDPADRV_MASK                  0x08000000
#define RF2G_RF2G2_PDPADRV_GET(x)                (((x) & RF2G_RF2G2_PDPADRV_MASK) >> RF2G_RF2G2_PDPADRV_LSB)
#define RF2G_RF2G2_PDPADRV_SET(x)                (((x) << RF2G_RF2G2_PDPADRV_LSB) & RF2G_RF2G2_PDPADRV_MASK)
#define RF2G_RF2G2_PDPAOUT_MSB                   26
#define RF2G_RF2G2_PDPAOUT_LSB                   26
#define RF2G_RF2G2_PDPAOUT_MASK                  0x04000000
#define RF2G_RF2G2_PDPAOUT_GET(x)                (((x) & RF2G_RF2G2_PDPAOUT_MASK) >> RF2G_RF2G2_PDPAOUT_LSB)
#define RF2G_RF2G2_PDPAOUT_SET(x)                (((x) << RF2G_RF2G2_PDPAOUT_LSB) & RF2G_RF2G2_PDPAOUT_MASK)
#define RF2G_RF2G2_PDREGLNA_MSB                  25
#define RF2G_RF2G2_PDREGLNA_LSB                  25
#define RF2G_RF2G2_PDREGLNA_MASK                 0x02000000
#define RF2G_RF2G2_PDREGLNA_GET(x)               (((x) & RF2G_RF2G2_PDREGLNA_MASK) >> RF2G_RF2G2_PDREGLNA_LSB)
#define RF2G_RF2G2_PDREGLNA_SET(x)               (((x) << RF2G_RF2G2_PDREGLNA_LSB) & RF2G_RF2G2_PDREGLNA_MASK)
#define RF2G_RF2G2_PDREGLO_MSB                   24
#define RF2G_RF2G2_PDREGLO_LSB                   24
#define RF2G_RF2G2_PDREGLO_MASK                  0x01000000
#define RF2G_RF2G2_PDREGLO_GET(x)                (((x) & RF2G_RF2G2_PDREGLO_MASK) >> RF2G_RF2G2_PDREGLO_LSB)
#define RF2G_RF2G2_PDREGLO_SET(x)                (((x) << RF2G_RF2G2_PDREGLO_LSB) & RF2G_RF2G2_PDREGLO_MASK)
#define RF2G_RF2G2_PDRFGM_MSB                    23
#define RF2G_RF2G2_PDRFGM_LSB                    23
#define RF2G_RF2G2_PDRFGM_MASK                   0x00800000
#define RF2G_RF2G2_PDRFGM_GET(x)                 (((x) & RF2G_RF2G2_PDRFGM_MASK) >> RF2G_RF2G2_PDRFGM_LSB)
#define RF2G_RF2G2_PDRFGM_SET(x)                 (((x) << RF2G_RF2G2_PDRFGM_LSB) & RF2G_RF2G2_PDRFGM_MASK)
#define RF2G_RF2G2_PDRXLO_MSB                    22
#define RF2G_RF2G2_PDRXLO_LSB                    22
#define RF2G_RF2G2_PDRXLO_MASK                   0x00400000
#define RF2G_RF2G2_PDRXLO_GET(x)                 (((x) & RF2G_RF2G2_PDRXLO_MASK) >> RF2G_RF2G2_PDRXLO_LSB)
#define RF2G_RF2G2_PDRXLO_SET(x)                 (((x) << RF2G_RF2G2_PDRXLO_LSB) & RF2G_RF2G2_PDRXLO_MASK)
#define RF2G_RF2G2_PDTXLO_MSB                    21
#define RF2G_RF2G2_PDTXLO_LSB                    21
#define RF2G_RF2G2_PDTXLO_MASK                   0x00200000
#define RF2G_RF2G2_PDTXLO_GET(x)                 (((x) & RF2G_RF2G2_PDTXLO_MASK) >> RF2G_RF2G2_PDTXLO_LSB)
#define RF2G_RF2G2_PDTXLO_SET(x)                 (((x) << RF2G_RF2G2_PDTXLO_LSB) & RF2G_RF2G2_PDTXLO_MASK)
#define RF2G_RF2G2_PDTXMIX_MSB                   20
#define RF2G_RF2G2_PDTXMIX_LSB                   20
#define RF2G_RF2G2_PDTXMIX_MASK                  0x00100000
#define RF2G_RF2G2_PDTXMIX_GET(x)                (((x) & RF2G_RF2G2_PDTXMIX_MASK) >> RF2G_RF2G2_PDTXMIX_LSB)
#define RF2G_RF2G2_PDTXMIX_SET(x)                (((x) << RF2G_RF2G2_PDTXMIX_LSB) & RF2G_RF2G2_PDTXMIX_MASK)
#define RF2G_RF2G2_REGLNA_BYPASS_MSB             19
#define RF2G_RF2G2_REGLNA_BYPASS_LSB             19
#define RF2G_RF2G2_REGLNA_BYPASS_MASK            0x00080000
#define RF2G_RF2G2_REGLNA_BYPASS_GET(x)          (((x) & RF2G_RF2G2_REGLNA_BYPASS_MASK) >> RF2G_RF2G2_REGLNA_BYPASS_LSB)
#define RF2G_RF2G2_REGLNA_BYPASS_SET(x)          (((x) << RF2G_RF2G2_REGLNA_BYPASS_LSB) & RF2G_RF2G2_REGLNA_BYPASS_MASK)
#define RF2G_RF2G2_REGLO_BYPASS_MSB              18
#define RF2G_RF2G2_REGLO_BYPASS_LSB              18
#define RF2G_RF2G2_REGLO_BYPASS_MASK             0x00040000
#define RF2G_RF2G2_REGLO_BYPASS_GET(x)           (((x) & RF2G_RF2G2_REGLO_BYPASS_MASK) >> RF2G_RF2G2_REGLO_BYPASS_LSB)
#define RF2G_RF2G2_REGLO_BYPASS_SET(x)           (((x) << RF2G_RF2G2_REGLO_BYPASS_LSB) & RF2G_RF2G2_REGLO_BYPASS_MASK)
#define RF2G_RF2G2_ENABLE_PCB_MSB                17
#define RF2G_RF2G2_ENABLE_PCB_LSB                17
#define RF2G_RF2G2_ENABLE_PCB_MASK               0x00020000
#define RF2G_RF2G2_ENABLE_PCB_GET(x)             (((x) & RF2G_RF2G2_ENABLE_PCB_MASK) >> RF2G_RF2G2_ENABLE_PCB_LSB)
#define RF2G_RF2G2_ENABLE_PCB_SET(x)             (((x) << RF2G_RF2G2_ENABLE_PCB_LSB) & RF2G_RF2G2_ENABLE_PCB_MASK)
#define RF2G_RF2G2_SPARE_MSB                     16
#define RF2G_RF2G2_SPARE_LSB                     0
#define RF2G_RF2G2_SPARE_MASK                    0x0001ffff
#define RF2G_RF2G2_SPARE_GET(x)                  (((x) & RF2G_RF2G2_SPARE_MASK) >> RF2G_RF2G2_SPARE_LSB)
#define RF2G_RF2G2_SPARE_SET(x)                  (((x) << RF2G_RF2G2_SPARE_LSB) & RF2G_RF2G2_SPARE_MASK)

#define TOP_GAIN_ADDRESS                         0x00000030
#define TOP_GAIN_OFFSET                          0x00000030
#define TOP_GAIN_TX6DBLOQGAIN_MSB                31
#define TOP_GAIN_TX6DBLOQGAIN_LSB                30
#define TOP_GAIN_TX6DBLOQGAIN_MASK               0xc0000000
#define TOP_GAIN_TX6DBLOQGAIN_GET(x)             (((x) & TOP_GAIN_TX6DBLOQGAIN_MASK) >> TOP_GAIN_TX6DBLOQGAIN_LSB)
#define TOP_GAIN_TX6DBLOQGAIN_SET(x)             (((x) << TOP_GAIN_TX6DBLOQGAIN_LSB) & TOP_GAIN_TX6DBLOQGAIN_MASK)
#define TOP_GAIN_TX1DBLOQGAIN_MSB                29
#define TOP_GAIN_TX1DBLOQGAIN_LSB                27
#define TOP_GAIN_TX1DBLOQGAIN_MASK               0x38000000
#define TOP_GAIN_TX1DBLOQGAIN_GET(x)             (((x) & TOP_GAIN_TX1DBLOQGAIN_MASK) >> TOP_GAIN_TX1DBLOQGAIN_LSB)
#define TOP_GAIN_TX1DBLOQGAIN_SET(x)             (((x) << TOP_GAIN_TX1DBLOQGAIN_LSB) & TOP_GAIN_TX1DBLOQGAIN_MASK)
#define TOP_GAIN_TXV2IGAIN_MSB                   26
#define TOP_GAIN_TXV2IGAIN_LSB                   25
#define TOP_GAIN_TXV2IGAIN_MASK                  0x06000000
#define TOP_GAIN_TXV2IGAIN_GET(x)                (((x) & TOP_GAIN_TXV2IGAIN_MASK) >> TOP_GAIN_TXV2IGAIN_LSB)
#define TOP_GAIN_TXV2IGAIN_SET(x)                (((x) << TOP_GAIN_TXV2IGAIN_LSB) & TOP_GAIN_TXV2IGAIN_MASK)
#define TOP_GAIN_PABUF5GN_MSB                    24
#define TOP_GAIN_PABUF5GN_LSB                    24
#define TOP_GAIN_PABUF5GN_MASK                   0x01000000
#define TOP_GAIN_PABUF5GN_GET(x)                 (((x) & TOP_GAIN_PABUF5GN_MASK) >> TOP_GAIN_PABUF5GN_LSB)
#define TOP_GAIN_PABUF5GN_SET(x)                 (((x) << TOP_GAIN_PABUF5GN_LSB) & TOP_GAIN_PABUF5GN_MASK)
#define TOP_GAIN_PADRVGN_MSB                     23
#define TOP_GAIN_PADRVGN_LSB                     21
#define TOP_GAIN_PADRVGN_MASK                    0x00e00000
#define TOP_GAIN_PADRVGN_GET(x)                  (((x) & TOP_GAIN_PADRVGN_MASK) >> TOP_GAIN_PADRVGN_LSB)
#define TOP_GAIN_PADRVGN_SET(x)                  (((x) << TOP_GAIN_PADRVGN_LSB) & TOP_GAIN_PADRVGN_MASK)
#define TOP_GAIN_PAOUT2GN_MSB                    20
#define TOP_GAIN_PAOUT2GN_LSB                    18
#define TOP_GAIN_PAOUT2GN_MASK                   0x001c0000
#define TOP_GAIN_PAOUT2GN_GET(x)                 (((x) & TOP_GAIN_PAOUT2GN_MASK) >> TOP_GAIN_PAOUT2GN_LSB)
#define TOP_GAIN_PAOUT2GN_SET(x)                 (((x) << TOP_GAIN_PAOUT2GN_LSB) & TOP_GAIN_PAOUT2GN_MASK)
#define TOP_GAIN_LNAON_MSB                       17
#define TOP_GAIN_LNAON_LSB                       17
#define TOP_GAIN_LNAON_MASK                      0x00020000
#define TOP_GAIN_LNAON_GET(x)                    (((x) & TOP_GAIN_LNAON_MASK) >> TOP_GAIN_LNAON_LSB)
#define TOP_GAIN_LNAON_SET(x)                    (((x) << TOP_GAIN_LNAON_LSB) & TOP_GAIN_LNAON_MASK)
#define TOP_GAIN_LNAGAIN_MSB                     16
#define TOP_GAIN_LNAGAIN_LSB                     13
#define TOP_GAIN_LNAGAIN_MASK                    0x0001e000
#define TOP_GAIN_LNAGAIN_GET(x)                  (((x) & TOP_GAIN_LNAGAIN_MASK) >> TOP_GAIN_LNAGAIN_LSB)
#define TOP_GAIN_LNAGAIN_SET(x)                  (((x) << TOP_GAIN_LNAGAIN_LSB) & TOP_GAIN_LNAGAIN_MASK)
#define TOP_GAIN_RFVGA5GAIN_MSB                  12
#define TOP_GAIN_RFVGA5GAIN_LSB                  11
#define TOP_GAIN_RFVGA5GAIN_MASK                 0x00001800
#define TOP_GAIN_RFVGA5GAIN_GET(x)               (((x) & TOP_GAIN_RFVGA5GAIN_MASK) >> TOP_GAIN_RFVGA5GAIN_LSB)
#define TOP_GAIN_RFVGA5GAIN_SET(x)               (((x) << TOP_GAIN_RFVGA5GAIN_LSB) & TOP_GAIN_RFVGA5GAIN_MASK)
#define TOP_GAIN_RFGMGN_MSB                      10
#define TOP_GAIN_RFGMGN_LSB                      8
#define TOP_GAIN_RFGMGN_MASK                     0x00000700
#define TOP_GAIN_RFGMGN_GET(x)                   (((x) & TOP_GAIN_RFGMGN_MASK) >> TOP_GAIN_RFGMGN_LSB)
#define TOP_GAIN_RFGMGN_SET(x)                   (((x) << TOP_GAIN_RFGMGN_LSB) & TOP_GAIN_RFGMGN_MASK)
#define TOP_GAIN_RX6DBLOQGAIN_MSB                7
#define TOP_GAIN_RX6DBLOQGAIN_LSB                6
#define TOP_GAIN_RX6DBLOQGAIN_MASK               0x000000c0
#define TOP_GAIN_RX6DBLOQGAIN_GET(x)             (((x) & TOP_GAIN_RX6DBLOQGAIN_MASK) >> TOP_GAIN_RX6DBLOQGAIN_LSB)
#define TOP_GAIN_RX6DBLOQGAIN_SET(x)             (((x) << TOP_GAIN_RX6DBLOQGAIN_LSB) & TOP_GAIN_RX6DBLOQGAIN_MASK)
#define TOP_GAIN_RX1DBLOQGAIN_MSB                5
#define TOP_GAIN_RX1DBLOQGAIN_LSB                3
#define TOP_GAIN_RX1DBLOQGAIN_MASK               0x00000038
#define TOP_GAIN_RX1DBLOQGAIN_GET(x)             (((x) & TOP_GAIN_RX1DBLOQGAIN_MASK) >> TOP_GAIN_RX1DBLOQGAIN_LSB)
#define TOP_GAIN_RX1DBLOQGAIN_SET(x)             (((x) << TOP_GAIN_RX1DBLOQGAIN_LSB) & TOP_GAIN_RX1DBLOQGAIN_MASK)
#define TOP_GAIN_RX6DBHIQGAIN_MSB                2
#define TOP_GAIN_RX6DBHIQGAIN_LSB                1
#define TOP_GAIN_RX6DBHIQGAIN_MASK               0x00000006
#define TOP_GAIN_RX6DBHIQGAIN_GET(x)             (((x) & TOP_GAIN_RX6DBHIQGAIN_MASK) >> TOP_GAIN_RX6DBHIQGAIN_LSB)
#define TOP_GAIN_RX6DBHIQGAIN_SET(x)             (((x) << TOP_GAIN_RX6DBHIQGAIN_LSB) & TOP_GAIN_RX6DBHIQGAIN_MASK)
#define TOP_GAIN_SPARE_MSB                       0
#define TOP_GAIN_SPARE_LSB                       0
#define TOP_GAIN_SPARE_MASK                      0x00000001
#define TOP_GAIN_SPARE_GET(x)                    (((x) & TOP_GAIN_SPARE_MASK) >> TOP_GAIN_SPARE_LSB)
#define TOP_GAIN_SPARE_SET(x)                    (((x) << TOP_GAIN_SPARE_LSB) & TOP_GAIN_SPARE_MASK)

#define TOP_TOP_ADDRESS                          0x00000034
#define TOP_TOP_OFFSET                           0x00000034
#define TOP_TOP_LOCALTXGAIN_MSB                  31
#define TOP_TOP_LOCALTXGAIN_LSB                  31
#define TOP_TOP_LOCALTXGAIN_MASK                 0x80000000
#define TOP_TOP_LOCALTXGAIN_GET(x)               (((x) & TOP_TOP_LOCALTXGAIN_MASK) >> TOP_TOP_LOCALTXGAIN_LSB)
#define TOP_TOP_LOCALTXGAIN_SET(x)               (((x) << TOP_TOP_LOCALTXGAIN_LSB) & TOP_TOP_LOCALTXGAIN_MASK)
#define TOP_TOP_LOCALRXGAIN_MSB                  30
#define TOP_TOP_LOCALRXGAIN_LSB                  30
#define TOP_TOP_LOCALRXGAIN_MASK                 0x40000000
#define TOP_TOP_LOCALRXGAIN_GET(x)               (((x) & TOP_TOP_LOCALRXGAIN_MASK) >> TOP_TOP_LOCALRXGAIN_LSB)
#define TOP_TOP_LOCALRXGAIN_SET(x)               (((x) << TOP_TOP_LOCALRXGAIN_LSB) & TOP_TOP_LOCALRXGAIN_MASK)
#define TOP_TOP_LOCALMODE_MSB                    29
#define TOP_TOP_LOCALMODE_LSB                    29
#define TOP_TOP_LOCALMODE_MASK                   0x20000000
#define TOP_TOP_LOCALMODE_GET(x)                 (((x) & TOP_TOP_LOCALMODE_MASK) >> TOP_TOP_LOCALMODE_LSB)
#define TOP_TOP_LOCALMODE_SET(x)                 (((x) << TOP_TOP_LOCALMODE_LSB) & TOP_TOP_LOCALMODE_MASK)
#define TOP_TOP_CALFC_MSB                        28
#define TOP_TOP_CALFC_LSB                        28
#define TOP_TOP_CALFC_MASK                       0x10000000
#define TOP_TOP_CALFC_GET(x)                     (((x) & TOP_TOP_CALFC_MASK) >> TOP_TOP_CALFC_LSB)
#define TOP_TOP_CALFC_SET(x)                     (((x) << TOP_TOP_CALFC_LSB) & TOP_TOP_CALFC_MASK)
#define TOP_TOP_CALDC_MSB                        27
#define TOP_TOP_CALDC_LSB                        27
#define TOP_TOP_CALDC_MASK                       0x08000000
#define TOP_TOP_CALDC_GET(x)                     (((x) & TOP_TOP_CALDC_MASK) >> TOP_TOP_CALDC_LSB)
#define TOP_TOP_CALDC_SET(x)                     (((x) << TOP_TOP_CALDC_LSB) & TOP_TOP_CALDC_MASK)
#define TOP_TOP_CAL_RESIDUE_MSB                  26
#define TOP_TOP_CAL_RESIDUE_LSB                  26
#define TOP_TOP_CAL_RESIDUE_MASK                 0x04000000
#define TOP_TOP_CAL_RESIDUE_GET(x)               (((x) & TOP_TOP_CAL_RESIDUE_MASK) >> TOP_TOP_CAL_RESIDUE_LSB)
#define TOP_TOP_CAL_RESIDUE_SET(x)               (((x) << TOP_TOP_CAL_RESIDUE_LSB) & TOP_TOP_CAL_RESIDUE_MASK)
#define TOP_TOP_BMODE_MSB                        25
#define TOP_TOP_BMODE_LSB                        25
#define TOP_TOP_BMODE_MASK                       0x02000000
#define TOP_TOP_BMODE_GET(x)                     (((x) & TOP_TOP_BMODE_MASK) >> TOP_TOP_BMODE_LSB)
#define TOP_TOP_BMODE_SET(x)                     (((x) << TOP_TOP_BMODE_LSB) & TOP_TOP_BMODE_MASK)
#define TOP_TOP_SYNTHON_MSB                      24
#define TOP_TOP_SYNTHON_LSB                      24
#define TOP_TOP_SYNTHON_MASK                     0x01000000
#define TOP_TOP_SYNTHON_GET(x)                   (((x) & TOP_TOP_SYNTHON_MASK) >> TOP_TOP_SYNTHON_LSB)
#define TOP_TOP_SYNTHON_SET(x)                   (((x) << TOP_TOP_SYNTHON_LSB) & TOP_TOP_SYNTHON_MASK)
#define TOP_TOP_RXON_MSB                         23
#define TOP_TOP_RXON_LSB                         23
#define TOP_TOP_RXON_MASK                        0x00800000
#define TOP_TOP_RXON_GET(x)                      (((x) & TOP_TOP_RXON_MASK) >> TOP_TOP_RXON_LSB)
#define TOP_TOP_RXON_SET(x)                      (((x) << TOP_TOP_RXON_LSB) & TOP_TOP_RXON_MASK)
#define TOP_TOP_TXON_MSB                         22
#define TOP_TOP_TXON_LSB                         22
#define TOP_TOP_TXON_MASK                        0x00400000
#define TOP_TOP_TXON_GET(x)                      (((x) & TOP_TOP_TXON_MASK) >> TOP_TOP_TXON_LSB)
#define TOP_TOP_TXON_SET(x)                      (((x) << TOP_TOP_TXON_LSB) & TOP_TOP_TXON_MASK)
#define TOP_TOP_PAON_MSB                         21
#define TOP_TOP_PAON_LSB                         21
#define TOP_TOP_PAON_MASK                        0x00200000
#define TOP_TOP_PAON_GET(x)                      (((x) & TOP_TOP_PAON_MASK) >> TOP_TOP_PAON_LSB)
#define TOP_TOP_PAON_SET(x)                      (((x) << TOP_TOP_PAON_LSB) & TOP_TOP_PAON_MASK)
#define TOP_TOP_CALTX_MSB                        20
#define TOP_TOP_CALTX_LSB                        20
#define TOP_TOP_CALTX_MASK                       0x00100000
#define TOP_TOP_CALTX_GET(x)                     (((x) & TOP_TOP_CALTX_MASK) >> TOP_TOP_CALTX_LSB)
#define TOP_TOP_CALTX_SET(x)                     (((x) << TOP_TOP_CALTX_LSB) & TOP_TOP_CALTX_MASK)
#define TOP_TOP_LOCALADDAC_MSB                   19
#define TOP_TOP_LOCALADDAC_LSB                   19
#define TOP_TOP_LOCALADDAC_MASK                  0x00080000
#define TOP_TOP_LOCALADDAC_GET(x)                (((x) & TOP_TOP_LOCALADDAC_MASK) >> TOP_TOP_LOCALADDAC_LSB)
#define TOP_TOP_LOCALADDAC_SET(x)                (((x) << TOP_TOP_LOCALADDAC_LSB) & TOP_TOP_LOCALADDAC_MASK)
#define TOP_TOP_PWDPLL_MSB                       18
#define TOP_TOP_PWDPLL_LSB                       18
#define TOP_TOP_PWDPLL_MASK                      0x00040000
#define TOP_TOP_PWDPLL_GET(x)                    (((x) & TOP_TOP_PWDPLL_MASK) >> TOP_TOP_PWDPLL_LSB)
#define TOP_TOP_PWDPLL_SET(x)                    (((x) << TOP_TOP_PWDPLL_LSB) & TOP_TOP_PWDPLL_MASK)
#define TOP_TOP_PWDADC_MSB                       17
#define TOP_TOP_PWDADC_LSB                       17
#define TOP_TOP_PWDADC_MASK                      0x00020000
#define TOP_TOP_PWDADC_GET(x)                    (((x) & TOP_TOP_PWDADC_MASK) >> TOP_TOP_PWDADC_LSB)
#define TOP_TOP_PWDADC_SET(x)                    (((x) << TOP_TOP_PWDADC_LSB) & TOP_TOP_PWDADC_MASK)
#define TOP_TOP_PWDDAC_MSB                       16
#define TOP_TOP_PWDDAC_LSB                       16
#define TOP_TOP_PWDDAC_MASK                      0x00010000
#define TOP_TOP_PWDDAC_GET(x)                    (((x) & TOP_TOP_PWDDAC_MASK) >> TOP_TOP_PWDDAC_LSB)
#define TOP_TOP_PWDDAC_SET(x)                    (((x) << TOP_TOP_PWDDAC_LSB) & TOP_TOP_PWDDAC_MASK)
#define TOP_TOP_LOCALXTAL_MSB                    15
#define TOP_TOP_LOCALXTAL_LSB                    15
#define TOP_TOP_LOCALXTAL_MASK                   0x00008000
#define TOP_TOP_LOCALXTAL_GET(x)                 (((x) & TOP_TOP_LOCALXTAL_MASK) >> TOP_TOP_LOCALXTAL_LSB)
#define TOP_TOP_LOCALXTAL_SET(x)                 (((x) << TOP_TOP_LOCALXTAL_LSB) & TOP_TOP_LOCALXTAL_MASK)
#define TOP_TOP_PWDCLKIN_MSB                     14
#define TOP_TOP_PWDCLKIN_LSB                     14
#define TOP_TOP_PWDCLKIN_MASK                    0x00004000
#define TOP_TOP_PWDCLKIN_GET(x)                  (((x) & TOP_TOP_PWDCLKIN_MASK) >> TOP_TOP_PWDCLKIN_LSB)
#define TOP_TOP_PWDCLKIN_SET(x)                  (((x) << TOP_TOP_PWDCLKIN_LSB) & TOP_TOP_PWDCLKIN_MASK)
#define TOP_TOP_OSCON_MSB                        13
#define TOP_TOP_OSCON_LSB                        13
#define TOP_TOP_OSCON_MASK                       0x00002000
#define TOP_TOP_OSCON_GET(x)                     (((x) & TOP_TOP_OSCON_MASK) >> TOP_TOP_OSCON_LSB)
#define TOP_TOP_OSCON_SET(x)                     (((x) << TOP_TOP_OSCON_LSB) & TOP_TOP_OSCON_MASK)
#define TOP_TOP_SCLKEN_FORCE_MSB                 12
#define TOP_TOP_SCLKEN_FORCE_LSB                 12
#define TOP_TOP_SCLKEN_FORCE_MASK                0x00001000
#define TOP_TOP_SCLKEN_FORCE_GET(x)              (((x) & TOP_TOP_SCLKEN_FORCE_MASK) >> TOP_TOP_SCLKEN_FORCE_LSB)
#define TOP_TOP_SCLKEN_FORCE_SET(x)              (((x) << TOP_TOP_SCLKEN_FORCE_LSB) & TOP_TOP_SCLKEN_FORCE_MASK)
#define TOP_TOP_SYNTHON_FORCE_MSB                11
#define TOP_TOP_SYNTHON_FORCE_LSB                11
#define TOP_TOP_SYNTHON_FORCE_MASK               0x00000800
#define TOP_TOP_SYNTHON_FORCE_GET(x)             (((x) & TOP_TOP_SYNTHON_FORCE_MASK) >> TOP_TOP_SYNTHON_FORCE_LSB)
#define TOP_TOP_SYNTHON_FORCE_SET(x)             (((x) << TOP_TOP_SYNTHON_FORCE_LSB) & TOP_TOP_SYNTHON_FORCE_MASK)
#define TOP_TOP_PDBIAS_MSB                       10
#define TOP_TOP_PDBIAS_LSB                       10
#define TOP_TOP_PDBIAS_MASK                      0x00000400
#define TOP_TOP_PDBIAS_GET(x)                    (((x) & TOP_TOP_PDBIAS_MASK) >> TOP_TOP_PDBIAS_LSB)
#define TOP_TOP_PDBIAS_SET(x)                    (((x) << TOP_TOP_PDBIAS_LSB) & TOP_TOP_PDBIAS_MASK)
#define TOP_TOP_DATAOUTSEL_MSB                   9
#define TOP_TOP_DATAOUTSEL_LSB                   8
#define TOP_TOP_DATAOUTSEL_MASK                  0x00000300
#define TOP_TOP_DATAOUTSEL_GET(x)                (((x) & TOP_TOP_DATAOUTSEL_MASK) >> TOP_TOP_DATAOUTSEL_LSB)
#define TOP_TOP_DATAOUTSEL_SET(x)                (((x) << TOP_TOP_DATAOUTSEL_LSB) & TOP_TOP_DATAOUTSEL_MASK)
#define TOP_TOP_REVID_MSB                        7
#define TOP_TOP_REVID_LSB                        5
#define TOP_TOP_REVID_MASK                       0x000000e0
#define TOP_TOP_REVID_GET(x)                     (((x) & TOP_TOP_REVID_MASK) >> TOP_TOP_REVID_LSB)
#define TOP_TOP_REVID_SET(x)                     (((x) << TOP_TOP_REVID_LSB) & TOP_TOP_REVID_MASK)
#define TOP_TOP_INT2PAD_MSB                      4
#define TOP_TOP_INT2PAD_LSB                      4
#define TOP_TOP_INT2PAD_MASK                     0x00000010
#define TOP_TOP_INT2PAD_GET(x)                   (((x) & TOP_TOP_INT2PAD_MASK) >> TOP_TOP_INT2PAD_LSB)
#define TOP_TOP_INT2PAD_SET(x)                   (((x) << TOP_TOP_INT2PAD_LSB) & TOP_TOP_INT2PAD_MASK)
#define TOP_TOP_INTH2PAD_MSB                     3
#define TOP_TOP_INTH2PAD_LSB                     3
#define TOP_TOP_INTH2PAD_MASK                    0x00000008
#define TOP_TOP_INTH2PAD_GET(x)                  (((x) & TOP_TOP_INTH2PAD_MASK) >> TOP_TOP_INTH2PAD_LSB)
#define TOP_TOP_INTH2PAD_SET(x)                  (((x) << TOP_TOP_INTH2PAD_LSB) & TOP_TOP_INTH2PAD_MASK)
#define TOP_TOP_PAD2GND_MSB                      2
#define TOP_TOP_PAD2GND_LSB                      2
#define TOP_TOP_PAD2GND_MASK                     0x00000004
#define TOP_TOP_PAD2GND_GET(x)                   (((x) & TOP_TOP_PAD2GND_MASK) >> TOP_TOP_PAD2GND_LSB)
#define TOP_TOP_PAD2GND_SET(x)                   (((x) << TOP_TOP_PAD2GND_LSB) & TOP_TOP_PAD2GND_MASK)
#define TOP_TOP_INT2GND_MSB                      1
#define TOP_TOP_INT2GND_LSB                      1
#define TOP_TOP_INT2GND_MASK                     0x00000002
#define TOP_TOP_INT2GND_GET(x)                   (((x) & TOP_TOP_INT2GND_MASK) >> TOP_TOP_INT2GND_LSB)
#define TOP_TOP_INT2GND_SET(x)                   (((x) << TOP_TOP_INT2GND_LSB) & TOP_TOP_INT2GND_MASK)
#define TOP_TOP_FORCE_XPAON_MSB                  0
#define TOP_TOP_FORCE_XPAON_LSB                  0
#define TOP_TOP_FORCE_XPAON_MASK                 0x00000001
#define TOP_TOP_FORCE_XPAON_GET(x)               (((x) & TOP_TOP_FORCE_XPAON_MASK) >> TOP_TOP_FORCE_XPAON_LSB)
#define TOP_TOP_FORCE_XPAON_SET(x)               (((x) << TOP_TOP_FORCE_XPAON_LSB) & TOP_TOP_FORCE_XPAON_MASK)

#define BIAS_BIAS_SEL_ADDRESS                    0x00000038
#define BIAS_BIAS_SEL_OFFSET                     0x00000038
#define BIAS_BIAS_SEL_PADON_MSB                  31
#define BIAS_BIAS_SEL_PADON_LSB                  31
#define BIAS_BIAS_SEL_PADON_MASK                 0x80000000
#define BIAS_BIAS_SEL_PADON_GET(x)               (((x) & BIAS_BIAS_SEL_PADON_MASK) >> BIAS_BIAS_SEL_PADON_LSB)
#define BIAS_BIAS_SEL_PADON_SET(x)               (((x) << BIAS_BIAS_SEL_PADON_LSB) & BIAS_BIAS_SEL_PADON_MASK)
#define BIAS_BIAS_SEL_SEL_BIAS_MSB               30
#define BIAS_BIAS_SEL_SEL_BIAS_LSB               25
#define BIAS_BIAS_SEL_SEL_BIAS_MASK              0x7e000000
#define BIAS_BIAS_SEL_SEL_BIAS_GET(x)            (((x) & BIAS_BIAS_SEL_SEL_BIAS_MASK) >> BIAS_BIAS_SEL_SEL_BIAS_LSB)
#define BIAS_BIAS_SEL_SEL_BIAS_SET(x)            (((x) << BIAS_BIAS_SEL_SEL_BIAS_LSB) & BIAS_BIAS_SEL_SEL_BIAS_MASK)
#define BIAS_BIAS_SEL_SEL_SPARE_MSB              24
#define BIAS_BIAS_SEL_SEL_SPARE_LSB              21
#define BIAS_BIAS_SEL_SEL_SPARE_MASK             0x01e00000
#define BIAS_BIAS_SEL_SEL_SPARE_GET(x)           (((x) & BIAS_BIAS_SEL_SEL_SPARE_MASK) >> BIAS_BIAS_SEL_SEL_SPARE_LSB)
#define BIAS_BIAS_SEL_SEL_SPARE_SET(x)           (((x) << BIAS_BIAS_SEL_SEL_SPARE_LSB) & BIAS_BIAS_SEL_SEL_SPARE_MASK)
#define BIAS_BIAS_SEL_SPARE_MSB                  20
#define BIAS_BIAS_SEL_SPARE_LSB                  20
#define BIAS_BIAS_SEL_SPARE_MASK                 0x00100000
#define BIAS_BIAS_SEL_SPARE_GET(x)               (((x) & BIAS_BIAS_SEL_SPARE_MASK) >> BIAS_BIAS_SEL_SPARE_LSB)
#define BIAS_BIAS_SEL_SPARE_SET(x)               (((x) << BIAS_BIAS_SEL_SPARE_LSB) & BIAS_BIAS_SEL_SPARE_MASK)
#define BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_MSB   19
#define BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_LSB   17
#define BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_MASK  0x000e0000
#define BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_GET(x) (((x) & BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_MASK) >> BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_LSB)
#define BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_SET(x) (((x) << BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_LSB) & BIAS_BIAS_SEL_PWD_ICREFBUFBIAS12P5_MASK)
#define BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_MSB    16
#define BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_LSB    16
#define BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_MASK   0x00010000
#define BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_GET(x) (((x) & BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_MASK) >> BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_LSB)
#define BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_SET(x) (((x) << BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_LSB) & BIAS_BIAS_SEL_PWD_IRDACREGREF12P5_MASK)
#define BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_MSB 15
#define BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_LSB 15
#define BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_MASK 0x00008000
#define BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_GET(x) (((x) & BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_MASK) >> BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_LSB)
#define BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_SET(x) (((x) << BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_LSB) & BIAS_BIAS_SEL_PWD_IRREFMASTERBIAS12P5_MASK)
#define BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_MSB   14
#define BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_LSB   14
#define BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_MASK  0x00004000
#define BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_GET(x) (((x) & BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_MASK) >> BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_LSB)
#define BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_SET(x) (((x) << BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_LSB) & BIAS_BIAS_SEL_PWD_ICREFOPAMPBIAS25_MASK)
#define BIAS_BIAS_SEL_PWD_ICCPLL25_MSB           13
#define BIAS_BIAS_SEL_PWD_ICCPLL25_LSB           13
#define BIAS_BIAS_SEL_PWD_ICCPLL25_MASK          0x00002000
#define BIAS_BIAS_SEL_PWD_ICCPLL25_GET(x)        (((x) & BIAS_BIAS_SEL_PWD_ICCPLL25_MASK) >> BIAS_BIAS_SEL_PWD_ICCPLL25_LSB)
#define BIAS_BIAS_SEL_PWD_ICCPLL25_SET(x)        (((x) << BIAS_BIAS_SEL_PWD_ICCPLL25_LSB) & BIAS_BIAS_SEL_PWD_ICCPLL25_MASK)
#define BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_MSB       12
#define BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_LSB       10
#define BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_MASK      0x00001c00
#define BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_GET(x)    (((x) & BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_MASK) >> BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_LSB)
#define BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_SET(x)    (((x) << BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_LSB) & BIAS_BIAS_SEL_PWD_ICCOMPBIAS25_MASK)
#define BIAS_BIAS_SEL_PWD_ICXTAL25_MSB           9
#define BIAS_BIAS_SEL_PWD_ICXTAL25_LSB           7
#define BIAS_BIAS_SEL_PWD_ICXTAL25_MASK          0x00000380
#define BIAS_BIAS_SEL_PWD_ICXTAL25_GET(x)        (((x) & BIAS_BIAS_SEL_PWD_ICXTAL25_MASK) >> BIAS_BIAS_SEL_PWD_ICXTAL25_LSB)
#define BIAS_BIAS_SEL_PWD_ICXTAL25_SET(x)        (((x) << BIAS_BIAS_SEL_PWD_ICXTAL25_LSB) & BIAS_BIAS_SEL_PWD_ICXTAL25_MASK)
#define BIAS_BIAS_SEL_PWD_ICTSENS25_MSB          6
#define BIAS_BIAS_SEL_PWD_ICTSENS25_LSB          4
#define BIAS_BIAS_SEL_PWD_ICTSENS25_MASK         0x00000070
#define BIAS_BIAS_SEL_PWD_ICTSENS25_GET(x)       (((x) & BIAS_BIAS_SEL_PWD_ICTSENS25_MASK) >> BIAS_BIAS_SEL_PWD_ICTSENS25_LSB)
#define BIAS_BIAS_SEL_PWD_ICTSENS25_SET(x)       (((x) << BIAS_BIAS_SEL_PWD_ICTSENS25_LSB) & BIAS_BIAS_SEL_PWD_ICTSENS25_MASK)
#define BIAS_BIAS_SEL_PWD_ICTXPC25_MSB           3
#define BIAS_BIAS_SEL_PWD_ICTXPC25_LSB           1
#define BIAS_BIAS_SEL_PWD_ICTXPC25_MASK          0x0000000e
#define BIAS_BIAS_SEL_PWD_ICTXPC25_GET(x)        (((x) & BIAS_BIAS_SEL_PWD_ICTXPC25_MASK) >> BIAS_BIAS_SEL_PWD_ICTXPC25_LSB)
#define BIAS_BIAS_SEL_PWD_ICTXPC25_SET(x)        (((x) << BIAS_BIAS_SEL_PWD_ICTXPC25_LSB) & BIAS_BIAS_SEL_PWD_ICTXPC25_MASK)
#define BIAS_BIAS_SEL_PWD_ICLDO25_MSB            0
#define BIAS_BIAS_SEL_PWD_ICLDO25_LSB            0
#define BIAS_BIAS_SEL_PWD_ICLDO25_MASK           0x00000001
#define BIAS_BIAS_SEL_PWD_ICLDO25_GET(x)         (((x) & BIAS_BIAS_SEL_PWD_ICLDO25_MASK) >> BIAS_BIAS_SEL_PWD_ICLDO25_LSB)
#define BIAS_BIAS_SEL_PWD_ICLDO25_SET(x)         (((x) << BIAS_BIAS_SEL_PWD_ICLDO25_LSB) & BIAS_BIAS_SEL_PWD_ICLDO25_MASK)

#define BIAS_BIAS1_ADDRESS                       0x0000003c
#define BIAS_BIAS1_OFFSET                        0x0000003c
#define BIAS_BIAS1_PWD_ICDAC2BB25_MSB            31
#define BIAS_BIAS1_PWD_ICDAC2BB25_LSB            29
#define BIAS_BIAS1_PWD_ICDAC2BB25_MASK           0xe0000000
#define BIAS_BIAS1_PWD_ICDAC2BB25_GET(x)         (((x) & BIAS_BIAS1_PWD_ICDAC2BB25_MASK) >> BIAS_BIAS1_PWD_ICDAC2BB25_LSB)
#define BIAS_BIAS1_PWD_ICDAC2BB25_SET(x)         (((x) << BIAS_BIAS1_PWD_ICDAC2BB25_LSB) & BIAS_BIAS1_PWD_ICDAC2BB25_MASK)
#define BIAS_BIAS1_PWD_IC2GVGM25_MSB             28
#define BIAS_BIAS1_PWD_IC2GVGM25_LSB             26
#define BIAS_BIAS1_PWD_IC2GVGM25_MASK            0x1c000000
#define BIAS_BIAS1_PWD_IC2GVGM25_GET(x)          (((x) & BIAS_BIAS1_PWD_IC2GVGM25_MASK) >> BIAS_BIAS1_PWD_IC2GVGM25_LSB)
#define BIAS_BIAS1_PWD_IC2GVGM25_SET(x)          (((x) << BIAS_BIAS1_PWD_IC2GVGM25_LSB) & BIAS_BIAS1_PWD_IC2GVGM25_MASK)
#define BIAS_BIAS1_PWD_IC2GRFFE25_MSB            25
#define BIAS_BIAS1_PWD_IC2GRFFE25_LSB            23
#define BIAS_BIAS1_PWD_IC2GRFFE25_MASK           0x03800000
#define BIAS_BIAS1_PWD_IC2GRFFE25_GET(x)         (((x) & BIAS_BIAS1_PWD_IC2GRFFE25_MASK) >> BIAS_BIAS1_PWD_IC2GRFFE25_LSB)
#define BIAS_BIAS1_PWD_IC2GRFFE25_SET(x)         (((x) << BIAS_BIAS1_PWD_IC2GRFFE25_LSB) & BIAS_BIAS1_PWD_IC2GRFFE25_MASK)
#define BIAS_BIAS1_PWD_IC2GLOREG25_MSB           22
#define BIAS_BIAS1_PWD_IC2GLOREG25_LSB           20
#define BIAS_BIAS1_PWD_IC2GLOREG25_MASK          0x00700000
#define BIAS_BIAS1_PWD_IC2GLOREG25_GET(x)        (((x) & BIAS_BIAS1_PWD_IC2GLOREG25_MASK) >> BIAS_BIAS1_PWD_IC2GLOREG25_LSB)
#define BIAS_BIAS1_PWD_IC2GLOREG25_SET(x)        (((x) << BIAS_BIAS1_PWD_IC2GLOREG25_LSB) & BIAS_BIAS1_PWD_IC2GLOREG25_MASK)
#define BIAS_BIAS1_PWD_IC2GLNAREG25_MSB          19
#define BIAS_BIAS1_PWD_IC2GLNAREG25_LSB          17
#define BIAS_BIAS1_PWD_IC2GLNAREG25_MASK         0x000e0000
#define BIAS_BIAS1_PWD_IC2GLNAREG25_GET(x)       (((x) & BIAS_BIAS1_PWD_IC2GLNAREG25_MASK) >> BIAS_BIAS1_PWD_IC2GLNAREG25_LSB)
#define BIAS_BIAS1_PWD_IC2GLNAREG25_SET(x)       (((x) << BIAS_BIAS1_PWD_IC2GLNAREG25_LSB) & BIAS_BIAS1_PWD_IC2GLNAREG25_MASK)
#define BIAS_BIAS1_PWD_ICDETECTORB25_MSB         16
#define BIAS_BIAS1_PWD_ICDETECTORB25_LSB         16
#define BIAS_BIAS1_PWD_ICDETECTORB25_MASK        0x00010000
#define BIAS_BIAS1_PWD_ICDETECTORB25_GET(x)      (((x) & BIAS_BIAS1_PWD_ICDETECTORB25_MASK) >> BIAS_BIAS1_PWD_ICDETECTORB25_LSB)
#define BIAS_BIAS1_PWD_ICDETECTORB25_SET(x)      (((x) << BIAS_BIAS1_PWD_ICDETECTORB25_LSB) & BIAS_BIAS1_PWD_ICDETECTORB25_MASK)
#define BIAS_BIAS1_PWD_ICDETECTORA25_MSB         15
#define BIAS_BIAS1_PWD_ICDETECTORA25_LSB         15
#define BIAS_BIAS1_PWD_ICDETECTORA25_MASK        0x00008000
#define BIAS_BIAS1_PWD_ICDETECTORA25_GET(x)      (((x) & BIAS_BIAS1_PWD_ICDETECTORA25_MASK) >> BIAS_BIAS1_PWD_ICDETECTORA25_LSB)
#define BIAS_BIAS1_PWD_ICDETECTORA25_SET(x)      (((x) << BIAS_BIAS1_PWD_ICDETECTORA25_LSB) & BIAS_BIAS1_PWD_ICDETECTORA25_MASK)
#define BIAS_BIAS1_PWD_IC5GRXRF25_MSB            14
#define BIAS_BIAS1_PWD_IC5GRXRF25_LSB            14
#define BIAS_BIAS1_PWD_IC5GRXRF25_MASK           0x00004000
#define BIAS_BIAS1_PWD_IC5GRXRF25_GET(x)         (((x) & BIAS_BIAS1_PWD_IC5GRXRF25_MASK) >> BIAS_BIAS1_PWD_IC5GRXRF25_LSB)
#define BIAS_BIAS1_PWD_IC5GRXRF25_SET(x)         (((x) << BIAS_BIAS1_PWD_IC5GRXRF25_LSB) & BIAS_BIAS1_PWD_IC5GRXRF25_MASK)
#define BIAS_BIAS1_PWD_IC5GTXPA25_MSB            13
#define BIAS_BIAS1_PWD_IC5GTXPA25_LSB            11
#define BIAS_BIAS1_PWD_IC5GTXPA25_MASK           0x00003800
#define BIAS_BIAS1_PWD_IC5GTXPA25_GET(x)         (((x) & BIAS_BIAS1_PWD_IC5GTXPA25_MASK) >> BIAS_BIAS1_PWD_IC5GTXPA25_LSB)
#define BIAS_BIAS1_PWD_IC5GTXPA25_SET(x)         (((x) << BIAS_BIAS1_PWD_IC5GTXPA25_LSB) & BIAS_BIAS1_PWD_IC5GTXPA25_MASK)
#define BIAS_BIAS1_PWD_IC5GTXBUF25_MSB           10
#define BIAS_BIAS1_PWD_IC5GTXBUF25_LSB           8
#define BIAS_BIAS1_PWD_IC5GTXBUF25_MASK          0x00000700
#define BIAS_BIAS1_PWD_IC5GTXBUF25_GET(x)        (((x) & BIAS_BIAS1_PWD_IC5GTXBUF25_MASK) >> BIAS_BIAS1_PWD_IC5GTXBUF25_LSB)
#define BIAS_BIAS1_PWD_IC5GTXBUF25_SET(x)        (((x) << BIAS_BIAS1_PWD_IC5GTXBUF25_LSB) & BIAS_BIAS1_PWD_IC5GTXBUF25_MASK)
#define BIAS_BIAS1_PWD_IC5GQB25_MSB              7
#define BIAS_BIAS1_PWD_IC5GQB25_LSB              5
#define BIAS_BIAS1_PWD_IC5GQB25_MASK             0x000000e0
#define BIAS_BIAS1_PWD_IC5GQB25_GET(x)           (((x) & BIAS_BIAS1_PWD_IC5GQB25_MASK) >> BIAS_BIAS1_PWD_IC5GQB25_LSB)
#define BIAS_BIAS1_PWD_IC5GQB25_SET(x)           (((x) << BIAS_BIAS1_PWD_IC5GQB25_LSB) & BIAS_BIAS1_PWD_IC5GQB25_MASK)
#define BIAS_BIAS1_PWD_IC5GMIXQ25_MSB            4
#define BIAS_BIAS1_PWD_IC5GMIXQ25_LSB            2
#define BIAS_BIAS1_PWD_IC5GMIXQ25_MASK           0x0000001c
#define BIAS_BIAS1_PWD_IC5GMIXQ25_GET(x)         (((x) & BIAS_BIAS1_PWD_IC5GMIXQ25_MASK) >> BIAS_BIAS1_PWD_IC5GMIXQ25_LSB)
#define BIAS_BIAS1_PWD_IC5GMIXQ25_SET(x)         (((x) << BIAS_BIAS1_PWD_IC5GMIXQ25_LSB) & BIAS_BIAS1_PWD_IC5GMIXQ25_MASK)
#define BIAS_BIAS1_SPARE_MSB                     1
#define BIAS_BIAS1_SPARE_LSB                     0
#define BIAS_BIAS1_SPARE_MASK                    0x00000003
#define BIAS_BIAS1_SPARE_GET(x)                  (((x) & BIAS_BIAS1_SPARE_MASK) >> BIAS_BIAS1_SPARE_LSB)
#define BIAS_BIAS1_SPARE_SET(x)                  (((x) << BIAS_BIAS1_SPARE_LSB) & BIAS_BIAS1_SPARE_MASK)

#define BIAS_BIAS2_ADDRESS                       0x00000040
#define BIAS_BIAS2_OFFSET                        0x00000040
#define BIAS_BIAS2_PWD_IC5GMIXI25_MSB            31
#define BIAS_BIAS2_PWD_IC5GMIXI25_LSB            29
#define BIAS_BIAS2_PWD_IC5GMIXI25_MASK           0xe0000000
#define BIAS_BIAS2_PWD_IC5GMIXI25_GET(x)         (((x) & BIAS_BIAS2_PWD_IC5GMIXI25_MASK) >> BIAS_BIAS2_PWD_IC5GMIXI25_LSB)
#define BIAS_BIAS2_PWD_IC5GMIXI25_SET(x)         (((x) << BIAS_BIAS2_PWD_IC5GMIXI25_LSB) & BIAS_BIAS2_PWD_IC5GMIXI25_MASK)
#define BIAS_BIAS2_PWD_IC5GDIV25_MSB             28
#define BIAS_BIAS2_PWD_IC5GDIV25_LSB             26
#define BIAS_BIAS2_PWD_IC5GDIV25_MASK            0x1c000000
#define BIAS_BIAS2_PWD_IC5GDIV25_GET(x)          (((x) & BIAS_BIAS2_PWD_IC5GDIV25_MASK) >> BIAS_BIAS2_PWD_IC5GDIV25_LSB)
#define BIAS_BIAS2_PWD_IC5GDIV25_SET(x)          (((x) << BIAS_BIAS2_PWD_IC5GDIV25_LSB) & BIAS_BIAS2_PWD_IC5GDIV25_MASK)
#define BIAS_BIAS2_PWD_IC5GLOREG25_MSB           25
#define BIAS_BIAS2_PWD_IC5GLOREG25_LSB           23
#define BIAS_BIAS2_PWD_IC5GLOREG25_MASK          0x03800000
#define BIAS_BIAS2_PWD_IC5GLOREG25_GET(x)        (((x) & BIAS_BIAS2_PWD_IC5GLOREG25_MASK) >> BIAS_BIAS2_PWD_IC5GLOREG25_LSB)
#define BIAS_BIAS2_PWD_IC5GLOREG25_SET(x)        (((x) << BIAS_BIAS2_PWD_IC5GLOREG25_LSB) & BIAS_BIAS2_PWD_IC5GLOREG25_MASK)
#define BIAS_BIAS2_PWD_IRPLL25_MSB               22
#define BIAS_BIAS2_PWD_IRPLL25_LSB               22
#define BIAS_BIAS2_PWD_IRPLL25_MASK              0x00400000
#define BIAS_BIAS2_PWD_IRPLL25_GET(x)            (((x) & BIAS_BIAS2_PWD_IRPLL25_MASK) >> BIAS_BIAS2_PWD_IRPLL25_LSB)
#define BIAS_BIAS2_PWD_IRPLL25_SET(x)            (((x) << BIAS_BIAS2_PWD_IRPLL25_LSB) & BIAS_BIAS2_PWD_IRPLL25_MASK)
#define BIAS_BIAS2_PWD_IRXTAL25_MSB              21
#define BIAS_BIAS2_PWD_IRXTAL25_LSB              19
#define BIAS_BIAS2_PWD_IRXTAL25_MASK             0x00380000
#define BIAS_BIAS2_PWD_IRXTAL25_GET(x)           (((x) & BIAS_BIAS2_PWD_IRXTAL25_MASK) >> BIAS_BIAS2_PWD_IRXTAL25_LSB)
#define BIAS_BIAS2_PWD_IRXTAL25_SET(x)           (((x) << BIAS_BIAS2_PWD_IRXTAL25_LSB) & BIAS_BIAS2_PWD_IRXTAL25_MASK)
#define BIAS_BIAS2_PWD_IRTSENS25_MSB             18
#define BIAS_BIAS2_PWD_IRTSENS25_LSB             16
#define BIAS_BIAS2_PWD_IRTSENS25_MASK            0x00070000
#define BIAS_BIAS2_PWD_IRTSENS25_GET(x)          (((x) & BIAS_BIAS2_PWD_IRTSENS25_MASK) >> BIAS_BIAS2_PWD_IRTSENS25_LSB)
#define BIAS_BIAS2_PWD_IRTSENS25_SET(x)          (((x) << BIAS_BIAS2_PWD_IRTSENS25_LSB) & BIAS_BIAS2_PWD_IRTSENS25_MASK)
#define BIAS_BIAS2_PWD_IRTXPC25_MSB              15
#define BIAS_BIAS2_PWD_IRTXPC25_LSB              13
#define BIAS_BIAS2_PWD_IRTXPC25_MASK             0x0000e000
#define BIAS_BIAS2_PWD_IRTXPC25_GET(x)           (((x) & BIAS_BIAS2_PWD_IRTXPC25_MASK) >> BIAS_BIAS2_PWD_IRTXPC25_LSB)
#define BIAS_BIAS2_PWD_IRTXPC25_SET(x)           (((x) << BIAS_BIAS2_PWD_IRTXPC25_LSB) & BIAS_BIAS2_PWD_IRTXPC25_MASK)
#define BIAS_BIAS2_PWD_IRLDO25_MSB               12
#define BIAS_BIAS2_PWD_IRLDO25_LSB               12
#define BIAS_BIAS2_PWD_IRLDO25_MASK              0x00001000
#define BIAS_BIAS2_PWD_IRLDO25_GET(x)            (((x) & BIAS_BIAS2_PWD_IRLDO25_MASK) >> BIAS_BIAS2_PWD_IRLDO25_LSB)
#define BIAS_BIAS2_PWD_IRLDO25_SET(x)            (((x) << BIAS_BIAS2_PWD_IRLDO25_LSB) & BIAS_BIAS2_PWD_IRLDO25_MASK)
#define BIAS_BIAS2_PWD_IR2GTXMIX25_MSB           11
#define BIAS_BIAS2_PWD_IR2GTXMIX25_LSB           9
#define BIAS_BIAS2_PWD_IR2GTXMIX25_MASK          0x00000e00
#define BIAS_BIAS2_PWD_IR2GTXMIX25_GET(x)        (((x) & BIAS_BIAS2_PWD_IR2GTXMIX25_MASK) >> BIAS_BIAS2_PWD_IR2GTXMIX25_LSB)
#define BIAS_BIAS2_PWD_IR2GTXMIX25_SET(x)        (((x) << BIAS_BIAS2_PWD_IR2GTXMIX25_LSB) & BIAS_BIAS2_PWD_IR2GTXMIX25_MASK)
#define BIAS_BIAS2_PWD_IR2GLOREG25_MSB           8
#define BIAS_BIAS2_PWD_IR2GLOREG25_LSB           6
#define BIAS_BIAS2_PWD_IR2GLOREG25_MASK          0x000001c0
#define BIAS_BIAS2_PWD_IR2GLOREG25_GET(x)        (((x) & BIAS_BIAS2_PWD_IR2GLOREG25_MASK) >> BIAS_BIAS2_PWD_IR2GLOREG25_LSB)
#define BIAS_BIAS2_PWD_IR2GLOREG25_SET(x)        (((x) << BIAS_BIAS2_PWD_IR2GLOREG25_LSB) & BIAS_BIAS2_PWD_IR2GLOREG25_MASK)
#define BIAS_BIAS2_PWD_IR2GLNAREG25_MSB          5
#define BIAS_BIAS2_PWD_IR2GLNAREG25_LSB          3
#define BIAS_BIAS2_PWD_IR2GLNAREG25_MASK         0x00000038
#define BIAS_BIAS2_PWD_IR2GLNAREG25_GET(x)       (((x) & BIAS_BIAS2_PWD_IR2GLNAREG25_MASK) >> BIAS_BIAS2_PWD_IR2GLNAREG25_LSB)
#define BIAS_BIAS2_PWD_IR2GLNAREG25_SET(x)       (((x) << BIAS_BIAS2_PWD_IR2GLNAREG25_LSB) & BIAS_BIAS2_PWD_IR2GLNAREG25_MASK)
#define BIAS_BIAS2_PWD_IR5GRFVREF2525_MSB        2
#define BIAS_BIAS2_PWD_IR5GRFVREF2525_LSB        0
#define BIAS_BIAS2_PWD_IR5GRFVREF2525_MASK       0x00000007
#define BIAS_BIAS2_PWD_IR5GRFVREF2525_GET(x)     (((x) & BIAS_BIAS2_PWD_IR5GRFVREF2525_MASK) >> BIAS_BIAS2_PWD_IR5GRFVREF2525_LSB)
#define BIAS_BIAS2_PWD_IR5GRFVREF2525_SET(x)     (((x) << BIAS_BIAS2_PWD_IR5GRFVREF2525_LSB) & BIAS_BIAS2_PWD_IR5GRFVREF2525_MASK)

#define BIAS_BIAS3_ADDRESS                       0x00000044
#define BIAS_BIAS3_OFFSET                        0x00000044
#define BIAS_BIAS3_PWD_IR5GTXMIX25_MSB           31
#define BIAS_BIAS3_PWD_IR5GTXMIX25_LSB           29
#define BIAS_BIAS3_PWD_IR5GTXMIX25_MASK          0xe0000000
#define BIAS_BIAS3_PWD_IR5GTXMIX25_GET(x)        (((x) & BIAS_BIAS3_PWD_IR5GTXMIX25_MASK) >> BIAS_BIAS3_PWD_IR5GTXMIX25_LSB)
#define BIAS_BIAS3_PWD_IR5GTXMIX25_SET(x)        (((x) << BIAS_BIAS3_PWD_IR5GTXMIX25_LSB) & BIAS_BIAS3_PWD_IR5GTXMIX25_MASK)
#define BIAS_BIAS3_PWD_IR5GAGC25_MSB             28
#define BIAS_BIAS3_PWD_IR5GAGC25_LSB             26
#define BIAS_BIAS3_PWD_IR5GAGC25_MASK            0x1c000000
#define BIAS_BIAS3_PWD_IR5GAGC25_GET(x)          (((x) & BIAS_BIAS3_PWD_IR5GAGC25_MASK) >> BIAS_BIAS3_PWD_IR5GAGC25_LSB)
#define BIAS_BIAS3_PWD_IR5GAGC25_SET(x)          (((x) << BIAS_BIAS3_PWD_IR5GAGC25_LSB) & BIAS_BIAS3_PWD_IR5GAGC25_MASK)
#define BIAS_BIAS3_PWD_ICDAC50_MSB               25
#define BIAS_BIAS3_PWD_ICDAC50_LSB               23
#define BIAS_BIAS3_PWD_ICDAC50_MASK              0x03800000
#define BIAS_BIAS3_PWD_ICDAC50_GET(x)            (((x) & BIAS_BIAS3_PWD_ICDAC50_MASK) >> BIAS_BIAS3_PWD_ICDAC50_LSB)
#define BIAS_BIAS3_PWD_ICDAC50_SET(x)            (((x) << BIAS_BIAS3_PWD_ICDAC50_LSB) & BIAS_BIAS3_PWD_ICDAC50_MASK)
#define BIAS_BIAS3_PWD_ICSYNTH50_MSB             22
#define BIAS_BIAS3_PWD_ICSYNTH50_LSB             22
#define BIAS_BIAS3_PWD_ICSYNTH50_MASK            0x00400000
#define BIAS_BIAS3_PWD_ICSYNTH50_GET(x)          (((x) & BIAS_BIAS3_PWD_ICSYNTH50_MASK) >> BIAS_BIAS3_PWD_ICSYNTH50_LSB)
#define BIAS_BIAS3_PWD_ICSYNTH50_SET(x)          (((x) << BIAS_BIAS3_PWD_ICSYNTH50_LSB) & BIAS_BIAS3_PWD_ICSYNTH50_MASK)
#define BIAS_BIAS3_PWD_ICBB50_MSB                21
#define BIAS_BIAS3_PWD_ICBB50_LSB                21
#define BIAS_BIAS3_PWD_ICBB50_MASK               0x00200000
#define BIAS_BIAS3_PWD_ICBB50_GET(x)             (((x) & BIAS_BIAS3_PWD_ICBB50_MASK) >> BIAS_BIAS3_PWD_ICBB50_LSB)
#define BIAS_BIAS3_PWD_ICBB50_SET(x)             (((x) << BIAS_BIAS3_PWD_ICBB50_LSB) & BIAS_BIAS3_PWD_ICBB50_MASK)
#define BIAS_BIAS3_PWD_IC2GDIV50_MSB             20
#define BIAS_BIAS3_PWD_IC2GDIV50_LSB             18
#define BIAS_BIAS3_PWD_IC2GDIV50_MASK            0x001c0000
#define BIAS_BIAS3_PWD_IC2GDIV50_GET(x)          (((x) & BIAS_BIAS3_PWD_IC2GDIV50_MASK) >> BIAS_BIAS3_PWD_IC2GDIV50_LSB)
#define BIAS_BIAS3_PWD_IC2GDIV50_SET(x)          (((x) << BIAS_BIAS3_PWD_IC2GDIV50_LSB) & BIAS_BIAS3_PWD_IC2GDIV50_MASK)
#define BIAS_BIAS3_PWD_IRSYNTH50_MSB             17
#define BIAS_BIAS3_PWD_IRSYNTH50_LSB             17
#define BIAS_BIAS3_PWD_IRSYNTH50_MASK            0x00020000
#define BIAS_BIAS3_PWD_IRSYNTH50_GET(x)          (((x) & BIAS_BIAS3_PWD_IRSYNTH50_MASK) >> BIAS_BIAS3_PWD_IRSYNTH50_LSB)
#define BIAS_BIAS3_PWD_IRSYNTH50_SET(x)          (((x) << BIAS_BIAS3_PWD_IRSYNTH50_LSB) & BIAS_BIAS3_PWD_IRSYNTH50_MASK)
#define BIAS_BIAS3_PWD_IRBB50_MSB                16
#define BIAS_BIAS3_PWD_IRBB50_LSB                16
#define BIAS_BIAS3_PWD_IRBB50_MASK               0x00010000
#define BIAS_BIAS3_PWD_IRBB50_GET(x)             (((x) & BIAS_BIAS3_PWD_IRBB50_MASK) >> BIAS_BIAS3_PWD_IRBB50_LSB)
#define BIAS_BIAS3_PWD_IRBB50_SET(x)             (((x) << BIAS_BIAS3_PWD_IRBB50_LSB) & BIAS_BIAS3_PWD_IRBB50_MASK)
#define BIAS_BIAS3_PWD_IC25SPARE1_MSB            15
#define BIAS_BIAS3_PWD_IC25SPARE1_LSB            13
#define BIAS_BIAS3_PWD_IC25SPARE1_MASK           0x0000e000
#define BIAS_BIAS3_PWD_IC25SPARE1_GET(x)         (((x) & BIAS_BIAS3_PWD_IC25SPARE1_MASK) >> BIAS_BIAS3_PWD_IC25SPARE1_LSB)
#define BIAS_BIAS3_PWD_IC25SPARE1_SET(x)         (((x) << BIAS_BIAS3_PWD_IC25SPARE1_LSB) & BIAS_BIAS3_PWD_IC25SPARE1_MASK)
#define BIAS_BIAS3_PWD_IC25SPARE2_MSB            12
#define BIAS_BIAS3_PWD_IC25SPARE2_LSB            10
#define BIAS_BIAS3_PWD_IC25SPARE2_MASK           0x00001c00
#define BIAS_BIAS3_PWD_IC25SPARE2_GET(x)         (((x) & BIAS_BIAS3_PWD_IC25SPARE2_MASK) >> BIAS_BIAS3_PWD_IC25SPARE2_LSB)
#define BIAS_BIAS3_PWD_IC25SPARE2_SET(x)         (((x) << BIAS_BIAS3_PWD_IC25SPARE2_LSB) & BIAS_BIAS3_PWD_IC25SPARE2_MASK)
#define BIAS_BIAS3_PWD_IR25SPARE1_MSB            9
#define BIAS_BIAS3_PWD_IR25SPARE1_LSB            7
#define BIAS_BIAS3_PWD_IR25SPARE1_MASK           0x00000380
#define BIAS_BIAS3_PWD_IR25SPARE1_GET(x)         (((x) & BIAS_BIAS3_PWD_IR25SPARE1_MASK) >> BIAS_BIAS3_PWD_IR25SPARE1_LSB)
#define BIAS_BIAS3_PWD_IR25SPARE1_SET(x)         (((x) << BIAS_BIAS3_PWD_IR25SPARE1_LSB) & BIAS_BIAS3_PWD_IR25SPARE1_MASK)
#define BIAS_BIAS3_PWD_IR25SPARE2_MSB            6
#define BIAS_BIAS3_PWD_IR25SPARE2_LSB            4
#define BIAS_BIAS3_PWD_IR25SPARE2_MASK           0x00000070
#define BIAS_BIAS3_PWD_IR25SPARE2_GET(x)         (((x) & BIAS_BIAS3_PWD_IR25SPARE2_MASK) >> BIAS_BIAS3_PWD_IR25SPARE2_LSB)
#define BIAS_BIAS3_PWD_IR25SPARE2_SET(x)         (((x) << BIAS_BIAS3_PWD_IR25SPARE2_LSB) & BIAS_BIAS3_PWD_IR25SPARE2_MASK)
#define BIAS_BIAS3_PWD_ICDACREG12P5_MSB          3
#define BIAS_BIAS3_PWD_ICDACREG12P5_LSB          1
#define BIAS_BIAS3_PWD_ICDACREG12P5_MASK         0x0000000e
#define BIAS_BIAS3_PWD_ICDACREG12P5_GET(x)       (((x) & BIAS_BIAS3_PWD_ICDACREG12P5_MASK) >> BIAS_BIAS3_PWD_ICDACREG12P5_LSB)
#define BIAS_BIAS3_PWD_ICDACREG12P5_SET(x)       (((x) << BIAS_BIAS3_PWD_ICDACREG12P5_LSB) & BIAS_BIAS3_PWD_ICDACREG12P5_MASK)
#define BIAS_BIAS3_SPARE_MSB                     0
#define BIAS_BIAS3_SPARE_LSB                     0
#define BIAS_BIAS3_SPARE_MASK                    0x00000001
#define BIAS_BIAS3_SPARE_GET(x)                  (((x) & BIAS_BIAS3_SPARE_MASK) >> BIAS_BIAS3_SPARE_LSB)
#define BIAS_BIAS3_SPARE_SET(x)                  (((x) << BIAS_BIAS3_SPARE_LSB) & BIAS_BIAS3_SPARE_MASK)

#define TXPC_TXPC_ADDRESS                        0x00000048
#define TXPC_TXPC_OFFSET                         0x00000048
#define TXPC_TXPC_SELINTPD_MSB                   31
#define TXPC_TXPC_SELINTPD_LSB                   31
#define TXPC_TXPC_SELINTPD_MASK                  0x80000000
#define TXPC_TXPC_SELINTPD_GET(x)                (((x) & TXPC_TXPC_SELINTPD_MASK) >> TXPC_TXPC_SELINTPD_LSB)
#define TXPC_TXPC_SELINTPD_SET(x)                (((x) << TXPC_TXPC_SELINTPD_LSB) & TXPC_TXPC_SELINTPD_MASK)
#define TXPC_TXPC_TEST_MSB                       30
#define TXPC_TXPC_TEST_LSB                       30
#define TXPC_TXPC_TEST_MASK                      0x40000000
#define TXPC_TXPC_TEST_GET(x)                    (((x) & TXPC_TXPC_TEST_MASK) >> TXPC_TXPC_TEST_LSB)
#define TXPC_TXPC_TEST_SET(x)                    (((x) << TXPC_TXPC_TEST_LSB) & TXPC_TXPC_TEST_MASK)
#define TXPC_TXPC_TESTGAIN_MSB                   29
#define TXPC_TXPC_TESTGAIN_LSB                   28
#define TXPC_TXPC_TESTGAIN_MASK                  0x30000000
#define TXPC_TXPC_TESTGAIN_GET(x)                (((x) & TXPC_TXPC_TESTGAIN_MASK) >> TXPC_TXPC_TESTGAIN_LSB)
#define TXPC_TXPC_TESTGAIN_SET(x)                (((x) << TXPC_TXPC_TESTGAIN_LSB) & TXPC_TXPC_TESTGAIN_MASK)
#define TXPC_TXPC_TESTDAC_MSB                    27
#define TXPC_TXPC_TESTDAC_LSB                    22
#define TXPC_TXPC_TESTDAC_MASK                   0x0fc00000
#define TXPC_TXPC_TESTDAC_GET(x)                 (((x) & TXPC_TXPC_TESTDAC_MASK) >> TXPC_TXPC_TESTDAC_LSB)
#define TXPC_TXPC_TESTDAC_SET(x)                 (((x) << TXPC_TXPC_TESTDAC_LSB) & TXPC_TXPC_TESTDAC_MASK)
#define TXPC_TXPC_TESTPWDPC_MSB                  21
#define TXPC_TXPC_TESTPWDPC_LSB                  21
#define TXPC_TXPC_TESTPWDPC_MASK                 0x00200000
#define TXPC_TXPC_TESTPWDPC_GET(x)               (((x) & TXPC_TXPC_TESTPWDPC_MASK) >> TXPC_TXPC_TESTPWDPC_LSB)
#define TXPC_TXPC_TESTPWDPC_SET(x)               (((x) << TXPC_TXPC_TESTPWDPC_LSB) & TXPC_TXPC_TESTPWDPC_MASK)
#define TXPC_TXPC_CURHALF_MSB                    20
#define TXPC_TXPC_CURHALF_LSB                    20
#define TXPC_TXPC_CURHALF_MASK                   0x00100000
#define TXPC_TXPC_CURHALF_GET(x)                 (((x) & TXPC_TXPC_CURHALF_MASK) >> TXPC_TXPC_CURHALF_LSB)
#define TXPC_TXPC_CURHALF_SET(x)                 (((x) << TXPC_TXPC_CURHALF_LSB) & TXPC_TXPC_CURHALF_MASK)
#define TXPC_TXPC_NEGOUT_MSB                     19
#define TXPC_TXPC_NEGOUT_LSB                     19
#define TXPC_TXPC_NEGOUT_MASK                    0x00080000
#define TXPC_TXPC_NEGOUT_GET(x)                  (((x) & TXPC_TXPC_NEGOUT_MASK) >> TXPC_TXPC_NEGOUT_LSB)
#define TXPC_TXPC_NEGOUT_SET(x)                  (((x) << TXPC_TXPC_NEGOUT_LSB) & TXPC_TXPC_NEGOUT_MASK)
#define TXPC_TXPC_CLKDELAY_MSB                   18
#define TXPC_TXPC_CLKDELAY_LSB                   18
#define TXPC_TXPC_CLKDELAY_MASK                  0x00040000
#define TXPC_TXPC_CLKDELAY_GET(x)                (((x) & TXPC_TXPC_CLKDELAY_MASK) >> TXPC_TXPC_CLKDELAY_LSB)
#define TXPC_TXPC_CLKDELAY_SET(x)                (((x) << TXPC_TXPC_CLKDELAY_LSB) & TXPC_TXPC_CLKDELAY_MASK)
#define TXPC_TXPC_SELMODREF_MSB                  17
#define TXPC_TXPC_SELMODREF_LSB                  17
#define TXPC_TXPC_SELMODREF_MASK                 0x00020000
#define TXPC_TXPC_SELMODREF_GET(x)               (((x) & TXPC_TXPC_SELMODREF_MASK) >> TXPC_TXPC_SELMODREF_LSB)
#define TXPC_TXPC_SELMODREF_SET(x)               (((x) << TXPC_TXPC_SELMODREF_LSB) & TXPC_TXPC_SELMODREF_MASK)
#define TXPC_TXPC_SELCMOUT_MSB                   16
#define TXPC_TXPC_SELCMOUT_LSB                   16
#define TXPC_TXPC_SELCMOUT_MASK                  0x00010000
#define TXPC_TXPC_SELCMOUT_GET(x)                (((x) & TXPC_TXPC_SELCMOUT_MASK) >> TXPC_TXPC_SELCMOUT_LSB)
#define TXPC_TXPC_SELCMOUT_SET(x)                (((x) << TXPC_TXPC_SELCMOUT_LSB) & TXPC_TXPC_SELCMOUT_MASK)
#define TXPC_TXPC_TSMODE_MSB                     15
#define TXPC_TXPC_TSMODE_LSB                     14
#define TXPC_TXPC_TSMODE_MASK                    0x0000c000
#define TXPC_TXPC_TSMODE_GET(x)                  (((x) & TXPC_TXPC_TSMODE_MASK) >> TXPC_TXPC_TSMODE_LSB)
#define TXPC_TXPC_TSMODE_SET(x)                  (((x) << TXPC_TXPC_TSMODE_LSB) & TXPC_TXPC_TSMODE_MASK)
#define TXPC_TXPC_N_MSB                          13
#define TXPC_TXPC_N_LSB                          6
#define TXPC_TXPC_N_MASK                         0x00003fc0
#define TXPC_TXPC_N_GET(x)                       (((x) & TXPC_TXPC_N_MASK) >> TXPC_TXPC_N_LSB)
#define TXPC_TXPC_N_SET(x)                       (((x) << TXPC_TXPC_N_LSB) & TXPC_TXPC_N_MASK)
#define TXPC_TXPC_ON1STSYNTHON_MSB               5
#define TXPC_TXPC_ON1STSYNTHON_LSB               5
#define TXPC_TXPC_ON1STSYNTHON_MASK              0x00000020
#define TXPC_TXPC_ON1STSYNTHON_GET(x)            (((x) & TXPC_TXPC_ON1STSYNTHON_MASK) >> TXPC_TXPC_ON1STSYNTHON_LSB)
#define TXPC_TXPC_ON1STSYNTHON_SET(x)            (((x) << TXPC_TXPC_ON1STSYNTHON_LSB) & TXPC_TXPC_ON1STSYNTHON_MASK)
#define TXPC_TXPC_SELINIT_MSB                    4
#define TXPC_TXPC_SELINIT_LSB                    3
#define TXPC_TXPC_SELINIT_MASK                   0x00000018
#define TXPC_TXPC_SELINIT_GET(x)                 (((x) & TXPC_TXPC_SELINIT_MASK) >> TXPC_TXPC_SELINIT_LSB)
#define TXPC_TXPC_SELINIT_SET(x)                 (((x) << TXPC_TXPC_SELINIT_LSB) & TXPC_TXPC_SELINIT_MASK)
#define TXPC_TXPC_SELCOUNT_MSB                   2
#define TXPC_TXPC_SELCOUNT_LSB                   2
#define TXPC_TXPC_SELCOUNT_MASK                  0x00000004
#define TXPC_TXPC_SELCOUNT_GET(x)                (((x) & TXPC_TXPC_SELCOUNT_MASK) >> TXPC_TXPC_SELCOUNT_LSB)
#define TXPC_TXPC_SELCOUNT_SET(x)                (((x) << TXPC_TXPC_SELCOUNT_LSB) & TXPC_TXPC_SELCOUNT_MASK)
#define TXPC_TXPC_ATBSEL_MSB                     1
#define TXPC_TXPC_ATBSEL_LSB                     0
#define TXPC_TXPC_ATBSEL_MASK                    0x00000003
#define TXPC_TXPC_ATBSEL_GET(x)                  (((x) & TXPC_TXPC_ATBSEL_MASK) >> TXPC_TXPC_ATBSEL_LSB)
#define TXPC_TXPC_ATBSEL_SET(x)                  (((x) << TXPC_TXPC_ATBSEL_LSB) & TXPC_TXPC_ATBSEL_MASK)

#define TXPC_MISC_ADDRESS                        0x0000004c
#define TXPC_MISC_OFFSET                         0x0000004c
#define TXPC_MISC_FLIPBMODE_MSB                  31
#define TXPC_MISC_FLIPBMODE_LSB                  31
#define TXPC_MISC_FLIPBMODE_MASK                 0x80000000
#define TXPC_MISC_FLIPBMODE_GET(x)               (((x) & TXPC_MISC_FLIPBMODE_MASK) >> TXPC_MISC_FLIPBMODE_LSB)
#define TXPC_MISC_FLIPBMODE_SET(x)               (((x) << TXPC_MISC_FLIPBMODE_LSB) & TXPC_MISC_FLIPBMODE_MASK)
#define TXPC_MISC_LEVEL_MSB                      30
#define TXPC_MISC_LEVEL_LSB                      29
#define TXPC_MISC_LEVEL_MASK                     0x60000000
#define TXPC_MISC_LEVEL_GET(x)                   (((x) & TXPC_MISC_LEVEL_MASK) >> TXPC_MISC_LEVEL_LSB)
#define TXPC_MISC_LEVEL_SET(x)                   (((x) << TXPC_MISC_LEVEL_LSB) & TXPC_MISC_LEVEL_MASK)
#define TXPC_MISC_LDO_TEST_MODE_MSB              28
#define TXPC_MISC_LDO_TEST_MODE_LSB              28
#define TXPC_MISC_LDO_TEST_MODE_MASK             0x10000000
#define TXPC_MISC_LDO_TEST_MODE_GET(x)           (((x) & TXPC_MISC_LDO_TEST_MODE_MASK) >> TXPC_MISC_LDO_TEST_MODE_LSB)
#define TXPC_MISC_LDO_TEST_MODE_SET(x)           (((x) << TXPC_MISC_LDO_TEST_MODE_LSB) & TXPC_MISC_LDO_TEST_MODE_MASK)
#define TXPC_MISC_NOTCXODET_MSB                  27
#define TXPC_MISC_NOTCXODET_LSB                  27
#define TXPC_MISC_NOTCXODET_MASK                 0x08000000
#define TXPC_MISC_NOTCXODET_GET(x)               (((x) & TXPC_MISC_NOTCXODET_MASK) >> TXPC_MISC_NOTCXODET_LSB)
#define TXPC_MISC_NOTCXODET_SET(x)               (((x) << TXPC_MISC_NOTCXODET_LSB) & TXPC_MISC_NOTCXODET_MASK)
#define TXPC_MISC_PWDCLKIND_MSB                  26
#define TXPC_MISC_PWDCLKIND_LSB                  26
#define TXPC_MISC_PWDCLKIND_MASK                 0x04000000
#define TXPC_MISC_PWDCLKIND_GET(x)               (((x) & TXPC_MISC_PWDCLKIND_MASK) >> TXPC_MISC_PWDCLKIND_LSB)
#define TXPC_MISC_PWDCLKIND_SET(x)               (((x) << TXPC_MISC_PWDCLKIND_LSB) & TXPC_MISC_PWDCLKIND_MASK)
#define TXPC_MISC_PWDXINPAD_MSB                  25
#define TXPC_MISC_PWDXINPAD_LSB                  25
#define TXPC_MISC_PWDXINPAD_MASK                 0x02000000
#define TXPC_MISC_PWDXINPAD_GET(x)               (((x) & TXPC_MISC_PWDXINPAD_MASK) >> TXPC_MISC_PWDXINPAD_LSB)
#define TXPC_MISC_PWDXINPAD_SET(x)               (((x) << TXPC_MISC_PWDXINPAD_LSB) & TXPC_MISC_PWDXINPAD_MASK)
#define TXPC_MISC_LOCALBIAS_MSB                  24
#define TXPC_MISC_LOCALBIAS_LSB                  24
#define TXPC_MISC_LOCALBIAS_MASK                 0x01000000
#define TXPC_MISC_LOCALBIAS_GET(x)               (((x) & TXPC_MISC_LOCALBIAS_MASK) >> TXPC_MISC_LOCALBIAS_LSB)
#define TXPC_MISC_LOCALBIAS_SET(x)               (((x) << TXPC_MISC_LOCALBIAS_LSB) & TXPC_MISC_LOCALBIAS_MASK)
#define TXPC_MISC_LOCALBIAS2X_MSB                23
#define TXPC_MISC_LOCALBIAS2X_LSB                23
#define TXPC_MISC_LOCALBIAS2X_MASK               0x00800000
#define TXPC_MISC_LOCALBIAS2X_GET(x)             (((x) & TXPC_MISC_LOCALBIAS2X_MASK) >> TXPC_MISC_LOCALBIAS2X_LSB)
#define TXPC_MISC_LOCALBIAS2X_SET(x)             (((x) << TXPC_MISC_LOCALBIAS2X_LSB) & TXPC_MISC_LOCALBIAS2X_MASK)
#define TXPC_MISC_SELTSP_MSB                     22
#define TXPC_MISC_SELTSP_LSB                     22
#define TXPC_MISC_SELTSP_MASK                    0x00400000
#define TXPC_MISC_SELTSP_GET(x)                  (((x) & TXPC_MISC_SELTSP_MASK) >> TXPC_MISC_SELTSP_LSB)
#define TXPC_MISC_SELTSP_SET(x)                  (((x) << TXPC_MISC_SELTSP_LSB) & TXPC_MISC_SELTSP_MASK)
#define TXPC_MISC_SELTSN_MSB                     21
#define TXPC_MISC_SELTSN_LSB                     21
#define TXPC_MISC_SELTSN_MASK                    0x00200000
#define TXPC_MISC_SELTSN_GET(x)                  (((x) & TXPC_MISC_SELTSN_MASK) >> TXPC_MISC_SELTSN_LSB)
#define TXPC_MISC_SELTSN_SET(x)                  (((x) << TXPC_MISC_SELTSN_LSB) & TXPC_MISC_SELTSN_MASK)
#define TXPC_MISC_SPARE_A_MSB                    20
#define TXPC_MISC_SPARE_A_LSB                    18
#define TXPC_MISC_SPARE_A_MASK                   0x001c0000
#define TXPC_MISC_SPARE_A_GET(x)                 (((x) & TXPC_MISC_SPARE_A_MASK) >> TXPC_MISC_SPARE_A_LSB)
#define TXPC_MISC_SPARE_A_SET(x)                 (((x) << TXPC_MISC_SPARE_A_LSB) & TXPC_MISC_SPARE_A_MASK)
#define TXPC_MISC_DECOUT_MSB                     17
#define TXPC_MISC_DECOUT_LSB                     8
#define TXPC_MISC_DECOUT_MASK                    0x0003ff00
#define TXPC_MISC_DECOUT_GET(x)                  (((x) & TXPC_MISC_DECOUT_MASK) >> TXPC_MISC_DECOUT_LSB)
#define TXPC_MISC_DECOUT_SET(x)                  (((x) << TXPC_MISC_DECOUT_LSB) & TXPC_MISC_DECOUT_MASK)
#define TXPC_MISC_XTALDIV_MSB                    7
#define TXPC_MISC_XTALDIV_LSB                    6
#define TXPC_MISC_XTALDIV_MASK                   0x000000c0
#define TXPC_MISC_XTALDIV_GET(x)                 (((x) & TXPC_MISC_XTALDIV_MASK) >> TXPC_MISC_XTALDIV_LSB)
#define TXPC_MISC_XTALDIV_SET(x)                 (((x) << TXPC_MISC_XTALDIV_LSB) & TXPC_MISC_XTALDIV_MASK)
#define TXPC_MISC_SPARE_MSB                      5
#define TXPC_MISC_SPARE_LSB                      0
#define TXPC_MISC_SPARE_MASK                     0x0000003f
#define TXPC_MISC_SPARE_GET(x)                   (((x) & TXPC_MISC_SPARE_MASK) >> TXPC_MISC_SPARE_LSB)
#define TXPC_MISC_SPARE_SET(x)                   (((x) << TXPC_MISC_SPARE_LSB) & TXPC_MISC_SPARE_MASK)

#define RXTXBB_RXTXBB1_ADDRESS                   0x00000050
#define RXTXBB_RXTXBB1_OFFSET                    0x00000050
#define RXTXBB_RXTXBB1_SPARE_MSB                 31
#define RXTXBB_RXTXBB1_SPARE_LSB                 19
#define RXTXBB_RXTXBB1_SPARE_MASK                0xfff80000
#define RXTXBB_RXTXBB1_SPARE_GET(x)              (((x) & RXTXBB_RXTXBB1_SPARE_MASK) >> RXTXBB_RXTXBB1_SPARE_LSB)
#define RXTXBB_RXTXBB1_SPARE_SET(x)              (((x) << RXTXBB_RXTXBB1_SPARE_LSB) & RXTXBB_RXTXBB1_SPARE_MASK)
#define RXTXBB_RXTXBB1_FNOTCH_MSB                18
#define RXTXBB_RXTXBB1_FNOTCH_LSB                17
#define RXTXBB_RXTXBB1_FNOTCH_MASK               0x00060000
#define RXTXBB_RXTXBB1_FNOTCH_GET(x)             (((x) & RXTXBB_RXTXBB1_FNOTCH_MASK) >> RXTXBB_RXTXBB1_FNOTCH_LSB)
#define RXTXBB_RXTXBB1_FNOTCH_SET(x)             (((x) << RXTXBB_RXTXBB1_FNOTCH_LSB) & RXTXBB_RXTXBB1_FNOTCH_MASK)
#define RXTXBB_RXTXBB1_SEL_ATB_MSB               16
#define RXTXBB_RXTXBB1_SEL_ATB_LSB               9
#define RXTXBB_RXTXBB1_SEL_ATB_MASK              0x0001fe00
#define RXTXBB_RXTXBB1_SEL_ATB_GET(x)            (((x) & RXTXBB_RXTXBB1_SEL_ATB_MASK) >> RXTXBB_RXTXBB1_SEL_ATB_LSB)
#define RXTXBB_RXTXBB1_SEL_ATB_SET(x)            (((x) << RXTXBB_RXTXBB1_SEL_ATB_LSB) & RXTXBB_RXTXBB1_SEL_ATB_MASK)
#define RXTXBB_RXTXBB1_PDDACINTERFACE_MSB        8
#define RXTXBB_RXTXBB1_PDDACINTERFACE_LSB        8
#define RXTXBB_RXTXBB1_PDDACINTERFACE_MASK       0x00000100
#define RXTXBB_RXTXBB1_PDDACINTERFACE_GET(x)     (((x) & RXTXBB_RXTXBB1_PDDACINTERFACE_MASK) >> RXTXBB_RXTXBB1_PDDACINTERFACE_LSB)
#define RXTXBB_RXTXBB1_PDDACINTERFACE_SET(x)     (((x) << RXTXBB_RXTXBB1_PDDACINTERFACE_LSB) & RXTXBB_RXTXBB1_PDDACINTERFACE_MASK)
#define RXTXBB_RXTXBB1_PDV2I_MSB                 7
#define RXTXBB_RXTXBB1_PDV2I_LSB                 7
#define RXTXBB_RXTXBB1_PDV2I_MASK                0x00000080
#define RXTXBB_RXTXBB1_PDV2I_GET(x)              (((x) & RXTXBB_RXTXBB1_PDV2I_MASK) >> RXTXBB_RXTXBB1_PDV2I_LSB)
#define RXTXBB_RXTXBB1_PDV2I_SET(x)              (((x) << RXTXBB_RXTXBB1_PDV2I_LSB) & RXTXBB_RXTXBB1_PDV2I_MASK)
#define RXTXBB_RXTXBB1_PDI2V_MSB                 6
#define RXTXBB_RXTXBB1_PDI2V_LSB                 6
#define RXTXBB_RXTXBB1_PDI2V_MASK                0x00000040
#define RXTXBB_RXTXBB1_PDI2V_GET(x)              (((x) & RXTXBB_RXTXBB1_PDI2V_MASK) >> RXTXBB_RXTXBB1_PDI2V_LSB)
#define RXTXBB_RXTXBB1_PDI2V_SET(x)              (((x) << RXTXBB_RXTXBB1_PDI2V_LSB) & RXTXBB_RXTXBB1_PDI2V_MASK)
#define RXTXBB_RXTXBB1_PDRXTXBB_MSB              5
#define RXTXBB_RXTXBB1_PDRXTXBB_LSB              5
#define RXTXBB_RXTXBB1_PDRXTXBB_MASK             0x00000020
#define RXTXBB_RXTXBB1_PDRXTXBB_GET(x)           (((x) & RXTXBB_RXTXBB1_PDRXTXBB_MASK) >> RXTXBB_RXTXBB1_PDRXTXBB_LSB)
#define RXTXBB_RXTXBB1_PDRXTXBB_SET(x)           (((x) << RXTXBB_RXTXBB1_PDRXTXBB_LSB) & RXTXBB_RXTXBB1_PDRXTXBB_MASK)
#define RXTXBB_RXTXBB1_PDOFFSETLOQ_MSB           4
#define RXTXBB_RXTXBB1_PDOFFSETLOQ_LSB           4
#define RXTXBB_RXTXBB1_PDOFFSETLOQ_MASK          0x00000010
#define RXTXBB_RXTXBB1_PDOFFSETLOQ_GET(x)        (((x) & RXTXBB_RXTXBB1_PDOFFSETLOQ_MASK) >> RXTXBB_RXTXBB1_PDOFFSETLOQ_LSB)
#define RXTXBB_RXTXBB1_PDOFFSETLOQ_SET(x)        (((x) << RXTXBB_RXTXBB1_PDOFFSETLOQ_LSB) & RXTXBB_RXTXBB1_PDOFFSETLOQ_MASK)
#define RXTXBB_RXTXBB1_PDOFFSETHIQ_MSB           3
#define RXTXBB_RXTXBB1_PDOFFSETHIQ_LSB           3
#define RXTXBB_RXTXBB1_PDOFFSETHIQ_MASK          0x00000008
#define RXTXBB_RXTXBB1_PDOFFSETHIQ_GET(x)        (((x) & RXTXBB_RXTXBB1_PDOFFSETHIQ_MASK) >> RXTXBB_RXTXBB1_PDOFFSETHIQ_LSB)
#define RXTXBB_RXTXBB1_PDOFFSETHIQ_SET(x)        (((x) << RXTXBB_RXTXBB1_PDOFFSETHIQ_LSB) & RXTXBB_RXTXBB1_PDOFFSETHIQ_MASK)
#define RXTXBB_RXTXBB1_PDOFFSETI2V_MSB           2
#define RXTXBB_RXTXBB1_PDOFFSETI2V_LSB           2
#define RXTXBB_RXTXBB1_PDOFFSETI2V_MASK          0x00000004
#define RXTXBB_RXTXBB1_PDOFFSETI2V_GET(x)        (((x) & RXTXBB_RXTXBB1_PDOFFSETI2V_MASK) >> RXTXBB_RXTXBB1_PDOFFSETI2V_LSB)
#define RXTXBB_RXTXBB1_PDOFFSETI2V_SET(x)        (((x) << RXTXBB_RXTXBB1_PDOFFSETI2V_LSB) & RXTXBB_RXTXBB1_PDOFFSETI2V_MASK)
#define RXTXBB_RXTXBB1_PDLOQ_MSB                 1
#define RXTXBB_RXTXBB1_PDLOQ_LSB                 1
#define RXTXBB_RXTXBB1_PDLOQ_MASK                0x00000002
#define RXTXBB_RXTXBB1_PDLOQ_GET(x)              (((x) & RXTXBB_RXTXBB1_PDLOQ_MASK) >> RXTXBB_RXTXBB1_PDLOQ_LSB)
#define RXTXBB_RXTXBB1_PDLOQ_SET(x)              (((x) << RXTXBB_RXTXBB1_PDLOQ_LSB) & RXTXBB_RXTXBB1_PDLOQ_MASK)
#define RXTXBB_RXTXBB1_PDHIQ_MSB                 0
#define RXTXBB_RXTXBB1_PDHIQ_LSB                 0
#define RXTXBB_RXTXBB1_PDHIQ_MASK                0x00000001
#define RXTXBB_RXTXBB1_PDHIQ_GET(x)              (((x) & RXTXBB_RXTXBB1_PDHIQ_MASK) >> RXTXBB_RXTXBB1_PDHIQ_LSB)
#define RXTXBB_RXTXBB1_PDHIQ_SET(x)              (((x) << RXTXBB_RXTXBB1_PDHIQ_LSB) & RXTXBB_RXTXBB1_PDHIQ_MASK)

#define RXTXBB_RXTXBB2_ADDRESS                   0x00000054
#define RXTXBB_RXTXBB2_OFFSET                    0x00000054
#define RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_MSB    31
#define RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_LSB    29
#define RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_MASK   0xe0000000
#define RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_GET(x) (((x) & RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_MASK) >> RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_LSB)
#define RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_SET(x) (((x) << RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_LSB) & RXTXBB_RXTXBB2_IBN_37P5_OSHI_CTRL_MASK)
#define RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_MSB    28
#define RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_LSB    26
#define RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_MASK   0x1c000000
#define RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_GET(x) (((x) & RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_MASK) >> RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_LSB)
#define RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_SET(x) (((x) << RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_LSB) & RXTXBB_RXTXBB2_IBN_37P5_OSLO_CTRL_MASK)
#define RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_MSB   25
#define RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_LSB   23
#define RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_MASK  0x03800000
#define RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_GET(x) (((x) & RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_MASK) >> RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_LSB)
#define RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_SET(x) (((x) << RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_LSB) & RXTXBB_RXTXBB2_IBN_37P5_OSI2V_CTRL_MASK)
#define RXTXBB_RXTXBB2_SPARE_MSB                 22
#define RXTXBB_RXTXBB2_SPARE_LSB                 21
#define RXTXBB_RXTXBB2_SPARE_MASK                0x00600000
#define RXTXBB_RXTXBB2_SPARE_GET(x)              (((x) & RXTXBB_RXTXBB2_SPARE_MASK) >> RXTXBB_RXTXBB2_SPARE_LSB)
#define RXTXBB_RXTXBB2_SPARE_SET(x)              (((x) << RXTXBB_RXTXBB2_SPARE_LSB) & RXTXBB_RXTXBB2_SPARE_MASK)
#define RXTXBB_RXTXBB2_SHORTBUFFER_MSB           20
#define RXTXBB_RXTXBB2_SHORTBUFFER_LSB           20
#define RXTXBB_RXTXBB2_SHORTBUFFER_MASK          0x00100000
#define RXTXBB_RXTXBB2_SHORTBUFFER_GET(x)        (((x) & RXTXBB_RXTXBB2_SHORTBUFFER_MASK) >> RXTXBB_RXTXBB2_SHORTBUFFER_LSB)
#define RXTXBB_RXTXBB2_SHORTBUFFER_SET(x)        (((x) << RXTXBB_RXTXBB2_SHORTBUFFER_LSB) & RXTXBB_RXTXBB2_SHORTBUFFER_MASK)
#define RXTXBB_RXTXBB2_SELBUFFER_MSB             19
#define RXTXBB_RXTXBB2_SELBUFFER_LSB             19
#define RXTXBB_RXTXBB2_SELBUFFER_MASK            0x00080000
#define RXTXBB_RXTXBB2_SELBUFFER_GET(x)          (((x) & RXTXBB_RXTXBB2_SELBUFFER_MASK) >> RXTXBB_RXTXBB2_SELBUFFER_LSB)
#define RXTXBB_RXTXBB2_SELBUFFER_SET(x)          (((x) << RXTXBB_RXTXBB2_SELBUFFER_LSB) & RXTXBB_RXTXBB2_SELBUFFER_MASK)
#define RXTXBB_RXTXBB2_SEL_DAC_TEST_MSB          18
#define RXTXBB_RXTXBB2_SEL_DAC_TEST_LSB          18
#define RXTXBB_RXTXBB2_SEL_DAC_TEST_MASK         0x00040000
#define RXTXBB_RXTXBB2_SEL_DAC_TEST_GET(x)       (((x) & RXTXBB_RXTXBB2_SEL_DAC_TEST_MASK) >> RXTXBB_RXTXBB2_SEL_DAC_TEST_LSB)
#define RXTXBB_RXTXBB2_SEL_DAC_TEST_SET(x)       (((x) << RXTXBB_RXTXBB2_SEL_DAC_TEST_LSB) & RXTXBB_RXTXBB2_SEL_DAC_TEST_MASK)
#define RXTXBB_RXTXBB2_SEL_LOQ_TEST_MSB          17
#define RXTXBB_RXTXBB2_SEL_LOQ_TEST_LSB          17
#define RXTXBB_RXTXBB2_SEL_LOQ_TEST_MASK         0x00020000
#define RXTXBB_RXTXBB2_SEL_LOQ_TEST_GET(x)       (((x) & RXTXBB_RXTXBB2_SEL_LOQ_TEST_MASK) >> RXTXBB_RXTXBB2_SEL_LOQ_TEST_LSB)
#define RXTXBB_RXTXBB2_SEL_LOQ_TEST_SET(x)       (((x) << RXTXBB_RXTXBB2_SEL_LOQ_TEST_LSB) & RXTXBB_RXTXBB2_SEL_LOQ_TEST_MASK)
#define RXTXBB_RXTXBB2_SEL_HIQ_TEST_MSB          16
#define RXTXBB_RXTXBB2_SEL_HIQ_TEST_LSB          16
#define RXTXBB_RXTXBB2_SEL_HIQ_TEST_MASK         0x00010000
#define RXTXBB_RXTXBB2_SEL_HIQ_TEST_GET(x)       (((x) & RXTXBB_RXTXBB2_SEL_HIQ_TEST_MASK) >> RXTXBB_RXTXBB2_SEL_HIQ_TEST_LSB)
#define RXTXBB_RXTXBB2_SEL_HIQ_TEST_SET(x)       (((x) << RXTXBB_RXTXBB2_SEL_HIQ_TEST_LSB) & RXTXBB_RXTXBB2_SEL_HIQ_TEST_MASK)
#define RXTXBB_RXTXBB2_SEL_I2V_TEST_MSB          15
#define RXTXBB_RXTXBB2_SEL_I2V_TEST_LSB          15
#define RXTXBB_RXTXBB2_SEL_I2V_TEST_MASK         0x00008000
#define RXTXBB_RXTXBB2_SEL_I2V_TEST_GET(x)       (((x) & RXTXBB_RXTXBB2_SEL_I2V_TEST_MASK) >> RXTXBB_RXTXBB2_SEL_I2V_TEST_LSB)
#define RXTXBB_RXTXBB2_SEL_I2V_TEST_SET(x)       (((x) << RXTXBB_RXTXBB2_SEL_I2V_TEST_LSB) & RXTXBB_RXTXBB2_SEL_I2V_TEST_MASK)
#define RXTXBB_RXTXBB2_CMSEL_MSB                 14
#define RXTXBB_RXTXBB2_CMSEL_LSB                 13
#define RXTXBB_RXTXBB2_CMSEL_MASK                0x00006000
#define RXTXBB_RXTXBB2_CMSEL_GET(x)              (((x) & RXTXBB_RXTXBB2_CMSEL_MASK) >> RXTXBB_RXTXBB2_CMSEL_LSB)
#define RXTXBB_RXTXBB2_CMSEL_SET(x)              (((x) << RXTXBB_RXTXBB2_CMSEL_LSB) & RXTXBB_RXTXBB2_CMSEL_MASK)
#define RXTXBB_RXTXBB2_FILTERFC_MSB              12
#define RXTXBB_RXTXBB2_FILTERFC_LSB              8
#define RXTXBB_RXTXBB2_FILTERFC_MASK             0x00001f00
#define RXTXBB_RXTXBB2_FILTERFC_GET(x)           (((x) & RXTXBB_RXTXBB2_FILTERFC_MASK) >> RXTXBB_RXTXBB2_FILTERFC_LSB)
#define RXTXBB_RXTXBB2_FILTERFC_SET(x)           (((x) << RXTXBB_RXTXBB2_FILTERFC_LSB) & RXTXBB_RXTXBB2_FILTERFC_MASK)
#define RXTXBB_RXTXBB2_LOCALFILTERTUNING_MSB     7
#define RXTXBB_RXTXBB2_LOCALFILTERTUNING_LSB     7
#define RXTXBB_RXTXBB2_LOCALFILTERTUNING_MASK    0x00000080
#define RXTXBB_RXTXBB2_LOCALFILTERTUNING_GET(x)  (((x) & RXTXBB_RXTXBB2_LOCALFILTERTUNING_MASK) >> RXTXBB_RXTXBB2_LOCALFILTERTUNING_LSB)
#define RXTXBB_RXTXBB2_LOCALFILTERTUNING_SET(x)  (((x) << RXTXBB_RXTXBB2_LOCALFILTERTUNING_LSB) & RXTXBB_RXTXBB2_LOCALFILTERTUNING_MASK)
#define RXTXBB_RXTXBB2_FILTERDOUBLEBW_MSB        6
#define RXTXBB_RXTXBB2_FILTERDOUBLEBW_LSB        6
#define RXTXBB_RXTXBB2_FILTERDOUBLEBW_MASK       0x00000040
#define RXTXBB_RXTXBB2_FILTERDOUBLEBW_GET(x)     (((x) & RXTXBB_RXTXBB2_FILTERDOUBLEBW_MASK) >> RXTXBB_RXTXBB2_FILTERDOUBLEBW_LSB)
#define RXTXBB_RXTXBB2_FILTERDOUBLEBW_SET(x)     (((x) << RXTXBB_RXTXBB2_FILTERDOUBLEBW_LSB) & RXTXBB_RXTXBB2_FILTERDOUBLEBW_MASK)
#define RXTXBB_RXTXBB2_PATH2HIQ_EN_MSB           5
#define RXTXBB_RXTXBB2_PATH2HIQ_EN_LSB           5
#define RXTXBB_RXTXBB2_PATH2HIQ_EN_MASK          0x00000020
#define RXTXBB_RXTXBB2_PATH2HIQ_EN_GET(x)        (((x) & RXTXBB_RXTXBB2_PATH2HIQ_EN_MASK) >> RXTXBB_RXTXBB2_PATH2HIQ_EN_LSB)
#define RXTXBB_RXTXBB2_PATH2HIQ_EN_SET(x)        (((x) << RXTXBB_RXTXBB2_PATH2HIQ_EN_LSB) & RXTXBB_RXTXBB2_PATH2HIQ_EN_MASK)
#define RXTXBB_RXTXBB2_PATH1HIQ_EN_MSB           4
#define RXTXBB_RXTXBB2_PATH1HIQ_EN_LSB           4
#define RXTXBB_RXTXBB2_PATH1HIQ_EN_MASK          0x00000010
#define RXTXBB_RXTXBB2_PATH1HIQ_EN_GET(x)        (((x) & RXTXBB_RXTXBB2_PATH1HIQ_EN_MASK) >> RXTXBB_RXTXBB2_PATH1HIQ_EN_LSB)
#define RXTXBB_RXTXBB2_PATH1HIQ_EN_SET(x)        (((x) << RXTXBB_RXTXBB2_PATH1HIQ_EN_LSB) & RXTXBB_RXTXBB2_PATH1HIQ_EN_MASK)
#define RXTXBB_RXTXBB2_PATH3LOQ_EN_MSB           3
#define RXTXBB_RXTXBB2_PATH3LOQ_EN_LSB           3
#define RXTXBB_RXTXBB2_PATH3LOQ_EN_MASK          0x00000008
#define RXTXBB_RXTXBB2_PATH3LOQ_EN_GET(x)        (((x) & RXTXBB_RXTXBB2_PATH3LOQ_EN_MASK) >> RXTXBB_RXTXBB2_PATH3LOQ_EN_LSB)
#define RXTXBB_RXTXBB2_PATH3LOQ_EN_SET(x)        (((x) << RXTXBB_RXTXBB2_PATH3LOQ_EN_LSB) & RXTXBB_RXTXBB2_PATH3LOQ_EN_MASK)
#define RXTXBB_RXTXBB2_PATH2LOQ_EN_MSB           2
#define RXTXBB_RXTXBB2_PATH2LOQ_EN_LSB           2
#define RXTXBB_RXTXBB2_PATH2LOQ_EN_MASK          0x00000004
#define RXTXBB_RXTXBB2_PATH2LOQ_EN_GET(x)        (((x) & RXTXBB_RXTXBB2_PATH2LOQ_EN_MASK) >> RXTXBB_RXTXBB2_PATH2LOQ_EN_LSB)
#define RXTXBB_RXTXBB2_PATH2LOQ_EN_SET(x)        (((x) << RXTXBB_RXTXBB2_PATH2LOQ_EN_LSB) & RXTXBB_RXTXBB2_PATH2LOQ_EN_MASK)
#define RXTXBB_RXTXBB2_PATH1LOQ_EN_MSB           1
#define RXTXBB_RXTXBB2_PATH1LOQ_EN_LSB           1
#define RXTXBB_RXTXBB2_PATH1LOQ_EN_MASK          0x00000002
#define RXTXBB_RXTXBB2_PATH1LOQ_EN_GET(x)        (((x) & RXTXBB_RXTXBB2_PATH1LOQ_EN_MASK) >> RXTXBB_RXTXBB2_PATH1LOQ_EN_LSB)
#define RXTXBB_RXTXBB2_PATH1LOQ_EN_SET(x)        (((x) << RXTXBB_RXTXBB2_PATH1LOQ_EN_LSB) & RXTXBB_RXTXBB2_PATH1LOQ_EN_MASK)
#define RXTXBB_RXTXBB2_PATH_OVERRIDE_MSB         0
#define RXTXBB_RXTXBB2_PATH_OVERRIDE_LSB         0
#define RXTXBB_RXTXBB2_PATH_OVERRIDE_MASK        0x00000001
#define RXTXBB_RXTXBB2_PATH_OVERRIDE_GET(x)      (((x) & RXTXBB_RXTXBB2_PATH_OVERRIDE_MASK) >> RXTXBB_RXTXBB2_PATH_OVERRIDE_LSB)
#define RXTXBB_RXTXBB2_PATH_OVERRIDE_SET(x)      (((x) << RXTXBB_RXTXBB2_PATH_OVERRIDE_LSB) & RXTXBB_RXTXBB2_PATH_OVERRIDE_MASK)

#define RXTXBB_RXTXBB3_ADDRESS                   0x00000058
#define RXTXBB_RXTXBB3_OFFSET                    0x00000058
#define RXTXBB_RXTXBB3_SPARE_MSB                 31
#define RXTXBB_RXTXBB3_SPARE_LSB                 27
#define RXTXBB_RXTXBB3_SPARE_MASK                0xf8000000
#define RXTXBB_RXTXBB3_SPARE_GET(x)              (((x) & RXTXBB_RXTXBB3_SPARE_MASK) >> RXTXBB_RXTXBB3_SPARE_LSB)
#define RXTXBB_RXTXBB3_SPARE_SET(x)              (((x) << RXTXBB_RXTXBB3_SPARE_LSB) & RXTXBB_RXTXBB3_SPARE_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_MSB 26
#define RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_LSB 24
#define RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_MASK 0x07000000
#define RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_GET(x) (((x) & RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_SET(x) (((x) << RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_CM_BUFAMP_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_MSB    23
#define RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_LSB    21
#define RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_MASK   0x00e00000
#define RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_GET(x) (((x) & RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_SET(x) (((x) << RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_BKV2I_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_MSB      20
#define RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_LSB      18
#define RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_MASK     0x001c0000
#define RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_GET(x)   (((x) & RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_SET(x)   (((x) << RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_I2V_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_MSB      17
#define RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_LSB      15
#define RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_MASK     0x00038000
#define RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_GET(x)   (((x) & RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_SET(x)   (((x) << RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_HI1_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_MSB      14
#define RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_LSB      12
#define RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_MASK     0x00007000
#define RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_GET(x)   (((x) & RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_SET(x)   (((x) << RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_HI2_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_MSB      11
#define RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_LSB      9
#define RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_MASK     0x00000e00
#define RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_GET(x)   (((x) & RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_SET(x)   (((x) << RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_LO1_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_MSB      8
#define RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_LSB      6
#define RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_MASK     0x000001c0
#define RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_GET(x)   (((x) & RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_SET(x)   (((x) << RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_25U_LO2_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_MSB     5
#define RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_LSB     3
#define RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_MASK    0x00000038
#define RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_GET(x)  (((x) & RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_MASK) >> RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_SET(x)  (((x) << RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_LSB) & RXTXBB_RXTXBB3_IBRN_12P5_CM_CTRL_MASK)
#define RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_MSB    2
#define RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_LSB    0
#define RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_MASK   0x00000007
#define RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_GET(x) (((x) & RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_MASK) >> RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_LSB)
#define RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_SET(x) (((x) << RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_LSB) & RXTXBB_RXTXBB3_IBN_100U_TEST_CTRL_MASK)

#define RXTXBB_RXTXBB4_ADDRESS                   0x0000005c
#define RXTXBB_RXTXBB4_OFFSET                    0x0000005c
#define RXTXBB_RXTXBB4_SPARE_MSB                 31
#define RXTXBB_RXTXBB4_SPARE_LSB                 31
#define RXTXBB_RXTXBB4_SPARE_MASK                0x80000000
#define RXTXBB_RXTXBB4_SPARE_GET(x)              (((x) & RXTXBB_RXTXBB4_SPARE_MASK) >> RXTXBB_RXTXBB4_SPARE_LSB)
#define RXTXBB_RXTXBB4_SPARE_SET(x)              (((x) << RXTXBB_RXTXBB4_SPARE_LSB) & RXTXBB_RXTXBB4_SPARE_MASK)
#define RXTXBB_RXTXBB4_LOCALOFFSET_MSB           30
#define RXTXBB_RXTXBB4_LOCALOFFSET_LSB           30
#define RXTXBB_RXTXBB4_LOCALOFFSET_MASK          0x40000000
#define RXTXBB_RXTXBB4_LOCALOFFSET_GET(x)        (((x) & RXTXBB_RXTXBB4_LOCALOFFSET_MASK) >> RXTXBB_RXTXBB4_LOCALOFFSET_LSB)
#define RXTXBB_RXTXBB4_LOCALOFFSET_SET(x)        (((x) << RXTXBB_RXTXBB4_LOCALOFFSET_LSB) & RXTXBB_RXTXBB4_LOCALOFFSET_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRHII_MSB           29
#define RXTXBB_RXTXBB4_OFSTCORRHII_LSB           25
#define RXTXBB_RXTXBB4_OFSTCORRHII_MASK          0x3e000000
#define RXTXBB_RXTXBB4_OFSTCORRHII_GET(x)        (((x) & RXTXBB_RXTXBB4_OFSTCORRHII_MASK) >> RXTXBB_RXTXBB4_OFSTCORRHII_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRHII_SET(x)        (((x) << RXTXBB_RXTXBB4_OFSTCORRHII_LSB) & RXTXBB_RXTXBB4_OFSTCORRHII_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRHIQ_MSB           24
#define RXTXBB_RXTXBB4_OFSTCORRHIQ_LSB           20
#define RXTXBB_RXTXBB4_OFSTCORRHIQ_MASK          0x01f00000
#define RXTXBB_RXTXBB4_OFSTCORRHIQ_GET(x)        (((x) & RXTXBB_RXTXBB4_OFSTCORRHIQ_MASK) >> RXTXBB_RXTXBB4_OFSTCORRHIQ_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRHIQ_SET(x)        (((x) << RXTXBB_RXTXBB4_OFSTCORRHIQ_LSB) & RXTXBB_RXTXBB4_OFSTCORRHIQ_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRLOI_MSB           19
#define RXTXBB_RXTXBB4_OFSTCORRLOI_LSB           15
#define RXTXBB_RXTXBB4_OFSTCORRLOI_MASK          0x000f8000
#define RXTXBB_RXTXBB4_OFSTCORRLOI_GET(x)        (((x) & RXTXBB_RXTXBB4_OFSTCORRLOI_MASK) >> RXTXBB_RXTXBB4_OFSTCORRLOI_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRLOI_SET(x)        (((x) << RXTXBB_RXTXBB4_OFSTCORRLOI_LSB) & RXTXBB_RXTXBB4_OFSTCORRLOI_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRLOQ_MSB           14
#define RXTXBB_RXTXBB4_OFSTCORRLOQ_LSB           10
#define RXTXBB_RXTXBB4_OFSTCORRLOQ_MASK          0x00007c00
#define RXTXBB_RXTXBB4_OFSTCORRLOQ_GET(x)        (((x) & RXTXBB_RXTXBB4_OFSTCORRLOQ_MASK) >> RXTXBB_RXTXBB4_OFSTCORRLOQ_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRLOQ_SET(x)        (((x) << RXTXBB_RXTXBB4_OFSTCORRLOQ_LSB) & RXTXBB_RXTXBB4_OFSTCORRLOQ_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRI2VI_MSB          9
#define RXTXBB_RXTXBB4_OFSTCORRI2VI_LSB          5
#define RXTXBB_RXTXBB4_OFSTCORRI2VI_MASK         0x000003e0
#define RXTXBB_RXTXBB4_OFSTCORRI2VI_GET(x)       (((x) & RXTXBB_RXTXBB4_OFSTCORRI2VI_MASK) >> RXTXBB_RXTXBB4_OFSTCORRI2VI_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRI2VI_SET(x)       (((x) << RXTXBB_RXTXBB4_OFSTCORRI2VI_LSB) & RXTXBB_RXTXBB4_OFSTCORRI2VI_MASK)
#define RXTXBB_RXTXBB4_OFSTCORRI2VQ_MSB          4
#define RXTXBB_RXTXBB4_OFSTCORRI2VQ_LSB          0
#define RXTXBB_RXTXBB4_OFSTCORRI2VQ_MASK         0x0000001f
#define RXTXBB_RXTXBB4_OFSTCORRI2VQ_GET(x)       (((x) & RXTXBB_RXTXBB4_OFSTCORRI2VQ_MASK) >> RXTXBB_RXTXBB4_OFSTCORRI2VQ_LSB)
#define RXTXBB_RXTXBB4_OFSTCORRI2VQ_SET(x)       (((x) << RXTXBB_RXTXBB4_OFSTCORRI2VQ_LSB) & RXTXBB_RXTXBB4_OFSTCORRI2VQ_MASK)

#define ADDAC_ADDAC1_ADDRESS                     0x00000060
#define ADDAC_ADDAC1_OFFSET                      0x00000060
#define ADDAC_ADDAC1_PLL_SVREG_MSB               31
#define ADDAC_ADDAC1_PLL_SVREG_LSB               31
#define ADDAC_ADDAC1_PLL_SVREG_MASK              0x80000000
#define ADDAC_ADDAC1_PLL_SVREG_GET(x)            (((x) & ADDAC_ADDAC1_PLL_SVREG_MASK) >> ADDAC_ADDAC1_PLL_SVREG_LSB)
#define ADDAC_ADDAC1_PLL_SVREG_SET(x)            (((x) << ADDAC_ADDAC1_PLL_SVREG_LSB) & ADDAC_ADDAC1_PLL_SVREG_MASK)
#define ADDAC_ADDAC1_PLL_SCLAMP_MSB              30
#define ADDAC_ADDAC1_PLL_SCLAMP_LSB              28
#define ADDAC_ADDAC1_PLL_SCLAMP_MASK             0x70000000
#define ADDAC_ADDAC1_PLL_SCLAMP_GET(x)           (((x) & ADDAC_ADDAC1_PLL_SCLAMP_MASK) >> ADDAC_ADDAC1_PLL_SCLAMP_LSB)
#define ADDAC_ADDAC1_PLL_SCLAMP_SET(x)           (((x) << ADDAC_ADDAC1_PLL_SCLAMP_LSB) & ADDAC_ADDAC1_PLL_SCLAMP_MASK)
#define ADDAC_ADDAC1_PLL_ATB_MSB                 27
#define ADDAC_ADDAC1_PLL_ATB_LSB                 26
#define ADDAC_ADDAC1_PLL_ATB_MASK                0x0c000000
#define ADDAC_ADDAC1_PLL_ATB_GET(x)              (((x) & ADDAC_ADDAC1_PLL_ATB_MASK) >> ADDAC_ADDAC1_PLL_ATB_LSB)
#define ADDAC_ADDAC1_PLL_ATB_SET(x)              (((x) << ADDAC_ADDAC1_PLL_ATB_LSB) & ADDAC_ADDAC1_PLL_ATB_MASK)
#define ADDAC_ADDAC1_PLL_ICP_MSB                 25
#define ADDAC_ADDAC1_PLL_ICP_LSB                 23
#define ADDAC_ADDAC1_PLL_ICP_MASK                0x03800000
#define ADDAC_ADDAC1_PLL_ICP_GET(x)              (((x) & ADDAC_ADDAC1_PLL_ICP_MASK) >> ADDAC_ADDAC1_PLL_ICP_LSB)
#define ADDAC_ADDAC1_PLL_ICP_SET(x)              (((x) << ADDAC_ADDAC1_PLL_ICP_LSB) & ADDAC_ADDAC1_PLL_ICP_MASK)
#define ADDAC_ADDAC1_PLL_FILTER_MSB              22
#define ADDAC_ADDAC1_PLL_FILTER_LSB              15
#define ADDAC_ADDAC1_PLL_FILTER_MASK             0x007f8000
#define ADDAC_ADDAC1_PLL_FILTER_GET(x)           (((x) & ADDAC_ADDAC1_PLL_FILTER_MASK) >> ADDAC_ADDAC1_PLL_FILTER_LSB)
#define ADDAC_ADDAC1_PLL_FILTER_SET(x)           (((x) << ADDAC_ADDAC1_PLL_FILTER_LSB) & ADDAC_ADDAC1_PLL_FILTER_MASK)
#define ADDAC_ADDAC1_PWDPLL_MSB                  14
#define ADDAC_ADDAC1_PWDPLL_LSB                  14
#define ADDAC_ADDAC1_PWDPLL_MASK                 0x00004000
#define ADDAC_ADDAC1_PWDPLL_GET(x)               (((x) & ADDAC_ADDAC1_PWDPLL_MASK) >> ADDAC_ADDAC1_PWDPLL_LSB)
#define ADDAC_ADDAC1_PWDPLL_SET(x)               (((x) << ADDAC_ADDAC1_PWDPLL_LSB) & ADDAC_ADDAC1_PWDPLL_MASK)
#define ADDAC_ADDAC1_PWDADC_MSB                  13
#define ADDAC_ADDAC1_PWDADC_LSB                  13
#define ADDAC_ADDAC1_PWDADC_MASK                 0x00002000
#define ADDAC_ADDAC1_PWDADC_GET(x)               (((x) & ADDAC_ADDAC1_PWDADC_MASK) >> ADDAC_ADDAC1_PWDADC_LSB)
#define ADDAC_ADDAC1_PWDADC_SET(x)               (((x) << ADDAC_ADDAC1_PWDADC_LSB) & ADDAC_ADDAC1_PWDADC_MASK)
#define ADDAC_ADDAC1_PWDDAC_MSB                  12
#define ADDAC_ADDAC1_PWDDAC_LSB                  12
#define ADDAC_ADDAC1_PWDDAC_MASK                 0x00001000
#define ADDAC_ADDAC1_PWDDAC_GET(x)               (((x) & ADDAC_ADDAC1_PWDDAC_MASK) >> ADDAC_ADDAC1_PWDDAC_LSB)
#define ADDAC_ADDAC1_PWDDAC_SET(x)               (((x) << ADDAC_ADDAC1_PWDDAC_LSB) & ADDAC_ADDAC1_PWDDAC_MASK)
#define ADDAC_ADDAC1_FORCEMSBLOW_MSB             11
#define ADDAC_ADDAC1_FORCEMSBLOW_LSB             11
#define ADDAC_ADDAC1_FORCEMSBLOW_MASK            0x00000800
#define ADDAC_ADDAC1_FORCEMSBLOW_GET(x)          (((x) & ADDAC_ADDAC1_FORCEMSBLOW_MASK) >> ADDAC_ADDAC1_FORCEMSBLOW_LSB)
#define ADDAC_ADDAC1_FORCEMSBLOW_SET(x)          (((x) << ADDAC_ADDAC1_FORCEMSBLOW_LSB) & ADDAC_ADDAC1_FORCEMSBLOW_MASK)
#define ADDAC_ADDAC1_SELMANPWDS_MSB              10
#define ADDAC_ADDAC1_SELMANPWDS_LSB              10
#define ADDAC_ADDAC1_SELMANPWDS_MASK             0x00000400
#define ADDAC_ADDAC1_SELMANPWDS_GET(x)           (((x) & ADDAC_ADDAC1_SELMANPWDS_MASK) >> ADDAC_ADDAC1_SELMANPWDS_LSB)
#define ADDAC_ADDAC1_SELMANPWDS_SET(x)           (((x) << ADDAC_ADDAC1_SELMANPWDS_LSB) & ADDAC_ADDAC1_SELMANPWDS_MASK)
#define ADDAC_ADDAC1_INV_CLK160_ADC_MSB          9
#define ADDAC_ADDAC1_INV_CLK160_ADC_LSB          9
#define ADDAC_ADDAC1_INV_CLK160_ADC_MASK         0x00000200
#define ADDAC_ADDAC1_INV_CLK160_ADC_GET(x)       (((x) & ADDAC_ADDAC1_INV_CLK160_ADC_MASK) >> ADDAC_ADDAC1_INV_CLK160_ADC_LSB)
#define ADDAC_ADDAC1_INV_CLK160_ADC_SET(x)       (((x) << ADDAC_ADDAC1_INV_CLK160_ADC_LSB) & ADDAC_ADDAC1_INV_CLK160_ADC_MASK)
#define ADDAC_ADDAC1_CM_SEL_MSB                  8
#define ADDAC_ADDAC1_CM_SEL_LSB                  7
#define ADDAC_ADDAC1_CM_SEL_MASK                 0x00000180
#define ADDAC_ADDAC1_CM_SEL_GET(x)               (((x) & ADDAC_ADDAC1_CM_SEL_MASK) >> ADDAC_ADDAC1_CM_SEL_LSB)
#define ADDAC_ADDAC1_CM_SEL_SET(x)               (((x) << ADDAC_ADDAC1_CM_SEL_LSB) & ADDAC_ADDAC1_CM_SEL_MASK)
#define ADDAC_ADDAC1_DISABLE_DAC_REG_MSB         6
#define ADDAC_ADDAC1_DISABLE_DAC_REG_LSB         6
#define ADDAC_ADDAC1_DISABLE_DAC_REG_MASK        0x00000040
#define ADDAC_ADDAC1_DISABLE_DAC_REG_GET(x)      (((x) & ADDAC_ADDAC1_DISABLE_DAC_REG_MASK) >> ADDAC_ADDAC1_DISABLE_DAC_REG_LSB)
#define ADDAC_ADDAC1_DISABLE_DAC_REG_SET(x)      (((x) << ADDAC_ADDAC1_DISABLE_DAC_REG_LSB) & ADDAC_ADDAC1_DISABLE_DAC_REG_MASK)
#define ADDAC_ADDAC1_SPARE_MSB                   5
#define ADDAC_ADDAC1_SPARE_LSB                   0
#define ADDAC_ADDAC1_SPARE_MASK                  0x0000003f
#define ADDAC_ADDAC1_SPARE_GET(x)                (((x) & ADDAC_ADDAC1_SPARE_MASK) >> ADDAC_ADDAC1_SPARE_LSB)
#define ADDAC_ADDAC1_SPARE_SET(x)                (((x) << ADDAC_ADDAC1_SPARE_LSB) & ADDAC_ADDAC1_SPARE_MASK)


#ifndef __ASSEMBLER__

typedef struct analog_reg_reg_s {
  volatile unsigned int synth_synth1;
  volatile unsigned int synth_synth2;
  volatile unsigned int synth_synth3;
  volatile unsigned int synth_synth4;
  volatile unsigned int synth_synth5;
  volatile unsigned int synth_synth6;
  volatile unsigned int synth_synth7;
  volatile unsigned int synth_synth8;
  volatile unsigned int rf5g_rf5g1;
  volatile unsigned int rf5g_rf5g2;
  volatile unsigned int rf2g_rf2g1;
  volatile unsigned int rf2g_rf2g2;
  volatile unsigned int top_gain;
  volatile unsigned int top_top;
  volatile unsigned int bias_bias_sel;
  volatile unsigned int bias_bias1;
  volatile unsigned int bias_bias2;
  volatile unsigned int bias_bias3;
  volatile unsigned int txpc_txpc;
  volatile unsigned int txpc_misc;
  volatile unsigned int rxtxbb_rxtxbb1;
  volatile unsigned int rxtxbb_rxtxbb2;
  volatile unsigned int rxtxbb_rxtxbb3;
  volatile unsigned int rxtxbb_rxtxbb4;
  volatile unsigned int addac_addac1;
} analog_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _ANALOG_REG_H_ */
