/* Copyright (c) 2002,2007-2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

START_REGISTER(PA_CL_VPORT_XSCALE)
    GENERATE_FIELD(VPORT_XSCALE, float)
END_REGISTER(PA_CL_VPORT_XSCALE)

START_REGISTER(PA_CL_VPORT_XOFFSET)
    GENERATE_FIELD(VPORT_XOFFSET, float)
END_REGISTER(PA_CL_VPORT_XOFFSET)

START_REGISTER(PA_CL_VPORT_YSCALE)
    GENERATE_FIELD(VPORT_YSCALE, float)
END_REGISTER(PA_CL_VPORT_YSCALE)

START_REGISTER(PA_CL_VPORT_YOFFSET)
    GENERATE_FIELD(VPORT_YOFFSET, float)
END_REGISTER(PA_CL_VPORT_YOFFSET)

START_REGISTER(PA_CL_VPORT_ZSCALE)
    GENERATE_FIELD(VPORT_ZSCALE, float)
END_REGISTER(PA_CL_VPORT_ZSCALE)

START_REGISTER(PA_CL_VPORT_ZOFFSET)
    GENERATE_FIELD(VPORT_ZOFFSET, float)
END_REGISTER(PA_CL_VPORT_ZOFFSET)

START_REGISTER(PA_CL_VTE_CNTL)
    GENERATE_FIELD(VPORT_X_SCALE_ENA, bool)
    GENERATE_FIELD(VPORT_X_OFFSET_ENA, bool)
    GENERATE_FIELD(VPORT_Y_SCALE_ENA, bool)
    GENERATE_FIELD(VPORT_Y_OFFSET_ENA, bool)
    GENERATE_FIELD(VPORT_Z_SCALE_ENA, bool)
    GENERATE_FIELD(VPORT_Z_OFFSET_ENA, bool)
    GENERATE_FIELD(VTX_XY_FMT, bool)
    GENERATE_FIELD(VTX_Z_FMT, bool)
    GENERATE_FIELD(VTX_W0_FMT, bool)
    GENERATE_FIELD(PERFCOUNTER_REF, bool)
END_REGISTER(PA_CL_VTE_CNTL)

START_REGISTER(PA_CL_CLIP_CNTL)
    GENERATE_FIELD(CLIP_DISABLE, bool)
    GENERATE_FIELD(BOUNDARY_EDGE_FLAG_ENA, bool)
    GENERATE_FIELD(DX_CLIP_SPACE_DEF, DXClipSpaceDef)
    GENERATE_FIELD(DIS_CLIP_ERR_DETECT, bool)
    GENERATE_FIELD(VTX_KILL_OR, bool)
    GENERATE_FIELD(XY_NAN_RETAIN, bool)
    GENERATE_FIELD(Z_NAN_RETAIN, bool)
    GENERATE_FIELD(W_NAN_RETAIN, bool)
END_REGISTER(PA_CL_CLIP_CNTL)

START_REGISTER(PA_CL_GB_VERT_CLIP_ADJ)
    GENERATE_FIELD(DATA_REGISTER, float)
END_REGISTER(PA_CL_GB_VERT_CLIP_ADJ)

START_REGISTER(PA_CL_GB_VERT_DISC_ADJ)
    GENERATE_FIELD(DATA_REGISTER, float)
END_REGISTER(PA_CL_GB_VERT_DISC_ADJ)

START_REGISTER(PA_CL_GB_HORZ_CLIP_ADJ)
    GENERATE_FIELD(DATA_REGISTER, float)
END_REGISTER(PA_CL_GB_HORZ_CLIP_ADJ)

START_REGISTER(PA_CL_GB_HORZ_DISC_ADJ)
    GENERATE_FIELD(DATA_REGISTER, float)
END_REGISTER(PA_CL_GB_HORZ_DISC_ADJ)

START_REGISTER(PA_CL_ENHANCE)
    GENERATE_FIELD(CLIP_VTX_REORDER_ENA, bool)
    GENERATE_FIELD(ECO_SPARE3, int)
    GENERATE_FIELD(ECO_SPARE2, int)
    GENERATE_FIELD(ECO_SPARE1, int)
    GENERATE_FIELD(ECO_SPARE0, int)
END_REGISTER(PA_CL_ENHANCE)

START_REGISTER(PA_SC_ENHANCE)
    GENERATE_FIELD(ECO_SPARE3, int)
    GENERATE_FIELD(ECO_SPARE2, int)
    GENERATE_FIELD(ECO_SPARE1, int)
    GENERATE_FIELD(ECO_SPARE0, int)
END_REGISTER(PA_SC_ENHANCE)

START_REGISTER(PA_SU_VTX_CNTL)
    GENERATE_FIELD(PIX_CENTER, PixCenter)
    GENERATE_FIELD(ROUND_MODE, RoundMode)
    GENERATE_FIELD(QUANT_MODE, QuantMode)
END_REGISTER(PA_SU_VTX_CNTL)

START_REGISTER(PA_SU_POINT_SIZE)
    GENERATE_FIELD(HEIGHT, fixed12_4)
    GENERATE_FIELD(WIDTH, fixed12_4)
END_REGISTER(PA_SU_POINT_SIZE)

START_REGISTER(PA_SU_POINT_MINMAX)
    GENERATE_FIELD(MIN_SIZE, fixed12_4)
    GENERATE_FIELD(MAX_SIZE, fixed12_4)
END_REGISTER(PA_SU_POINT_MINMAX)

START_REGISTER(PA_SU_LINE_CNTL)
    GENERATE_FIELD(WIDTH, fixed12_4)
END_REGISTER(PA_SU_LINE_CNTL)

START_REGISTER(PA_SU_FACE_DATA)
    GENERATE_FIELD(BASE_ADDR, int)
END_REGISTER(PA_SU_FACE_DATA)

START_REGISTER(PA_SU_SC_MODE_CNTL)
    GENERATE_FIELD(CULL_FRONT, bool)
    GENERATE_FIELD(CULL_BACK, bool)
    GENERATE_FIELD(FACE, FrontFace)
    GENERATE_FIELD(POLY_MODE, PolyMode)
    GENERATE_FIELD(POLYMODE_FRONT_PTYPE, PType)
    GENERATE_FIELD(POLYMODE_BACK_PTYPE, PType)
    GENERATE_FIELD(POLY_OFFSET_FRONT_ENABLE, bool)
    GENERATE_FIELD(POLY_OFFSET_BACK_ENABLE, bool)
    GENERATE_FIELD(POLY_OFFSET_PARA_ENABLE, bool)
    GENERATE_FIELD(MSAA_ENABLE, bool)
    GENERATE_FIELD(VTX_WINDOW_OFFSET_ENABLE, bool)
    GENERATE_FIELD(LINE_STIPPLE_ENABLE, bool)
    GENERATE_FIELD(PROVOKING_VTX_LAST, bool)
    GENERATE_FIELD(PERSP_CORR_DIS, bool)
    GENERATE_FIELD(MULTI_PRIM_IB_ENA, bool)
    GENERATE_FIELD(QUAD_ORDER_ENABLE, bool)
    GENERATE_FIELD(WAIT_RB_IDLE_ALL_TRI, bool)
    GENERATE_FIELD(WAIT_RB_IDLE_FIRST_TRI_NEW_STATE, bool)
    GENERATE_FIELD(CLAMPED_FACENESS, bool)
    GENERATE_FIELD(ZERO_AREA_FACENESS, bool)
    GENERATE_FIELD(FACE_KILL_ENABLE, bool)
    GENERATE_FIELD(FACE_WRITE_ENABLE, bool)
END_REGISTER(PA_SU_SC_MODE_CNTL)

START_REGISTER(PA_SU_POLY_OFFSET_FRONT_SCALE)
    GENERATE_FIELD(SCALE, float)
END_REGISTER(PA_SU_POLY_OFFSET_FRONT_SCALE)

START_REGISTER(PA_SU_POLY_OFFSET_FRONT_OFFSET)
    GENERATE_FIELD(OFFSET, float)
END_REGISTER(PA_SU_POLY_OFFSET_FRONT_OFFSET)

START_REGISTER(PA_SU_POLY_OFFSET_BACK_SCALE)
    GENERATE_FIELD(SCALE, float)
END_REGISTER(PA_SU_POLY_OFFSET_BACK_SCALE)

START_REGISTER(PA_SU_POLY_OFFSET_BACK_OFFSET)
    GENERATE_FIELD(OFFSET, float)
END_REGISTER(PA_SU_POLY_OFFSET_BACK_OFFSET)

START_REGISTER(PA_SU_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, SU_PERFCNT_SELECT)
END_REGISTER(PA_SU_PERFCOUNTER0_SELECT)

START_REGISTER(PA_SU_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(PA_SU_PERFCOUNTER1_SELECT)

START_REGISTER(PA_SU_PERFCOUNTER2_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(PA_SU_PERFCOUNTER2_SELECT)

START_REGISTER(PA_SU_PERFCOUNTER3_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(PA_SU_PERFCOUNTER3_SELECT)

START_REGISTER(PA_SU_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER0_LOW)

START_REGISTER(PA_SU_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER0_HI)

START_REGISTER(PA_SU_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER1_LOW)

START_REGISTER(PA_SU_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER1_HI)

START_REGISTER(PA_SU_PERFCOUNTER2_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER2_LOW)

START_REGISTER(PA_SU_PERFCOUNTER2_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER2_HI)

START_REGISTER(PA_SU_PERFCOUNTER3_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER3_LOW)

START_REGISTER(PA_SU_PERFCOUNTER3_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SU_PERFCOUNTER3_HI)

START_REGISTER(PA_SC_WINDOW_OFFSET)
    GENERATE_FIELD(WINDOW_X_OFFSET, signedint15)
    GENERATE_FIELD(WINDOW_Y_OFFSET, signedint15)
END_REGISTER(PA_SC_WINDOW_OFFSET)

START_REGISTER(PA_SC_AA_CONFIG)
    GENERATE_FIELD(MSAA_NUM_SAMPLES, MSAANumSamples)
    GENERATE_FIELD(MAX_SAMPLE_DIST, int)
END_REGISTER(PA_SC_AA_CONFIG)

START_REGISTER(PA_SC_AA_MASK)
    GENERATE_FIELD(AA_MASK, hex)
END_REGISTER(PA_SC_AA_MASK)

START_REGISTER(PA_SC_LINE_STIPPLE)
    GENERATE_FIELD(LINE_PATTERN, hex)
    GENERATE_FIELD(REPEAT_COUNT, intMinusOne)
    GENERATE_FIELD(PATTERN_BIT_ORDER, PatternBitOrder)
    GENERATE_FIELD(AUTO_RESET_CNTL, AutoResetCntl)
END_REGISTER(PA_SC_LINE_STIPPLE)

START_REGISTER(PA_SC_LINE_CNTL)
    GENERATE_FIELD(BRES_CNTL, int)
    GENERATE_FIELD(USE_BRES_CNTL, bool)
    GENERATE_FIELD(EXPAND_LINE_WIDTH, bool)
    GENERATE_FIELD(LAST_PIXEL, bool)
END_REGISTER(PA_SC_LINE_CNTL)

START_REGISTER(PA_SC_WINDOW_SCISSOR_TL)
    GENERATE_FIELD(TL_X, int)
    GENERATE_FIELD(TL_Y, int)
    GENERATE_FIELD(WINDOW_OFFSET_DISABLE, bool)
END_REGISTER(PA_SC_WINDOW_SCISSOR_TL)

START_REGISTER(PA_SC_WINDOW_SCISSOR_BR)
    GENERATE_FIELD(BR_X, int)
    GENERATE_FIELD(BR_Y, int)
END_REGISTER(PA_SC_WINDOW_SCISSOR_BR)

START_REGISTER(PA_SC_SCREEN_SCISSOR_TL)
    GENERATE_FIELD(TL_X, int)
    GENERATE_FIELD(TL_Y, int)
END_REGISTER(PA_SC_SCREEN_SCISSOR_TL)

START_REGISTER(PA_SC_SCREEN_SCISSOR_BR)
    GENERATE_FIELD(BR_X, int)
    GENERATE_FIELD(BR_Y, int)
END_REGISTER(PA_SC_SCREEN_SCISSOR_BR)

START_REGISTER(PA_SC_VIZ_QUERY)
    GENERATE_FIELD(VIZ_QUERY_ENA, bool)
    GENERATE_FIELD(VIZ_QUERY_ID, int)
    GENERATE_FIELD(KILL_PIX_POST_EARLY_Z, bool)
END_REGISTER(PA_SC_VIZ_QUERY)

START_REGISTER(PA_SC_VIZ_QUERY_STATUS)
    GENERATE_FIELD(STATUS_BITS, hex)
END_REGISTER(PA_SC_VIZ_QUERY_STATUS)

START_REGISTER(PA_SC_LINE_STIPPLE_STATE)
    GENERATE_FIELD(CURRENT_PTR, int)
    GENERATE_FIELD(CURRENT_COUNT, int)
END_REGISTER(PA_SC_LINE_STIPPLE_STATE)

START_REGISTER(PA_SC_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, SC_PERFCNT_SELECT)
END_REGISTER(PA_SC_PERFCOUNTER0_SELECT)

START_REGISTER(PA_SC_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SC_PERFCOUNTER0_LOW)

START_REGISTER(PA_SC_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(PA_SC_PERFCOUNTER0_HI)

START_REGISTER(PA_CL_CNTL_STATUS)
    GENERATE_FIELD(CL_BUSY, int)
END_REGISTER(PA_CL_CNTL_STATUS)

START_REGISTER(PA_SU_CNTL_STATUS)
    GENERATE_FIELD(SU_BUSY, int)
END_REGISTER(PA_SU_CNTL_STATUS)

START_REGISTER(PA_SC_CNTL_STATUS)
    GENERATE_FIELD(SC_BUSY, int)
END_REGISTER(PA_SC_CNTL_STATUS)

START_REGISTER(PA_SU_DEBUG_CNTL)
    GENERATE_FIELD(SU_DEBUG_INDX, int)
END_REGISTER(PA_SU_DEBUG_CNTL)

START_REGISTER(PA_SU_DEBUG_DATA)
    GENERATE_FIELD(DATA, hex)
END_REGISTER(PA_SU_DEBUG_DATA)

START_REGISTER(PA_SC_DEBUG_CNTL)
    GENERATE_FIELD(SC_DEBUG_INDX, int)
END_REGISTER(PA_SC_DEBUG_CNTL)

START_REGISTER(PA_SC_DEBUG_DATA)
    GENERATE_FIELD(DATA, int)
END_REGISTER(PA_SC_DEBUG_DATA)

START_REGISTER(GFX_COPY_STATE)
    GENERATE_FIELD(SRC_STATE_ID, int)
END_REGISTER(GFX_COPY_STATE)

START_REGISTER(VGT_DRAW_INITIATOR)
    GENERATE_FIELD(PRIM_TYPE, VGT_DI_PRIM_TYPE)
    GENERATE_FIELD(SOURCE_SELECT, VGT_DI_SOURCE_SELECT)
    GENERATE_FIELD(FACENESS_CULL_SELECT, VGT_DI_FACENESS_CULL_SELECT)
    GENERATE_FIELD(INDEX_SIZE, VGT_DI_INDEX_SIZE)
    GENERATE_FIELD(NOT_EOP, bool)
    GENERATE_FIELD(SMALL_INDEX, VGT_DI_SMALL_INDEX)
    GENERATE_FIELD(PRE_FETCH_CULL_ENABLE, VGT_DI_PRE_FETCH_CULL_ENABLE)
    GENERATE_FIELD(GRP_CULL_ENABLE, VGT_DI_GRP_CULL_ENABLE)
    GENERATE_FIELD(NUM_INDICES, uint)
END_REGISTER(VGT_DRAW_INITIATOR)

START_REGISTER(VGT_EVENT_INITIATOR)
    GENERATE_FIELD(EVENT_TYPE, VGT_EVENT_TYPE)
END_REGISTER(VGT_EVENT_INITIATOR)

START_REGISTER(VGT_DMA_BASE)
    GENERATE_FIELD(BASE_ADDR, uint)
END_REGISTER(VGT_DMA_BASE)

START_REGISTER(VGT_DMA_SIZE)
    GENERATE_FIELD(NUM_WORDS, uint)
    GENERATE_FIELD(SWAP_MODE, VGT_DMA_SWAP_MODE)
END_REGISTER(VGT_DMA_SIZE)

START_REGISTER(VGT_BIN_BASE)
    GENERATE_FIELD(BIN_BASE_ADDR, uint)
END_REGISTER(VGT_BIN_BASE)

START_REGISTER(VGT_BIN_SIZE)
    GENERATE_FIELD(NUM_WORDS, uint)
    GENERATE_FIELD(FACENESS_FETCH, int)
    GENERATE_FIELD(FACENESS_RESET, int)
END_REGISTER(VGT_BIN_SIZE)

START_REGISTER(VGT_CURRENT_BIN_ID_MIN)
    GENERATE_FIELD(COLUMN, int)
    GENERATE_FIELD(ROW, int)
    GENERATE_FIELD(GUARD_BAND, int)
END_REGISTER(VGT_CURRENT_BIN_ID_MIN)

START_REGISTER(VGT_CURRENT_BIN_ID_MAX)
    GENERATE_FIELD(COLUMN, int)
    GENERATE_FIELD(ROW, int)
    GENERATE_FIELD(GUARD_BAND, int)
END_REGISTER(VGT_CURRENT_BIN_ID_MAX)

START_REGISTER(VGT_IMMED_DATA)
    GENERATE_FIELD(DATA, hex)
END_REGISTER(VGT_IMMED_DATA)

START_REGISTER(VGT_MAX_VTX_INDX)
    GENERATE_FIELD(MAX_INDX, int)
END_REGISTER(VGT_MAX_VTX_INDX)

START_REGISTER(VGT_MIN_VTX_INDX)
    GENERATE_FIELD(MIN_INDX, int)
END_REGISTER(VGT_MIN_VTX_INDX)

START_REGISTER(VGT_INDX_OFFSET)
    GENERATE_FIELD(INDX_OFFSET, int)
END_REGISTER(VGT_INDX_OFFSET)

START_REGISTER(VGT_VERTEX_REUSE_BLOCK_CNTL)
    GENERATE_FIELD(VTX_REUSE_DEPTH, int)
END_REGISTER(VGT_VERTEX_REUSE_BLOCK_CNTL)

START_REGISTER(VGT_OUT_DEALLOC_CNTL)
    GENERATE_FIELD(DEALLOC_DIST, int)
END_REGISTER(VGT_OUT_DEALLOC_CNTL)

START_REGISTER(VGT_MULTI_PRIM_IB_RESET_INDX)
    GENERATE_FIELD(RESET_INDX, int)
END_REGISTER(VGT_MULTI_PRIM_IB_RESET_INDX)

START_REGISTER(VGT_ENHANCE)
    GENERATE_FIELD(MISC, hex)
END_REGISTER(VGT_ENHANCE)

START_REGISTER(VGT_VTX_VECT_EJECT_REG)
    GENERATE_FIELD(PRIM_COUNT, int)
END_REGISTER(VGT_VTX_VECT_EJECT_REG)

START_REGISTER(VGT_LAST_COPY_STATE)
    GENERATE_FIELD(SRC_STATE_ID, int)
    GENERATE_FIELD(DST_STATE_ID, int)
END_REGISTER(VGT_LAST_COPY_STATE)

START_REGISTER(VGT_DEBUG_CNTL)
    GENERATE_FIELD(VGT_DEBUG_INDX, int)
END_REGISTER(VGT_DEBUG_CNTL)

START_REGISTER(VGT_DEBUG_DATA)
    GENERATE_FIELD(DATA, hex)
END_REGISTER(VGT_DEBUG_DATA)

START_REGISTER(VGT_CNTL_STATUS)
    GENERATE_FIELD(VGT_BUSY, int)
    GENERATE_FIELD(VGT_DMA_BUSY, int)
    GENERATE_FIELD(VGT_DMA_REQ_BUSY, int)
    GENERATE_FIELD(VGT_GRP_BUSY, int)
    GENERATE_FIELD(VGT_VR_BUSY, int)
    GENERATE_FIELD(VGT_BIN_BUSY, int)
    GENERATE_FIELD(VGT_PT_BUSY, int)
    GENERATE_FIELD(VGT_OUT_BUSY, int)
    GENERATE_FIELD(VGT_OUT_INDX_BUSY, int)
END_REGISTER(VGT_CNTL_STATUS)

START_REGISTER(VGT_CRC_SQ_DATA)
    GENERATE_FIELD(CRC, hex)
END_REGISTER(VGT_CRC_SQ_DATA)

START_REGISTER(VGT_CRC_SQ_CTRL)
    GENERATE_FIELD(CRC, hex)
END_REGISTER(VGT_CRC_SQ_CTRL)

START_REGISTER(VGT_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, VGT_PERFCOUNT_SELECT)
END_REGISTER(VGT_PERFCOUNTER0_SELECT)

START_REGISTER(VGT_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERF_SEL, VGT_PERFCOUNT_SELECT)
END_REGISTER(VGT_PERFCOUNTER1_SELECT)

START_REGISTER(VGT_PERFCOUNTER2_SELECT)
    GENERATE_FIELD(PERF_SEL, VGT_PERFCOUNT_SELECT)
END_REGISTER(VGT_PERFCOUNTER2_SELECT)

START_REGISTER(VGT_PERFCOUNTER3_SELECT)
    GENERATE_FIELD(PERF_SEL, VGT_PERFCOUNT_SELECT)
END_REGISTER(VGT_PERFCOUNTER3_SELECT)

START_REGISTER(VGT_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER0_LOW)

START_REGISTER(VGT_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER1_LOW)

START_REGISTER(VGT_PERFCOUNTER2_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER2_LOW)

START_REGISTER(VGT_PERFCOUNTER3_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER3_LOW)

START_REGISTER(VGT_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER0_HI)

START_REGISTER(VGT_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER1_HI)

START_REGISTER(VGT_PERFCOUNTER2_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER2_HI)

START_REGISTER(VGT_PERFCOUNTER3_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(VGT_PERFCOUNTER3_HI)

START_REGISTER(TC_CNTL_STATUS)
    GENERATE_FIELD(L2_INVALIDATE, int)
    GENERATE_FIELD(TC_L2_HIT_MISS, int)
    GENERATE_FIELD(TC_BUSY, int)
END_REGISTER(TC_CNTL_STATUS)

START_REGISTER(TCR_CHICKEN)
    GENERATE_FIELD(SPARE, hex)
END_REGISTER(TCR_CHICKEN)

START_REGISTER(TCF_CHICKEN)
    GENERATE_FIELD(SPARE, hex)
END_REGISTER(TCF_CHICKEN)

START_REGISTER(TCM_CHICKEN)
    GENERATE_FIELD(TCO_READ_LATENCY_FIFO_PROG_DEPTH, int)
    GENERATE_FIELD(ETC_COLOR_ENDIAN, int)
    GENERATE_FIELD(SPARE, hex)
END_REGISTER(TCM_CHICKEN)

START_REGISTER(TCR_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCR_PERFCOUNT_SELECT)
END_REGISTER(TCR_PERFCOUNTER0_SELECT)

START_REGISTER(TCR_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCR_PERFCOUNT_SELECT)
END_REGISTER(TCR_PERFCOUNTER1_SELECT)

START_REGISTER(TCR_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCR_PERFCOUNTER0_HI)

START_REGISTER(TCR_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCR_PERFCOUNTER1_HI)

START_REGISTER(TCR_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCR_PERFCOUNTER0_LOW)

START_REGISTER(TCR_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCR_PERFCOUNTER1_LOW)

START_REGISTER(TP_TC_CLKGATE_CNTL)
    GENERATE_FIELD(TP_BUSY_EXTEND, int)
    GENERATE_FIELD(TC_BUSY_EXTEND, int)
END_REGISTER(TP_TC_CLKGATE_CNTL)

START_REGISTER(TPC_CNTL_STATUS)
    GENERATE_FIELD(TPC_INPUT_BUSY, int)
    GENERATE_FIELD(TPC_TC_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_STATE_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_FETCH_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_WALKER_PIPE_BUSY, int)
    GENERATE_FIELD(TPC_WALK_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_WALKER_BUSY, int)
    GENERATE_FIELD(TPC_ALIGNER_PIPE_BUSY, int)
    GENERATE_FIELD(TPC_ALIGN_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_ALIGNER_BUSY, int)
    GENERATE_FIELD(TPC_RR_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_BLEND_PIPE_BUSY, int)
    GENERATE_FIELD(TPC_OUT_FIFO_BUSY, int)
    GENERATE_FIELD(TPC_BLEND_BUSY, int)
    GENERATE_FIELD(TF_TW_RTS, int)
    GENERATE_FIELD(TF_TW_STATE_RTS, int)
    GENERATE_FIELD(TF_TW_RTR, int)
    GENERATE_FIELD(TW_TA_RTS, int)
    GENERATE_FIELD(TW_TA_TT_RTS, int)
    GENERATE_FIELD(TW_TA_LAST_RTS, int)
    GENERATE_FIELD(TW_TA_RTR, int)
    GENERATE_FIELD(TA_TB_RTS, int)
    GENERATE_FIELD(TA_TB_TT_RTS, int)
    GENERATE_FIELD(TA_TB_RTR, int)
    GENERATE_FIELD(TA_TF_RTS, int)
    GENERATE_FIELD(TA_TF_TC_FIFO_REN, int)
    GENERATE_FIELD(TP_SQ_DEC, int)
    GENERATE_FIELD(TPC_BUSY, int)
END_REGISTER(TPC_CNTL_STATUS)

START_REGISTER(TPC_DEBUG0)
    GENERATE_FIELD(LOD_CNTL, int)
    GENERATE_FIELD(IC_CTR, int)
    GENERATE_FIELD(WALKER_CNTL, int)
    GENERATE_FIELD(ALIGNER_CNTL, int)
    GENERATE_FIELD(PREV_TC_STATE_VALID, int)
    GENERATE_FIELD(WALKER_STATE, int)
    GENERATE_FIELD(ALIGNER_STATE, int)
    GENERATE_FIELD(REG_CLK_EN, int)
    GENERATE_FIELD(TPC_CLK_EN, int)
    GENERATE_FIELD(SQ_TP_WAKEUP, int)
END_REGISTER(TPC_DEBUG0)

START_REGISTER(TPC_DEBUG1)
    GENERATE_FIELD(UNUSED, int)
END_REGISTER(TPC_DEBUG1)

START_REGISTER(TPC_CHICKEN)
    GENERATE_FIELD(BLEND_PRECISION, int)
    GENERATE_FIELD(SPARE, int)
END_REGISTER(TPC_CHICKEN)

START_REGISTER(TP0_CNTL_STATUS)
    GENERATE_FIELD(TP_INPUT_BUSY, int)
    GENERATE_FIELD(TP_LOD_BUSY, int)
    GENERATE_FIELD(TP_LOD_FIFO_BUSY, int)
    GENERATE_FIELD(TP_ADDR_BUSY, int)
    GENERATE_FIELD(TP_ALIGN_FIFO_BUSY, int)
    GENERATE_FIELD(TP_ALIGNER_BUSY, int)
    GENERATE_FIELD(TP_TC_FIFO_BUSY, int)
    GENERATE_FIELD(TP_RR_FIFO_BUSY, int)
    GENERATE_FIELD(TP_FETCH_BUSY, int)
    GENERATE_FIELD(TP_CH_BLEND_BUSY, int)
    GENERATE_FIELD(TP_TT_BUSY, int)
    GENERATE_FIELD(TP_HICOLOR_BUSY, int)
    GENERATE_FIELD(TP_BLEND_BUSY, int)
    GENERATE_FIELD(TP_OUT_FIFO_BUSY, int)
    GENERATE_FIELD(TP_OUTPUT_BUSY, int)
    GENERATE_FIELD(IN_LC_RTS, int)
    GENERATE_FIELD(LC_LA_RTS, int)
    GENERATE_FIELD(LA_FL_RTS, int)
    GENERATE_FIELD(FL_TA_RTS, int)
    GENERATE_FIELD(TA_FA_RTS, int)
    GENERATE_FIELD(TA_FA_TT_RTS, int)
    GENERATE_FIELD(FA_AL_RTS, int)
    GENERATE_FIELD(FA_AL_TT_RTS, int)
    GENERATE_FIELD(AL_TF_RTS, int)
    GENERATE_FIELD(AL_TF_TT_RTS, int)
    GENERATE_FIELD(TF_TB_RTS, int)
    GENERATE_FIELD(TF_TB_TT_RTS, int)
    GENERATE_FIELD(TB_TT_RTS, int)
    GENERATE_FIELD(TB_TT_TT_RESET, int)
    GENERATE_FIELD(TB_TO_RTS, int)
    GENERATE_FIELD(TP_BUSY, int)
END_REGISTER(TP0_CNTL_STATUS)

START_REGISTER(TP0_DEBUG)
    GENERATE_FIELD(Q_LOD_CNTL, int)
    GENERATE_FIELD(Q_SQ_TP_WAKEUP, int)
    GENERATE_FIELD(FL_TA_ADDRESSER_CNTL, int)
    GENERATE_FIELD(REG_CLK_EN, int)
    GENERATE_FIELD(PERF_CLK_EN, int)
    GENERATE_FIELD(TP_CLK_EN, int)
    GENERATE_FIELD(Q_WALKER_CNTL, int)
    GENERATE_FIELD(Q_ALIGNER_CNTL, int)
END_REGISTER(TP0_DEBUG)

START_REGISTER(TP0_CHICKEN)
    GENERATE_FIELD(TT_MODE, int)
    GENERATE_FIELD(VFETCH_ADDRESS_MODE, int)
    GENERATE_FIELD(SPARE, int)
END_REGISTER(TP0_CHICKEN)

START_REGISTER(TP0_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TP_PERFCOUNT_SELECT)
END_REGISTER(TP0_PERFCOUNTER0_SELECT)

START_REGISTER(TP0_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TP0_PERFCOUNTER0_HI)

START_REGISTER(TP0_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TP0_PERFCOUNTER0_LOW)

START_REGISTER(TP0_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, int)
END_REGISTER(TP0_PERFCOUNTER1_SELECT)

START_REGISTER(TP0_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TP0_PERFCOUNTER1_HI)

START_REGISTER(TP0_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TP0_PERFCOUNTER1_LOW)

START_REGISTER(TCM_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCM_PERFCOUNT_SELECT)
END_REGISTER(TCM_PERFCOUNTER0_SELECT)

START_REGISTER(TCM_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCM_PERFCOUNT_SELECT)
END_REGISTER(TCM_PERFCOUNTER1_SELECT)

START_REGISTER(TCM_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCM_PERFCOUNTER0_HI)

START_REGISTER(TCM_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCM_PERFCOUNTER1_HI)

START_REGISTER(TCM_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCM_PERFCOUNTER0_LOW)

START_REGISTER(TCM_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCM_PERFCOUNTER1_LOW)

START_REGISTER(TCF_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER0_SELECT)

START_REGISTER(TCF_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER1_SELECT)

START_REGISTER(TCF_PERFCOUNTER2_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER2_SELECT)

START_REGISTER(TCF_PERFCOUNTER3_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER3_SELECT)

START_REGISTER(TCF_PERFCOUNTER4_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER4_SELECT)

START_REGISTER(TCF_PERFCOUNTER5_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER5_SELECT)

START_REGISTER(TCF_PERFCOUNTER6_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER6_SELECT)

START_REGISTER(TCF_PERFCOUNTER7_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER7_SELECT)

START_REGISTER(TCF_PERFCOUNTER8_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER8_SELECT)

START_REGISTER(TCF_PERFCOUNTER9_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER9_SELECT)

START_REGISTER(TCF_PERFCOUNTER10_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER10_SELECT)

START_REGISTER(TCF_PERFCOUNTER11_SELECT)
    GENERATE_FIELD(PERFCOUNTER_SELECT, TCF_PERFCOUNT_SELECT)
END_REGISTER(TCF_PERFCOUNTER11_SELECT)

START_REGISTER(TCF_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER0_HI)

START_REGISTER(TCF_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER1_HI)

START_REGISTER(TCF_PERFCOUNTER2_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER2_HI)

START_REGISTER(TCF_PERFCOUNTER3_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER3_HI)

START_REGISTER(TCF_PERFCOUNTER4_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER4_HI)

START_REGISTER(TCF_PERFCOUNTER5_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER5_HI)

START_REGISTER(TCF_PERFCOUNTER6_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER6_HI)

START_REGISTER(TCF_PERFCOUNTER7_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER7_HI)

START_REGISTER(TCF_PERFCOUNTER8_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER8_HI)

START_REGISTER(TCF_PERFCOUNTER9_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER9_HI)

START_REGISTER(TCF_PERFCOUNTER10_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER10_HI)

START_REGISTER(TCF_PERFCOUNTER11_HI)
    GENERATE_FIELD(PERFCOUNTER_HI, int)
END_REGISTER(TCF_PERFCOUNTER11_HI)

START_REGISTER(TCF_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER0_LOW)

START_REGISTER(TCF_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER1_LOW)

START_REGISTER(TCF_PERFCOUNTER2_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER2_LOW)

START_REGISTER(TCF_PERFCOUNTER3_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER3_LOW)

START_REGISTER(TCF_PERFCOUNTER4_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER4_LOW)

START_REGISTER(TCF_PERFCOUNTER5_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER5_LOW)

START_REGISTER(TCF_PERFCOUNTER6_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER6_LOW)

START_REGISTER(TCF_PERFCOUNTER7_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER7_LOW)

START_REGISTER(TCF_PERFCOUNTER8_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER8_LOW)

START_REGISTER(TCF_PERFCOUNTER9_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER9_LOW)

START_REGISTER(TCF_PERFCOUNTER10_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER10_LOW)

START_REGISTER(TCF_PERFCOUNTER11_LOW)
    GENERATE_FIELD(PERFCOUNTER_LOW, int)
END_REGISTER(TCF_PERFCOUNTER11_LOW)

START_REGISTER(TCF_DEBUG)
    GENERATE_FIELD(not_MH_TC_rtr, int)
    GENERATE_FIELD(TC_MH_send, int)
    GENERATE_FIELD(not_FG0_rtr, int)
    GENERATE_FIELD(not_TCB_TCO_rtr, int)
    GENERATE_FIELD(TCB_ff_stall, int)
    GENERATE_FIELD(TCB_miss_stall, int)
    GENERATE_FIELD(TCA_TCB_stall, int)
    GENERATE_FIELD(PF0_stall, int)
    GENERATE_FIELD(TP0_full, int)
    GENERATE_FIELD(TPC_full, int)
    GENERATE_FIELD(not_TPC_rtr, int)
    GENERATE_FIELD(tca_state_rts, int)
    GENERATE_FIELD(tca_rts, int)
END_REGISTER(TCF_DEBUG)

START_REGISTER(TCA_FIFO_DEBUG)
    GENERATE_FIELD(tp0_full, int)
    GENERATE_FIELD(tpc_full, int)
    GENERATE_FIELD(load_tpc_fifo, int)
    GENERATE_FIELD(load_tp_fifos, int)
    GENERATE_FIELD(FW_full, int)
    GENERATE_FIELD(not_FW_rtr0, int)
    GENERATE_FIELD(FW_rts0, int)
    GENERATE_FIELD(not_FW_tpc_rtr, int)
    GENERATE_FIELD(FW_tpc_rts, int)
END_REGISTER(TCA_FIFO_DEBUG)

START_REGISTER(TCA_PROBE_DEBUG)
    GENERATE_FIELD(ProbeFilter_stall, int)
END_REGISTER(TCA_PROBE_DEBUG)

START_REGISTER(TCA_TPC_DEBUG)
    GENERATE_FIELD(captue_state_rts, int)
    GENERATE_FIELD(capture_tca_rts, int)
END_REGISTER(TCA_TPC_DEBUG)

START_REGISTER(TCB_CORE_DEBUG)
    GENERATE_FIELD(access512, int)
    GENERATE_FIELD(tiled, int)
    GENERATE_FIELD(opcode, int)
    GENERATE_FIELD(format, int)
    GENERATE_FIELD(sector_format, int)
    GENERATE_FIELD(sector_format512, int)
END_REGISTER(TCB_CORE_DEBUG)

START_REGISTER(TCB_TAG0_DEBUG)
    GENERATE_FIELD(mem_read_cycle, int)
    GENERATE_FIELD(tag_access_cycle, int)
    GENERATE_FIELD(miss_stall, int)
    GENERATE_FIELD(num_feee_lines, int)
    GENERATE_FIELD(max_misses, int)
END_REGISTER(TCB_TAG0_DEBUG)

START_REGISTER(TCB_TAG1_DEBUG)
    GENERATE_FIELD(mem_read_cycle, int)
    GENERATE_FIELD(tag_access_cycle, int)
    GENERATE_FIELD(miss_stall, int)
    GENERATE_FIELD(num_feee_lines, int)
    GENERATE_FIELD(max_misses, int)
END_REGISTER(TCB_TAG1_DEBUG)

START_REGISTER(TCB_TAG2_DEBUG)
    GENERATE_FIELD(mem_read_cycle, int)
    GENERATE_FIELD(tag_access_cycle, int)
    GENERATE_FIELD(miss_stall, int)
    GENERATE_FIELD(num_feee_lines, int)
    GENERATE_FIELD(max_misses, int)
END_REGISTER(TCB_TAG2_DEBUG)

START_REGISTER(TCB_TAG3_DEBUG)
    GENERATE_FIELD(mem_read_cycle, int)
    GENERATE_FIELD(tag_access_cycle, int)
    GENERATE_FIELD(miss_stall, int)
    GENERATE_FIELD(num_feee_lines, int)
    GENERATE_FIELD(max_misses, int)
END_REGISTER(TCB_TAG3_DEBUG)

START_REGISTER(TCB_FETCH_GEN_SECTOR_WALKER0_DEBUG)
    GENERATE_FIELD(left_done, int)
    GENERATE_FIELD(fg0_sends_left, int)
    GENERATE_FIELD(one_sector_to_go_left_q, int)
    GENERATE_FIELD(no_sectors_to_go, int)
    GENERATE_FIELD(update_left, int)
    GENERATE_FIELD(sector_mask_left_count_q, int)
    GENERATE_FIELD(sector_mask_left_q, int)
    GENERATE_FIELD(valid_left_q, int)
END_REGISTER(TCB_FETCH_GEN_SECTOR_WALKER0_DEBUG)

START_REGISTER(TCB_FETCH_GEN_WALKER_DEBUG)
    GENERATE_FIELD(quad_sel_left, int)
    GENERATE_FIELD(set_sel_left, int)
    GENERATE_FIELD(right_eq_left, int)
    GENERATE_FIELD(ff_fg_type512, int)
    GENERATE_FIELD(busy, int)
    GENERATE_FIELD(setquads_to_send, int)
END_REGISTER(TCB_FETCH_GEN_WALKER_DEBUG)

START_REGISTER(TCB_FETCH_GEN_PIPE0_DEBUG)
    GENERATE_FIELD(tc0_arb_rts, int)
    GENERATE_FIELD(ga_out_rts, int)
    GENERATE_FIELD(tc_arb_format, int)
    GENERATE_FIELD(tc_arb_fmsopcode, int)
    GENERATE_FIELD(tc_arb_request_type, int)
    GENERATE_FIELD(busy, int)
    GENERATE_FIELD(fgo_busy, int)
    GENERATE_FIELD(ga_busy, int)
    GENERATE_FIELD(mc_sel_q, int)
    GENERATE_FIELD(valid_q, int)
    GENERATE_FIELD(arb_RTR, int)
END_REGISTER(TCB_FETCH_GEN_PIPE0_DEBUG)

START_REGISTER(TCD_INPUT0_DEBUG)
    GENERATE_FIELD(empty, int)
    GENERATE_FIELD(full, int)
    GENERATE_FIELD(valid_q1, int)
    GENERATE_FIELD(cnt_q1, int)
    GENERATE_FIELD(last_send_q1, int)
    GENERATE_FIELD(ip_send, int)
    GENERATE_FIELD(ipbuf_dxt_send, int)
    GENERATE_FIELD(ipbuf_busy, int)
END_REGISTER(TCD_INPUT0_DEBUG)

START_REGISTER(TCD_DEGAMMA_DEBUG)
    GENERATE_FIELD(dgmm_ftfconv_dgmmen, int)
    GENERATE_FIELD(dgmm_ctrl_dgmm8, int)
    GENERATE_FIELD(dgmm_ctrl_last_send, int)
    GENERATE_FIELD(dgmm_ctrl_send, int)
    GENERATE_FIELD(dgmm_stall, int)
    GENERATE_FIELD(dgmm_pstate, int)
END_REGISTER(TCD_DEGAMMA_DEBUG)

START_REGISTER(TCD_DXTMUX_SCTARB_DEBUG)
    GENERATE_FIELD(pstate, int)
    GENERATE_FIELD(sctrmx_rtr, int)
    GENERATE_FIELD(dxtc_rtr, int)
    GENERATE_FIELD(sctrarb_multcyl_send, int)
    GENERATE_FIELD(sctrmx0_sctrarb_rts, int)
    GENERATE_FIELD(dxtc_sctrarb_send, int)
    GENERATE_FIELD(dxtc_dgmmpd_last_send, int)
    GENERATE_FIELD(dxtc_dgmmpd_send, int)
    GENERATE_FIELD(dcmp_mux_send, int)
END_REGISTER(TCD_DXTMUX_SCTARB_DEBUG)

START_REGISTER(TCD_DXTC_ARB_DEBUG)
    GENERATE_FIELD(n0_stall, int)
    GENERATE_FIELD(pstate, int)
    GENERATE_FIELD(arb_dcmp01_last_send, int)
    GENERATE_FIELD(arb_dcmp01_cnt, int)
    GENERATE_FIELD(arb_dcmp01_sector, int)
    GENERATE_FIELD(arb_dcmp01_cacheline, int)
    GENERATE_FIELD(arb_dcmp01_format, int)
    GENERATE_FIELD(arb_dcmp01_send, int)
    GENERATE_FIELD(n0_dxt2_4_types, int)
END_REGISTER(TCD_DXTC_ARB_DEBUG)

START_REGISTER(TCD_STALLS_DEBUG)
    GENERATE_FIELD(not_multcyl_sctrarb_rtr, int)
    GENERATE_FIELD(not_sctrmx0_sctrarb_rtr, int)
    GENERATE_FIELD(not_dcmp0_arb_rtr, int)
    GENERATE_FIELD(not_dgmmpd_dxtc_rtr, int)
    GENERATE_FIELD(not_mux_dcmp_rtr, int)
    GENERATE_FIELD(not_incoming_rtr, int)
END_REGISTER(TCD_STALLS_DEBUG)

START_REGISTER(TCO_STALLS_DEBUG)
    GENERATE_FIELD(quad0_sg_crd_RTR, int)
    GENERATE_FIELD(quad0_rl_sg_RTR, int)
    GENERATE_FIELD(quad0_TCO_TCB_rtr_d, int)
END_REGISTER(TCO_STALLS_DEBUG)

START_REGISTER(TCO_QUAD0_DEBUG0)
    GENERATE_FIELD(rl_sg_sector_format, int)
    GENERATE_FIELD(rl_sg_end_of_sample, int)
    GENERATE_FIELD(rl_sg_rtr, int)
    GENERATE_FIELD(rl_sg_rts, int)
    GENERATE_FIELD(sg_crd_end_of_sample, int)
    GENERATE_FIELD(sg_crd_rtr, int)
    GENERATE_FIELD(sg_crd_rts, int)
    GENERATE_FIELD(stageN1_valid_q, int)
    GENERATE_FIELD(read_cache_q, int)
    GENERATE_FIELD(cache_read_RTR, int)
    GENERATE_FIELD(all_sectors_written_set3, int)
    GENERATE_FIELD(all_sectors_written_set2, int)
    GENERATE_FIELD(all_sectors_written_set1, int)
    GENERATE_FIELD(all_sectors_written_set0, int)
    GENERATE_FIELD(busy, int)
END_REGISTER(TCO_QUAD0_DEBUG0)

START_REGISTER(TCO_QUAD0_DEBUG1)
    GENERATE_FIELD(fifo_busy, int)
    GENERATE_FIELD(empty, int)
    GENERATE_FIELD(full, int)
    GENERATE_FIELD(write_enable, int)
    GENERATE_FIELD(fifo_write_ptr, int)
    GENERATE_FIELD(fifo_read_ptr, int)
    GENERATE_FIELD(cache_read_busy, int)
    GENERATE_FIELD(latency_fifo_busy, int)
    GENERATE_FIELD(input_quad_busy, int)
    GENERATE_FIELD(tco_quad_pipe_busy, int)
    GENERATE_FIELD(TCB_TCO_rtr_d, int)
    GENERATE_FIELD(TCB_TCO_xfc_q, int)
    GENERATE_FIELD(rl_sg_rtr, int)
    GENERATE_FIELD(rl_sg_rts, int)
    GENERATE_FIELD(sg_crd_rtr, int)
    GENERATE_FIELD(sg_crd_rts, int)
    GENERATE_FIELD(TCO_TCB_read_xfc, int)
END_REGISTER(TCO_QUAD0_DEBUG1)

START_REGISTER(SQ_GPR_MANAGEMENT)
    GENERATE_FIELD(REG_DYNAMIC, int)
    GENERATE_FIELD(REG_SIZE_PIX, int)
    GENERATE_FIELD(REG_SIZE_VTX, int)
END_REGISTER(SQ_GPR_MANAGEMENT)

START_REGISTER(SQ_FLOW_CONTROL)
    GENERATE_FIELD(INPUT_ARBITRATION_POLICY, int)
    GENERATE_FIELD(ONE_THREAD, int)
    GENERATE_FIELD(ONE_ALU, int)
    GENERATE_FIELD(CF_WR_BASE, hex)
    GENERATE_FIELD(NO_PV_PS, int)
    GENERATE_FIELD(NO_LOOP_EXIT, int)
    GENERATE_FIELD(NO_CEXEC_OPTIMIZE, int)
    GENERATE_FIELD(TEXTURE_ARBITRATION_POLICY, int)
    GENERATE_FIELD(VC_ARBITRATION_POLICY, int)
    GENERATE_FIELD(ALU_ARBITRATION_POLICY, int)
    GENERATE_FIELD(NO_ARB_EJECT, int)
    GENERATE_FIELD(NO_CFS_EJECT, int)
    GENERATE_FIELD(POS_EXP_PRIORITY, int)
    GENERATE_FIELD(NO_EARLY_THREAD_TERMINATION, int)
    GENERATE_FIELD(PS_PREFETCH_COLOR_ALLOC, int)
END_REGISTER(SQ_FLOW_CONTROL)

START_REGISTER(SQ_INST_STORE_MANAGMENT)
    GENERATE_FIELD(INST_BASE_PIX, int)
    GENERATE_FIELD(INST_BASE_VTX, int)
END_REGISTER(SQ_INST_STORE_MANAGMENT)

START_REGISTER(SQ_RESOURCE_MANAGMENT)
    GENERATE_FIELD(VTX_THREAD_BUF_ENTRIES, int)
    GENERATE_FIELD(PIX_THREAD_BUF_ENTRIES, int)
    GENERATE_FIELD(EXPORT_BUF_ENTRIES, int)
END_REGISTER(SQ_RESOURCE_MANAGMENT)

START_REGISTER(SQ_EO_RT)
    GENERATE_FIELD(EO_CONSTANTS_RT, int)
    GENERATE_FIELD(EO_TSTATE_RT, int)
END_REGISTER(SQ_EO_RT)

START_REGISTER(SQ_DEBUG_MISC)
    GENERATE_FIELD(DB_ALUCST_SIZE, int)
    GENERATE_FIELD(DB_TSTATE_SIZE, int)
    GENERATE_FIELD(DB_READ_CTX, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(DB_READ_MEMORY, int)
    GENERATE_FIELD(DB_WEN_MEMORY_0, int)
    GENERATE_FIELD(DB_WEN_MEMORY_1, int)
    GENERATE_FIELD(DB_WEN_MEMORY_2, int)
    GENERATE_FIELD(DB_WEN_MEMORY_3, int)
END_REGISTER(SQ_DEBUG_MISC)

START_REGISTER(SQ_ACTIVITY_METER_CNTL)
    GENERATE_FIELD(TIMEBASE, int)
    GENERATE_FIELD(THRESHOLD_LOW, int)
    GENERATE_FIELD(THRESHOLD_HIGH, int)
    GENERATE_FIELD(SPARE, int)
END_REGISTER(SQ_ACTIVITY_METER_CNTL)

START_REGISTER(SQ_ACTIVITY_METER_STATUS)
    GENERATE_FIELD(PERCENT_BUSY, int)
END_REGISTER(SQ_ACTIVITY_METER_STATUS)

START_REGISTER(SQ_INPUT_ARB_PRIORITY)
    GENERATE_FIELD(PC_AVAIL_WEIGHT, int)
    GENERATE_FIELD(PC_AVAIL_SIGN, int)
    GENERATE_FIELD(SX_AVAIL_WEIGHT, int)
    GENERATE_FIELD(SX_AVAIL_SIGN, int)
    GENERATE_FIELD(THRESHOLD, int)
END_REGISTER(SQ_INPUT_ARB_PRIORITY)

START_REGISTER(SQ_THREAD_ARB_PRIORITY)
    GENERATE_FIELD(PC_AVAIL_WEIGHT, int)
    GENERATE_FIELD(PC_AVAIL_SIGN, int)
    GENERATE_FIELD(SX_AVAIL_WEIGHT, int)
    GENERATE_FIELD(SX_AVAIL_SIGN, int)
    GENERATE_FIELD(THRESHOLD, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(VS_PRIORITIZE_SERIAL, int)
    GENERATE_FIELD(PS_PRIORITIZE_SERIAL, int)
    GENERATE_FIELD(USE_SERIAL_COUNT_THRESHOLD, int)
END_REGISTER(SQ_THREAD_ARB_PRIORITY)

START_REGISTER(SQ_VS_WATCHDOG_TIMER)
    GENERATE_FIELD(ENABLE, int)
    GENERATE_FIELD(TIMEOUT_COUNT, int)
END_REGISTER(SQ_VS_WATCHDOG_TIMER)

START_REGISTER(SQ_PS_WATCHDOG_TIMER)
    GENERATE_FIELD(ENABLE, int)
    GENERATE_FIELD(TIMEOUT_COUNT, int)
END_REGISTER(SQ_PS_WATCHDOG_TIMER)

START_REGISTER(SQ_INT_CNTL)
    GENERATE_FIELD(PS_WATCHDOG_MASK, int)
    GENERATE_FIELD(VS_WATCHDOG_MASK, int)
END_REGISTER(SQ_INT_CNTL)

START_REGISTER(SQ_INT_STATUS)
    GENERATE_FIELD(PS_WATCHDOG_TIMEOUT, int)
    GENERATE_FIELD(VS_WATCHDOG_TIMEOUT, int)
END_REGISTER(SQ_INT_STATUS)

START_REGISTER(SQ_INT_ACK)
    GENERATE_FIELD(PS_WATCHDOG_ACK, int)
    GENERATE_FIELD(VS_WATCHDOG_ACK, int)
END_REGISTER(SQ_INT_ACK)

START_REGISTER(SQ_DEBUG_INPUT_FSM)
    GENERATE_FIELD(VC_VSR_LD, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(VC_GPR_LD, int)
    GENERATE_FIELD(PC_PISM, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(PC_AS, int)
    GENERATE_FIELD(PC_INTERP_CNT, int)
    GENERATE_FIELD(PC_GPR_SIZE, int)
END_REGISTER(SQ_DEBUG_INPUT_FSM)

START_REGISTER(SQ_DEBUG_CONST_MGR_FSM)
    GENERATE_FIELD(TEX_CONST_EVENT_STATE, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(ALU_CONST_EVENT_STATE, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(ALU_CONST_CNTX_VALID, int)
    GENERATE_FIELD(TEX_CONST_CNTX_VALID, int)
    GENERATE_FIELD(CNTX0_VTX_EVENT_DONE, int)
    GENERATE_FIELD(CNTX0_PIX_EVENT_DONE, int)
    GENERATE_FIELD(CNTX1_VTX_EVENT_DONE, int)
    GENERATE_FIELD(CNTX1_PIX_EVENT_DONE, int)
END_REGISTER(SQ_DEBUG_CONST_MGR_FSM)

START_REGISTER(SQ_DEBUG_TP_FSM)
    GENERATE_FIELD(EX_TP, int)
    GENERATE_FIELD(RESERVED0, int)
    GENERATE_FIELD(CF_TP, int)
    GENERATE_FIELD(IF_TP, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(TIS_TP, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(GS_TP, int)
    GENERATE_FIELD(RESERVED3, int)
    GENERATE_FIELD(FCR_TP, int)
    GENERATE_FIELD(RESERVED4, int)
    GENERATE_FIELD(FCS_TP, int)
    GENERATE_FIELD(RESERVED5, int)
    GENERATE_FIELD(ARB_TR_TP, int)
END_REGISTER(SQ_DEBUG_TP_FSM)

START_REGISTER(SQ_DEBUG_FSM_ALU_0)
    GENERATE_FIELD(EX_ALU_0, int)
    GENERATE_FIELD(RESERVED0, int)
    GENERATE_FIELD(CF_ALU_0, int)
    GENERATE_FIELD(IF_ALU_0, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(DU1_ALU_0, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(DU0_ALU_0, int)
    GENERATE_FIELD(RESERVED3, int)
    GENERATE_FIELD(AIS_ALU_0, int)
    GENERATE_FIELD(RESERVED4, int)
    GENERATE_FIELD(ACS_ALU_0, int)
    GENERATE_FIELD(RESERVED5, int)
    GENERATE_FIELD(ARB_TR_ALU, int)
END_REGISTER(SQ_DEBUG_FSM_ALU_0)

START_REGISTER(SQ_DEBUG_FSM_ALU_1)
    GENERATE_FIELD(EX_ALU_0, int)
    GENERATE_FIELD(RESERVED0, int)
    GENERATE_FIELD(CF_ALU_0, int)
    GENERATE_FIELD(IF_ALU_0, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(DU1_ALU_0, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(DU0_ALU_0, int)
    GENERATE_FIELD(RESERVED3, int)
    GENERATE_FIELD(AIS_ALU_0, int)
    GENERATE_FIELD(RESERVED4, int)
    GENERATE_FIELD(ACS_ALU_0, int)
    GENERATE_FIELD(RESERVED5, int)
    GENERATE_FIELD(ARB_TR_ALU, int)
END_REGISTER(SQ_DEBUG_FSM_ALU_1)

START_REGISTER(SQ_DEBUG_EXP_ALLOC)
    GENERATE_FIELD(POS_BUF_AVAIL, int)
    GENERATE_FIELD(COLOR_BUF_AVAIL, int)
    GENERATE_FIELD(EA_BUF_AVAIL, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(ALLOC_TBL_BUF_AVAIL, int)
END_REGISTER(SQ_DEBUG_EXP_ALLOC)

START_REGISTER(SQ_DEBUG_PTR_BUFF)
    GENERATE_FIELD(END_OF_BUFFER, int)
    GENERATE_FIELD(DEALLOC_CNT, int)
    GENERATE_FIELD(QUAL_NEW_VECTOR, int)
    GENERATE_FIELD(EVENT_CONTEXT_ID, int)
    GENERATE_FIELD(SC_EVENT_ID, int)
    GENERATE_FIELD(QUAL_EVENT, int)
    GENERATE_FIELD(PRIM_TYPE_POLYGON, int)
    GENERATE_FIELD(EF_EMPTY, int)
    GENERATE_FIELD(VTX_SYNC_CNT, int)
END_REGISTER(SQ_DEBUG_PTR_BUFF)

START_REGISTER(SQ_DEBUG_GPR_VTX)
    GENERATE_FIELD(VTX_TAIL_PTR, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(VTX_HEAD_PTR, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(VTX_MAX, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(VTX_FREE, int)
END_REGISTER(SQ_DEBUG_GPR_VTX)

START_REGISTER(SQ_DEBUG_GPR_PIX)
    GENERATE_FIELD(PIX_TAIL_PTR, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(PIX_HEAD_PTR, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(PIX_MAX, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(PIX_FREE, int)
END_REGISTER(SQ_DEBUG_GPR_PIX)

START_REGISTER(SQ_DEBUG_TB_STATUS_SEL)
    GENERATE_FIELD(VTX_TB_STATUS_REG_SEL, int)
    GENERATE_FIELD(VTX_TB_STATE_MEM_DW_SEL, int)
    GENERATE_FIELD(VTX_TB_STATE_MEM_RD_ADDR, int)
    GENERATE_FIELD(VTX_TB_STATE_MEM_RD_EN, int)
    GENERATE_FIELD(PIX_TB_STATE_MEM_RD_EN, int)
    GENERATE_FIELD(DEBUG_BUS_TRIGGER_SEL, int)
    GENERATE_FIELD(PIX_TB_STATUS_REG_SEL, int)
    GENERATE_FIELD(PIX_TB_STATE_MEM_DW_SEL, int)
    GENERATE_FIELD(PIX_TB_STATE_MEM_RD_ADDR, int)
    GENERATE_FIELD(VC_THREAD_BUF_DLY, int)
    GENERATE_FIELD(DISABLE_STRICT_CTX_SYNC, int)
END_REGISTER(SQ_DEBUG_TB_STATUS_SEL)

START_REGISTER(SQ_DEBUG_VTX_TB_0)
    GENERATE_FIELD(VTX_HEAD_PTR_Q, int)
    GENERATE_FIELD(TAIL_PTR_Q, int)
    GENERATE_FIELD(FULL_CNT_Q, int)
    GENERATE_FIELD(NXT_POS_ALLOC_CNT, int)
    GENERATE_FIELD(NXT_PC_ALLOC_CNT, int)
    GENERATE_FIELD(SX_EVENT_FULL, int)
    GENERATE_FIELD(BUSY_Q, int)
END_REGISTER(SQ_DEBUG_VTX_TB_0)

START_REGISTER(SQ_DEBUG_VTX_TB_1)
    GENERATE_FIELD(VS_DONE_PTR, int)
END_REGISTER(SQ_DEBUG_VTX_TB_1)

START_REGISTER(SQ_DEBUG_VTX_TB_STATUS_REG)
    GENERATE_FIELD(VS_STATUS_REG, int)
END_REGISTER(SQ_DEBUG_VTX_TB_STATUS_REG)

START_REGISTER(SQ_DEBUG_VTX_TB_STATE_MEM)
    GENERATE_FIELD(VS_STATE_MEM, int)
END_REGISTER(SQ_DEBUG_VTX_TB_STATE_MEM)

START_REGISTER(SQ_DEBUG_PIX_TB_0)
    GENERATE_FIELD(PIX_HEAD_PTR, int)
    GENERATE_FIELD(TAIL_PTR, int)
    GENERATE_FIELD(FULL_CNT, int)
    GENERATE_FIELD(NXT_PIX_ALLOC_CNT, int)
    GENERATE_FIELD(NXT_PIX_EXP_CNT, int)
    GENERATE_FIELD(BUSY, int)
END_REGISTER(SQ_DEBUG_PIX_TB_0)

START_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_0)
    GENERATE_FIELD(PIX_TB_STATUS_REG_0, int)
END_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_0)

START_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_1)
    GENERATE_FIELD(PIX_TB_STATUS_REG_1, int)
END_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_1)

START_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_2)
    GENERATE_FIELD(PIX_TB_STATUS_REG_2, int)
END_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_2)

START_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_3)
    GENERATE_FIELD(PIX_TB_STATUS_REG_3, int)
END_REGISTER(SQ_DEBUG_PIX_TB_STATUS_REG_3)

START_REGISTER(SQ_DEBUG_PIX_TB_STATE_MEM)
    GENERATE_FIELD(PIX_TB_STATE_MEM, int)
END_REGISTER(SQ_DEBUG_PIX_TB_STATE_MEM)

START_REGISTER(SQ_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, SQ_PERFCNT_SELECT)
END_REGISTER(SQ_PERFCOUNTER0_SELECT)

START_REGISTER(SQ_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(SQ_PERFCOUNTER1_SELECT)

START_REGISTER(SQ_PERFCOUNTER2_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(SQ_PERFCOUNTER2_SELECT)

START_REGISTER(SQ_PERFCOUNTER3_SELECT)
    GENERATE_FIELD(PERF_SEL, int)
END_REGISTER(SQ_PERFCOUNTER3_SELECT)

START_REGISTER(SQ_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER0_LOW)

START_REGISTER(SQ_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER0_HI)

START_REGISTER(SQ_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER1_LOW)

START_REGISTER(SQ_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER1_HI)

START_REGISTER(SQ_PERFCOUNTER2_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER2_LOW)

START_REGISTER(SQ_PERFCOUNTER2_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER2_HI)

START_REGISTER(SQ_PERFCOUNTER3_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER3_LOW)

START_REGISTER(SQ_PERFCOUNTER3_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SQ_PERFCOUNTER3_HI)

START_REGISTER(SX_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, SX_PERFCNT_SELECT)
END_REGISTER(SX_PERFCOUNTER0_SELECT)

START_REGISTER(SX_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SX_PERFCOUNTER0_LOW)

START_REGISTER(SX_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(SX_PERFCOUNTER0_HI)

START_REGISTER(SQ_INSTRUCTION_ALU_0)
    GENERATE_FIELD(VECTOR_RESULT, int)
    GENERATE_FIELD(VECTOR_DST_REL, Abs_modifier)
    GENERATE_FIELD(LOW_PRECISION_16B_FP, int)
    GENERATE_FIELD(SCALAR_RESULT, int)
    GENERATE_FIELD(SCALAR_DST_REL, int)
    GENERATE_FIELD(EXPORT_DATA, Exporting)
    GENERATE_FIELD(VECTOR_WRT_MSK, int)
    GENERATE_FIELD(SCALAR_WRT_MSK, int)
    GENERATE_FIELD(VECTOR_CLAMP, int)
    GENERATE_FIELD(SCALAR_CLAMP, int)
    GENERATE_FIELD(SCALAR_OPCODE, ScalarOpcode)
END_REGISTER(SQ_INSTRUCTION_ALU_0)

START_REGISTER(SQ_INSTRUCTION_ALU_1)
    GENERATE_FIELD(SRC_C_SWIZZLE_R, SwizzleType)
    GENERATE_FIELD(SRC_C_SWIZZLE_G, SwizzleType)
    GENERATE_FIELD(SRC_C_SWIZZLE_B, SwizzleType)
    GENERATE_FIELD(SRC_C_SWIZZLE_A, SwizzleType)
    GENERATE_FIELD(SRC_B_SWIZZLE_R, SwizzleType)
    GENERATE_FIELD(SRC_B_SWIZZLE_G, SwizzleType)
    GENERATE_FIELD(SRC_B_SWIZZLE_B, SwizzleType)
    GENERATE_FIELD(SRC_B_SWIZZLE_A, SwizzleType)
    GENERATE_FIELD(SRC_A_SWIZZLE_R, SwizzleType)
    GENERATE_FIELD(SRC_A_SWIZZLE_G, SwizzleType)
    GENERATE_FIELD(SRC_A_SWIZZLE_B, SwizzleType)
    GENERATE_FIELD(SRC_A_SWIZZLE_A, SwizzleType)
    GENERATE_FIELD(SRC_C_ARG_MOD, InputModifier)
    GENERATE_FIELD(SRC_B_ARG_MOD, InputModifier)
    GENERATE_FIELD(SRC_A_ARG_MOD, InputModifier)
    GENERATE_FIELD(PRED_SELECT, PredicateSelect)
    GENERATE_FIELD(RELATIVE_ADDR, int)
    GENERATE_FIELD(CONST_1_REL_ABS, int)
    GENERATE_FIELD(CONST_0_REL_ABS, int)
END_REGISTER(SQ_INSTRUCTION_ALU_1)

START_REGISTER(SQ_INSTRUCTION_ALU_2)
    GENERATE_FIELD(SRC_C_REG_PTR, int)
    GENERATE_FIELD(REG_SELECT_C, OperandSelect1)
    GENERATE_FIELD(REG_ABS_MOD_C, Abs_modifier)
    GENERATE_FIELD(SRC_B_REG_PTR, int)
    GENERATE_FIELD(REG_SELECT_B, OperandSelect1)
    GENERATE_FIELD(REG_ABS_MOD_B, Abs_modifier)
    GENERATE_FIELD(SRC_A_REG_PTR, int)
    GENERATE_FIELD(REG_SELECT_A, OperandSelect1)
    GENERATE_FIELD(REG_ABS_MOD_A, Abs_modifier)
    GENERATE_FIELD(VECTOR_OPCODE, VectorOpcode)
    GENERATE_FIELD(SRC_C_SEL, OperandSelect0)
    GENERATE_FIELD(SRC_B_SEL, OperandSelect0)
    GENERATE_FIELD(SRC_A_SEL, OperandSelect0)
END_REGISTER(SQ_INSTRUCTION_ALU_2)

START_REGISTER(SQ_INSTRUCTION_CF_EXEC_0)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(COUNT, int)
    GENERATE_FIELD(YIELD, int)
    GENERATE_FIELD(INST_TYPE_0, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_0, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_1, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_1, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_2, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_2, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_3, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_3, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_4, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_4, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_5, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_5, Instruction_serial)
    GENERATE_FIELD(INST_VC_0, VC_type)
    GENERATE_FIELD(INST_VC_1, VC_type)
    GENERATE_FIELD(INST_VC_2, VC_type)
    GENERATE_FIELD(INST_VC_3, VC_type)
END_REGISTER(SQ_INSTRUCTION_CF_EXEC_0)

START_REGISTER(SQ_INSTRUCTION_CF_EXEC_1)
    GENERATE_FIELD(INST_VC_4, VC_type)
    GENERATE_FIELD(INST_VC_5, VC_type)
    GENERATE_FIELD(BOOL_ADDR, int)
    GENERATE_FIELD(CONDITION, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(COUNT, int)
    GENERATE_FIELD(YIELD, int)
END_REGISTER(SQ_INSTRUCTION_CF_EXEC_1)

START_REGISTER(SQ_INSTRUCTION_CF_EXEC_2)
    GENERATE_FIELD(INST_TYPE_0, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_0, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_1, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_1, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_2, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_2, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_3, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_3, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_4, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_4, Instruction_serial)
    GENERATE_FIELD(INST_TYPE_5, Ressource_type)
    GENERATE_FIELD(INST_SERIAL_5, Instruction_serial)
    GENERATE_FIELD(INST_VC_0, VC_type)
    GENERATE_FIELD(INST_VC_1, VC_type)
    GENERATE_FIELD(INST_VC_2, VC_type)
    GENERATE_FIELD(INST_VC_3, VC_type)
    GENERATE_FIELD(INST_VC_4, VC_type)
    GENERATE_FIELD(INST_VC_5, VC_type)
    GENERATE_FIELD(BOOL_ADDR, int)
    GENERATE_FIELD(CONDITION, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
END_REGISTER(SQ_INSTRUCTION_CF_EXEC_2)

START_REGISTER(SQ_INSTRUCTION_CF_LOOP_0)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED_0, int)
    GENERATE_FIELD(LOOP_ID, int)
    GENERATE_FIELD(RESERVED_1, int)
END_REGISTER(SQ_INSTRUCTION_CF_LOOP_0)

START_REGISTER(SQ_INSTRUCTION_CF_LOOP_1)
    GENERATE_FIELD(RESERVED_0, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED_1, int)
END_REGISTER(SQ_INSTRUCTION_CF_LOOP_1)

START_REGISTER(SQ_INSTRUCTION_CF_LOOP_2)
    GENERATE_FIELD(LOOP_ID, int)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
END_REGISTER(SQ_INSTRUCTION_CF_LOOP_2)

START_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_0)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED_0, int)
    GENERATE_FIELD(FORCE_CALL, int)
    GENERATE_FIELD(PREDICATED_JMP, int)
    GENERATE_FIELD(RESERVED_1, int)
END_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_0)

START_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_1)
    GENERATE_FIELD(RESERVED_0, int)
    GENERATE_FIELD(DIRECTION, int)
    GENERATE_FIELD(BOOL_ADDR, int)
    GENERATE_FIELD(CONDITION, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
    GENERATE_FIELD(ADDRESS, int)
    GENERATE_FIELD(RESERVED_1, int)
    GENERATE_FIELD(FORCE_CALL, int)
    GENERATE_FIELD(RESERVED_2, int)
END_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_1)

START_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_2)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(DIRECTION, int)
    GENERATE_FIELD(BOOL_ADDR, int)
    GENERATE_FIELD(CONDITION, int)
    GENERATE_FIELD(ADDRESS_MODE, Addressing)
    GENERATE_FIELD(OPCODE, CFOpcode)
END_REGISTER(SQ_INSTRUCTION_CF_JMP_CALL_2)

START_REGISTER(SQ_INSTRUCTION_CF_ALLOC_0)
    GENERATE_FIELD(SIZE, int)
    GENERATE_FIELD(RESERVED, int)
END_REGISTER(SQ_INSTRUCTION_CF_ALLOC_0)

START_REGISTER(SQ_INSTRUCTION_CF_ALLOC_1)
    GENERATE_FIELD(RESERVED_0, int)
    GENERATE_FIELD(NO_SERIAL, int)
    GENERATE_FIELD(BUFFER_SELECT, Allocation_type)
    GENERATE_FIELD(ALLOC_MODE, int)
    GENERATE_FIELD(OPCODE, CFOpcode)
    GENERATE_FIELD(SIZE, int)
    GENERATE_FIELD(RESERVED_1, int)
END_REGISTER(SQ_INSTRUCTION_CF_ALLOC_1)

START_REGISTER(SQ_INSTRUCTION_CF_ALLOC_2)
    GENERATE_FIELD(RESERVED, int)
    GENERATE_FIELD(NO_SERIAL, int)
    GENERATE_FIELD(BUFFER_SELECT, Allocation_type)
    GENERATE_FIELD(ALLOC_MODE, int)
    GENERATE_FIELD(OPCODE, CFOpcode)
END_REGISTER(SQ_INSTRUCTION_CF_ALLOC_2)

START_REGISTER(SQ_INSTRUCTION_TFETCH_0)
    GENERATE_FIELD(OPCODE, TexInstOpcode)
    GENERATE_FIELD(SRC_GPR, int)
    GENERATE_FIELD(SRC_GPR_AM, Addressmode)
    GENERATE_FIELD(DST_GPR, int)
    GENERATE_FIELD(DST_GPR_AM, Addressmode)
    GENERATE_FIELD(FETCH_VALID_ONLY, int)
    GENERATE_FIELD(CONST_INDEX, int)
    GENERATE_FIELD(TX_COORD_DENORM, TexCoordDenorm)
    GENERATE_FIELD(SRC_SEL_X, SrcSel)
    GENERATE_FIELD(SRC_SEL_Y, SrcSel)
    GENERATE_FIELD(SRC_SEL_Z, SrcSel)
END_REGISTER(SQ_INSTRUCTION_TFETCH_0)

START_REGISTER(SQ_INSTRUCTION_TFETCH_1)
    GENERATE_FIELD(DST_SEL_X, DstSel)
    GENERATE_FIELD(DST_SEL_Y, DstSel)
    GENERATE_FIELD(DST_SEL_Z, DstSel)
    GENERATE_FIELD(DST_SEL_W, DstSel)
    GENERATE_FIELD(MAG_FILTER, MagFilter)
    GENERATE_FIELD(MIN_FILTER, MinFilter)
    GENERATE_FIELD(MIP_FILTER, MipFilter)
    GENERATE_FIELD(ANISO_FILTER, AnisoFilter)
    GENERATE_FIELD(ARBITRARY_FILTER, ArbitraryFilter)
    GENERATE_FIELD(VOL_MAG_FILTER, VolMagFilter)
    GENERATE_FIELD(VOL_MIN_FILTER, VolMinFilter)
    GENERATE_FIELD(USE_COMP_LOD, int)
    GENERATE_FIELD(USE_REG_LOD, int)
    GENERATE_FIELD(PRED_SELECT, PredSelect)
END_REGISTER(SQ_INSTRUCTION_TFETCH_1)

START_REGISTER(SQ_INSTRUCTION_TFETCH_2)
    GENERATE_FIELD(USE_REG_GRADIENTS, int)
    GENERATE_FIELD(SAMPLE_LOCATION, SampleLocation)
    GENERATE_FIELD(LOD_BIAS, int)
    GENERATE_FIELD(UNUSED, int)
    GENERATE_FIELD(OFFSET_X, int)
    GENERATE_FIELD(OFFSET_Y, int)
    GENERATE_FIELD(OFFSET_Z, int)
    GENERATE_FIELD(PRED_CONDITION, int)
END_REGISTER(SQ_INSTRUCTION_TFETCH_2)

START_REGISTER(SQ_INSTRUCTION_VFETCH_0)
    GENERATE_FIELD(OPCODE, int)
    GENERATE_FIELD(SRC_GPR, int)
    GENERATE_FIELD(SRC_GPR_AM, int)
    GENERATE_FIELD(DST_GPR, int)
    GENERATE_FIELD(DST_GPR_AM, int)
    GENERATE_FIELD(MUST_BE_ONE, int)
    GENERATE_FIELD(CONST_INDEX, int)
    GENERATE_FIELD(CONST_INDEX_SEL, int)
    GENERATE_FIELD(SRC_SEL, int)
END_REGISTER(SQ_INSTRUCTION_VFETCH_0)

START_REGISTER(SQ_INSTRUCTION_VFETCH_1)
    GENERATE_FIELD(DST_SEL_X, int)
    GENERATE_FIELD(DST_SEL_Y, int)
    GENERATE_FIELD(DST_SEL_Z, int)
    GENERATE_FIELD(DST_SEL_W, int)
    GENERATE_FIELD(FORMAT_COMP_ALL, int)
    GENERATE_FIELD(NUM_FORMAT_ALL, int)
    GENERATE_FIELD(SIGNED_RF_MODE_ALL, int)
    GENERATE_FIELD(DATA_FORMAT, int)
    GENERATE_FIELD(EXP_ADJUST_ALL, int)
    GENERATE_FIELD(PRED_SELECT, int)
END_REGISTER(SQ_INSTRUCTION_VFETCH_1)

START_REGISTER(SQ_INSTRUCTION_VFETCH_2)
    GENERATE_FIELD(STRIDE, int)
    GENERATE_FIELD(OFFSET, int)
    GENERATE_FIELD(PRED_CONDITION, int)
END_REGISTER(SQ_INSTRUCTION_VFETCH_2)

START_REGISTER(SQ_CONSTANT_0)
    GENERATE_FIELD(RED, float)
END_REGISTER(SQ_CONSTANT_0)

START_REGISTER(SQ_CONSTANT_1)
    GENERATE_FIELD(GREEN, float)
END_REGISTER(SQ_CONSTANT_1)

START_REGISTER(SQ_CONSTANT_2)
    GENERATE_FIELD(BLUE, float)
END_REGISTER(SQ_CONSTANT_2)

START_REGISTER(SQ_CONSTANT_3)
    GENERATE_FIELD(ALPHA, float)
END_REGISTER(SQ_CONSTANT_3)

START_REGISTER(SQ_FETCH_0)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_0)

START_REGISTER(SQ_FETCH_1)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_1)

START_REGISTER(SQ_FETCH_2)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_2)

START_REGISTER(SQ_FETCH_3)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_3)

START_REGISTER(SQ_FETCH_4)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_4)

START_REGISTER(SQ_FETCH_5)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_5)

START_REGISTER(SQ_CONSTANT_VFETCH_0)
    GENERATE_FIELD(TYPE, int)
    GENERATE_FIELD(STATE, int)
    GENERATE_FIELD(BASE_ADDRESS, hex)
END_REGISTER(SQ_CONSTANT_VFETCH_0)

START_REGISTER(SQ_CONSTANT_VFETCH_1)
    GENERATE_FIELD(ENDIAN_SWAP, int)
    GENERATE_FIELD(LIMIT_ADDRESS, hex)
END_REGISTER(SQ_CONSTANT_VFETCH_1)

START_REGISTER(SQ_CONSTANT_T2)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_CONSTANT_T2)

START_REGISTER(SQ_CONSTANT_T3)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_CONSTANT_T3)

START_REGISTER(SQ_CF_BOOLEANS)
    GENERATE_FIELD(CF_BOOLEANS_0, int)
    GENERATE_FIELD(CF_BOOLEANS_1, int)
    GENERATE_FIELD(CF_BOOLEANS_2, int)
    GENERATE_FIELD(CF_BOOLEANS_3, int)
END_REGISTER(SQ_CF_BOOLEANS)

START_REGISTER(SQ_CF_LOOP)
    GENERATE_FIELD(CF_LOOP_COUNT, int)
    GENERATE_FIELD(CF_LOOP_START, int)
    GENERATE_FIELD(CF_LOOP_STEP, int)
END_REGISTER(SQ_CF_LOOP)

START_REGISTER(SQ_CONSTANT_RT_0)
    GENERATE_FIELD(RED, float)
END_REGISTER(SQ_CONSTANT_RT_0)

START_REGISTER(SQ_CONSTANT_RT_1)
    GENERATE_FIELD(GREEN, float)
END_REGISTER(SQ_CONSTANT_RT_1)

START_REGISTER(SQ_CONSTANT_RT_2)
    GENERATE_FIELD(BLUE, float)
END_REGISTER(SQ_CONSTANT_RT_2)

START_REGISTER(SQ_CONSTANT_RT_3)
    GENERATE_FIELD(ALPHA, float)
END_REGISTER(SQ_CONSTANT_RT_3)

START_REGISTER(SQ_FETCH_RT_0)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_0)

START_REGISTER(SQ_FETCH_RT_1)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_1)

START_REGISTER(SQ_FETCH_RT_2)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_2)

START_REGISTER(SQ_FETCH_RT_3)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_3)

START_REGISTER(SQ_FETCH_RT_4)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_4)

START_REGISTER(SQ_FETCH_RT_5)
    GENERATE_FIELD(VALUE, int)
END_REGISTER(SQ_FETCH_RT_5)

START_REGISTER(SQ_CF_RT_BOOLEANS)
    GENERATE_FIELD(CF_BOOLEANS_0, int)
    GENERATE_FIELD(CF_BOOLEANS_1, int)
    GENERATE_FIELD(CF_BOOLEANS_2, int)
    GENERATE_FIELD(CF_BOOLEANS_3, int)
END_REGISTER(SQ_CF_RT_BOOLEANS)

START_REGISTER(SQ_CF_RT_LOOP)
    GENERATE_FIELD(CF_LOOP_COUNT, int)
    GENERATE_FIELD(CF_LOOP_START, int)
    GENERATE_FIELD(CF_LOOP_STEP, int)
END_REGISTER(SQ_CF_RT_LOOP)

START_REGISTER(SQ_VS_PROGRAM)
    GENERATE_FIELD(BASE, int)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(SQ_VS_PROGRAM)

START_REGISTER(SQ_PS_PROGRAM)
    GENERATE_FIELD(BASE, int)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(SQ_PS_PROGRAM)

START_REGISTER(SQ_CF_PROGRAM_SIZE)
    GENERATE_FIELD(VS_CF_SIZE, int)
    GENERATE_FIELD(PS_CF_SIZE, int)
END_REGISTER(SQ_CF_PROGRAM_SIZE)

START_REGISTER(SQ_INTERPOLATOR_CNTL)
    GENERATE_FIELD(PARAM_SHADE, ParamShade)
    GENERATE_FIELD(SAMPLING_PATTERN, SamplingPattern)
END_REGISTER(SQ_INTERPOLATOR_CNTL)

START_REGISTER(SQ_PROGRAM_CNTL)
    GENERATE_FIELD(VS_NUM_REG, intMinusOne)
    GENERATE_FIELD(PS_NUM_REG, intMinusOne)
    GENERATE_FIELD(VS_RESOURCE, int)
    GENERATE_FIELD(PS_RESOURCE, int)
    GENERATE_FIELD(PARAM_GEN, int)
    GENERATE_FIELD(GEN_INDEX_PIX, int)
    GENERATE_FIELD(VS_EXPORT_COUNT, intMinusOne)
    GENERATE_FIELD(VS_EXPORT_MODE, VertexMode)
    GENERATE_FIELD(PS_EXPORT_MODE, int)
    GENERATE_FIELD(GEN_INDEX_VTX, int)
END_REGISTER(SQ_PROGRAM_CNTL)

START_REGISTER(SQ_WRAPPING_0)
    GENERATE_FIELD(PARAM_WRAP_0, hex)
    GENERATE_FIELD(PARAM_WRAP_1, hex)
    GENERATE_FIELD(PARAM_WRAP_2, hex)
    GENERATE_FIELD(PARAM_WRAP_3, hex)
    GENERATE_FIELD(PARAM_WRAP_4, hex)
    GENERATE_FIELD(PARAM_WRAP_5, hex)
    GENERATE_FIELD(PARAM_WRAP_6, hex)
    GENERATE_FIELD(PARAM_WRAP_7, hex)
END_REGISTER(SQ_WRAPPING_0)

START_REGISTER(SQ_WRAPPING_1)
    GENERATE_FIELD(PARAM_WRAP_8, hex)
    GENERATE_FIELD(PARAM_WRAP_9, hex)
    GENERATE_FIELD(PARAM_WRAP_10, hex)
    GENERATE_FIELD(PARAM_WRAP_11, hex)
    GENERATE_FIELD(PARAM_WRAP_12, hex)
    GENERATE_FIELD(PARAM_WRAP_13, hex)
    GENERATE_FIELD(PARAM_WRAP_14, hex)
    GENERATE_FIELD(PARAM_WRAP_15, hex)
END_REGISTER(SQ_WRAPPING_1)

START_REGISTER(SQ_VS_CONST)
    GENERATE_FIELD(BASE, int)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(SQ_VS_CONST)

START_REGISTER(SQ_PS_CONST)
    GENERATE_FIELD(BASE, int)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(SQ_PS_CONST)

START_REGISTER(SQ_CONTEXT_MISC)
    GENERATE_FIELD(INST_PRED_OPTIMIZE, int)
    GENERATE_FIELD(SC_OUTPUT_SCREEN_XY, int)
    GENERATE_FIELD(SC_SAMPLE_CNTL, Sample_Cntl)
    GENERATE_FIELD(PARAM_GEN_POS, int)
    GENERATE_FIELD(PERFCOUNTER_REF, int)
    GENERATE_FIELD(YEILD_OPTIMIZE, int)
    GENERATE_FIELD(TX_CACHE_SEL, int)
END_REGISTER(SQ_CONTEXT_MISC)

START_REGISTER(SQ_CF_RD_BASE)
    GENERATE_FIELD(RD_BASE, hex)
END_REGISTER(SQ_CF_RD_BASE)

START_REGISTER(SQ_DEBUG_MISC_0)
    GENERATE_FIELD(DB_PROB_ON, int)
    GENERATE_FIELD(DB_PROB_BREAK, int)
    GENERATE_FIELD(DB_PROB_ADDR, int)
    GENERATE_FIELD(DB_PROB_COUNT, int)
END_REGISTER(SQ_DEBUG_MISC_0)

START_REGISTER(SQ_DEBUG_MISC_1)
    GENERATE_FIELD(DB_ON_PIX, int)
    GENERATE_FIELD(DB_ON_VTX, int)
    GENERATE_FIELD(DB_INST_COUNT, int)
    GENERATE_FIELD(DB_BREAK_ADDR, int)
END_REGISTER(SQ_DEBUG_MISC_1)

START_REGISTER(MH_ARBITER_CONFIG)
    GENERATE_FIELD(SAME_PAGE_LIMIT, int)
    GENERATE_FIELD(SAME_PAGE_GRANULARITY, int)
    GENERATE_FIELD(L1_ARB_ENABLE, bool)
    GENERATE_FIELD(L1_ARB_HOLD_ENABLE, int)
    GENERATE_FIELD(L2_ARB_CONTROL, int)
    GENERATE_FIELD(PAGE_SIZE, int)
    GENERATE_FIELD(TC_REORDER_ENABLE, bool)
    GENERATE_FIELD(TC_ARB_HOLD_ENABLE, bool)
    GENERATE_FIELD(IN_FLIGHT_LIMIT_ENABLE, bool)
    GENERATE_FIELD(IN_FLIGHT_LIMIT, int)
    GENERATE_FIELD(CP_CLNT_ENABLE, bool)
    GENERATE_FIELD(VGT_CLNT_ENABLE, bool)
    GENERATE_FIELD(TC_CLNT_ENABLE, bool)
    GENERATE_FIELD(RB_CLNT_ENABLE, bool)
    GENERATE_FIELD(PA_CLNT_ENABLE, bool)
END_REGISTER(MH_ARBITER_CONFIG)

START_REGISTER(MH_CLNT_AXI_ID_REUSE)
    GENERATE_FIELD(CPw_ID, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(RBw_ID, int)
    GENERATE_FIELD(RESERVED2, int)
    GENERATE_FIELD(MMUr_ID, int)
    GENERATE_FIELD(RESERVED3, int)
    GENERATE_FIELD(PAw_ID, int)
END_REGISTER(MH_CLNT_AXI_ID_REUSE)

START_REGISTER(MH_INTERRUPT_MASK)
    GENERATE_FIELD(AXI_READ_ERROR, bool)
    GENERATE_FIELD(AXI_WRITE_ERROR, bool)
    GENERATE_FIELD(MMU_PAGE_FAULT, bool)
END_REGISTER(MH_INTERRUPT_MASK)

START_REGISTER(MH_INTERRUPT_STATUS)
    GENERATE_FIELD(AXI_READ_ERROR, int)
    GENERATE_FIELD(AXI_WRITE_ERROR, int)
    GENERATE_FIELD(MMU_PAGE_FAULT, int)
END_REGISTER(MH_INTERRUPT_STATUS)

START_REGISTER(MH_INTERRUPT_CLEAR)
    GENERATE_FIELD(AXI_READ_ERROR, int)
    GENERATE_FIELD(AXI_WRITE_ERROR, int)
    GENERATE_FIELD(MMU_PAGE_FAULT, int)
END_REGISTER(MH_INTERRUPT_CLEAR)

START_REGISTER(MH_AXI_ERROR)
    GENERATE_FIELD(AXI_READ_ID, int)
    GENERATE_FIELD(AXI_READ_ERROR, int)
    GENERATE_FIELD(AXI_WRITE_ID, int)
    GENERATE_FIELD(AXI_WRITE_ERROR, int)
END_REGISTER(MH_AXI_ERROR)

START_REGISTER(MH_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, MhPerfEncode)
END_REGISTER(MH_PERFCOUNTER0_SELECT)

START_REGISTER(MH_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERF_SEL, MhPerfEncode)
END_REGISTER(MH_PERFCOUNTER1_SELECT)

START_REGISTER(MH_PERFCOUNTER0_CONFIG)
    GENERATE_FIELD(N_VALUE, int)
END_REGISTER(MH_PERFCOUNTER0_CONFIG)

START_REGISTER(MH_PERFCOUNTER1_CONFIG)
    GENERATE_FIELD(N_VALUE, int)
END_REGISTER(MH_PERFCOUNTER1_CONFIG)

START_REGISTER(MH_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNTER_LOW, int)
END_REGISTER(MH_PERFCOUNTER0_LOW)

START_REGISTER(MH_PERFCOUNTER1_LOW)
    GENERATE_FIELD(PERF_COUNTER_LOW, int)
END_REGISTER(MH_PERFCOUNTER1_LOW)

START_REGISTER(MH_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNTER_HI, int)
END_REGISTER(MH_PERFCOUNTER0_HI)

START_REGISTER(MH_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERF_COUNTER_HI, int)
END_REGISTER(MH_PERFCOUNTER1_HI)

START_REGISTER(MH_DEBUG_CTRL)
    GENERATE_FIELD(INDEX, int)
END_REGISTER(MH_DEBUG_CTRL)

START_REGISTER(MH_DEBUG_DATA)
    GENERATE_FIELD(DATA, int)
END_REGISTER(MH_DEBUG_DATA)

START_REGISTER(MH_AXI_HALT_CONTROL)
    GENERATE_FIELD(AXI_HALT, bool)
END_REGISTER(MH_AXI_HALT_CONTROL)

START_REGISTER(MH_MMU_CONFIG)
    GENERATE_FIELD(MMU_ENABLE, bool)
    GENERATE_FIELD(SPLIT_MODE_ENABLE, bool)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(RB_W_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_W_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_R0_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_R1_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_R2_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_R3_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(CP_R4_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(VGT_R0_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(VGT_R1_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(TC_R_CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(PA_W_CLNT_BEHAVIOR, MmuClntBeh)
END_REGISTER(MH_MMU_CONFIG)

START_REGISTER(MH_MMU_VA_RANGE)
    GENERATE_FIELD(NUM_64KB_REGIONS, int)
    GENERATE_FIELD(VA_BASE, int)
END_REGISTER(MH_MMU_VA_RANGE)

START_REGISTER(MH_MMU_PT_BASE)
    GENERATE_FIELD(PT_BASE, int)
END_REGISTER(MH_MMU_PT_BASE)

START_REGISTER(MH_MMU_PAGE_FAULT)
    GENERATE_FIELD(PAGE_FAULT, int)
    GENERATE_FIELD(OP_TYPE, int)
    GENERATE_FIELD(CLNT_BEHAVIOR, MmuClntBeh)
    GENERATE_FIELD(AXI_ID, int)
    GENERATE_FIELD(RESERVED1, int)
    GENERATE_FIELD(MPU_ADDRESS_OUT_OF_RANGE, int)
    GENERATE_FIELD(ADDRESS_OUT_OF_RANGE, int)
    GENERATE_FIELD(READ_PROTECTION_ERROR, int)
    GENERATE_FIELD(WRITE_PROTECTION_ERROR, int)
    GENERATE_FIELD(REQ_VA, int)
END_REGISTER(MH_MMU_PAGE_FAULT)

START_REGISTER(MH_MMU_TRAN_ERROR)
    GENERATE_FIELD(TRAN_ERROR, int)
END_REGISTER(MH_MMU_TRAN_ERROR)

START_REGISTER(MH_MMU_INVALIDATE)
    GENERATE_FIELD(INVALIDATE_ALL, int)
    GENERATE_FIELD(INVALIDATE_TC, int)
END_REGISTER(MH_MMU_INVALIDATE)

START_REGISTER(MH_MMU_MPU_BASE)
    GENERATE_FIELD(MPU_BASE, int)
END_REGISTER(MH_MMU_MPU_BASE)

START_REGISTER(MH_MMU_MPU_END)
    GENERATE_FIELD(MPU_END, int)
END_REGISTER(MH_MMU_MPU_END)

START_REGISTER(WAIT_UNTIL)
    GENERATE_FIELD(WAIT_RE_VSYNC, int)
    GENERATE_FIELD(WAIT_FE_VSYNC, int)
    GENERATE_FIELD(WAIT_VSYNC, int)
    GENERATE_FIELD(WAIT_DSPLY_ID0, int)
    GENERATE_FIELD(WAIT_DSPLY_ID1, int)
    GENERATE_FIELD(WAIT_DSPLY_ID2, int)
    GENERATE_FIELD(WAIT_CMDFIFO, int)
    GENERATE_FIELD(WAIT_2D_IDLE, int)
    GENERATE_FIELD(WAIT_3D_IDLE, int)
    GENERATE_FIELD(WAIT_2D_IDLECLEAN, int)
    GENERATE_FIELD(WAIT_3D_IDLECLEAN, int)
    GENERATE_FIELD(CMDFIFO_ENTRIES, int)
END_REGISTER(WAIT_UNTIL)

START_REGISTER(RBBM_ISYNC_CNTL)
    GENERATE_FIELD(ISYNC_WAIT_IDLEGUI, int)
    GENERATE_FIELD(ISYNC_CPSCRATCH_IDLEGUI, int)
END_REGISTER(RBBM_ISYNC_CNTL)

START_REGISTER(RBBM_STATUS)
    GENERATE_FIELD(CMDFIFO_AVAIL, int)
    GENERATE_FIELD(TC_BUSY, int)
    GENERATE_FIELD(HIRQ_PENDING, int)
    GENERATE_FIELD(CPRQ_PENDING, int)
    GENERATE_FIELD(CFRQ_PENDING, int)
    GENERATE_FIELD(PFRQ_PENDING, int)
    GENERATE_FIELD(VGT_BUSY_NO_DMA, int)
    GENERATE_FIELD(RBBM_WU_BUSY, int)
    GENERATE_FIELD(CP_NRT_BUSY, int)
    GENERATE_FIELD(MH_BUSY, int)
    GENERATE_FIELD(MH_COHERENCY_BUSY, int)
    GENERATE_FIELD(SX_BUSY, int)
    GENERATE_FIELD(TPC_BUSY, int)
    GENERATE_FIELD(SC_CNTX_BUSY, int)
    GENERATE_FIELD(PA_BUSY, int)
    GENERATE_FIELD(VGT_BUSY, int)
    GENERATE_FIELD(SQ_CNTX17_BUSY, int)
    GENERATE_FIELD(SQ_CNTX0_BUSY, int)
    GENERATE_FIELD(RB_CNTX_BUSY, int)
    GENERATE_FIELD(GUI_ACTIVE, int)
END_REGISTER(RBBM_STATUS)

START_REGISTER(RBBM_DSPLY)
    GENERATE_FIELD(SEL_DMI_ACTIVE_BUFID0, int)
    GENERATE_FIELD(SEL_DMI_ACTIVE_BUFID1, int)
    GENERATE_FIELD(SEL_DMI_ACTIVE_BUFID2, int)
    GENERATE_FIELD(SEL_DMI_VSYNC_VALID, int)
    GENERATE_FIELD(DMI_CH1_USE_BUFID0, int)
    GENERATE_FIELD(DMI_CH1_USE_BUFID1, int)
    GENERATE_FIELD(DMI_CH1_USE_BUFID2, int)
    GENERATE_FIELD(DMI_CH1_SW_CNTL, int)
    GENERATE_FIELD(DMI_CH1_NUM_BUFS, int)
    GENERATE_FIELD(DMI_CH2_USE_BUFID0, int)
    GENERATE_FIELD(DMI_CH2_USE_BUFID1, int)
    GENERATE_FIELD(DMI_CH2_USE_BUFID2, int)
    GENERATE_FIELD(DMI_CH2_SW_CNTL, int)
    GENERATE_FIELD(DMI_CH2_NUM_BUFS, int)
    GENERATE_FIELD(DMI_CHANNEL_SELECT, int)
    GENERATE_FIELD(DMI_CH3_USE_BUFID0, int)
    GENERATE_FIELD(DMI_CH3_USE_BUFID1, int)
    GENERATE_FIELD(DMI_CH3_USE_BUFID2, int)
    GENERATE_FIELD(DMI_CH3_SW_CNTL, int)
    GENERATE_FIELD(DMI_CH3_NUM_BUFS, int)
    GENERATE_FIELD(DMI_CH4_USE_BUFID0, int)
    GENERATE_FIELD(DMI_CH4_USE_BUFID1, int)
    GENERATE_FIELD(DMI_CH4_USE_BUFID2, int)
    GENERATE_FIELD(DMI_CH4_SW_CNTL, int)
    GENERATE_FIELD(DMI_CH4_NUM_BUFS, int)
END_REGISTER(RBBM_DSPLY)

START_REGISTER(RBBM_RENDER_LATEST)
    GENERATE_FIELD(DMI_CH1_BUFFER_ID, int)
    GENERATE_FIELD(DMI_CH2_BUFFER_ID, int)
    GENERATE_FIELD(DMI_CH3_BUFFER_ID, int)
    GENERATE_FIELD(DMI_CH4_BUFFER_ID, int)
END_REGISTER(RBBM_RENDER_LATEST)

START_REGISTER(RBBM_RTL_RELEASE)
    GENERATE_FIELD(CHANGELIST, int)
END_REGISTER(RBBM_RTL_RELEASE)

START_REGISTER(RBBM_PATCH_RELEASE)
    GENERATE_FIELD(PATCH_REVISION, int)
    GENERATE_FIELD(PATCH_SELECTION, int)
    GENERATE_FIELD(CUSTOMER_ID, int)
END_REGISTER(RBBM_PATCH_RELEASE)

START_REGISTER(RBBM_AUXILIARY_CONFIG)
    GENERATE_FIELD(RESERVED, int)
END_REGISTER(RBBM_AUXILIARY_CONFIG)

START_REGISTER(RBBM_PERIPHID0)
    GENERATE_FIELD(PARTNUMBER0, int)
END_REGISTER(RBBM_PERIPHID0)

START_REGISTER(RBBM_PERIPHID1)
    GENERATE_FIELD(PARTNUMBER1, int)
    GENERATE_FIELD(DESIGNER0, int)
END_REGISTER(RBBM_PERIPHID1)

START_REGISTER(RBBM_PERIPHID2)
    GENERATE_FIELD(DESIGNER1, int)
    GENERATE_FIELD(REVISION, int)
END_REGISTER(RBBM_PERIPHID2)

START_REGISTER(RBBM_PERIPHID3)
    GENERATE_FIELD(RBBM_HOST_INTERFACE, int)
    GENERATE_FIELD(GARB_SLAVE_INTERFACE, int)
    GENERATE_FIELD(MH_INTERFACE, int)
    GENERATE_FIELD(CONTINUATION, int)
END_REGISTER(RBBM_PERIPHID3)

START_REGISTER(RBBM_CNTL)
    GENERATE_FIELD(READ_TIMEOUT, int)
    GENERATE_FIELD(REGCLK_DEASSERT_TIME, int)
END_REGISTER(RBBM_CNTL)

START_REGISTER(RBBM_SKEW_CNTL)
    GENERATE_FIELD(SKEW_TOP_THRESHOLD, int)
    GENERATE_FIELD(SKEW_COUNT, int)
END_REGISTER(RBBM_SKEW_CNTL)

START_REGISTER(RBBM_SOFT_RESET)
    GENERATE_FIELD(SOFT_RESET_CP, int)
    GENERATE_FIELD(SOFT_RESET_PA, int)
    GENERATE_FIELD(SOFT_RESET_MH, int)
    GENERATE_FIELD(SOFT_RESET_BC, int)
    GENERATE_FIELD(SOFT_RESET_SQ, int)
    GENERATE_FIELD(SOFT_RESET_SX, int)
    GENERATE_FIELD(SOFT_RESET_CIB, int)
    GENERATE_FIELD(SOFT_RESET_SC, int)
    GENERATE_FIELD(SOFT_RESET_VGT, int)
END_REGISTER(RBBM_SOFT_RESET)

START_REGISTER(RBBM_PM_OVERRIDE1)
    GENERATE_FIELD(RBBM_AHBCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SC_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SC_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SP_TOP_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SP_V0_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SQ_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SQ_REG_FIFOS_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SQ_CONST_MEM_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SQ_SQ_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SX_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SX_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCM_TCO_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCM_TCM_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCM_TCD_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCM_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TPC_TPC_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TPC_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCF_TCA_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCF_TCB_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TCF_TCB_READ_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TP_TP_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(TP_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(CP_G_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(CP_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(CP_G_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(SPI_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(RB_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(RB_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(MH_MH_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(MH_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(MH_MMU_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(MH_TCROQ_SCLK_PM_OVERRIDE, int)
END_REGISTER(RBBM_PM_OVERRIDE1)

START_REGISTER(RBBM_PM_OVERRIDE2)
    GENERATE_FIELD(PA_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(PA_PA_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(PA_AG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(VGT_REG_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(VGT_FIFOS_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(VGT_VGT_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(DEBUG_PERF_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(PERM_SCLK_PM_OVERRIDE, int)
    GENERATE_FIELD(GC_GA_GMEM0_PM_OVERRIDE, int)
    GENERATE_FIELD(GC_GA_GMEM1_PM_OVERRIDE, int)
    GENERATE_FIELD(GC_GA_GMEM2_PM_OVERRIDE, int)
    GENERATE_FIELD(GC_GA_GMEM3_PM_OVERRIDE, int)
END_REGISTER(RBBM_PM_OVERRIDE2)

START_REGISTER(GC_SYS_IDLE)
    GENERATE_FIELD(GC_SYS_IDLE_DELAY, int)
    GENERATE_FIELD(GC_SYS_WAIT_DMI_MASK, int)
    GENERATE_FIELD(GC_SYS_URGENT_RAMP, int)
    GENERATE_FIELD(GC_SYS_WAIT_DMI, int)
    GENERATE_FIELD(GC_SYS_URGENT_RAMP_OVERRIDE, int)
    GENERATE_FIELD(GC_SYS_WAIT_DMI_OVERRIDE, int)
    GENERATE_FIELD(GC_SYS_IDLE_OVERRIDE, int)
END_REGISTER(GC_SYS_IDLE)

START_REGISTER(NQWAIT_UNTIL)
    GENERATE_FIELD(WAIT_GUI_IDLE, int)
END_REGISTER(NQWAIT_UNTIL)

START_REGISTER(RBBM_DEBUG_OUT)
    GENERATE_FIELD(DEBUG_BUS_OUT, int)
END_REGISTER(RBBM_DEBUG_OUT)

START_REGISTER(RBBM_DEBUG_CNTL)
    GENERATE_FIELD(SUB_BLOCK_ADDR, int)
    GENERATE_FIELD(SUB_BLOCK_SEL, int)
    GENERATE_FIELD(SW_ENABLE, int)
    GENERATE_FIELD(GPIO_SUB_BLOCK_ADDR, int)
    GENERATE_FIELD(GPIO_SUB_BLOCK_SEL, int)
    GENERATE_FIELD(GPIO_BYTE_LANE_ENB, int)
END_REGISTER(RBBM_DEBUG_CNTL)

START_REGISTER(RBBM_DEBUG)
    GENERATE_FIELD(IGNORE_RTR, int)
    GENERATE_FIELD(IGNORE_CP_SCHED_WU, int)
    GENERATE_FIELD(IGNORE_CP_SCHED_ISYNC, int)
    GENERATE_FIELD(IGNORE_CP_SCHED_NQ_HI, int)
    GENERATE_FIELD(HYSTERESIS_NRT_GUI_ACTIVE, int)
    GENERATE_FIELD(IGNORE_RTR_FOR_HI, int)
    GENERATE_FIELD(IGNORE_CP_RBBM_NRTRTR_FOR_HI, int)
    GENERATE_FIELD(IGNORE_VGT_RBBM_NRTRTR_FOR_HI, int)
    GENERATE_FIELD(IGNORE_SQ_RBBM_NRTRTR_FOR_HI, int)
    GENERATE_FIELD(CP_RBBM_NRTRTR, int)
    GENERATE_FIELD(VGT_RBBM_NRTRTR, int)
    GENERATE_FIELD(SQ_RBBM_NRTRTR, int)
    GENERATE_FIELD(CLIENTS_FOR_NRT_RTR_FOR_HI, int)
    GENERATE_FIELD(CLIENTS_FOR_NRT_RTR, int)
    GENERATE_FIELD(IGNORE_SX_RBBM_BUSY, int)
END_REGISTER(RBBM_DEBUG)

START_REGISTER(RBBM_READ_ERROR)
    GENERATE_FIELD(READ_ADDRESS, int)
    GENERATE_FIELD(READ_REQUESTER, int)
    GENERATE_FIELD(READ_ERROR, int)
END_REGISTER(RBBM_READ_ERROR)

START_REGISTER(RBBM_WAIT_IDLE_CLOCKS)
    GENERATE_FIELD(WAIT_IDLE_CLOCKS_NRT, int)
END_REGISTER(RBBM_WAIT_IDLE_CLOCKS)

START_REGISTER(RBBM_INT_CNTL)
    GENERATE_FIELD(RDERR_INT_MASK, int)
    GENERATE_FIELD(DISPLAY_UPDATE_INT_MASK, int)
    GENERATE_FIELD(GUI_IDLE_INT_MASK, int)
END_REGISTER(RBBM_INT_CNTL)

START_REGISTER(RBBM_INT_STATUS)
    GENERATE_FIELD(RDERR_INT_STAT, int)
    GENERATE_FIELD(DISPLAY_UPDATE_INT_STAT, int)
    GENERATE_FIELD(GUI_IDLE_INT_STAT, int)
END_REGISTER(RBBM_INT_STATUS)

START_REGISTER(RBBM_INT_ACK)
    GENERATE_FIELD(RDERR_INT_ACK, int)
    GENERATE_FIELD(DISPLAY_UPDATE_INT_ACK, int)
    GENERATE_FIELD(GUI_IDLE_INT_ACK, int)
END_REGISTER(RBBM_INT_ACK)

START_REGISTER(MASTER_INT_SIGNAL)
    GENERATE_FIELD(MH_INT_STAT, int)
    GENERATE_FIELD(SQ_INT_STAT, int)
    GENERATE_FIELD(CP_INT_STAT, int)
    GENERATE_FIELD(RBBM_INT_STAT, int)
END_REGISTER(MASTER_INT_SIGNAL)

START_REGISTER(RBBM_PERFCOUNTER1_SELECT)
    GENERATE_FIELD(PERF_COUNT1_SEL, RBBM_PERFCOUNT1_SEL)
END_REGISTER(RBBM_PERFCOUNTER1_SELECT)

START_REGISTER(RBBM_PERFCOUNTER1_LO)
    GENERATE_FIELD(PERF_COUNT1_LO, int)
END_REGISTER(RBBM_PERFCOUNTER1_LO)

START_REGISTER(RBBM_PERFCOUNTER1_HI)
    GENERATE_FIELD(PERF_COUNT1_HI, int)
END_REGISTER(RBBM_PERFCOUNTER1_HI)

START_REGISTER(CP_RB_BASE)
    GENERATE_FIELD(RB_BASE, int)
END_REGISTER(CP_RB_BASE)

START_REGISTER(CP_RB_CNTL)
    GENERATE_FIELD(RB_BUFSZ, int)
    GENERATE_FIELD(RB_BLKSZ, int)
    GENERATE_FIELD(BUF_SWAP, int)
    GENERATE_FIELD(RB_POLL_EN, int)
    GENERATE_FIELD(RB_NO_UPDATE, int)
    GENERATE_FIELD(RB_RPTR_WR_ENA, int)
END_REGISTER(CP_RB_CNTL)

START_REGISTER(CP_RB_RPTR_ADDR)
    GENERATE_FIELD(RB_RPTR_SWAP, int)
    GENERATE_FIELD(RB_RPTR_ADDR, int)
END_REGISTER(CP_RB_RPTR_ADDR)

START_REGISTER(CP_RB_RPTR)
    GENERATE_FIELD(RB_RPTR, int)
END_REGISTER(CP_RB_RPTR)

START_REGISTER(CP_RB_RPTR_WR)
    GENERATE_FIELD(RB_RPTR_WR, int)
END_REGISTER(CP_RB_RPTR_WR)

START_REGISTER(CP_RB_WPTR)
    GENERATE_FIELD(RB_WPTR, int)
END_REGISTER(CP_RB_WPTR)

START_REGISTER(CP_RB_WPTR_DELAY)
    GENERATE_FIELD(PRE_WRITE_TIMER, int)
    GENERATE_FIELD(PRE_WRITE_LIMIT, int)
END_REGISTER(CP_RB_WPTR_DELAY)

START_REGISTER(CP_RB_WPTR_BASE)
    GENERATE_FIELD(RB_WPTR_SWAP, int)
    GENERATE_FIELD(RB_WPTR_BASE, int)
END_REGISTER(CP_RB_WPTR_BASE)

START_REGISTER(CP_IB1_BASE)
    GENERATE_FIELD(IB1_BASE, int)
END_REGISTER(CP_IB1_BASE)

START_REGISTER(CP_IB1_BUFSZ)
    GENERATE_FIELD(IB1_BUFSZ, int)
END_REGISTER(CP_IB1_BUFSZ)

START_REGISTER(CP_IB2_BASE)
    GENERATE_FIELD(IB2_BASE, int)
END_REGISTER(CP_IB2_BASE)

START_REGISTER(CP_IB2_BUFSZ)
    GENERATE_FIELD(IB2_BUFSZ, int)
END_REGISTER(CP_IB2_BUFSZ)

START_REGISTER(CP_ST_BASE)
    GENERATE_FIELD(ST_BASE, int)
END_REGISTER(CP_ST_BASE)

START_REGISTER(CP_ST_BUFSZ)
    GENERATE_FIELD(ST_BUFSZ, int)
END_REGISTER(CP_ST_BUFSZ)

START_REGISTER(CP_QUEUE_THRESHOLDS)
    GENERATE_FIELD(CSQ_IB1_START, int)
    GENERATE_FIELD(CSQ_IB2_START, int)
    GENERATE_FIELD(CSQ_ST_START, int)
END_REGISTER(CP_QUEUE_THRESHOLDS)

START_REGISTER(CP_MEQ_THRESHOLDS)
    GENERATE_FIELD(MEQ_END, int)
    GENERATE_FIELD(ROQ_END, int)
END_REGISTER(CP_MEQ_THRESHOLDS)

START_REGISTER(CP_CSQ_AVAIL)
    GENERATE_FIELD(CSQ_CNT_RING, int)
    GENERATE_FIELD(CSQ_CNT_IB1, int)
    GENERATE_FIELD(CSQ_CNT_IB2, int)
END_REGISTER(CP_CSQ_AVAIL)

START_REGISTER(CP_STQ_AVAIL)
    GENERATE_FIELD(STQ_CNT_ST, int)
END_REGISTER(CP_STQ_AVAIL)

START_REGISTER(CP_MEQ_AVAIL)
    GENERATE_FIELD(MEQ_CNT, int)
END_REGISTER(CP_MEQ_AVAIL)

START_REGISTER(CP_CSQ_RB_STAT)
    GENERATE_FIELD(CSQ_RPTR_PRIMARY, int)
    GENERATE_FIELD(CSQ_WPTR_PRIMARY, int)
END_REGISTER(CP_CSQ_RB_STAT)

START_REGISTER(CP_CSQ_IB1_STAT)
    GENERATE_FIELD(CSQ_RPTR_INDIRECT1, int)
    GENERATE_FIELD(CSQ_WPTR_INDIRECT1, int)
END_REGISTER(CP_CSQ_IB1_STAT)

START_REGISTER(CP_CSQ_IB2_STAT)
    GENERATE_FIELD(CSQ_RPTR_INDIRECT2, int)
    GENERATE_FIELD(CSQ_WPTR_INDIRECT2, int)
END_REGISTER(CP_CSQ_IB2_STAT)

START_REGISTER(CP_NON_PREFETCH_CNTRS)
    GENERATE_FIELD(IB1_COUNTER, int)
    GENERATE_FIELD(IB2_COUNTER, int)
END_REGISTER(CP_NON_PREFETCH_CNTRS)

START_REGISTER(CP_STQ_ST_STAT)
    GENERATE_FIELD(STQ_RPTR_ST, int)
    GENERATE_FIELD(STQ_WPTR_ST, int)
END_REGISTER(CP_STQ_ST_STAT)

START_REGISTER(CP_MEQ_STAT)
    GENERATE_FIELD(MEQ_RPTR, int)
    GENERATE_FIELD(MEQ_WPTR, int)
END_REGISTER(CP_MEQ_STAT)

START_REGISTER(CP_MIU_TAG_STAT)
    GENERATE_FIELD(TAG_0_STAT, int)
    GENERATE_FIELD(TAG_1_STAT, int)
    GENERATE_FIELD(TAG_2_STAT, int)
    GENERATE_FIELD(TAG_3_STAT, int)
    GENERATE_FIELD(TAG_4_STAT, int)
    GENERATE_FIELD(TAG_5_STAT, int)
    GENERATE_FIELD(TAG_6_STAT, int)
    GENERATE_FIELD(TAG_7_STAT, int)
    GENERATE_FIELD(TAG_8_STAT, int)
    GENERATE_FIELD(TAG_9_STAT, int)
    GENERATE_FIELD(TAG_10_STAT, int)
    GENERATE_FIELD(TAG_11_STAT, int)
    GENERATE_FIELD(TAG_12_STAT, int)
    GENERATE_FIELD(TAG_13_STAT, int)
    GENERATE_FIELD(TAG_14_STAT, int)
    GENERATE_FIELD(TAG_15_STAT, int)
    GENERATE_FIELD(TAG_16_STAT, int)
    GENERATE_FIELD(TAG_17_STAT, int)
    GENERATE_FIELD(INVALID_RETURN_TAG, int)
END_REGISTER(CP_MIU_TAG_STAT)

START_REGISTER(CP_CMD_INDEX)
    GENERATE_FIELD(CMD_INDEX, int)
    GENERATE_FIELD(CMD_QUEUE_SEL, int)
END_REGISTER(CP_CMD_INDEX)

START_REGISTER(CP_CMD_DATA)
    GENERATE_FIELD(CMD_DATA, int)
END_REGISTER(CP_CMD_DATA)

START_REGISTER(CP_ME_CNTL)
    GENERATE_FIELD(ME_STATMUX, int)
    GENERATE_FIELD(VTX_DEALLOC_FIFO_EMPTY, int)
    GENERATE_FIELD(PIX_DEALLOC_FIFO_EMPTY, int)
    GENERATE_FIELD(ME_HALT, int)
    GENERATE_FIELD(ME_BUSY, int)
    GENERATE_FIELD(PROG_CNT_SIZE, int)
END_REGISTER(CP_ME_CNTL)

START_REGISTER(CP_ME_STATUS)
    GENERATE_FIELD(ME_DEBUG_DATA, int)
END_REGISTER(CP_ME_STATUS)

START_REGISTER(CP_ME_RAM_WADDR)
    GENERATE_FIELD(ME_RAM_WADDR, int)
END_REGISTER(CP_ME_RAM_WADDR)

START_REGISTER(CP_ME_RAM_RADDR)
    GENERATE_FIELD(ME_RAM_RADDR, int)
END_REGISTER(CP_ME_RAM_RADDR)

START_REGISTER(CP_ME_RAM_DATA)
    GENERATE_FIELD(ME_RAM_DATA, int)
END_REGISTER(CP_ME_RAM_DATA)

START_REGISTER(CP_ME_RDADDR)
    GENERATE_FIELD(ME_RDADDR, int)
END_REGISTER(CP_ME_RDADDR)

START_REGISTER(CP_DEBUG)
    GENERATE_FIELD(CP_DEBUG_UNUSED_22_to_0, int)
    GENERATE_FIELD(PREDICATE_DISABLE, int)
    GENERATE_FIELD(PROG_END_PTR_ENABLE, int)
    GENERATE_FIELD(MIU_128BIT_WRITE_ENABLE, int)
    GENERATE_FIELD(PREFETCH_PASS_NOPS, int)
    GENERATE_FIELD(DYNAMIC_CLK_DISABLE, int)
    GENERATE_FIELD(PREFETCH_MATCH_DISABLE, int)
    GENERATE_FIELD(SIMPLE_ME_FLOW_CONTROL, int)
    GENERATE_FIELD(MIU_WRITE_PACK_DISABLE, int)
END_REGISTER(CP_DEBUG)

START_REGISTER(SCRATCH_REG0)
    GENERATE_FIELD(SCRATCH_REG0, int)
END_REGISTER(SCRATCH_REG0)

START_REGISTER(SCRATCH_REG1)
    GENERATE_FIELD(SCRATCH_REG1, int)
END_REGISTER(SCRATCH_REG1)

START_REGISTER(SCRATCH_REG2)
    GENERATE_FIELD(SCRATCH_REG2, int)
END_REGISTER(SCRATCH_REG2)

START_REGISTER(SCRATCH_REG3)
    GENERATE_FIELD(SCRATCH_REG3, int)
END_REGISTER(SCRATCH_REG3)

START_REGISTER(SCRATCH_REG4)
    GENERATE_FIELD(SCRATCH_REG4, int)
END_REGISTER(SCRATCH_REG4)

START_REGISTER(SCRATCH_REG5)
    GENERATE_FIELD(SCRATCH_REG5, int)
END_REGISTER(SCRATCH_REG5)

START_REGISTER(SCRATCH_REG6)
    GENERATE_FIELD(SCRATCH_REG6, int)
END_REGISTER(SCRATCH_REG6)

START_REGISTER(SCRATCH_REG7)
    GENERATE_FIELD(SCRATCH_REG7, int)
END_REGISTER(SCRATCH_REG7)

START_REGISTER(SCRATCH_UMSK)
    GENERATE_FIELD(SCRATCH_UMSK, int)
    GENERATE_FIELD(SCRATCH_SWAP, int)
END_REGISTER(SCRATCH_UMSK)

START_REGISTER(SCRATCH_ADDR)
    GENERATE_FIELD(SCRATCH_ADDR, hex)
END_REGISTER(SCRATCH_ADDR)

START_REGISTER(CP_ME_VS_EVENT_SRC)
    GENERATE_FIELD(VS_DONE_SWM, int)
    GENERATE_FIELD(VS_DONE_CNTR, int)
END_REGISTER(CP_ME_VS_EVENT_SRC)

START_REGISTER(CP_ME_VS_EVENT_ADDR)
    GENERATE_FIELD(VS_DONE_SWAP, int)
    GENERATE_FIELD(VS_DONE_ADDR, int)
END_REGISTER(CP_ME_VS_EVENT_ADDR)

START_REGISTER(CP_ME_VS_EVENT_DATA)
    GENERATE_FIELD(VS_DONE_DATA, int)
END_REGISTER(CP_ME_VS_EVENT_DATA)

START_REGISTER(CP_ME_VS_EVENT_ADDR_SWM)
    GENERATE_FIELD(VS_DONE_SWAP_SWM, int)
    GENERATE_FIELD(VS_DONE_ADDR_SWM, int)
END_REGISTER(CP_ME_VS_EVENT_ADDR_SWM)

START_REGISTER(CP_ME_VS_EVENT_DATA_SWM)
    GENERATE_FIELD(VS_DONE_DATA_SWM, int)
END_REGISTER(CP_ME_VS_EVENT_DATA_SWM)

START_REGISTER(CP_ME_PS_EVENT_SRC)
    GENERATE_FIELD(PS_DONE_SWM, int)
    GENERATE_FIELD(PS_DONE_CNTR, int)
END_REGISTER(CP_ME_PS_EVENT_SRC)

START_REGISTER(CP_ME_PS_EVENT_ADDR)
    GENERATE_FIELD(PS_DONE_SWAP, int)
    GENERATE_FIELD(PS_DONE_ADDR, int)
END_REGISTER(CP_ME_PS_EVENT_ADDR)

START_REGISTER(CP_ME_PS_EVENT_DATA)
    GENERATE_FIELD(PS_DONE_DATA, int)
END_REGISTER(CP_ME_PS_EVENT_DATA)

START_REGISTER(CP_ME_PS_EVENT_ADDR_SWM)
    GENERATE_FIELD(PS_DONE_SWAP_SWM, int)
    GENERATE_FIELD(PS_DONE_ADDR_SWM, int)
END_REGISTER(CP_ME_PS_EVENT_ADDR_SWM)

START_REGISTER(CP_ME_PS_EVENT_DATA_SWM)
    GENERATE_FIELD(PS_DONE_DATA_SWM, int)
END_REGISTER(CP_ME_PS_EVENT_DATA_SWM)

START_REGISTER(CP_ME_CF_EVENT_SRC)
    GENERATE_FIELD(CF_DONE_SRC, int)
END_REGISTER(CP_ME_CF_EVENT_SRC)

START_REGISTER(CP_ME_CF_EVENT_ADDR)
    GENERATE_FIELD(CF_DONE_SWAP, int)
    GENERATE_FIELD(CF_DONE_ADDR, int)
END_REGISTER(CP_ME_CF_EVENT_ADDR)

START_REGISTER(CP_ME_CF_EVENT_DATA)
    GENERATE_FIELD(CF_DONE_DATA, int)
END_REGISTER(CP_ME_CF_EVENT_DATA)

START_REGISTER(CP_ME_NRT_ADDR)
    GENERATE_FIELD(NRT_WRITE_SWAP, int)
    GENERATE_FIELD(NRT_WRITE_ADDR, int)
END_REGISTER(CP_ME_NRT_ADDR)

START_REGISTER(CP_ME_NRT_DATA)
    GENERATE_FIELD(NRT_WRITE_DATA, int)
END_REGISTER(CP_ME_NRT_DATA)

START_REGISTER(CP_ME_VS_FETCH_DONE_SRC)
    GENERATE_FIELD(VS_FETCH_DONE_CNTR, int)
END_REGISTER(CP_ME_VS_FETCH_DONE_SRC)

START_REGISTER(CP_ME_VS_FETCH_DONE_ADDR)
    GENERATE_FIELD(VS_FETCH_DONE_SWAP, int)
    GENERATE_FIELD(VS_FETCH_DONE_ADDR, int)
END_REGISTER(CP_ME_VS_FETCH_DONE_ADDR)

START_REGISTER(CP_ME_VS_FETCH_DONE_DATA)
    GENERATE_FIELD(VS_FETCH_DONE_DATA, int)
END_REGISTER(CP_ME_VS_FETCH_DONE_DATA)

START_REGISTER(CP_INT_CNTL)
    GENERATE_FIELD(SW_INT_MASK, int)
    GENERATE_FIELD(T0_PACKET_IN_IB_MASK, int)
    GENERATE_FIELD(OPCODE_ERROR_MASK, int)
    GENERATE_FIELD(PROTECTED_MODE_ERROR_MASK, int)
    GENERATE_FIELD(RESERVED_BIT_ERROR_MASK, int)
    GENERATE_FIELD(IB_ERROR_MASK, int)
    GENERATE_FIELD(IB2_INT_MASK, int)
    GENERATE_FIELD(IB1_INT_MASK, int)
    GENERATE_FIELD(RB_INT_MASK, int)
END_REGISTER(CP_INT_CNTL)

START_REGISTER(CP_INT_STATUS)
    GENERATE_FIELD(SW_INT_STAT, int)
    GENERATE_FIELD(T0_PACKET_IN_IB_STAT, int)
    GENERATE_FIELD(OPCODE_ERROR_STAT, int)
    GENERATE_FIELD(PROTECTED_MODE_ERROR_STAT, int)
    GENERATE_FIELD(RESERVED_BIT_ERROR_STAT, int)
    GENERATE_FIELD(IB_ERROR_STAT, int)
    GENERATE_FIELD(IB2_INT_STAT, int)
    GENERATE_FIELD(IB1_INT_STAT, int)
    GENERATE_FIELD(RB_INT_STAT, int)
END_REGISTER(CP_INT_STATUS)

START_REGISTER(CP_INT_ACK)
    GENERATE_FIELD(SW_INT_ACK, int)
    GENERATE_FIELD(T0_PACKET_IN_IB_ACK, int)
    GENERATE_FIELD(OPCODE_ERROR_ACK, int)
    GENERATE_FIELD(PROTECTED_MODE_ERROR_ACK, int)
    GENERATE_FIELD(RESERVED_BIT_ERROR_ACK, int)
    GENERATE_FIELD(IB_ERROR_ACK, int)
    GENERATE_FIELD(IB2_INT_ACK, int)
    GENERATE_FIELD(IB1_INT_ACK, int)
    GENERATE_FIELD(RB_INT_ACK, int)
END_REGISTER(CP_INT_ACK)

START_REGISTER(CP_PFP_UCODE_ADDR)
    GENERATE_FIELD(UCODE_ADDR, hex)
END_REGISTER(CP_PFP_UCODE_ADDR)

START_REGISTER(CP_PFP_UCODE_DATA)
    GENERATE_FIELD(UCODE_DATA, hex)
END_REGISTER(CP_PFP_UCODE_DATA)

START_REGISTER(CP_PERFMON_CNTL)
    GENERATE_FIELD(PERFMON_STATE, int)
    GENERATE_FIELD(PERFMON_ENABLE_MODE, int)
END_REGISTER(CP_PERFMON_CNTL)

START_REGISTER(CP_PERFCOUNTER_SELECT)
    GENERATE_FIELD(PERFCOUNT_SEL, CP_PERFCOUNT_SEL)
END_REGISTER(CP_PERFCOUNTER_SELECT)

START_REGISTER(CP_PERFCOUNTER_LO)
    GENERATE_FIELD(PERFCOUNT_LO, int)
END_REGISTER(CP_PERFCOUNTER_LO)

START_REGISTER(CP_PERFCOUNTER_HI)
    GENERATE_FIELD(PERFCOUNT_HI, int)
END_REGISTER(CP_PERFCOUNTER_HI)

START_REGISTER(CP_BIN_MASK_LO)
    GENERATE_FIELD(BIN_MASK_LO, int)
END_REGISTER(CP_BIN_MASK_LO)

START_REGISTER(CP_BIN_MASK_HI)
    GENERATE_FIELD(BIN_MASK_HI, int)
END_REGISTER(CP_BIN_MASK_HI)

START_REGISTER(CP_BIN_SELECT_LO)
    GENERATE_FIELD(BIN_SELECT_LO, int)
END_REGISTER(CP_BIN_SELECT_LO)

START_REGISTER(CP_BIN_SELECT_HI)
    GENERATE_FIELD(BIN_SELECT_HI, int)
END_REGISTER(CP_BIN_SELECT_HI)

START_REGISTER(CP_NV_FLAGS_0)
    GENERATE_FIELD(DISCARD_0, int)
    GENERATE_FIELD(END_RCVD_0, int)
    GENERATE_FIELD(DISCARD_1, int)
    GENERATE_FIELD(END_RCVD_1, int)
    GENERATE_FIELD(DISCARD_2, int)
    GENERATE_FIELD(END_RCVD_2, int)
    GENERATE_FIELD(DISCARD_3, int)
    GENERATE_FIELD(END_RCVD_3, int)
    GENERATE_FIELD(DISCARD_4, int)
    GENERATE_FIELD(END_RCVD_4, int)
    GENERATE_FIELD(DISCARD_5, int)
    GENERATE_FIELD(END_RCVD_5, int)
    GENERATE_FIELD(DISCARD_6, int)
    GENERATE_FIELD(END_RCVD_6, int)
    GENERATE_FIELD(DISCARD_7, int)
    GENERATE_FIELD(END_RCVD_7, int)
    GENERATE_FIELD(DISCARD_8, int)
    GENERATE_FIELD(END_RCVD_8, int)
    GENERATE_FIELD(DISCARD_9, int)
    GENERATE_FIELD(END_RCVD_9, int)
    GENERATE_FIELD(DISCARD_10, int)
    GENERATE_FIELD(END_RCVD_10, int)
    GENERATE_FIELD(DISCARD_11, int)
    GENERATE_FIELD(END_RCVD_11, int)
    GENERATE_FIELD(DISCARD_12, int)
    GENERATE_FIELD(END_RCVD_12, int)
    GENERATE_FIELD(DISCARD_13, int)
    GENERATE_FIELD(END_RCVD_13, int)
    GENERATE_FIELD(DISCARD_14, int)
    GENERATE_FIELD(END_RCVD_14, int)
    GENERATE_FIELD(DISCARD_15, int)
    GENERATE_FIELD(END_RCVD_15, int)
END_REGISTER(CP_NV_FLAGS_0)

START_REGISTER(CP_NV_FLAGS_1)
    GENERATE_FIELD(DISCARD_16, int)
    GENERATE_FIELD(END_RCVD_16, int)
    GENERATE_FIELD(DISCARD_17, int)
    GENERATE_FIELD(END_RCVD_17, int)
    GENERATE_FIELD(DISCARD_18, int)
    GENERATE_FIELD(END_RCVD_18, int)
    GENERATE_FIELD(DISCARD_19, int)
    GENERATE_FIELD(END_RCVD_19, int)
    GENERATE_FIELD(DISCARD_20, int)
    GENERATE_FIELD(END_RCVD_20, int)
    GENERATE_FIELD(DISCARD_21, int)
    GENERATE_FIELD(END_RCVD_21, int)
    GENERATE_FIELD(DISCARD_22, int)
    GENERATE_FIELD(END_RCVD_22, int)
    GENERATE_FIELD(DISCARD_23, int)
    GENERATE_FIELD(END_RCVD_23, int)
    GENERATE_FIELD(DISCARD_24, int)
    GENERATE_FIELD(END_RCVD_24, int)
    GENERATE_FIELD(DISCARD_25, int)
    GENERATE_FIELD(END_RCVD_25, int)
    GENERATE_FIELD(DISCARD_26, int)
    GENERATE_FIELD(END_RCVD_26, int)
    GENERATE_FIELD(DISCARD_27, int)
    GENERATE_FIELD(END_RCVD_27, int)
    GENERATE_FIELD(DISCARD_28, int)
    GENERATE_FIELD(END_RCVD_28, int)
    GENERATE_FIELD(DISCARD_29, int)
    GENERATE_FIELD(END_RCVD_29, int)
    GENERATE_FIELD(DISCARD_30, int)
    GENERATE_FIELD(END_RCVD_30, int)
    GENERATE_FIELD(DISCARD_31, int)
    GENERATE_FIELD(END_RCVD_31, int)
END_REGISTER(CP_NV_FLAGS_1)

START_REGISTER(CP_NV_FLAGS_2)
    GENERATE_FIELD(DISCARD_32, int)
    GENERATE_FIELD(END_RCVD_32, int)
    GENERATE_FIELD(DISCARD_33, int)
    GENERATE_FIELD(END_RCVD_33, int)
    GENERATE_FIELD(DISCARD_34, int)
    GENERATE_FIELD(END_RCVD_34, int)
    GENERATE_FIELD(DISCARD_35, int)
    GENERATE_FIELD(END_RCVD_35, int)
    GENERATE_FIELD(DISCARD_36, int)
    GENERATE_FIELD(END_RCVD_36, int)
    GENERATE_FIELD(DISCARD_37, int)
    GENERATE_FIELD(END_RCVD_37, int)
    GENERATE_FIELD(DISCARD_38, int)
    GENERATE_FIELD(END_RCVD_38, int)
    GENERATE_FIELD(DISCARD_39, int)
    GENERATE_FIELD(END_RCVD_39, int)
    GENERATE_FIELD(DISCARD_40, int)
    GENERATE_FIELD(END_RCVD_40, int)
    GENERATE_FIELD(DISCARD_41, int)
    GENERATE_FIELD(END_RCVD_41, int)
    GENERATE_FIELD(DISCARD_42, int)
    GENERATE_FIELD(END_RCVD_42, int)
    GENERATE_FIELD(DISCARD_43, int)
    GENERATE_FIELD(END_RCVD_43, int)
    GENERATE_FIELD(DISCARD_44, int)
    GENERATE_FIELD(END_RCVD_44, int)
    GENERATE_FIELD(DISCARD_45, int)
    GENERATE_FIELD(END_RCVD_45, int)
    GENERATE_FIELD(DISCARD_46, int)
    GENERATE_FIELD(END_RCVD_46, int)
    GENERATE_FIELD(DISCARD_47, int)
    GENERATE_FIELD(END_RCVD_47, int)
END_REGISTER(CP_NV_FLAGS_2)

START_REGISTER(CP_NV_FLAGS_3)
    GENERATE_FIELD(DISCARD_48, int)
    GENERATE_FIELD(END_RCVD_48, int)
    GENERATE_FIELD(DISCARD_49, int)
    GENERATE_FIELD(END_RCVD_49, int)
    GENERATE_FIELD(DISCARD_50, int)
    GENERATE_FIELD(END_RCVD_50, int)
    GENERATE_FIELD(DISCARD_51, int)
    GENERATE_FIELD(END_RCVD_51, int)
    GENERATE_FIELD(DISCARD_52, int)
    GENERATE_FIELD(END_RCVD_52, int)
    GENERATE_FIELD(DISCARD_53, int)
    GENERATE_FIELD(END_RCVD_53, int)
    GENERATE_FIELD(DISCARD_54, int)
    GENERATE_FIELD(END_RCVD_54, int)
    GENERATE_FIELD(DISCARD_55, int)
    GENERATE_FIELD(END_RCVD_55, int)
    GENERATE_FIELD(DISCARD_56, int)
    GENERATE_FIELD(END_RCVD_56, int)
    GENERATE_FIELD(DISCARD_57, int)
    GENERATE_FIELD(END_RCVD_57, int)
    GENERATE_FIELD(DISCARD_58, int)
    GENERATE_FIELD(END_RCVD_58, int)
    GENERATE_FIELD(DISCARD_59, int)
    GENERATE_FIELD(END_RCVD_59, int)
    GENERATE_FIELD(DISCARD_60, int)
    GENERATE_FIELD(END_RCVD_60, int)
    GENERATE_FIELD(DISCARD_61, int)
    GENERATE_FIELD(END_RCVD_61, int)
    GENERATE_FIELD(DISCARD_62, int)
    GENERATE_FIELD(END_RCVD_62, int)
    GENERATE_FIELD(DISCARD_63, int)
    GENERATE_FIELD(END_RCVD_63, int)
END_REGISTER(CP_NV_FLAGS_3)

START_REGISTER(CP_STATE_DEBUG_INDEX)
    GENERATE_FIELD(STATE_DEBUG_INDEX, int)
END_REGISTER(CP_STATE_DEBUG_INDEX)

START_REGISTER(CP_STATE_DEBUG_DATA)
    GENERATE_FIELD(STATE_DEBUG_DATA, int)
END_REGISTER(CP_STATE_DEBUG_DATA)

START_REGISTER(CP_PROG_COUNTER)
    GENERATE_FIELD(COUNTER, int)
END_REGISTER(CP_PROG_COUNTER)

START_REGISTER(CP_STAT)
    GENERATE_FIELD(MIU_WR_BUSY, int)
    GENERATE_FIELD(MIU_RD_REQ_BUSY, int)
    GENERATE_FIELD(MIU_RD_RETURN_BUSY, int)
    GENERATE_FIELD(RBIU_BUSY, int)
    GENERATE_FIELD(RCIU_BUSY, int)
    GENERATE_FIELD(CSF_RING_BUSY, int)
    GENERATE_FIELD(CSF_INDIRECTS_BUSY, int)
    GENERATE_FIELD(CSF_INDIRECT2_BUSY, int)
    GENERATE_FIELD(CSF_ST_BUSY, int)
    GENERATE_FIELD(CSF_BUSY, int)
    GENERATE_FIELD(RING_QUEUE_BUSY, int)
    GENERATE_FIELD(INDIRECTS_QUEUE_BUSY, int)
    GENERATE_FIELD(INDIRECT2_QUEUE_BUSY, int)
    GENERATE_FIELD(ST_QUEUE_BUSY, int)
    GENERATE_FIELD(PFP_BUSY, int)
    GENERATE_FIELD(MEQ_RING_BUSY, int)
    GENERATE_FIELD(MEQ_INDIRECTS_BUSY, int)
    GENERATE_FIELD(MEQ_INDIRECT2_BUSY, int)
    GENERATE_FIELD(MIU_WC_STALL, int)
    GENERATE_FIELD(CP_NRT_BUSY, int)
    GENERATE_FIELD(_3D_BUSY, int)
    GENERATE_FIELD(ME_BUSY, int)
    GENERATE_FIELD(ME_WC_BUSY, int)
    GENERATE_FIELD(MIU_WC_TRACK_FIFO_EMPTY, int)
    GENERATE_FIELD(CP_BUSY, int)
END_REGISTER(CP_STAT)

START_REGISTER(BIOS_0_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_0_SCRATCH)

START_REGISTER(BIOS_1_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_1_SCRATCH)

START_REGISTER(BIOS_2_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_2_SCRATCH)

START_REGISTER(BIOS_3_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_3_SCRATCH)

START_REGISTER(BIOS_4_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_4_SCRATCH)

START_REGISTER(BIOS_5_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_5_SCRATCH)

START_REGISTER(BIOS_6_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_6_SCRATCH)

START_REGISTER(BIOS_7_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_7_SCRATCH)

START_REGISTER(BIOS_8_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_8_SCRATCH)

START_REGISTER(BIOS_9_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_9_SCRATCH)

START_REGISTER(BIOS_10_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_10_SCRATCH)

START_REGISTER(BIOS_11_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_11_SCRATCH)

START_REGISTER(BIOS_12_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_12_SCRATCH)

START_REGISTER(BIOS_13_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_13_SCRATCH)

START_REGISTER(BIOS_14_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_14_SCRATCH)

START_REGISTER(BIOS_15_SCRATCH)
    GENERATE_FIELD(BIOS_SCRATCH, hex)
END_REGISTER(BIOS_15_SCRATCH)

START_REGISTER(COHER_SIZE_PM4)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(COHER_SIZE_PM4)

START_REGISTER(COHER_BASE_PM4)
    GENERATE_FIELD(BASE, int)
END_REGISTER(COHER_BASE_PM4)

START_REGISTER(COHER_STATUS_PM4)
    GENERATE_FIELD(MATCHING_CONTEXTS, int)
    GENERATE_FIELD(RB_COPY_DEST_BASE_ENA, int)
    GENERATE_FIELD(DEST_BASE_0_ENA, int)
    GENERATE_FIELD(DEST_BASE_1_ENA, int)
    GENERATE_FIELD(DEST_BASE_2_ENA, int)
    GENERATE_FIELD(DEST_BASE_3_ENA, int)
    GENERATE_FIELD(DEST_BASE_4_ENA, int)
    GENERATE_FIELD(DEST_BASE_5_ENA, int)
    GENERATE_FIELD(DEST_BASE_6_ENA, int)
    GENERATE_FIELD(DEST_BASE_7_ENA, int)
    GENERATE_FIELD(RB_COLOR_INFO_ENA, int)
    GENERATE_FIELD(TC_ACTION_ENA, int)
    GENERATE_FIELD(STATUS, int)
END_REGISTER(COHER_STATUS_PM4)

START_REGISTER(COHER_SIZE_HOST)
    GENERATE_FIELD(SIZE, int)
END_REGISTER(COHER_SIZE_HOST)

START_REGISTER(COHER_BASE_HOST)
    GENERATE_FIELD(BASE, hex)
END_REGISTER(COHER_BASE_HOST)

START_REGISTER(COHER_STATUS_HOST)
    GENERATE_FIELD(MATCHING_CONTEXTS, int)
    GENERATE_FIELD(RB_COPY_DEST_BASE_ENA, int)
    GENERATE_FIELD(DEST_BASE_0_ENA, int)
    GENERATE_FIELD(DEST_BASE_1_ENA, int)
    GENERATE_FIELD(DEST_BASE_2_ENA, int)
    GENERATE_FIELD(DEST_BASE_3_ENA, int)
    GENERATE_FIELD(DEST_BASE_4_ENA, int)
    GENERATE_FIELD(DEST_BASE_5_ENA, int)
    GENERATE_FIELD(DEST_BASE_6_ENA, int)
    GENERATE_FIELD(DEST_BASE_7_ENA, int)
    GENERATE_FIELD(RB_COLOR_INFO_ENA, int)
    GENERATE_FIELD(TC_ACTION_ENA, int)
    GENERATE_FIELD(STATUS, int)
END_REGISTER(COHER_STATUS_HOST)

START_REGISTER(COHER_DEST_BASE_0)
    GENERATE_FIELD(DEST_BASE_0, hex)
END_REGISTER(COHER_DEST_BASE_0)

START_REGISTER(COHER_DEST_BASE_1)
    GENERATE_FIELD(DEST_BASE_1, hex)
END_REGISTER(COHER_DEST_BASE_1)

START_REGISTER(COHER_DEST_BASE_2)
    GENERATE_FIELD(DEST_BASE_2, hex)
END_REGISTER(COHER_DEST_BASE_2)

START_REGISTER(COHER_DEST_BASE_3)
    GENERATE_FIELD(DEST_BASE_3, hex)
END_REGISTER(COHER_DEST_BASE_3)

START_REGISTER(COHER_DEST_BASE_4)
    GENERATE_FIELD(DEST_BASE_4, hex)
END_REGISTER(COHER_DEST_BASE_4)

START_REGISTER(COHER_DEST_BASE_5)
    GENERATE_FIELD(DEST_BASE_5, hex)
END_REGISTER(COHER_DEST_BASE_5)

START_REGISTER(COHER_DEST_BASE_6)
    GENERATE_FIELD(DEST_BASE_6, hex)
END_REGISTER(COHER_DEST_BASE_6)

START_REGISTER(COHER_DEST_BASE_7)
    GENERATE_FIELD(DEST_BASE_7, hex)
END_REGISTER(COHER_DEST_BASE_7)

START_REGISTER(RB_SURFACE_INFO)
    GENERATE_FIELD(SURFACE_PITCH, uint)
    GENERATE_FIELD(MSAA_SAMPLES, MSAASamples)
END_REGISTER(RB_SURFACE_INFO)

START_REGISTER(RB_COLOR_INFO)
    GENERATE_FIELD(COLOR_FORMAT, ColorformatX)
    GENERATE_FIELD(COLOR_ROUND_MODE, uint)
    GENERATE_FIELD(COLOR_LINEAR, bool)
    GENERATE_FIELD(COLOR_ENDIAN, uint)
    GENERATE_FIELD(COLOR_SWAP, uint)
    GENERATE_FIELD(COLOR_BASE, uint)
END_REGISTER(RB_COLOR_INFO)

START_REGISTER(RB_DEPTH_INFO)
    GENERATE_FIELD(DEPTH_FORMAT, DepthformatX)
    GENERATE_FIELD(DEPTH_BASE, uint)
END_REGISTER(RB_DEPTH_INFO)

START_REGISTER(RB_STENCILREFMASK)
    GENERATE_FIELD(STENCILREF, hex)
    GENERATE_FIELD(STENCILMASK, hex)
    GENERATE_FIELD(STENCILWRITEMASK, hex)
    GENERATE_FIELD(RESERVED0, bool)
    GENERATE_FIELD(RESERVED1, bool)
END_REGISTER(RB_STENCILREFMASK)

START_REGISTER(RB_ALPHA_REF)
    GENERATE_FIELD(ALPHA_REF, float)
END_REGISTER(RB_ALPHA_REF)

START_REGISTER(RB_COLOR_MASK)
    GENERATE_FIELD(WRITE_RED, bool)
    GENERATE_FIELD(WRITE_GREEN, bool)
    GENERATE_FIELD(WRITE_BLUE, bool)
    GENERATE_FIELD(WRITE_ALPHA, bool)
    GENERATE_FIELD(RESERVED2, bool)
    GENERATE_FIELD(RESERVED3, bool)
END_REGISTER(RB_COLOR_MASK)

START_REGISTER(RB_BLEND_RED)
    GENERATE_FIELD(BLEND_RED, uint)
END_REGISTER(RB_BLEND_RED)

START_REGISTER(RB_BLEND_GREEN)
    GENERATE_FIELD(BLEND_GREEN, uint)
END_REGISTER(RB_BLEND_GREEN)

START_REGISTER(RB_BLEND_BLUE)
    GENERATE_FIELD(BLEND_BLUE, uint)
END_REGISTER(RB_BLEND_BLUE)

START_REGISTER(RB_BLEND_ALPHA)
    GENERATE_FIELD(BLEND_ALPHA, uint)
END_REGISTER(RB_BLEND_ALPHA)

START_REGISTER(RB_FOG_COLOR)
    GENERATE_FIELD(FOG_RED, uint)
    GENERATE_FIELD(FOG_GREEN, uint)
    GENERATE_FIELD(FOG_BLUE, uint)
END_REGISTER(RB_FOG_COLOR)

START_REGISTER(RB_STENCILREFMASK_BF)
    GENERATE_FIELD(STENCILREF_BF, hex)
    GENERATE_FIELD(STENCILMASK_BF, hex)
    GENERATE_FIELD(STENCILWRITEMASK_BF, hex)
    GENERATE_FIELD(RESERVED4, bool)
    GENERATE_FIELD(RESERVED5, bool)
END_REGISTER(RB_STENCILREFMASK_BF)

START_REGISTER(RB_DEPTHCONTROL)
    GENERATE_FIELD(STENCIL_ENABLE, bool)
    GENERATE_FIELD(Z_ENABLE, bool)
    GENERATE_FIELD(Z_WRITE_ENABLE, bool)
    GENERATE_FIELD(EARLY_Z_ENABLE, bool)
    GENERATE_FIELD(ZFUNC, CompareFrag)
    GENERATE_FIELD(BACKFACE_ENABLE, bool)
    GENERATE_FIELD(STENCILFUNC, CompareRef)
    GENERATE_FIELD(STENCILFAIL, StencilOp)
    GENERATE_FIELD(STENCILZPASS, StencilOp)
    GENERATE_FIELD(STENCILZFAIL, StencilOp)
    GENERATE_FIELD(STENCILFUNC_BF, CompareRef)
    GENERATE_FIELD(STENCILFAIL_BF, StencilOp)
    GENERATE_FIELD(STENCILZPASS_BF, StencilOp)
    GENERATE_FIELD(STENCILZFAIL_BF, StencilOp)
END_REGISTER(RB_DEPTHCONTROL)

START_REGISTER(RB_BLENDCONTROL)
    GENERATE_FIELD(COLOR_SRCBLEND, BlendOpX)
    GENERATE_FIELD(COLOR_COMB_FCN, CombFuncX)
    GENERATE_FIELD(COLOR_DESTBLEND, BlendOpX)
    GENERATE_FIELD(ALPHA_SRCBLEND, BlendOpX)
    GENERATE_FIELD(ALPHA_COMB_FCN, CombFuncX)
    GENERATE_FIELD(ALPHA_DESTBLEND, BlendOpX)
    GENERATE_FIELD(BLEND_FORCE_ENABLE, bool)
    GENERATE_FIELD(BLEND_FORCE, bool)
END_REGISTER(RB_BLENDCONTROL)

START_REGISTER(RB_COLORCONTROL)
    GENERATE_FIELD(ALPHA_FUNC, CompareRef)
    GENERATE_FIELD(ALPHA_TEST_ENABLE, bool)
    GENERATE_FIELD(ALPHA_TO_MASK_ENABLE, bool)
    GENERATE_FIELD(BLEND_DISABLE, bool)
    GENERATE_FIELD(FOG_ENABLE, bool)
    GENERATE_FIELD(VS_EXPORTS_FOG, bool)
    GENERATE_FIELD(ROP_CODE, uint)
    GENERATE_FIELD(DITHER_MODE, DitherModeX)
    GENERATE_FIELD(DITHER_TYPE, DitherTypeX)
    GENERATE_FIELD(PIXEL_FOG, bool)
    GENERATE_FIELD(ALPHA_TO_MASK_OFFSET0, hex)
    GENERATE_FIELD(ALPHA_TO_MASK_OFFSET1, hex)
    GENERATE_FIELD(ALPHA_TO_MASK_OFFSET2, hex)
    GENERATE_FIELD(ALPHA_TO_MASK_OFFSET3, hex)
END_REGISTER(RB_COLORCONTROL)

START_REGISTER(RB_MODECONTROL)
    GENERATE_FIELD(EDRAM_MODE, EdramMode)
END_REGISTER(RB_MODECONTROL)

START_REGISTER(RB_COLOR_DEST_MASK)
    GENERATE_FIELD(COLOR_DEST_MASK, uint)
END_REGISTER(RB_COLOR_DEST_MASK)

START_REGISTER(RB_COPY_CONTROL)
    GENERATE_FIELD(COPY_SAMPLE_SELECT, CopySampleSelect)
    GENERATE_FIELD(DEPTH_CLEAR_ENABLE, bool)
    GENERATE_FIELD(CLEAR_MASK, uint)
END_REGISTER(RB_COPY_CONTROL)

START_REGISTER(RB_COPY_DEST_BASE)
    GENERATE_FIELD(COPY_DEST_BASE, uint)
END_REGISTER(RB_COPY_DEST_BASE)

START_REGISTER(RB_COPY_DEST_PITCH)
    GENERATE_FIELD(COPY_DEST_PITCH, uint)
END_REGISTER(RB_COPY_DEST_PITCH)

START_REGISTER(RB_COPY_DEST_INFO)
    GENERATE_FIELD(COPY_DEST_ENDIAN, SurfaceEndian)
    GENERATE_FIELD(COPY_DEST_LINEAR, uint)
    GENERATE_FIELD(COPY_DEST_FORMAT, ColorformatX)
    GENERATE_FIELD(COPY_DEST_SWAP, uint)
    GENERATE_FIELD(COPY_DEST_DITHER_MODE, DitherModeX)
    GENERATE_FIELD(COPY_DEST_DITHER_TYPE, DitherTypeX)
    GENERATE_FIELD(COPY_MASK_WRITE_RED, hex)
    GENERATE_FIELD(COPY_MASK_WRITE_GREEN, hex)
    GENERATE_FIELD(COPY_MASK_WRITE_BLUE, hex)
    GENERATE_FIELD(COPY_MASK_WRITE_ALPHA, hex)
END_REGISTER(RB_COPY_DEST_INFO)

START_REGISTER(RB_COPY_DEST_PIXEL_OFFSET)
    GENERATE_FIELD(OFFSET_X, uint)
    GENERATE_FIELD(OFFSET_Y, uint)
END_REGISTER(RB_COPY_DEST_PIXEL_OFFSET)

START_REGISTER(RB_DEPTH_CLEAR)
    GENERATE_FIELD(DEPTH_CLEAR, uint)
END_REGISTER(RB_DEPTH_CLEAR)

START_REGISTER(RB_SAMPLE_COUNT_CTL)
    GENERATE_FIELD(RESET_SAMPLE_COUNT, bool)
    GENERATE_FIELD(COPY_SAMPLE_COUNT, bool)
END_REGISTER(RB_SAMPLE_COUNT_CTL)

START_REGISTER(RB_SAMPLE_COUNT_ADDR)
    GENERATE_FIELD(SAMPLE_COUNT_ADDR, uint)
END_REGISTER(RB_SAMPLE_COUNT_ADDR)

START_REGISTER(RB_BC_CONTROL)
    GENERATE_FIELD(ACCUM_LINEAR_MODE_ENABLE, bool)
    GENERATE_FIELD(ACCUM_TIMEOUT_SELECT, uint)
    GENERATE_FIELD(DISABLE_EDRAM_CAM, bool)
    GENERATE_FIELD(DISABLE_EZ_FAST_CONTEXT_SWITCH, bool)
    GENERATE_FIELD(DISABLE_EZ_NULL_ZCMD_DROP, bool)
    GENERATE_FIELD(DISABLE_LZ_NULL_ZCMD_DROP, bool)
    GENERATE_FIELD(ENABLE_AZ_THROTTLE, bool)
    GENERATE_FIELD(AZ_THROTTLE_COUNT, uint)
    GENERATE_FIELD(ENABLE_CRC_UPDATE, bool)
    GENERATE_FIELD(CRC_MODE, bool)
    GENERATE_FIELD(DISABLE_SAMPLE_COUNTERS, bool)
    GENERATE_FIELD(DISABLE_ACCUM, bool)
    GENERATE_FIELD(ACCUM_ALLOC_MASK, uint)
    GENERATE_FIELD(LINEAR_PERFORMANCE_ENABLE, bool)
    GENERATE_FIELD(ACCUM_DATA_FIFO_LIMIT, bool)
    GENERATE_FIELD(MEM_EXPORT_TIMEOUT_SELECT, int)
    GENERATE_FIELD(MEM_EXPORT_LINEAR_MODE_ENABLE, bool)
    GENERATE_FIELD(CRC_SYSTEM, bool)
    GENERATE_FIELD(RESERVED6, bool)
END_REGISTER(RB_BC_CONTROL)

START_REGISTER(RB_EDRAM_INFO)
    GENERATE_FIELD(EDRAM_SIZE, EdramSizeX)
    GENERATE_FIELD(EDRAM_MAPPING_MODE, uint)
    GENERATE_FIELD(EDRAM_RANGE, hex)
END_REGISTER(RB_EDRAM_INFO)

START_REGISTER(RB_CRC_RD_PORT)
    GENERATE_FIELD(CRC_DATA, hex)
END_REGISTER(RB_CRC_RD_PORT)

START_REGISTER(RB_CRC_CONTROL)
    GENERATE_FIELD(CRC_RD_ADVANCE, bool)
END_REGISTER(RB_CRC_CONTROL)

START_REGISTER(RB_CRC_MASK)
    GENERATE_FIELD(CRC_MASK, hex)
END_REGISTER(RB_CRC_MASK)

START_REGISTER(RB_PERFCOUNTER0_SELECT)
    GENERATE_FIELD(PERF_SEL, RB_PERFCNT_SELECT)
END_REGISTER(RB_PERFCOUNTER0_SELECT)

START_REGISTER(RB_PERFCOUNTER0_LOW)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(RB_PERFCOUNTER0_LOW)

START_REGISTER(RB_PERFCOUNTER0_HI)
    GENERATE_FIELD(PERF_COUNT, int)
END_REGISTER(RB_PERFCOUNTER0_HI)

START_REGISTER(RB_TOTAL_SAMPLES)
    GENERATE_FIELD(TOTAL_SAMPLES, int)
END_REGISTER(RB_TOTAL_SAMPLES)

START_REGISTER(RB_ZPASS_SAMPLES)
    GENERATE_FIELD(ZPASS_SAMPLES, int)
END_REGISTER(RB_ZPASS_SAMPLES)

START_REGISTER(RB_ZFAIL_SAMPLES)
    GENERATE_FIELD(ZFAIL_SAMPLES, int)
END_REGISTER(RB_ZFAIL_SAMPLES)

START_REGISTER(RB_SFAIL_SAMPLES)
    GENERATE_FIELD(SFAIL_SAMPLES, int)
END_REGISTER(RB_SFAIL_SAMPLES)

START_REGISTER(RB_DEBUG_0)
    GENERATE_FIELD(RDREQ_CTL_Z1_PRE_FULL, bool)
    GENERATE_FIELD(RDREQ_CTL_Z0_PRE_FULL, bool)
    GENERATE_FIELD(RDREQ_CTL_C1_PRE_FULL, bool)
    GENERATE_FIELD(RDREQ_CTL_C0_PRE_FULL, bool)
    GENERATE_FIELD(RDREQ_E1_ORDERING_FULL, bool)
    GENERATE_FIELD(RDREQ_E0_ORDERING_FULL, bool)
    GENERATE_FIELD(RDREQ_Z1_FULL, bool)
    GENERATE_FIELD(RDREQ_Z0_FULL, bool)
    GENERATE_FIELD(RDREQ_C1_FULL, bool)
    GENERATE_FIELD(RDREQ_C0_FULL, bool)
    GENERATE_FIELD(WRREQ_E1_MACRO_HI_FULL, bool)
    GENERATE_FIELD(WRREQ_E1_MACRO_LO_FULL, bool)
    GENERATE_FIELD(WRREQ_E0_MACRO_HI_FULL, bool)
    GENERATE_FIELD(WRREQ_E0_MACRO_LO_FULL, bool)
    GENERATE_FIELD(WRREQ_C_WE_HI_FULL, bool)
    GENERATE_FIELD(WRREQ_C_WE_LO_FULL, bool)
    GENERATE_FIELD(WRREQ_Z1_FULL, bool)
    GENERATE_FIELD(WRREQ_Z0_FULL, bool)
    GENERATE_FIELD(WRREQ_C1_FULL, bool)
    GENERATE_FIELD(WRREQ_C0_FULL, bool)
    GENERATE_FIELD(CMDFIFO_Z1_HOLD_FULL, bool)
    GENERATE_FIELD(CMDFIFO_Z0_HOLD_FULL, bool)
    GENERATE_FIELD(CMDFIFO_C1_HOLD_FULL, bool)
    GENERATE_FIELD(CMDFIFO_C0_HOLD_FULL, bool)
    GENERATE_FIELD(CMDFIFO_Z_ORDERING_FULL, bool)
    GENERATE_FIELD(CMDFIFO_C_ORDERING_FULL, bool)
    GENERATE_FIELD(C_SX_LAT_FULL, bool)
    GENERATE_FIELD(C_SX_CMD_FULL, bool)
    GENERATE_FIELD(C_EZ_TILE_FULL, bool)
    GENERATE_FIELD(C_REQ_FULL, bool)
    GENERATE_FIELD(C_MASK_FULL, bool)
    GENERATE_FIELD(EZ_INFSAMP_FULL, bool)
END_REGISTER(RB_DEBUG_0)

START_REGISTER(RB_DEBUG_1)
    GENERATE_FIELD(RDREQ_Z1_CMD_EMPTY, bool)
    GENERATE_FIELD(RDREQ_Z0_CMD_EMPTY, bool)
    GENERATE_FIELD(RDREQ_C1_CMD_EMPTY, bool)
    GENERATE_FIELD(RDREQ_C0_CMD_EMPTY, bool)
    GENERATE_FIELD(RDREQ_E1_ORDERING_EMPTY, bool)
    GENERATE_FIELD(RDREQ_E0_ORDERING_EMPTY, bool)
    GENERATE_FIELD(RDREQ_Z1_EMPTY, bool)
    GENERATE_FIELD(RDREQ_Z0_EMPTY, bool)
    GENERATE_FIELD(RDREQ_C1_EMPTY, bool)
    GENERATE_FIELD(RDREQ_C0_EMPTY, bool)
    GENERATE_FIELD(WRREQ_E1_MACRO_HI_EMPTY, bool)
    GENERATE_FIELD(WRREQ_E1_MACRO_LO_EMPTY, bool)
    GENERATE_FIELD(WRREQ_E0_MACRO_HI_EMPTY, bool)
    GENERATE_FIELD(WRREQ_E0_MACRO_LO_EMPTY, bool)
    GENERATE_FIELD(WRREQ_C_WE_HI_EMPTY, bool)
    GENERATE_FIELD(WRREQ_C_WE_LO_EMPTY, bool)
    GENERATE_FIELD(WRREQ_Z1_EMPTY, bool)
    GENERATE_FIELD(WRREQ_Z0_EMPTY, bool)
    GENERATE_FIELD(WRREQ_C1_PRE_EMPTY, bool)
    GENERATE_FIELD(WRREQ_C0_PRE_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_Z1_HOLD_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_Z0_HOLD_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_C1_HOLD_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_C0_HOLD_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_Z_ORDERING_EMPTY, bool)
    GENERATE_FIELD(CMDFIFO_C_ORDERING_EMPTY, bool)
    GENERATE_FIELD(C_SX_LAT_EMPTY, bool)
    GENERATE_FIELD(C_SX_CMD_EMPTY, bool)
    GENERATE_FIELD(C_EZ_TILE_EMPTY, bool)
    GENERATE_FIELD(C_REQ_EMPTY, bool)
    GENERATE_FIELD(C_MASK_EMPTY, bool)
    GENERATE_FIELD(EZ_INFSAMP_EMPTY, bool)
END_REGISTER(RB_DEBUG_1)

START_REGISTER(RB_DEBUG_2)
    GENERATE_FIELD(TILE_FIFO_COUNT, bool)
    GENERATE_FIELD(SX_LAT_FIFO_COUNT, bool)
    GENERATE_FIELD(MEM_EXPORT_FLAG, bool)
    GENERATE_FIELD(SYSMEM_BLEND_FLAG, bool)
    GENERATE_FIELD(CURRENT_TILE_EVENT, bool)
    GENERATE_FIELD(EZ_INFTILE_FULL, bool)
    GENERATE_FIELD(EZ_MASK_LOWER_FULL, bool)
    GENERATE_FIELD(EZ_MASK_UPPER_FULL, bool)
    GENERATE_FIELD(Z0_MASK_FULL, bool)
    GENERATE_FIELD(Z1_MASK_FULL, bool)
    GENERATE_FIELD(Z0_REQ_FULL, bool)
    GENERATE_FIELD(Z1_REQ_FULL, bool)
    GENERATE_FIELD(Z_SAMP_FULL, bool)
    GENERATE_FIELD(Z_TILE_FULL, bool)
    GENERATE_FIELD(EZ_INFTILE_EMPTY, bool)
    GENERATE_FIELD(EZ_MASK_LOWER_EMPTY, bool)
    GENERATE_FIELD(EZ_MASK_UPPER_EMPTY, bool)
    GENERATE_FIELD(Z0_MASK_EMPTY, bool)
    GENERATE_FIELD(Z1_MASK_EMPTY, bool)
    GENERATE_FIELD(Z0_REQ_EMPTY, bool)
    GENERATE_FIELD(Z1_REQ_EMPTY, bool)
    GENERATE_FIELD(Z_SAMP_EMPTY, bool)
    GENERATE_FIELD(Z_TILE_EMPTY, bool)
END_REGISTER(RB_DEBUG_2)

START_REGISTER(RB_DEBUG_3)
    GENERATE_FIELD(ACCUM_VALID, bool)
    GENERATE_FIELD(ACCUM_FLUSHING, bool)
    GENERATE_FIELD(ACCUM_WRITE_CLEAN_COUNT, bool)
    GENERATE_FIELD(ACCUM_INPUT_REG_VALID, bool)
    GENERATE_FIELD(ACCUM_DATA_FIFO_CNT, bool)
    GENERATE_FIELD(SHD_FULL, bool)
    GENERATE_FIELD(SHD_EMPTY, bool)
    GENERATE_FIELD(EZ_RETURN_LOWER_EMPTY, bool)
    GENERATE_FIELD(EZ_RETURN_UPPER_EMPTY, bool)
    GENERATE_FIELD(EZ_RETURN_LOWER_FULL, bool)
    GENERATE_FIELD(EZ_RETURN_UPPER_FULL, bool)
    GENERATE_FIELD(ZEXP_LOWER_EMPTY, bool)
    GENERATE_FIELD(ZEXP_UPPER_EMPTY, bool)
    GENERATE_FIELD(ZEXP_LOWER_FULL, bool)
    GENERATE_FIELD(ZEXP_UPPER_FULL, bool)
END_REGISTER(RB_DEBUG_3)

START_REGISTER(RB_DEBUG_4)
    GENERATE_FIELD(GMEM_RD_ACCESS_FLAG, bool)
    GENERATE_FIELD(GMEM_WR_ACCESS_FLAG, bool)
    GENERATE_FIELD(SYSMEM_RD_ACCESS_FLAG, bool)
    GENERATE_FIELD(SYSMEM_WR_ACCESS_FLAG, bool)
    GENERATE_FIELD(ACCUM_DATA_FIFO_EMPTY, bool)
    GENERATE_FIELD(ACCUM_ORDER_FIFO_EMPTY, bool)
    GENERATE_FIELD(ACCUM_DATA_FIFO_FULL, bool)
    GENERATE_FIELD(ACCUM_ORDER_FIFO_FULL, bool)
    GENERATE_FIELD(SYSMEM_WRITE_COUNT_OVERFLOW, bool)
    GENERATE_FIELD(CONTEXT_COUNT_DEBUG, bool)
END_REGISTER(RB_DEBUG_4)

START_REGISTER(RB_FLAG_CONTROL)
    GENERATE_FIELD(DEBUG_FLAG_CLEAR, bool)
END_REGISTER(RB_FLAG_CONTROL)

START_REGISTER(RB_BC_SPARES)
    GENERATE_FIELD(RESERVED, bool)
END_REGISTER(RB_BC_SPARES)

START_REGISTER(BC_DUMMY_CRAYRB_ENUMS)
    GENERATE_FIELD(DUMMY_CRAYRB_DEPTH_FORMAT, DepthFormat)
    GENERATE_FIELD(DUMMY_CRAYRB_SURFACE_SWAP, SurfaceSwap)
    GENERATE_FIELD(DUMMY_CRAYRB_DEPTH_ARRAY, DepthArray)
    GENERATE_FIELD(DUMMY_CRAYRB_ARRAY, ColorArray)
    GENERATE_FIELD(DUMMY_CRAYRB_COLOR_FORMAT, ColorFormat)
    GENERATE_FIELD(DUMMY_CRAYRB_SURFACE_NUMBER, SurfaceNumber)
    GENERATE_FIELD(DUMMY_CRAYRB_SURFACE_FORMAT, SurfaceFormat)
    GENERATE_FIELD(DUMMY_CRAYRB_SURFACE_TILING, SurfaceTiling)
    GENERATE_FIELD(DUMMY_CRAYRB_SURFACE_ARRAY, SurfaceArray)
    GENERATE_FIELD(DUMMY_RB_COPY_DEST_INFO_NUMBER, SurfaceNumberX)
END_REGISTER(BC_DUMMY_CRAYRB_ENUMS)

START_REGISTER(BC_DUMMY_CRAYRB_MOREENUMS)
    GENERATE_FIELD(DUMMY_CRAYRB_COLORARRAYX, ColorArrayX)
END_REGISTER(BC_DUMMY_CRAYRB_MOREENUMS)

