static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Contains code originaly from GIMP tile-glass.c, copyright                  \n"
" * Karl-Johan Andersson and Tim Copperfield.                                  \n"
" *                                                                            \n"
" * Glass Tile (sequential version) ported to GEGL:                            \n"
" * Copyright 2014 Denis Knoepfle                                              \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (tile_width, _(\"Tile Width\"), 25)                              \n"
"   value_range (5, 500)                                                       \n"
"   ui_range    (5, 50)                                                        \n"
"   ui_meta     (\"unit\",   \"pixel-distance\")                               \n"
"   ui_meta     (\"axis\",   \"x\")                                            \n"
"                                                                              \n"
"property_int (tile_height, _(\"Tile Height\"), 25)                            \n"
"   value_range (5, 500)                                                       \n"
"   ui_range    (5, 50)                                                        \n"
"   ui_meta     (\"unit\",   \"pixel-distance\")                               \n"
"   ui_meta     (\"axis\",   \"y\")                                            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     tile_glass                                           \n"
"#define GEGL_OP_C_SOURCE tile-glass.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *input_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *format;                                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"                                                                              \n"
"  if (input_format == NULL || babl_format_has_alpha (input_format))           \n"
"    format = babl_format (\"R'G'B'A float\");                                 \n"
"  else                                                                        \n"
"    format = babl_format (\"R'G'B' float\");                                  \n"
"                                                                              \n"
"  area->left = area->right = o->tile_width - 1;                               \n"
"  area->top = area->bottom = o->tile_height - 1;                              \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle *region;                                                      \n"
"                                                                              \n"
"  region = gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"                                                                              \n"
"  if (region != NULL)                                                         \n"
"    return *region;                                                           \n"
"  else                                                                        \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"tile_glass (GeglBuffer          *src,                                         \n"
"            GeglBuffer          *dst,                                         \n"
"            const GeglRectangle *dst_rect, /* region of interest */           \n"
"            const Babl          *format,                                      \n"
"            gint                 tileWidth,                                   \n"
"            gint                 tileHeight)                                  \n"
"{                                                                             \n"
"  gint components;                                                            \n"
"  gfloat *src_row_buf;                                                        \n"
"  gfloat *dst_row_buf;                                                        \n"
"  const GeglRectangle *extent;                                                \n"
"  GeglRectangle src_bufrect, dst_bufrect;                                     \n"
"                                                                              \n"
"  gint row, col, i;                                                           \n"
"  gint x1, y1, y2;                                                            \n"
"  gint dst_xoffs, src_x0, xright_abyss, src_rowwidth;                         \n"
"                                                                              \n"
"  gint xpixel1, xpixel2;                                                      \n"
"  gint ypixel2;                                                               \n"
"  gint xhalf, xoffs, xmiddle, xplus;                                          \n"
"  gint yhalf, yoffs, ymiddle, yplus;                                          \n"
"                                                                              \n"
"  extent = gegl_buffer_get_extent (dst);                                      \n"
"                                                                              \n"
"  x1 = dst_rect->x;                                                           \n"
"  y1 = dst_rect->y;                                                           \n"
"  y2 = y1 + dst_rect->height;                                                 \n"
"                                                                              \n"
"  xhalf = tileWidth  / 2;                                                     \n"
"  yhalf = tileHeight / 2;                                                     \n"
"                                                                              \n"
"  xplus = tileWidth  % 2;                                                     \n"
"  yplus = tileHeight % 2;                                                     \n"
"                                                                              \n"
"  dst_xoffs = x1 % tileWidth + xplus;                                         \n"
"  src_x0 = x1 - dst_xoffs;                                                    \n"
"  xright_abyss = 2 * ((x1 + dst_rect->width) % tileWidth);                    \n"
"  if (xright_abyss > tileWidth - 2)                                           \n"
"    xright_abyss = tileWidth - 2;                                             \n"
"  src_rowwidth = dst_xoffs + dst_rect->width + xright_abyss;                  \n"
"                                                                              \n"
"  yoffs = y1 % tileHeight;                                                    \n"
"  ymiddle = y1 - yoffs;                                                       \n"
"  if (yoffs >= yhalf)                                                         \n"
"    {                                                                         \n"
"      ymiddle += tileHeight;                                                  \n"
"      yoffs -= tileHeight;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  components = babl_format_get_n_components (format);                         \n"
"                                                                              \n"
"  src_row_buf = g_new (gfloat, src_rowwidth * components);                    \n"
"  dst_row_buf = g_new (gfloat, dst_rect->width * components);                 \n"
"  gegl_rectangle_set (&src_bufrect, src_x0, 0, src_rowwidth, 1);              \n"
"  gegl_rectangle_set (&dst_bufrect, x1, 0, dst_rect->width, 1);               \n"
"                                                                              \n"
"  /* loop through rows */                                                     \n"
"  for (row = y1; row < y2; ++row)                                             \n"
"    {                                                                         \n"
"      /* no need to clamp as abyss policy does that */                        \n"
"      ypixel2 = ymiddle + yoffs * 2;                                          \n"
"                                                                              \n"
"      src_bufrect.y = ypixel2;                                                \n"
"      gegl_buffer_get (src, &src_bufrect, 1.0, format, src_row_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);\n"
"                                                                              \n"
"      yoffs++;                                                                \n"
"                                                                              \n"
"      /* if current offset = half, do a displacement next time around */      \n"
"      if (yoffs == yhalf)                                                     \n"
"        {                                                                     \n"
"          ymiddle += tileHeight;                                              \n"
"          yoffs = - (yhalf + yplus);                                          \n"
"        }                                                                     \n"
"                                                                              \n"
"      xoffs = x1 % tileWidth;                                                 \n"
"      xmiddle = x1 - xoffs;                                                   \n"
"      if (xoffs >= xhalf)                                                     \n"
"        {                                                                     \n"
"          xmiddle += tileWidth;                                               \n"
"          xoffs -= tileWidth;                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* loop through columns */                                              \n"
"      for (col = 0; col < dst_rect->width; ++col)                             \n"
"        {                                                                     \n"
"          xpixel1 = (xmiddle + xoffs - x1) * components;                      \n"
"          if (xmiddle + xoffs * 2 + dst_xoffs < extent->width)                \n"
"            {                                                                 \n"
"              xpixel2 = (xmiddle + xoffs * 2 - x1 + dst_xoffs) * components;  \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              xpixel2 = (xmiddle + xoffs - x1 + dst_xoffs) * components;      \n"
"            }                                                                 \n"
"                                                                              \n"
"          for (i = 0; i < components; ++i)                                    \n"
"            {                                                                 \n"
"              dst_row_buf[xpixel1 + i] = src_row_buf[xpixel2 + i];            \n"
"            }                                                                 \n"
"                                                                              \n"
"          xoffs++;                                                            \n"
"                                                                              \n"
"          if (xoffs == xhalf)                                                 \n"
"            {                                                                 \n"
"              xmiddle += tileWidth;                                           \n"
"              xoffs = - (xhalf + xplus);                                      \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* write result row to dest */                                          \n"
"      dst_bufrect.y = row;                                                    \n"
"      gegl_buffer_set (dst, &dst_bufrect, 0, format, dst_row_buf, GEGL_AUTO_ROWSTRIDE);\n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (src_row_buf);                                                       \n"
"  g_free (dst_row_buf);                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format = gegl_operation_get_format (operation, \"input\");      \n"
"                                                                              \n"
"  tile_glass (input, output, result, format, o->tile_width, o->tile_height);  \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  filter_class->process             = process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"categories\",         \"artistic:map\",                                 \n"
"    \"title\",              _(\"Tile Glass\"),                                \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"name\",               \"gegl:tile-glass\",                              \n"
"    \"reference-hash\",     \"d949027ca089aed4d4bea2950a33c56f\",             \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"Simulate distortion caused by rectangular glass tiles\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
