static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Jan Rüegg <rggjan@gmail.com>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (iterations, _(\"Iterations\"), 10)                              \n"
"    value_range (1, 10000)                                                    \n"
"    ui_range (1, 200)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     matting_global                                       \n"
"#define GEGL_OP_C_SOURCE matting-global.c                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include \"gegl-debug.h\"                                                     \n"
"                                                                              \n"
"#define max(a,b) \\                                                           \n"
"  ({ __typeof__ (a) _a = (a); \\                                              \n"
"  __typeof__ (b) _b = (b); \\                                                 \n"
"  _a > _b ? _a : _b; })                                                       \n"
"                                                                              \n"
"#define min(a,b) \\                                                           \n"
"  ({ __typeof__ (a) _a = (a); \\                                              \n"
"  __typeof__ (b) _b = (b); \\                                                 \n"
"  _a > _b ? _b : _a; })                                                       \n"
"                                                                              \n"
"#define likely(x)       __builtin_expect((x),1)                               \n"
"#define unlikely(x)       __builtin_expect((x),0)                             \n"
"                                                                              \n"
"#define ASSERT(condition) \\                                                  \n"
"  if(unlikely(!(condition))) { \\                                             \n"
"  printf(\"Error at line %i\\n\", __LINE__); \\                               \n"
"  exit(1);\\                                                                  \n"
"  }                                                                           \n"
"                                                                              \n"
"// Shortcut for doing things in all three channels                            \n"
"#define COLOR(expr) {int c; for (c = 0; c < 3; c++) { expr; }}                \n"
"                                                                              \n"
"/* We don't use the babl_format_get_n_components function for these values,   \n"
" * as literal constants can be used for stack allocation of array sizes. They \n"
" * are double checked in matting_process.                                     \n"
" */                                                                           \n"
"#define COMPONENTS_AUX    1                                                   \n"
"#define COMPONENTS_INPUT  3                                                   \n"
"#define COMPONENTS_OUTPUT 1                                                   \n"
"                                                                              \n"
"static const gchar *FORMAT_AUX    = \"Y u8\";                                 \n"
"static const gchar *FORMAT_INPUT  = \"R'G'B' float\";                         \n"
"static const gchar *FORMAT_OUTPUT = \"Y float\";                              \n"
"                                                                              \n"
"static void                                                                   \n"
"matting_prepare (GeglOperation *operation)                                    \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (FORMAT_INPUT));\n"
"  gegl_operation_set_format (operation, \"aux\",    babl_format (FORMAT_AUX));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (FORMAT_OUTPUT));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"matting_get_required_for_output (GeglOperation       *operation,              \n"
"                                 const gchar         *input_pad,              \n"
"                                 const GeglRectangle *roi)                    \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation,  \n"
"                                                                  \"input\"); \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"matting_get_cached_region (GeglOperation * operation,                         \n"
"                           const GeglRectangle * roi)                         \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"typedef struct {                                                              \n"
" gfloat fg_distance;                                                          \n"
" gfloat bg_distance;                                                          \n"
" gint   fg_index;                                                             \n"
" gint   bg_index;                                                             \n"
"} BufferRecord;                                                               \n"
"                                                                              \n"
"typedef float Color[3];                                                       \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  int x;                                                                      \n"
"  int y;                                                                      \n"
"} Position;                                                                   \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  Color color;                                                                \n"
"  Position pos;                                                               \n"
"} ColorSample;                                                                \n"
"                                                                              \n"
"#define SQUARE(x) ((x)*(x))                                                   \n"
"static inline float get_alpha (Color F, Color B, Color I)                     \n"
"{                                                                             \n"
"  int c;                                                                      \n"
"  float result = 0;                                                           \n"
"  float div = 0;                                                              \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      result += (I[c] - B[c]) * (F[c] - B[c]);                                \n"
"      div += SQUARE(F[c] - B[c]);                                             \n"
"    }                                                                         \n"
"  return min(max(result / div, 0), 1);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float get_color_cost (Color F, Color B, Color I, float alpha)   \n"
"{                                                                             \n"
"  int c;                                                                      \n"
"  float result = 0;                                                           \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      result += SQUARE(I[c] - (alpha * F[c] + (1 - alpha) * B[c]));           \n"
"    }                                                                         \n"
"                                                                              \n"
"  // TODO(rggjan): Remove sqrt to get faster code?                            \n"
"  // TODO(rggjan): Remove 255                                                 \n"
"  return sqrt(result) * 255;                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static inline int get_distance_squared(ColorSample s, int x, int y)           \n"
"{                                                                             \n"
"  return SQUARE(s.pos.x - x) + SQUARE(s.pos.y - y);                           \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float get_distance (ColorSample s, int x, int y)                \n"
"{                                                                             \n"
"  // TODO(rggjan): Remove sqrt to get faster code?                            \n"
"  return sqrt(get_distance_squared(s, x, y));                                 \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static inline float get_distance_cost (ColorSample s, int x, int y, float *best_distance)\n"
"{                                                                             \n"
"  float new_distance = get_distance(s, x, y);                                 \n"
"                                                                              \n"
"  if (new_distance < *best_distance)                                          \n"
"    *best_distance = new_distance;                                            \n"
"                                                                              \n"
"  return new_distance / *best_distance;                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float get_cost (ColorSample foreground, ColorSample background, Color I, int x, int y, float *best_fg_distance, float *best_bg_distance)\n"
"{                                                                             \n"
"  float cost = get_color_cost(foreground.color, background.color, I,          \n"
"                              get_alpha(foreground.color, background.color, I));\n"
"  cost += get_distance_cost(foreground, x, y, best_fg_distance);              \n"
"  cost += get_distance_cost(background, x, y, best_bg_distance);              \n"
"  return cost;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void do_propagate(GArray *foreground_samples, GArray *background_samples, gfloat *input, BufferRecord *buffer, guchar *trimap, int x, int y, int w, int h) {\n"
"  int index_orig = y * w + x;                                                 \n"
"  int index_new;                                                              \n"
"                                                                              \n"
"  if (!(trimap[index_orig] == 0 || trimap[index_orig] == 255))                \n"
"    {                                                                         \n"
"      int xdiff, ydiff;                                                       \n"
"      float best_cost = FLT_MAX;                                              \n"
"      float *best_fg_distance = &buffer[index_orig].fg_distance;              \n"
"      float *best_bg_distance = &buffer[index_orig].bg_distance;              \n"
"                                                                              \n"
"      for (ydiff = -1; ydiff <= 1; ydiff++)                                   \n"
"        {                                                                     \n"
"          // Borders                                                          \n"
"          if (y+ydiff < 0 || y+ydiff >= h)                                    \n"
"            continue;                                                         \n"
"          for (xdiff = -1; xdiff <= 1; xdiff++)                               \n"
"            {                                                                 \n"
"              // Borders                                                      \n"
"              if (x+xdiff < 0 || x+xdiff >= w)                                \n"
"                continue;                                                     \n"
"                                                                              \n"
"              index_new = (y + ydiff) * w + (x + xdiff);                      \n"
"                                                                              \n"
"              if (!(trimap[index_new] == 0 || trimap[index_new] == 255))      \n"
"                {                                                             \n"
"                  int fi = buffer[index_new].fg_index;                        \n"
"                  int bi = buffer[index_new].bg_index;                        \n"
"                                                                              \n"
"                  ColorSample foreground = g_array_index(foreground_samples, ColorSample, fi);\n"
"                  ColorSample background = g_array_index(background_samples, ColorSample, bi);\n"
"                                                                              \n"
"                  float cost = get_cost(foreground, background, &input[index_orig * 3], x, y, best_fg_distance, best_bg_distance);\n"
"                  if (cost < best_cost)                                       \n"
"                    {                                                         \n"
"                      buffer[index_orig].fg_index = fi;                       \n"
"                      buffer[index_orig].bg_index = bi;                       \n"
"                      best_cost = cost;                                       \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void do_random_search(GArray *foreground_samples, GArray *background_samples, gfloat *input, BufferRecord *buffer, int x, int y, int w) {\n"
"  int dist_f = foreground_samples->len;                                       \n"
"  int dist_b = background_samples->len;                                       \n"
"  int index = y * w + x;                                                      \n"
"                                                                              \n"
"  int best_fi = buffer[index].fg_index;                                       \n"
"  int best_bi = buffer[index].bg_index;                                       \n"
"                                                                              \n"
"  int start_fi = best_fi;                                                     \n"
"  int start_bi = best_bi;                                                     \n"
"                                                                              \n"
"  // Get current best result                                                  \n"
"  float *best_fg_distance = &buffer[index].fg_distance;                       \n"
"  float *best_bg_distance = &buffer[index].bg_distance;                       \n"
"                                                                              \n"
"  ColorSample foreground = g_array_index(foreground_samples, ColorSample, best_fi);\n"
"  ColorSample background = g_array_index(background_samples, ColorSample, best_bi);\n"
"                                                                              \n"
"  // Get cost                                                                 \n"
"  float best_cost = get_cost(foreground, background, &input[index * 3], x, y, best_fg_distance, best_bg_distance);\n"
"                                                                              \n"
"  while (dist_f > 0 || dist_b > 0)                                            \n"
"    {                                                                         \n"
"      // Get new indices to check                                             \n"
"      int fl = foreground_samples->len;                                       \n"
"      int bl = background_samples->len;                                       \n"
"      int fi = (start_fi + (rand () % (dist_f * 2 + 1)) + fl - dist_f) % fl;  \n"
"      int bi = (start_bi + (rand () % (dist_b * 2 + 1)) + bl - dist_b) % bl;  \n"
"                                                                              \n"
"      ColorSample foreground = g_array_index(foreground_samples, ColorSample, fi);\n"
"      ColorSample background = g_array_index(background_samples, ColorSample, bi);\n"
"                                                                              \n"
"      float cost = get_cost(foreground, background, &input[index * 3], x, y, best_fg_distance, best_bg_distance);\n"
"                                                                              \n"
"      if (cost < best_cost)                                                   \n"
"        {                                                                     \n"
"          best_cost = cost;                                                   \n"
"          best_fi = fi;                                                       \n"
"          best_bi = bi;                                                       \n"
"        }                                                                     \n"
"      dist_f /= 2;                                                            \n"
"      dist_b /= 2;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  buffer[index].fg_index = best_fi;                                           \n"
"  buffer[index].bg_index = best_bi;                                           \n"
"}                                                                             \n"
"                                                                              \n"
"// Compare color intensities                                                  \n"
"static gint color_compare(gconstpointer p1, gconstpointer p2)                 \n"
"{                                                                             \n"
"  ColorSample *s1 = (ColorSample*) p1;                                        \n"
"  ColorSample *s2 = (ColorSample*) p2;                                        \n"
"                                                                              \n"
"  float sum1 = s1->color[0] + s1->color[1] + s1->color[2];                    \n"
"  float sum2 = s2->color[0] + s2->color[1] + s2->color[2];                    \n"
"                                                                              \n"
"  return ((sum1 > sum2) - (sum2 > sum1));                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"matting_process (GeglOperation       *operation,                              \n"
"                 GeglBuffer          *input_buf,                              \n"
"                 GeglBuffer          *aux_buf,                                \n"
"                 GeglBuffer          *output_buf,                             \n"
"                 const GeglRectangle *result,                                 \n"
"                 int                  level)                                  \n"
"{                                                                             \n"
"                                                                              \n"
"  const GeglProperties   *o       = GEGL_PROPERTIES (operation);              \n"
"  gfloat                 *input   = NULL;                                     \n"
"  guchar                 *trimap  = NULL;                                     \n"
"  gfloat                 *output  = NULL;                                     \n"
"  BufferRecord           *buffer  = NULL;                                     \n"
"                                                                              \n"
"  gboolean          success = FALSE;                                          \n"
"  int               w, h, i, x, y, xdiff, ydiff, neighbour_mask;              \n"
"                                                                              \n"
"  GArray           *foreground_samples, *background_samples;                  \n"
"  GArray           *unknown_positions;                                        \n"
"                                                                              \n"
"  g_return_val_if_fail (babl_format_get_n_components (babl_format (FORMAT_INPUT )) == COMPONENTS_INPUT,  FALSE);\n"
"  g_return_val_if_fail (babl_format_get_n_components (babl_format (FORMAT_AUX   )) == COMPONENTS_AUX,    FALSE);\n"
"  g_return_val_if_fail (babl_format_get_n_components (babl_format (FORMAT_OUTPUT)) == COMPONENTS_OUTPUT, FALSE);\n"
"                                                                              \n"
"  g_return_val_if_fail (operation,  FALSE);                                   \n"
"  g_return_val_if_fail (input_buf,  FALSE);                                   \n"
"  g_return_val_if_fail (aux_buf,    FALSE);                                   \n"
"  g_return_val_if_fail (output_buf, FALSE);                                   \n"
"  g_return_val_if_fail (result,     FALSE);                                   \n"
"                                                                              \n"
"  w = result->width;                                                          \n"
"  h = result->height;                                                         \n"
"                                                                              \n"
"  input  = g_new (gfloat, w * h * COMPONENTS_INPUT);                          \n"
"  trimap = g_new (guchar, w * h * COMPONENTS_AUX);                            \n"
"  output = g_new0 (gfloat, w * h * COMPONENTS_OUTPUT);                        \n"
"  buffer = g_new0 (BufferRecord, w * h);                                      \n"
"                                                                              \n"
"  gegl_buffer_get (input_buf, result, 1.0, babl_format (FORMAT_INPUT), input, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"  gegl_buffer_get (  aux_buf, result, 1.0, babl_format (FORMAT_AUX),  trimap, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"  foreground_samples = g_array_new(FALSE, FALSE, sizeof(ColorSample));        \n"
"  background_samples = g_array_new(FALSE, FALSE, sizeof(ColorSample));        \n"
"  unknown_positions = g_array_new(FALSE, FALSE, sizeof(Position));            \n"
"                                                                              \n"
"  // Get mask                                                                 \n"
"  for (y = 0; y < h; y++)                                                     \n"
"    {                                                                         \n"
"      for (x = 0; x < w; x++)                                                 \n"
"        {                                                                     \n"
"          int mask = trimap[y * w + x];                                       \n"
"          for (ydiff = -1; ydiff <= 1; ydiff++)                               \n"
"            {                                                                 \n"
"              // Borders                                                      \n"
"              if (y+ydiff < 0 || y+ydiff >= h)                                \n"
"                continue;                                                     \n"
"                                                                              \n"
"              for (xdiff = -1; xdiff <= 1; xdiff++)                           \n"
"                {                                                             \n"
"                  // Borders                                                  \n"
"                  if (x+xdiff < 0 || x+xdiff >= w)                            \n"
"                    continue;                                                 \n"
"                                                                              \n"
"                  neighbour_mask = trimap[(y + ydiff) * w + x + xdiff];       \n"
"                  if (neighbour_mask != mask && (mask == 0 || mask == 255))   \n"
"                    {                                                         \n"
"                      int index = y*w+x;                                      \n"
"                      ColorSample s;                                          \n"
"                      s.pos.x = x;                                            \n"
"                      s.pos.y = y;                                            \n"
"                      COLOR(s.color[c] = input[index*3 + c]);                 \n"
"                                                                              \n"
"                      if (mask == 255)                                        \n"
"                        {                                                     \n"
"                          g_array_append_val(foreground_samples, s);          \n"
"                          buffer[index].fg_distance = 0;                      \n"
"                          buffer[index].bg_distance = FLT_MAX;                \n"
"                        }                                                     \n"
"                      else                                                    \n"
"                        {                                                     \n"
"                          g_array_append_val(background_samples, s);          \n"
"                          buffer[index].fg_distance = 0;                      \n"
"                          buffer[index].bg_distance = FLT_MAX;                \n"
"                        }                                                     \n"
"                                                                              \n"
"                      // Go to next pixel                                     \n"
"                      xdiff = 1;                                              \n"
"                      ydiff = 1;                                              \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* If we have no information to work with, there is nothing to process. */  \n"
"  if (foreground_samples->len == 0 ||                                         \n"
"      background_samples->len == 0)                                           \n"
"    {                                                                         \n"
"      success = FALSE;                                                        \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  // Initialize unknowns                                                      \n"
"  for (y = 0; y < h; y++)                                                     \n"
"    {                                                                         \n"
"      for (x = 0; x < w; x++)                                                 \n"
"        {                                                                     \n"
"          int index = y * w + x;                                              \n"
"                                                                              \n"
"          if (trimap[index] != 0 && trimap[index] != 255)                     \n"
"            {                                                                 \n"
"              Position p;                                                     \n"
"              p.x = x;                                                        \n"
"              p.y = y;                                                        \n"
"              g_array_append_val(unknown_positions, p);                       \n"
"              buffer[index].fg_distance = FLT_MAX;                            \n"
"              buffer[index].bg_distance = FLT_MAX;                            \n"
"              buffer[index].fg_index = rand() % foreground_samples->len;      \n"
"              buffer[index].bg_index = rand() % background_samples->len;      \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_array_sort(foreground_samples, color_compare);                            \n"
"  g_array_sort(background_samples, color_compare);                            \n"
"                                                                              \n"
"  // Do real iterations                                                       \n"
"  for (i = 0; i < o->iterations; i++)                                         \n"
"    {                                                                         \n"
"      unsigned j;                                                             \n"
"                                                                              \n"
"      GEGL_NOTE (GEGL_DEBUG_PROCESS, \"Iteration %i\", i);                    \n"
"                                                                              \n"
"      for (j=0; j<unknown_positions->len; j++)                                \n"
"        {                                                                     \n"
"          Position p = g_array_index(unknown_positions, Position, j);         \n"
"          do_random_search(foreground_samples, background_samples, input, buffer, p.x, p.y, w);\n"
"        }                                                                     \n"
"                                                                              \n"
"      for (j=0; j<unknown_positions->len; j++)                                \n"
"        {                                                                     \n"
"          Position p = g_array_index(unknown_positions, Position, j);         \n"
"          do_propagate(foreground_samples, background_samples, input, buffer, trimap, p.x, p.y, w, h);\n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  // Fill results in                                                          \n"
"  for (y = 0; y < h; y++)                                                     \n"
"    {                                                                         \n"
"      for (x = 0; x < w; x++)                                                 \n"
"        {                                                                     \n"
"          int index = y * w + x;                                              \n"
"          if (trimap[index] == 0 || trimap[index] == 255)                     \n"
"            {                                                                 \n"
"                                                                              \n"
"              if (trimap[index] == 0)                                         \n"
"                {                                                             \n"
"                  output[index] = 0;                                          \n"
"                }                                                             \n"
"              else if (trimap[index] == 255)                                  \n"
"                {                                                             \n"
"                  output[index] = 1;                                          \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              ColorSample background, foreground;                             \n"
"              foreground = g_array_index(foreground_samples, ColorSample, buffer[index].fg_index);\n"
"              background = g_array_index(background_samples, ColorSample, buffer[index].bg_index);\n"
"                                                                              \n"
"              output[index] = get_alpha(foreground.color, background.color, &input[index * 3]);\n"
"                                                                              \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  // Save to buffer                                                           \n"
"  gegl_buffer_set (output_buf, result, 0, babl_format (FORMAT_OUTPUT), output,\n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  success = TRUE;                                                             \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  g_free (input);                                                             \n"
"  g_free (trimap);                                                            \n"
"  g_free (output);                                                            \n"
"  g_free (buffer);                                                            \n"
"  g_array_free (foreground_samples, TRUE);                                    \n"
"  g_array_free (background_samples, TRUE);                                    \n"
"  g_array_free (unknown_positions, TRUE);                                     \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void gegl_op_class_init (GeglOpClass *klass)                           \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"  composer_class->process = matting_process;                                  \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  operation_class->prepare                 = matting_prepare;                 \n"
"  operation_class->get_required_for_output = matting_get_required_for_output; \n"
"  operation_class->get_cached_region       = matting_get_cached_region;       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:matting-global\",                                 \n"
"    \"categories\" , \"matting\",                                             \n"
"    \"title\"      , _(\"Matting Global\"),                                   \n"
"    \"description\",                                                          \n"
"   _(\"Given a sparse user supplied tri-map and an input image, create a \"   \n"
"     \"foreground alpha matte. Set white as foreground, black as background \"\n"
"     \"for the tri-map. Everything else will be treated as unknown and filled in.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
