static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
" /* Propagate labels by wathershed transformation using hierarchical queues */\n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME      watershed_transform                                 \n"
"#define GEGL_OP_C_SOURCE  watershed-transform.c                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct _PixelCoords                                                   \n"
"{                                                                             \n"
"  gint x;                                                                     \n"
"  gint y;                                                                     \n"
"} PixelCoords;                                                                \n"
"                                                                              \n"
"typedef struct _HQ                                                            \n"
"{                                                                             \n"
"  GQueue  *queues[256];                                                       \n"
"  GQueue  *lowest_non_empty;                                                  \n"
"  gint     lowest_non_empty_level;                                            \n"
"} HQ;                                                                         \n"
"                                                                              \n"
"static void                                                                   \n"
"HQ_init (HQ *hq)                                                              \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < 256; i++)                                                   \n"
"    hq->queues[i] = g_queue_new ();                                           \n"
"                                                                              \n"
"  hq->lowest_non_empty       = NULL;                                          \n"
"  hq->lowest_non_empty_level = 255;                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"HQ_is_empty (HQ *hq)                                                          \n"
"{                                                                             \n"
"  if (hq->lowest_non_empty == NULL)                                           \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"HQ_push (HQ      *hq,                                                         \n"
"         guint8   level,                                                      \n"
"         gpointer data)                                                       \n"
"{                                                                             \n"
"  g_queue_push_head (hq->queues[level], data);                                \n"
"                                                                              \n"
"  if (level <= hq->lowest_non_empty_level)                                    \n"
"    {                                                                         \n"
"      hq->lowest_non_empty_level = level;                                     \n"
"      hq->lowest_non_empty       = hq->queues[level];                         \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gpointer                                                        \n"
"HQ_pop (HQ *hq)                                                               \n"
"{                                                                             \n"
"  gint i, level;                                                              \n"
"  gpointer data = NULL;                                                       \n"
"                                                                              \n"
"  if (hq->lowest_non_empty != NULL)                                           \n"
"    {                                                                         \n"
"      data = g_queue_pop_tail (hq->lowest_non_empty);                         \n"
"                                                                              \n"
"      if (g_queue_is_empty (hq->lowest_non_empty))                            \n"
"        {                                                                     \n"
"          level = hq->lowest_non_empty_level;                                 \n"
"          hq->lowest_non_empty_level = 255;                                   \n"
"          hq->lowest_non_empty       = NULL;                                  \n"
"                                                                              \n"
"          for (i = level + 1; i < 256; i++)                                   \n"
"            if (!g_queue_is_empty (hq->queues[i]))                            \n"
"              {                                                               \n"
"                hq->lowest_non_empty_level = i;                               \n"
"                hq->lowest_non_empty       = hq->queues[i];                   \n"
"                break;                                                        \n"
"              }                                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return data;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"HQ_clean (HQ *hq)                                                             \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < 256; i++)                                                   \n"
"    {                                                                         \n"
"      if (!g_queue_is_empty (hq->queues[i]))                                  \n"
"        g_printerr (\"queue %u is not empty!\\n\", i);                        \n"
"      else                                                                    \n"
"        g_queue_free (hq->queues[i]);                                         \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *self)                                                  \n"
"{                                                                             \n"
"  GeglOperation *operation = GEGL_OPERATION (self);                           \n"
"  GParamSpec    *pspec;                                                       \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"output\",                                    \n"
"                               \"Output\",                                    \n"
"                               \"Output pad for generated image buffer.\",    \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READABLE |                             \n"
"                               GEGL_PARAM_PAD_OUTPUT);                        \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"input\",                                     \n"
"                               \"Input\",                                     \n"
"                               \"Input pad, for image buffer input.\",        \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READWRITE |                            \n"
"                               GEGL_PARAM_PAD_INPUT);                         \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"aux\",                                       \n"
"                               \"Aux\",                                       \n"
"                               \"Auxiliary image buffer input pad.\",         \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READWRITE |                            \n"
"                               GEGL_PARAM_PAD_INPUT);                         \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl  *labels_format   = babl_format (\"YA u32\");                    \n"
"  const Babl  *gradient_format = babl_format (\"Y u8\");                      \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  labels_format);           \n"
"  gegl_operation_set_format (operation, \"output\", labels_format);           \n"
"  gegl_operation_set_format (operation, \"aux\",    gradient_format);         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle *region;                                                      \n"
"                                                                              \n"
"  region = gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"                                                                              \n"
"  if (region != NULL)                                                         \n"
"    return *region;                                                           \n"
"  else                                                                        \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *operation,                    \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *input_region)                 \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  HQ      hq;                                                                 \n"
"  guint32 square3x3[18];                                                      \n"
"  gint    j;                                                                  \n"
"  gint    x, y;                                                               \n"
"  GeglBufferIterator  *iter;                                                  \n"
"  GeglSampler         *gradient_sampler;                                      \n"
"  const GeglRectangle *extent = gegl_buffer_get_extent (input);               \n"
"                                                                              \n"
"  const Babl  *labels_format   = babl_format (\"YA u32\");                    \n"
"  const Babl  *gradient_format = babl_format (\"Y u8\");                      \n"
"                                                                              \n"
"  gint neighbors_coords[8][2] = {{-1, -1},{0, -1},{1, -1},                    \n"
"                                 {-1, 0},         {1, 0},                     \n"
"                                 {-1, 1}, {0, 1}, {1, 1}};                    \n"
"                                                                              \n"
"  /* initialize hierarchical queues */                                        \n"
"                                                                              \n"
"  HQ_init (&hq);                                                              \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (input, extent, 0, labels_format,           \n"
"                                   GEGL_ACCESS_READ, GEGL_ABYSS_NONE);        \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, aux, extent, 0, gradient_format,            \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, output, extent, 0, labels_format,           \n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      guint32  *label    = iter->data[0];                                     \n"
"      guint8   *pixel    = iter->data[1];                                     \n"
"      guint32  *outlabel = iter->data[2];                                     \n"
"                                                                              \n"
"      for (y = iter->roi->y; y < iter->roi->y + iter->roi->height; y++)       \n"
"        for (x = iter->roi->x; x < iter->roi->x + iter->roi->width; x++)      \n"
"          {                                                                   \n"
"            if (label[1] != 0)                                                \n"
"              {                                                               \n"
"                PixelCoords *p = g_new (PixelCoords, 1);                      \n"
"                p->x = x;                                                     \n"
"                p->y = y;                                                     \n"
"                                                                              \n"
"                HQ_push (&hq, *pixel, p);                                     \n"
"              }                                                               \n"
"                                                                              \n"
"            outlabel[0] = label[0];                                           \n"
"            outlabel[1] = label[1];                                           \n"
"                                                                              \n"
"            pixel++;                                                          \n"
"            label += 2;                                                       \n"
"            outlabel += 2;                                                    \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  gradient_sampler = gegl_buffer_sampler_new_at_level (aux,                   \n"
"                                                       gradient_format,       \n"
"                                                       GEGL_SAMPLER_NEAREST,  \n"
"                                                       level);                \n"
"  while (!HQ_is_empty (&hq))                                                  \n"
"    {                                                                         \n"
"      PixelCoords *p = (PixelCoords *) HQ_pop (&hq);                          \n"
"      guint32 label[2];                                                       \n"
"                                                                              \n"
"      GeglRectangle square_rect = {p->x - 1, p->y - 1, 3, 3};                 \n"
"                                                                              \n"
"      gegl_buffer_get (output, &square_rect, 1.0, labels_format,              \n"
"                       square3x3,                                             \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      label[0] = square3x3[8];                                                \n"
"      label[1] = square3x3[9];                                                \n"
"                                                                              \n"
"      /* compute neighbors coordinate */                                      \n"
"      for (j = 0; j < 8; j++)                                                 \n"
"        {                                                                     \n"
"          guint32 *neighbor_label;                                            \n"
"          gint nx = p->x + neighbors_coords[j][0];                            \n"
"          gint ny = p->y + neighbors_coords[j][1];                            \n"
"                                                                              \n"
"          if (nx < 0 || nx >= extent->width || ny < 0 || ny >= extent->height)\n"
"            continue;                                                         \n"
"                                                                              \n"
"          neighbor_label = square3x3 + ((neighbors_coords[j][0] + 1) + (neighbors_coords[j][1] + 1) * 3) * 2;\n"
"                                                                              \n"
"          if (neighbor_label[1] == 0)                                         \n"
"            {                                                                 \n"
"              guint8 gradient_value;                                          \n"
"              GeglRectangle n_rect = {nx, ny, 1, 1};                          \n"
"              PixelCoords *n = g_new (PixelCoords, 1);                        \n"
"              n->x = nx;                                                      \n"
"              n->y = ny;                                                      \n"
"                                                                              \n"
"              gegl_sampler_get (gradient_sampler,                             \n"
"                                (gdouble) nx,                                 \n"
"                                (gdouble) ny,                                 \n"
"                                NULL, &gradient_value, GEGL_ABYSS_NONE);      \n"
"                                                                              \n"
"              HQ_push (&hq, gradient_value, n);                               \n"
"                                                                              \n"
"              neighbor_label[0] = label[0];                                   \n"
"              neighbor_label[1] = 1;                                          \n"
"                                                                              \n"
"              gegl_buffer_set (output, &n_rect,                               \n"
"                               0, labels_format,                              \n"
"                               neighbor_label, GEGL_AUTO_ROWSTRIDE);          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      g_free (p);                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  HQ_clean (&hq);                                                             \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglBuffer     *input = NULL;                                               \n"
"  GeglBuffer     *aux;                                                        \n"
"  GeglBuffer     *output;                                                     \n"
"  gboolean        success;                                                    \n"
"                                                                              \n"
"  aux = gegl_operation_context_get_source (context, \"aux\");                 \n"
"                                                                              \n"
"  if (!aux)                                                                   \n"
"    {                                                                         \n"
"      success = FALSE;                                                        \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      input = gegl_operation_context_get_source (context, \"input\");         \n"
"      output = gegl_operation_context_get_target (context, \"output\");       \n"
"                                                                              \n"
"      success = process (operation, input, aux, output, result, level);       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (input != NULL)                                                          \n"
"    g_object_unref (input);                                                   \n"
"                                                                              \n"
"  if (aux != NULL)                                                            \n"
"    g_object_unref (aux);                                                     \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach                    = attach;                        \n"
"  operation_class->prepare                   = prepare;                       \n"
"  operation_class->process                   = operation_process;             \n"
"  operation_class->get_bounding_box          = get_bounding_box;              \n"
"  operation_class->get_required_for_output   = get_required_for_output;       \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"  operation_class->get_cached_region         = get_cached_region;             \n"
"  operation_class->opencl_support            = FALSE;                         \n"
"  operation_class->threaded                  = FALSE;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:watershed-transform\",                            \n"
"    \"title\",       _(\"Watershed Transform\"),                              \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"Labels propagation by watershed transformation\"),   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
