static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1995 Spencer Kimball and Peter Mattis                            \n"
" * Copyright 1996 Torsten Martinsen                                           \n"
" * Copyright 2000 Tim Copperfield <timecop@japan.co.jp>                       \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" * Copyright 2012,2016 Øyvind Kolås <pippin@gimp.org>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (correlated, _(\"Correlated noise\"), FALSE)                 \n"
"                                                                              \n"
"property_boolean (independent, _(\"Independent RGB\"), TRUE)                  \n"
"   description (_(\"Control amount of noise for each RGB channel separately\"))\n"
"                                                                              \n"
"property_boolean (linear, _(\"Linear RGB\"), TRUE)                            \n"
"   description (_(\"Operate on linearized RGB color data\"))                  \n"
"                                                                              \n"
"property_boolean (gaussian, _(\"Gaussian distribution\"), TRUE)               \n"
"   description (_(\"Use a gaussian noise distribution, when unticked a linear noise distribution is used instead\"))\n"
"                                                                              \n"
"property_double (red, _(\"Red\"), 0.20)                                       \n"
"   value_range  (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (green, _(\"Green\"), 0.20)                                   \n"
"   value_range  (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (blue, _(\"Blue\"), 0.20)                                     \n"
"   value_range  (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (alpha, _(\"Alpha\"), 0.0)                                    \n"
"   value_range  (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     noise_rgb                                            \n"
"#define GEGL_OP_C_SOURCE noise-rgb.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" * Return a Gaussian (aka normal) distributed random variable.                \n"
" *                                                                            \n"
" * Adapted from gauss.c included in GNU scientific library.                   \n"
" *                                                                            \n"
" * Ratio method (Kinderman-Monahan); see Knuth v2, 3rd ed, p130               \n"
" * K+M, ACM Trans Math Software 3 (1977) 257-260.                             \n"
"*/                                                                            \n"
"static gfloat                                                                 \n"
"noise_gauss (GeglRandom *rand, int *i, int xx, int yy)                        \n"
"{                                                                             \n"
"  gfloat u, v, x;                                                             \n"
"                                                                              \n"
"  do                                                                          \n"
"  {                                                                           \n"
"    v = gegl_random_float (rand, xx, yy, 0, (*i)++);                          \n"
"                                                                              \n"
"    do                                                                        \n"
"      u = gegl_random_float (rand, xx, yy, 0, (*i)++);                        \n"
"    while (u == 0);                                                           \n"
"                                                                              \n"
"    /* Const 1.715... = sqrt(8/e) */                                          \n"
"    x = 1.71552776992141359295 * (v - 0.5f) / u;                              \n"
"  }                                                                           \n"
"  while (x * x > -4.0f * logf (u));                                           \n"
"                                                                              \n"
"  return x;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"noise_linear (GeglRandom *rand, int *i, int xx, int yy)                       \n"
"{                                                                             \n"
"  return gegl_random_float (rand, xx, yy, 0, (*i)++) * 2 - 1.0;               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"  if (o->linear)                                                              \n"
"    {                                                                         \n"
"      gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"      gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"      gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"                                                                              \n"
"  gdouble  noise_coeff = 0.0;                                                 \n"
"  int      rint = 0;                                                          \n"
"  gint     b, i;                                                              \n"
"  gint     x, y;                                                              \n"
"  gdouble  noise[4];                                                          \n"
"  gfloat   tmp;                                                               \n"
"  gfloat   * GEGL_ALIGNED in_pixel;                                           \n"
"  gfloat   * GEGL_ALIGNED out_pixel;                                          \n"
"  gfloat   (*noise_fun) (GeglRandom *rand, int *i, int xx, int yy) = noise_gauss;\n"
"                                                                              \n"
"  in_pixel   = in_buf;                                                        \n"
"  out_pixel  = out_buf;                                                       \n"
"                                                                              \n"
"  noise[0] = o->red;                                                          \n"
"  noise[1] = o->green;                                                        \n"
"  noise[2] = o->blue;                                                         \n"
"  noise[3] = o->alpha;                                                        \n"
"                                                                              \n"
"  if (o->gaussian == FALSE)                                                   \n"
"    noise_fun = noise_linear;                                                 \n"
"                                                                              \n"
"  x = roi->x;                                                                 \n"
"  y = roi->y;                                                                 \n"
"                                                                              \n"
"  for (i=0; i<n_pixels; i++)                                                  \n"
"  {                                                                           \n"
"    for (b = 0; b < 4; b++)                                                   \n"
"    {                                                                         \n"
"      if (b == 0 || o->independent || b == 3 )                                \n"
"         noise_coeff = noise[b] * noise_fun (o->rand, &rint, x, y) * 0.5;     \n"
"                                                                              \n"
"      if (noise[b] > 0.0)                                                     \n"
"      {                                                                       \n"
"        if (o->correlated)                                                    \n"
"        {                                                                     \n"
"          tmp = (in_pixel[b] + (in_pixel[b] * (noise_coeff / 0.5)) );         \n"
"        }                                                                     \n"
"        else                                                                  \n"
"        {                                                                     \n"
"          tmp = (in_pixel[b] + noise_coeff );                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"        out_pixel[b] = CLAMP(tmp, 0.0, 1.0);                                  \n"
"      }                                                                       \n"
"      else                                                                    \n"
"      {                                                                       \n"
"        out_pixel[b] = in_pixel[b];                                           \n"
"      }                                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"    in_pixel  += 4;                                                           \n"
"    out_pixel += 4;                                                           \n"
"                                                                              \n"
"    x++;                                                                      \n"
"    if (x >= roi->x + roi->width)                                             \n"
"      {                                                                       \n"
"        x = roi->x;                                                           \n"
"        y++;                                                                  \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:noise-rgb\",                                      \n"
"    \"title\",       _(\"Add RGB Noise\"),                                    \n"
"    \"categories\",  \"noise\",                                               \n"
"    \"description\", _(\"Distort colors by random amounts\"),                 \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
