/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import org.gnu.pilotlink.PilotLink;
import org.gnu.pilotlink.PilotLinkException;
import org.gnu.pilotlink.Record;
import org.gnu.pilotlink.SysInfo;
import org.gnu.pilotlink.ToDoRecord;
import org.gnu.pilotlink.User;

public class TestTodos {
    public static void main(String[] stringArray) {
        Object object;
        test test2 = new test();
        String string = stringArray.length == 0 ? "/dev/usb/tts/1" : stringArray[0];
        File file = new File(string);
        System.out.println("looking for file " + string);
        if (!file.exists()) {
            System.out.println("File does not exist... USB? Waiting for port to appear");
            while (!file.exists()) {
                System.out.print(".");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        PilotLink pilotLink = null;
        try {
            pilotLink = new PilotLink(string);
            if (!pilotLink.isConnected()) {
                System.out.println("Something went wrong. Check output!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            object = pilotLink.getUserInfo();
            System.out.println("User: " + ((User)object).getName());
            System.out.println("Last Synchronization Date: " + ((User)object).getLastSyncDate());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            object = pilotLink.getSysInfo();
            System.out.println("Product ID: '" + ((SysInfo)object).getProdID() + "'");
            System.out.println("Rom Version: " + ((SysInfo)object).getRomVersion());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            int n = pilotLink.openDB("ToDoDB");
            System.out.println("db opened!");
            System.out.println("Count: " + pilotLink.getRecordCount(n));
            for (int i = 0; i < pilotLink.getRecordCount(n); ++i) {
                Record record = pilotLink.getRecordByIndex(n, i);
                ToDoRecord toDoRecord = new ToDoRecord(record);
                System.out.println("READ IN:");
                System.out.println(toDoRecord);
                test.hexdump(record.getBuffer());
                System.out.println("\nRE-PACKED:");
                test.hexdump(toDoRecord.getBuffer());
                System.out.println();
            }
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            pilotLink.endSync();
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        pilotLink.close();
    }
}

