/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import org.qtproject.qt5.android.CursorView;
import org.qtproject.qt5.android.QtNative;

public class CursorHandle
implements ViewTreeObserver.OnPreDrawListener {
    private View m_layout = null;
    private CursorView m_cursorView = null;
    private PopupWindow m_popup = null;
    private int m_id;
    private int m_attr;
    private Activity m_activity;
    private int m_posX = 0;
    private int m_posY = 0;
    private int m_lastX;
    private int m_lastY;
    int tolerance;
    private boolean m_rtl;

    public CursorHandle(Activity activity, View view, int n, int n2, boolean bl) {
        this.m_activity = activity;
        this.m_id = n;
        this.m_attr = n2;
        this.m_layout = view;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.tolerance = Math.round(2.0f * displayMetrics.density);
        this.m_lastX = this.m_lastY = -1 - this.tolerance;
        this.m_rtl = bl;
    }

    private boolean initOverlay() {
        if (this.m_popup == null) {
            Context context = this.m_layout.getContext();
            int[] nArray = new int[]{this.m_attr};
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(nArray);
            Drawable drawable2 = typedArray.getDrawable(0);
            this.m_cursorView = new CursorView(context, this);
            this.m_cursorView.setImageDrawable(drawable2);
            this.m_popup = new PopupWindow(context, null, 16843464);
            this.m_popup.setSplitTouchEnabled(true);
            this.m_popup.setClippingEnabled(false);
            this.m_popup.setContentView((View)this.m_cursorView);
            this.m_popup.setWidth(drawable2.getIntrinsicWidth());
            this.m_popup.setHeight(drawable2.getIntrinsicHeight());
            this.m_layout.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        return true;
    }

    public void setPosition(int n, int n2) {
        this.initOverlay();
        int[] nArray = new int[2];
        this.m_layout.getLocationOnScreen(nArray);
        int n3 = n + nArray[0];
        int n4 = n2 + nArray[1];
        n3 = this.m_id == 1 ? (n3 -= this.m_cursorView.getWidth() / 2) : (this.m_id == 2 && !this.m_rtl || this.m_id == 3 && this.m_rtl ? (n3 -= this.m_cursorView.getWidth() * 3 / 4) : (n3 -= this.m_cursorView.getWidth() / 4));
        if (this.m_popup.isShowing()) {
            this.m_popup.update(n3, n4, -1, -1);
            this.m_cursorView.adjusted(n - this.m_posX, n2 - this.m_posY);
        } else {
            this.m_popup.showAtLocation(this.m_layout, 0, n3, n4);
        }
        this.m_posX = n;
        this.m_posY = n2;
    }

    public void hide() {
        if (this.m_popup != null) {
            this.m_popup.dismiss();
        }
    }

    public void updatePosition(int n, int n2) {
        if (Math.abs(this.m_lastX - n) > this.tolerance || Math.abs(this.m_lastY - n2) > this.tolerance) {
            QtNative.handleLocationChanged(this.m_id, n + this.m_posX, n2 + this.m_posY);
            this.m_lastX = n;
            this.m_lastY = n2;
        }
    }

    public boolean onPreDraw() {
        if (this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY);
        }
        return true;
    }
}

