/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class Comment
implements TextBlock {
    private final String[] text;
    private final int firstLine;
    private final int lastLine;
    private final int firstCol;
    private final int lastCol;

    public Comment(String[] text, int firstCol, int lastLine, int lastCol) {
        this.text = new String[text.length];
        System.arraycopy(text, 0, this.text, 0, this.text.length);
        this.firstLine = lastLine - this.text.length + 1;
        this.lastLine = lastLine;
        this.firstCol = firstCol;
        this.lastCol = lastCol;
    }

    @Override
    public final String[] getText() {
        return (String[])this.text.clone();
    }

    @Override
    public final int getStartLineNo() {
        return this.firstLine;
    }

    @Override
    public final int getEndLineNo() {
        return this.lastLine;
    }

    @Override
    public int getStartColNo() {
        return this.firstCol;
    }

    @Override
    public int getEndColNo() {
        return this.lastCol;
    }

    @Override
    public boolean intersects(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        long multiplier = Integer.MAX_VALUE;
        long thisStart = (long)this.firstLine * Integer.MAX_VALUE + (long)this.firstCol;
        long thisEnd = (long)this.lastLine * Integer.MAX_VALUE + (long)this.lastCol;
        long inStart = (long)startLineNo * Integer.MAX_VALUE + (long)startColNo;
        long inEnd = (long)endLineNo * Integer.MAX_VALUE + (long)endColNo;
        return thisEnd >= inStart && inEnd >= thisStart;
    }

    public String toString() {
        return "Comment[" + this.firstLine + ":" + this.firstCol + "-" + this.lastLine + ":" + this.lastCol + "]";
    }
}

