/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQml module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qqmljsengine_p.h"
#include "qqmljslexer_p.h"
#include "qqmljsast_p.h"
#include "qqmljsmemorypool_p.h"

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>



#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

using namespace QQmlJS;

QT_QML_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<AST::SourceLocation*> (realloc(location_stack, stack_size * sizeof(AST::SourceLocation)));
    string_stack = reinterpret_cast<QStringRef*> (realloc(static_cast<void *>(string_stack), stack_size * sizeof(QStringRef)));
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool()),
    tos(0),
    stack_size(0),
    sym_stack(0),
    state_stack(0),
    location_stack(0),
    string_stack(0),
    program(0),
    first_token(0),
    last_token(0)
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
        free(string_stack);
    }
}

static inline AST::SourceLocation location(Lexer *lexer)
{
    AST::SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringRef, 4> nameIds;
    QVarLengthArray<AST::SourceLocation, 4> locations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
        }

        return currentId->finish();
    }

    return 0;
}

AST::UiQualifiedPragmaId *Parser::reparseAsQualifiedPragmaId(AST::ExpressionNode *expr)
{
    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(expr)) {
        AST::UiQualifiedPragmaId *q = new (pool) AST::UiQualifiedPragmaId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        return q->finish();
    }

    return 0;
}


bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    int yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_PROGRAM && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yylloc = first_token->loc;
                ++first_token;
            }
        }

        action = t_action(action, yytoken);
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

          switch (r) {

case 0: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 1: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 2: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 3: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 4: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 5: {
  sym(1).Node = sym(2).Node;
  program = sym(1).Node;
} break;

case 6: {
  sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList,
        sym(2).UiObjectMemberList->finish());
} break;

case 8: {
    sym(1).Node = sym(1).UiHeaderItemList->finish();
} break;

case 9: {
    sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
} break;

case 10: {
    sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
} break;

case 11: {
    sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
} break;

case 12: {
    sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
} break;

case 16: {
    sym(1).UiPragma->semicolonToken = loc(2);
} break;

case 18: {
    sym(1).UiImport->semicolonToken = loc(2);
} break;

case 20: {
    sym(1).UiImport->versionToken = loc(2);
    sym(1).UiImport->semicolonToken = loc(3);
} break;

case 22: {
    sym(1).UiImport->versionToken = loc(2);
    sym(1).UiImport->asToken = loc(3);
    sym(1).UiImport->importIdToken = loc(4);
    sym(1).UiImport->importId = stringRef(4);
    sym(1).UiImport->semicolonToken = loc(5);
} break;

case 24: {
    sym(1).UiImport->asToken = loc(2);
    sym(1).UiImport->importIdToken = loc(3);
    sym(1).UiImport->importId = stringRef(3);
    sym(1).UiImport->semicolonToken = loc(4);
} break;

case 25: {
    AST::UiPragma *node = 0;

    if (AST::UiQualifiedPragmaId *qualifiedId = reparseAsQualifiedPragmaId(sym(2).Expression)) {
        node = new (pool) AST::UiPragma(qualifiedId);
    }

    sym(1).Node = node;

    if (node) {
        node->pragmaToken = loc(1);
    } else {
       diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, loc(1),
         QLatin1String("Expected a qualified name id")));

        return false; // ### remove me
    }
} break;

case 26: {
    AST::UiImport *node = 0;

    if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
        node = new (pool) AST::UiImport(importIdLiteral->value);
        node->fileNameToken = loc(2);
    } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
        node = new (pool) AST::UiImport(qualifiedId);
        node->fileNameToken = loc(2);
    }

    sym(1).Node = node;

    if (node) {
        node->importToken = loc(1);
    } else {
       diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, loc(1),
         QLatin1String("Expected a qualified name id or a string literal")));

        return false; // ### remove me
    }
} break;

case 27: {
    sym(1).Node = 0;
} break;

case 28: {
    sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
} break;

case 29: {
    sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
} break;

case 30: {
    AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(
        sym(1).UiObjectMemberList, sym(2).UiObjectMember);
    sym(1).Node = node;
} break;

case 31: {
    sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
} break;

case 32: {
    AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(
        sym(1).UiArrayMemberList, sym(3).UiObjectMember);
    node->commaToken = loc(2);
    sym(1).Node = node;
} break;

case 33: {
    AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
    node->lbraceToken = loc(1);
    node->rbraceToken = loc(2);
    sym(1).Node = node;
}   break;

case 34: {
    AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
    node->lbraceToken = loc(1);
    node->rbraceToken = loc(3);
    sym(1).Node = node;
}   break;

case 35: {
    AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId,
        sym(2).UiObjectInitializer);
    sym(1).Node = node;
}   break;

case 37: {
    AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(
        sym(1).UiQualifiedId, sym(4).UiArrayMemberList->finish());
    node->colonToken = loc(2);
    node->lbracketToken = loc(3);
    node->rbracketToken = loc(5);
    sym(1).Node = node;
}   break;

case 38: {
    AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
      sym(1).UiQualifiedId, sym(3).UiQualifiedId, sym(4).UiObjectInitializer);
    node->colonToken = loc(2);
    sym(1).Node = node;
} break;

case 39: {
    AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
      sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
    node->colonToken = loc(2);
    node->hasOnToken = true;
    sym(1).Node = node;
} break;

case 47:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(
        sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
}   break;

case 48: {
  AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 49: {
  AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 50: {
  AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 51: {
  AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 52: {
  sym(1).Node = 0;
} break;

case 53: {
  sym(1).Node = sym(1).UiParameterList->finish ();
} break;

case 54: {
  AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiQualifiedId->finish(), stringRef(2));
  node->propertyTypeToken = loc(1);
  node->identifierToken = loc(2);
  sym(1).Node = node;
} break;

case 55: {
  AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).UiQualifiedId->finish(), stringRef(4));
  node->propertyTypeToken = loc(3);
  node->commaToken = loc(2);
  node->identifierToken = loc(4);
  sym(1).Node = node;
} break;

case 57: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
    node->type = AST::UiPublicMember::Signal;
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(2);
    node->parameters = sym(4).UiParameterList;
    node->semicolonToken = loc(6);
    sym(1).Node = node;
}   break;

case 59: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
    node->type = AST::UiPublicMember::Signal;
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(2);
    node->semicolonToken = loc(3);
    sym(1).Node = node;
}   break;

case 61: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
    node->typeModifier = stringRef(2);
    node->propertyToken = loc(1);
    node->typeModifierToken = loc(2);
    node->typeToken = loc(4);
    node->identifierToken = loc(6);
    node->semicolonToken = loc(7);
    sym(1).Node = node;
}   break;

case 63: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(3);
    node->semicolonToken = loc(4);
    sym(1).Node = node;
}   break;

case 65: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(3).UiQualifiedId->finish(), stringRef(4));
    node->isDefaultMember = true;
    node->defaultToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->semicolonToken = loc(5);
    sym(1).Node = node;
}   break;

case 67: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(5).UiQualifiedId->finish(), stringRef(7));
    node->isDefaultMember = true;
    node->defaultToken = loc(1);
    node->typeModifier = stringRef(3);
    node->propertyToken = loc(2);
    node->typeModifierToken = loc(2);
    node->typeToken = loc(4);
    node->identifierToken = loc(7);
    node->semicolonToken = loc(8);
    sym(1).Node = node;
}   break;

case 68: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3),
        sym(5).Statement);
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(3);
    node->colonToken = loc(4);
    sym(1).Node = node;
}   break;

case 69: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(3).UiQualifiedId->finish(), stringRef(4),
        sym(6).Statement);
    node->isReadonlyMember = true;
    node->readonlyToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->colonToken = loc(5);
    sym(1).Node = node;
}   break;

case 70: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(3).UiQualifiedId->finish(), stringRef(4),
        sym(6).Statement);
    node->isDefaultMember = true;
    node->defaultToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->colonToken = loc(5);
    sym(1).Node = node;
}   break;

case 71: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
    node->typeModifier = stringRef(2);
    node->propertyToken = loc(1);
    node->typeModifierToken = loc(2);
    node->typeToken = loc(4);
    node->identifierToken = loc(6);
    node->semicolonToken = loc(7); // insert a fake ';' before ':'

    AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
    propertyName->identifierToken = loc(6);
    propertyName->next = 0;

    AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(
        propertyName, sym(9).UiArrayMemberList->finish());
    binding->colonToken = loc(7);
    binding->lbracketToken = loc(8);
    binding->rbracketToken = loc(10);

    node->binding = binding;

    sym(1).Node = node;
}   break;

case 72: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
    node->propertyToken = loc(1);
    node->typeToken = loc(2);
    node->identifierToken = loc(3);
    node->semicolonToken = loc(4); // insert a fake ';' before ':'

    AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
    propertyName->identifierToken = loc(3);
    propertyName->next = 0;

    AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
      propertyName, sym(5).UiQualifiedId, sym(6).UiObjectInitializer);
    binding->colonToken = loc(4);

    node->binding = binding;

    sym(1).Node = node;
}   break;

case 73: {
    AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(3).UiQualifiedId->finish(), stringRef(4));
    node->isReadonlyMember = true;
    node->readonlyToken = loc(1);
    node->propertyToken = loc(2);
    node->typeToken = loc(3);
    node->identifierToken = loc(4);
    node->semicolonToken = loc(5); // insert a fake ';' before ':'

    AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(4));
    propertyName->identifierToken = loc(4);
    propertyName->next = 0;

    AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
      propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
    binding->colonToken = loc(5);

    node->binding = binding;

    sym(1).Node = node;
}   break;

case 74: {
    sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
}   break;

case 75: {
    sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
}   break;

case 83: {
  AST::ThisExpression *node = new (pool) AST::ThisExpression();
  node->thisToken = loc(1);
  sym(1).Node = node;
} break;

case 84: {
  AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 85: {
  AST::NullExpression *node = new (pool) AST::NullExpression();
  node->nullToken = loc(1);
  sym(1).Node = node;
} break;

case 86: {
  AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
  node->trueToken = loc(1);
  sym(1).Node = node;
} break;

case 87: {
  AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
  node->falseToken = loc(1);
  sym(1).Node = node;
} break;

case 88: {
  AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;
case 89:
case 90: {
  AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 91: {
  bool rx = lexer->scanRegExp(Lexer::NoPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, location(lexer), lexer->errorMessage()));
    return false; // ### remove me
  }

  loc(1).length = lexer->tokenLength();
  yylloc = loc(1); // adjust the location of the current token

  AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(
    driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 92: {
  bool rx = lexer->scanRegExp(Lexer::EqualPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, location(lexer), lexer->errorMessage()));
    return false;
  }

  loc(1).length = lexer->tokenLength();
  yylloc = loc(1); // adjust the location of the current token

  AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(
    driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
  node->literalToken = loc(1);
  sym(1).Node = node;
} break;

case 93: {
  AST::ArrayLiteral *node = new (pool) AST::ArrayLiteral((AST::Elision *) 0);
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(2);
  sym(1).Node = node;
} break;

case 94: {
  AST::ArrayLiteral *node = new (pool) AST::ArrayLiteral(sym(2).Elision->finish());
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(3);
  sym(1).Node = node;
} break;

case 95: {
  AST::ArrayLiteral *node = new (pool) AST::ArrayLiteral(sym(2).ElementList->finish ());
  node->lbracketToken = loc(1);
  node->rbracketToken = loc(3);
  sym(1).Node = node;
} break;

case 96: {
  AST::ArrayLiteral *node = new (pool) AST::ArrayLiteral(sym(2).ElementList->finish (),
    (AST::Elision *) 0);
  node->lbracketToken = loc(1);
  node->commaToken = loc(3);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 97: {
  AST::ArrayLiteral *node = new (pool) AST::ArrayLiteral(sym(2).ElementList->finish (),
    sym(4).Elision->finish());
  node->lbracketToken = loc(1);
  node->commaToken = loc(3);
  node->rbracketToken = loc(5);
  sym(1).Node = node;
} break;

case 98: {
  AST::ObjectLiteral *node = 0;
  if (sym(2).Node)
    node = new (pool) AST::ObjectLiteral(
        sym(2).PropertyAssignmentList->finish ());
  else
    node = new (pool) AST::ObjectLiteral();
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 99: {
  AST::ObjectLiteral *node = new (pool) AST::ObjectLiteral(
    sym(2).PropertyAssignmentList->finish ());
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(4);
  sym(1).Node = node;
} break;

case 100: {
  AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
  node->lparenToken = loc(1);
  node->rparenToken = loc(3);
  sym(1).Node = node;
} break;

case 101: {
  if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Warning, mem->lbracketToken,
      QLatin1String("Ignored annotation")));

    sym(1).Expression = mem->base;
  }

  if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
    sym(1).UiQualifiedId = qualifiedId;
  } else {
    sym(1).UiQualifiedId = 0;

    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, loc(1),
      QLatin1String("Expected a qualified name id")));

    return false; // ### recover
  }
} break;

case 102: {
  sym(1).Node = new (pool) AST::ElementList((AST::Elision *) 0, sym(1).Expression);
} break;

case 103: {
  sym(1).Node = new (pool) AST::ElementList(sym(1).Elision->finish(), sym(2).Expression);
} break;

case 104: {
  AST::ElementList *node = new (pool) AST::ElementList(sym(1).ElementList,
    (AST::Elision *) 0, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 105: {
  AST::ElementList *node = new (pool) AST::ElementList(sym(1).ElementList, sym(3).Elision->finish(),
    sym(4).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 106: {
  AST::Elision *node = new (pool) AST::Elision();
  node->commaToken = loc(1);
  sym(1).Node = node;
} break;

case 107: {
  AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 108: {
  AST::PropertyNameAndValue *node = new (pool) AST::PropertyNameAndValue(
      sym(1).PropertyName, sym(3).Expression);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 109: {
  AST::PropertyGetterSetter *node = new (pool) AST::PropertyGetterSetter(
      sym(2).PropertyName, sym(6).FunctionBody);
  node->getSetToken = loc(1);
  node->lparenToken = loc(3);
  node->rparenToken = loc(4);
  node->lbraceToken = loc(5);
  node->rbraceToken = loc(7);
  sym(1).Node = node;
} break;

case 110: {
  AST::PropertyGetterSetter *node = new (pool) AST::PropertyGetterSetter(
      sym(2).PropertyName, sym(4).FormalParameterList, sym(7).FunctionBody);
  node->getSetToken = loc(1);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  node->lbraceToken = loc(6);
  node->rbraceToken = loc(8);
  sym(1).Node = node;
} break;

case 111: {
  sym(1).Node = new (pool) AST::PropertyAssignmentList(sym(1).PropertyAssignment);
} break;

case 112: {
  AST::PropertyAssignmentList *node = new (pool) AST::PropertyAssignmentList(
    sym(1).PropertyAssignmentList, sym(3).PropertyAssignment);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 113: {
  AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 114: {
  AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 115: {
  AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 116: {
  AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
  node->propertyNameToken = loc(1);
  sym(1).Node = node;
} break;

case 152: {
  AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
  node->lbracketToken = loc(2);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 153: {
  AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
  node->dotToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 154: {
  AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
  node->newToken = loc(1);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  sym(1).Node = node;
} break;

case 156: {
  AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
  node->newToken = loc(1);
  sym(1).Node = node;
} break;

case 157: {
  AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 158: {
  AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 159: {
  AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
  node->lbracketToken = loc(2);
  node->rbracketToken = loc(4);
  sym(1).Node = node;
} break;

case 160: {
  AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
  node->dotToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 161: {
  sym(1).Node = 0;
} break;

case 162: {
  sym(1).Node = sym(1).ArgumentList->finish();
} break;

case 163: {
  sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
} break;

case 164: {
  AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 168: {
  AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
  node->incrementToken = loc(2);
  sym(1).Node = node;
} break;

case 169: {
  AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
  node->decrementToken = loc(2);
  sym(1).Node = node;
} break;

case 171: {
  AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
  node->deleteToken = loc(1);
  sym(1).Node = node;
} break;

case 172: {
  AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
  node->voidToken = loc(1);
  sym(1).Node = node;
} break;

case 173: {
  AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
  node->typeofToken = loc(1);
  sym(1).Node = node;
} break;

case 174: {
  AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
  node->incrementToken = loc(1);
  sym(1).Node = node;
} break;

case 175: {
  AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
  node->decrementToken = loc(1);
  sym(1).Node = node;
} break;

case 176: {
  AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
  node->plusToken = loc(1);
  sym(1).Node = node;
} break;

case 177: {
  AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
  node->minusToken = loc(1);
  sym(1).Node = node;
} break;

case 178: {
  AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
  node->tildeToken = loc(1);
  sym(1).Node = node;
} break;

case 179: {
  AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
  node->notToken = loc(1);
  sym(1).Node = node;
} break;

case 181: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Mul, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 182: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Div, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 183: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Mod, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 185: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Add, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 186: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Sub, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 188: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::LShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 189: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::RShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 190: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::URShift, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 192: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Lt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 193: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Gt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 194: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Le, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 195: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Ge, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 196: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::InstanceOf, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 197: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::In, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 199: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Lt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 200: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Gt, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 201: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Le, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 202: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
   QSOperator::Ge, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 203: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::InstanceOf, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 205: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Equal, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 206: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::NotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 207: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::StrictEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 208: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::StrictNotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 210: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Equal, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 211: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::NotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 212: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::StrictEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 213: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::StrictNotEqual, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 215: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitAnd, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 217: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitAnd, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 219: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitXor, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 221: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitXor, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 223: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitOr, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 225: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::BitOr, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 227: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::And, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 229: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::And, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 231: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Or, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 233: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    QSOperator::Or, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 235: {
  AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression,
    sym(3).Expression, sym(5).Expression);
  node->questionToken = loc(2);
  node->colonToken = loc(4);
  sym(1).Node = node;
} break;

case 237: {
  AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression,
    sym(3).Expression, sym(5).Expression);
  node->questionToken = loc(2);
  node->colonToken = loc(4);
  sym(1).Node = node;
} break;

case 239: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    sym(2).ival, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 241: {
  AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression,
    sym(2).ival, sym(3).Expression);
  node->operatorToken = loc(2);
  sym(1).Node = node;
} break;

case 242: {
  sym(1).ival = QSOperator::Assign;
} break;

case 243: {
  sym(1).ival = QSOperator::InplaceMul;
} break;

case 244: {
  sym(1).ival = QSOperator::InplaceDiv;
} break;

case 245: {
  sym(1).ival = QSOperator::InplaceMod;
} break;

case 246: {
  sym(1).ival = QSOperator::InplaceAdd;
} break;

case 247: {
  sym(1).ival = QSOperator::InplaceSub;
} break;

case 248: {
  sym(1).ival = QSOperator::InplaceLeftShift;
} break;

case 249: {
  sym(1).ival = QSOperator::InplaceRightShift;
} break;

case 250: {
  sym(1).ival = QSOperator::InplaceURightShift;
} break;

case 251: {
  sym(1).ival = QSOperator::InplaceAnd;
} break;

case 252: {
  sym(1).ival = QSOperator::InplaceXor;
} break;

case 253: {
  sym(1).ival = QSOperator::InplaceOr;
} break;

case 255: {
  AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 256: {
  sym(1).Node = 0;
} break;

case 259: {
  AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 260: {
  sym(1).Node = 0;
} break;

case 277: {
  AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 278: {
  sym(1).Node = new (pool) AST::StatementList(sym(1).Statement);
} break;

case 279: {
  sym(1).Node = new (pool) AST::StatementList(sym(1).StatementList, sym(2).Statement);
} break;

case 280: {
  sym(1).Node = 0;
} break;

case 281: {
  sym(1).Node = sym(1).StatementList->finish ();
} break;

case 283: {
  AST::VariableStatement *node = new (pool) AST::VariableStatement(
     sym(2).VariableDeclarationList->finish (/*readOnly=*/sym(1).ival == T_CONST));
  node->declarationKindToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 284: {
  sym(1).ival = T_CONST;
} break;

case 285: {
  sym(1).ival = T_VAR;
} break;

case 286: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclaration);
} break;

case 287: {
  AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(
    sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
  node->commaToken = loc(2);
  sym(1).Node = node;
} break;

case 288: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclaration);
} break;

case 289: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
} break;

case 290: {
  AST::VariableDeclaration *node = new (pool) AST::VariableDeclaration(stringRef(1), sym(2).Expression);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 291: {
  AST::VariableDeclaration *node = new (pool) AST::VariableDeclaration(stringRef(1), sym(2).Expression);
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 292: {
  // ### TODO: AST for initializer
  sym(1) = sym(2);
} break;

case 293: {
  sym(1).Node = 0;
} break;

case 295: {
  // ### TODO: AST for initializer
  sym(1) = sym(2);
} break;

case 296: {
  sym(1).Node = 0;
} break;

case 298: {
  AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
  node->semicolonToken = loc(1);
  sym(1).Node = node;
} break;

case 300: {
  AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 301: {
  AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
  node->ifToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  node->elseToken = loc(6);
  sym(1).Node = node;
} break;

case 302: {
  AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
  node->ifToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 305: {
  AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
  node->doToken = loc(1);
  node->whileToken = loc(3);
  node->lparenToken = loc(4);
  node->rparenToken = loc(6);
  node->semicolonToken = loc(7);
  sym(1).Node = node;
} break;

case 306: {
  AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
  node->whileToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 307: {
  AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression,
    sym(5).Expression, sym(7).Expression, sym(9).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->firstSemicolonToken = loc(4);
  node->secondSemicolonToken = loc(6);
  node->rparenToken = loc(8);
  sym(1).Node = node;
} break;

case 308: {
  AST::LocalForStatement *node = new (pool) AST::LocalForStatement(
     sym(4).VariableDeclarationList->finish (/*readOnly=*/false), sym(6).Expression,
     sym(8).Expression, sym(10).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->varToken = loc(3);
  node->firstSemicolonToken = loc(5);
  node->secondSemicolonToken = loc(7);
  node->rparenToken = loc(9);
  sym(1).Node = node;
} break;

case 309: {
  AST:: ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression,
    sym(5).Expression, sym(7).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->inToken = loc(4);
  node->rparenToken = loc(6);
  sym(1).Node = node;
} break;

case 310: {
  AST::LocalForEachStatement *node = new (pool) AST::LocalForEachStatement(
    sym(4).VariableDeclaration, sym(6).Expression, sym(8).Statement);
  node->forToken = loc(1);
  node->lparenToken = loc(2);
  node->varToken = loc(3);
  node->inToken = loc(5);
  node->rparenToken = loc(7);
  sym(1).Node = node;
} break;

case 312: {
  AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
  node->continueToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 314: {
  AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
  node->continueToken = loc(1);
  node->identifierToken = loc(2);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 316: {
  AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringRef());
  node->breakToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 318: {
  AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
  node->breakToken = loc(1);
  node->identifierToken = loc(2);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 320: {
  AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
  node->returnToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 321: {
  AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
  node->withToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 322: {
  AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
  node->switchToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 323: {
  AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(3);
  sym(1).Node = node;
} break;

case 324: {
  AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
  node->lbraceToken = loc(1);
  node->rbraceToken = loc(5);
  sym(1).Node = node;
} break;

case 325: {
  sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
} break;

case 326: {
  sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
} break;

case 327: {
  sym(1).Node = 0;
} break;

case 328: {
  sym(1).Node = sym(1).CaseClauses->finish ();
} break;

case 329: {
  AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
  node->caseToken = loc(1);
  node->colonToken = loc(3);
  sym(1).Node = node;
} break;

case 330: {
  AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
  node->defaultToken = loc(1);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 331: {
  AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
  node->identifierToken = loc(1);
  node->colonToken = loc(2);
  sym(1).Node = node;
} break;

case 333: {
  AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
  node->throwToken = loc(1);
  node->semicolonToken = loc(3);
  sym(1).Node = node;
} break;

case 334: {
  AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 335: {
  AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 336: {
  AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
  node->tryToken = loc(1);
  sym(1).Node = node;
} break;

case 337: {
  AST::Catch *node = new (pool) AST::Catch(stringRef(3), sym(5).Block);
  node->catchToken = loc(1);
  node->lparenToken = loc(2);
  node->identifierToken = loc(3);
  node->rparenToken = loc(4);
  sym(1).Node = node;
} break;

case 338: {
  AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
  node->finallyToken = loc(1);
  sym(1).Node = node;
} break;

case 340: {
  AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
  node->debuggerToken = loc(1);
  node->semicolonToken = loc(2);
  sym(1).Node = node;
} break;

case 342: {
  AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(7).FunctionBody);
  node->functionToken = loc(1);
  node->identifierToken = loc(2);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  node->lbraceToken = loc(6);
  node->rbraceToken = loc(8);
  sym(1).Node = node;
} break;

case 343: {
  AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(7).FunctionBody);
  node->functionToken = loc(1);
  if (! stringRef(2).isNull())
      node->identifierToken = loc(2);
  node->lparenToken = loc(3);
  node->rparenToken = loc(5);
  node->lbraceToken = loc(6);
  node->rbraceToken = loc(8);
  sym(1).Node = node;
} break;

case 344: {
  AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringRef(), sym(3).FormalParameterList, sym(6).FunctionBody);
  node->functionToken = loc(1);
  node->lparenToken = loc(2);
  node->rparenToken = loc(4);
  node->lbraceToken = loc(5);
  node->rbraceToken = loc(7);
  sym(1).Node = node;
} break;

case 345: {
  AST::FormalParameterList *node = new (pool) AST::FormalParameterList(stringRef(1));
  node->identifierToken = loc(1);
  sym(1).Node = node;
} break;

case 346: {
  AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, stringRef(3));
  node->commaToken = loc(2);
  node->identifierToken = loc(3);
  sym(1).Node = node;
} break;

case 347: {
  sym(1).Node = 0;
} break;

case 348: {
  sym(1).Node = sym(1).FormalParameterList->finish ();
} break;

case 349: {
  sym(1).Node = 0;
} break;

case 351: {
  sym(1).Node = new (pool) AST::FunctionBody(sym(1).SourceElements->finish ());
} break;

case 353: {
  sym(1).Node = new (pool) AST::Program(sym(1).SourceElements->finish ());
} break;

case 354: {
  sym(1).Node = new (pool) AST::SourceElements(sym(1).SourceElement);
} break;

case 355: {
  sym(1).Node = new (pool) AST::SourceElements(sym(1).SourceElements, sym(2).SourceElement);
} break;

case 356: {
  sym(1).Node = new (pool) AST::StatementSourceElement(sym(1).Statement);
} break;

case 357: {
  sym(1).Node = new (pool) AST::FunctionSourceElement(sym(1).FunctionDeclaration);
} break;

case 358: {
  sym(1).Node = 0;
} break;

            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.spell = yytokenspell;
            tk.loc = yylloc;

            yylloc = yyprevlloc;
            yylloc.offset += yylloc.length;
            yylloc.startColumn += yylloc.length;
            yylloc.length = 0;

            //const QString msg = QCoreApplication::translate("QQmlParser", "Missing `;'");
            //diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Warning, yylloc, msg));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

                yytoken = *tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;
                yylloc.length = 0;

                first_token = &token_buffer[0];
                last_token = &token_buffer[2];

                action = errorState;
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION ||
                tk == T_FEED_JS_SOURCE_ELEMENT)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));

                yytoken = tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;
                yylloc.length = 0;

                action = errorState;
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, token_buffer[0].loc, msg));
    }

    return false;
}

QT_QML_END_NAMESPACE


