/*
 * Copyright 2016 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef SkSVGPath_DEFINED
#define SkSVGPath_DEFINED

#include "SkPath.h"
#include "SkSVGShape.h"

class SkSVGPath final : public SkSVGShape {
public:
    virtual ~SkSVGPath() = default;
    static sk_sp<SkSVGPath> Make() { return sk_sp<SkSVGPath>(new SkSVGPath()); }

    void setPath(const SkPath& path) { fPath = path; }

protected:
    void onSetAttribute(SkSVGAttribute, const SkSVGValue&) override;

    void onDraw(SkCanvas*, const SkSVGLengthContext&, const SkPaint&) const override;

private:
    SkSVGPath();

    SkPath fPath;

    typedef SkSVGShape INHERITED;
};

#endif // SkSVGPath_DEFINED
