/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.MethodOptimizationInfo;

public class ParameterUsageMarker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final boolean markThisParameter;
    private final boolean markAllParameters;
    private final PartialEvaluator partialEvaluator = new PartialEvaluator();

    public ParameterUsageMarker() {
        this(false, false);
    }

    public ParameterUsageMarker(boolean bl, boolean bl2) {
        this.markThisParameter = bl;
        this.markAllParameters = bl2;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = ClassUtil.internalMethodParameterSize(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
        if (n > 0) {
            int n2 = programMethod.getAccessFlags();
            if (this.markThisParameter && (n2 & 8) == 0) {
                ParameterUsageMarker.markParameterUsed(programMethod, 0);
            }
            if (this.markAllParameters) {
                ParameterUsageMarker.markUsedParameters(programMethod, (n2 & 8) != 0 ? -1L : -2L);
            }
            if ((n2 & 0x100) != 0) {
                ParameterUsageMarker.markUsedParameters(programMethod, -1L);
            } else if ((n2 & 0x400) != 0) {
                ParameterUsageMarker.markParameterUsed(programMethod, 0);
            } else {
                if ((n2 & 8) == 0 && ((n2 & 0x20) != 0 || programClass.mayHaveImplementations(programMethod) || programMethod.getName(programClass).equals("<init>"))) {
                    ParameterUsageMarker.markParameterUsed(programMethod, 0);
                }
                programMethod.attributesAccept(programClass, this);
            }
        }
        ParameterUsageMarker.setParameterSize(programMethod, n);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (libraryClass.mayHaveImplementations(libraryMethod)) {
            ParameterUsageMarker.markUsedParameters(libraryMethod, -1L);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        Value value;
        int n2;
        if (this.partialEvaluator.isTraced(n) && variableInstruction.isLoad() && (n2 = variableInstruction.variableIndex) < codeAttribute.u2maxLocals && (value = this.partialEvaluator.getVariablesBefore(n).getProducerValue(n2)) != null && value.instructionOffsetValue().contains(-1)) {
            ParameterUsageMarker.markParameterUsed(method, n2);
            if (variableInstruction.isCategory2()) {
                ParameterUsageMarker.markParameterUsed(method, n2 + 1);
            }
        }
    }

    private static void setParameterSize(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setParameterSize(n);
        }
    }

    public static int getParameterSize(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getParameterSize() : 0;
    }

    public static void markParameterUsed(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setParameterUsed(n);
        }
    }

    public static void markUsedParameters(Method method, long l) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setUsedParameters(methodOptimizationInfo.getUsedParameters() | l);
        }
    }

    public static boolean isParameterUsed(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.isParameterUsed(n);
    }

    public static long getUsedParameters(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getUsedParameters() : -1L;
    }
}

