/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class SimpleInstruction
extends Instruction {
    public int constant;

    public SimpleInstruction() {
    }

    public SimpleInstruction(byte by) {
        this(by, SimpleInstruction.embeddedConstant(by));
    }

    public SimpleInstruction(byte by, int n) {
        this.opcode = by;
        this.constant = n;
    }

    public SimpleInstruction copy(SimpleInstruction simpleInstruction) {
        this.opcode = simpleInstruction.opcode;
        this.constant = simpleInstruction.constant;
        return this;
    }

    private static int embeddedConstant(byte by) {
        switch (by) {
            case 2: {
                return -1;
            }
            case 4: 
            case 10: 
            case 12: 
            case 15: {
                return 1;
            }
            case 5: 
            case 13: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public byte canonicalOpcode() {
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return 3;
            }
            case 9: 
            case 10: {
                return 9;
            }
            case 11: 
            case 12: 
            case 13: {
                return 11;
            }
            case 14: 
            case 15: {
                return 14;
            }
        }
        return this.opcode;
    }

    @Override
    public Instruction shrink() {
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                switch (this.requiredConstantSize()) {
                    case 0: {
                        this.opcode = (byte)(3 + this.constant);
                        break;
                    }
                    case 1: {
                        this.opcode = (byte)16;
                        break;
                    }
                    case 2: {
                        this.opcode = (byte)17;
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                this.opcode = (byte)(9 + this.constant);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.opcode = (byte)(11 + this.constant);
                break;
            }
            case 14: 
            case 15: {
                this.opcode = (byte)(14 + this.constant);
            }
        }
        return this;
    }

    @Override
    protected void readInfo(byte[] byArray, int n) {
        int n2 = this.constantSize();
        this.constant = n2 == 0 ? SimpleInstruction.embeddedConstant(this.opcode) : SimpleInstruction.readSignedValue(byArray, n, n2);
    }

    @Override
    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.constantSize();
        if (this.requiredConstantSize() > n2) {
            throw new IllegalArgumentException("Instruction has invalid constant size (" + this.toString(n) + ")");
        }
        SimpleInstruction.writeSignedValue(byArray, n, this.constant, n2);
    }

    @Override
    public int length(int n) {
        return 1 + this.constantSize();
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, n, this);
    }

    public String toString() {
        return this.getName() + (this.constantSize() > 0 ? " " + this.constant : "");
    }

    private int constantSize() {
        return this.opcode == 16 || this.opcode == -68 ? 1 : (this.opcode == 17 ? 2 : 0);
    }

    private int requiredConstantSize() {
        return this.constant >= -1 && this.constant <= 5 ? 0 : ((byte)this.constant == this.constant ? 1 : ((short)this.constant == this.constant ? 2 : 4));
    }
}

