/*
 * Copyright (C) 2007 Eric Seidel <eric@webkit.org>
 * Copyright (C) 2008 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SVGAnimateMotionElement_h
#define SVGAnimateMotionElement_h

#include "core/svg/SVGAnimationElement.h"
#include "platform/graphics/Path.h"

namespace blink {

class SVGAnimateMotionElement final : public SVGAnimationElement {
  DEFINE_WRAPPERTYPEINFO();

 public:
  ~SVGAnimateMotionElement() override;

  DECLARE_NODE_FACTORY(SVGAnimateMotionElement);
  void UpdateAnimationPath();

 private:
  explicit SVGAnimateMotionElement(Document&);

  bool HasValidTarget() override;

  void ParseAttribute(const AttributeModificationParams&) override;

  void ResetAnimatedType() override;
  void ClearAnimatedType() override;
  bool CalculateToAtEndOfDurationValue(
      const String& to_at_end_of_duration_string) override;
  bool CalculateFromAndToValues(const String& from_string,
                                const String& to_string) override;
  bool CalculateFromAndByValues(const String& from_string,
                                const String& by_string) override;
  void CalculateAnimatedValue(float percentage,
                              unsigned repeat_count,
                              SVGSMILElement* result_element) override;
  void ApplyResultsToTarget() override;
  float CalculateDistance(const String& from_string,
                          const String& to_string) override;

  enum RotateMode { kRotateAngle, kRotateAuto, kRotateAutoReverse };
  RotateMode GetRotateMode() const;

  bool has_to_point_at_end_of_duration_;

  void UpdateAnimationMode() override;

  void InvalidateForAnimateMotionTransformChange(LayoutObject& target);

  // Note: we do not support percentage values for to/from coords as the spec
  // implies we should (opera doesn't either)
  FloatPoint from_point_;
  FloatPoint to_point_;
  FloatPoint to_point_at_end_of_duration_;

  Path path_;
  Path animation_path_;
};

}  // namespace blink

#endif  // SVGAnimateMotionElement_h
