/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QuotaTracker_h
#define QuotaTracker_h

#include "base/macros.h"
#include "modules/ModulesExport.h"
#include "platform/wtf/HashMap.h"
#include "platform/wtf/ThreadingPrimitives.h"
#include "platform/wtf/text/StringHash.h"
#include "platform/wtf/text/WTFString.h"

namespace blink {

class SecurityOrigin;

class MODULES_EXPORT QuotaTracker {
  USING_FAST_MALLOC(QuotaTracker);

 public:
  static QuotaTracker& Instance();

  void GetDatabaseSizeAndSpaceAvailableToOrigin(
      const SecurityOrigin*,
      const String& database_name,
      unsigned long long* database_size,
      unsigned long long* space_available);
  void UpdateDatabaseSize(const SecurityOrigin*,
                          const String& database_name,
                          unsigned long long database_size);

 private:
  QuotaTracker() = default;

  typedef HashMap<String, unsigned long long> SizeMap;
  HashMap<String, SizeMap> database_sizes_;
  Mutex data_guard_;

  DISALLOW_COPY_AND_ASSIGN(QuotaTracker);
};

}  // namespace blink

#endif  // QuotaTracker_h
