API Overview & Doxygen Docs
===========================

Skia is organized around the `SkCanvas` object. It is the host for the
"draw" calls: `drawRect`, `drawPath`, `drawText`, etc. Each of these
has two components: the primitive being drawn (`SkRect`, `SkPath`, etc.)
and color/style attributes (`SkPaint`).

<!--?prettify lang=cc?-->

    canvas->drawRect(rect, paint);

The paint holds much of the state describing how the rectangle (in
this case) is drawn: what color it is, if it is filled or stroked, how
it should blend with what was previously drawn.

The canvas holds relatively little state. It points to the actual
pixels being drawn, and it maintains a stack of matrices and
clips. Thus in the above call, the canvas' current matrix may
transform the coordinates of the rectangle (translation, rotation,
skewing, perspective), and the canvas' current clip may restrict where
on the canvas the rectangle will be drawn, but all other stylistic
attributes of the drawing are controlled by the paint.

Using the SkCanvas API:

1.  **[SkCanvas](/user/api/skcanvas)** - the drawing context.
2.  **[SkPaint](/user/api/skpaint)** - color, stroke, font, effects
3.  **[SkRect](/user/api/skrect)** - rectangles
4.  **[SkRegion](/user/api/skregion)** - set operations with rectangles and paths

Appendix:

1.  **[Creating SkCanvas Objects](/user/api/canvas)**

Autogenerated Doxygen Documentaion
----------------------------------

*   [Skia Doxygen](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/index.html)

Here's a partial list of the more important Skia classes:

*   [SkCanvas](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkCanvas.html)
*   [SkImage](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkImage.html)
*   [SkSurface](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkSurface.html)
*   [SkPaint](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPaint.html)
*   [SkShader](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkShader.html)
    -   [SkComposeShader](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkComposeShader.html)
    -   [SkPerlinNoiseShader](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPerlinNoiseShader.html)
    -   [SkGradientShader](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkGradientShader.html)
    -   [SkTransparentShader](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkTransparentShader.html)
*   [SkColorFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkColorFilter.html)
    -   [SkColorMatrixFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkColorMatrixFilter.html)
    -   [SkLumaColorFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkLumaColorFilter.html)
    -   [SkModeColorFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkModeColorFilter.html)
*   [SkPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPathEffect.html)
    -   [SkPath2DPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPath2DPathEffect.html)
    -   [SkLine2DPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkLine2DPathEffect.html)
    -   [SkPath1DPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPath1DPathEffect.html)
    -   [SkArcToPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkArcToPathEffect.html)
    -   [SkCornerPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkCornerPathEffect.html)
    -   [SkDashPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDashPathEffect.html)
    -   [SkDiscretePathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDiscretePathEffect.html)
    -   [SkComposePathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkComposePathEffect.html)
    -   [SkSumPathEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkSumPathEffect.html)
*   [SkImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkImageFilter.html)
    -   [SkAlphaThresholdFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkAlphaThresholdFilter.html)
    -   [SkBlurImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkBlurImageFilter.html)
    -   [SkBitmapSource](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkBitmapSource.html)
    -   [SkColorFilterImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkColorFilterImageFilter.html)
    -   [SkComposeImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkComposeImageFilter.html)
    -   [SkDisplacementMapEffect](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDisplacementMapEffect.html)
    -   [SkDownSampleImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDownSampleImageFilter.html)
    -   [SkDropShadowImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDropShadowImageFilter.html)
    -   [SkLightingImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkLightingImageFilter.html)
    -   [SkMagnifierImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkMagnifierImageFilter.html)
    -   [SkMatrixConvolutionImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkMatrixConvolutionImageFilter.html)
    -   [SkMergeImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkMergeImageFilter.html)
    -   [SkDilateImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDilateImageFilter.html)
    -   [SkErodeImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkErodeImageFilter.html)
    -   [SkOffsetImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkOffsetImageFilter.html)
    -   [SkPictureImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkPictureImageFilter.html)
    -   [SkRectShaderImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkRectShaderImageFilter.html)
    -   [SkTileImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkTileImageFilter.html)
    -   [SkXfermodeImageFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkXfermodeImageFilter.html)
*   [SkMaskFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkMaskFilter.html)
    -   [SkTableMaskFilter](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkTableMaskFilter.html)
*   [SkDrawLooper](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkDrawLooper.html)
    -   [SkBlurDrawLooper](http://skia-doc.commondatastorage.googleapis.com/doxygen/doxygen/html/classSkBlurDrawLooper.html)
