#!/usr/bin/env bash
set -eu

#############################################################################
##
## Copyright (C) 2019 Richard Weickelt.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qbs.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

export PATH="$1:$PATH"

export LSAN_OPTIONS="suppressions=$( cd "$(dirname "$0")" ; pwd -P )/address-sanitizer-suppressions.txt:print_suppressions=0"

#
# These are set outside of this script, for instance in the Docker image
#
echo "Android SDK installed at ${ANDROID_SDK_ROOT}"
echo "Android NDK installed at ${ANDROID_NDK_ROOT}"

# Cleaning profiles
qbs config --unset profiles.qbs_autotests-android

# Setting auto test profiles
qbs setup-android --ndk-dir ${ANDROID_NDK_ROOT} --sdk-dir ${ANDROID_HOME} qbs_autotests-android

export QBS_AUTOTEST_PROFILE=qbs_autotests-android
export QBS_AUTOTEST_ALWAYS_LOG_STDERR=true
export QTEST_FUNCTION_TIMEOUT=9000000

qbs config --list

tst_blackbox-android

