precision mediump int;
precision mediump float;

VARYING vec3 vColor;

void MAIN(){
    vec3 fNormal = normalize(VAR_WORLD_NORMAL);
    vec3 fView = normalize(VIEW_VECTOR);
    float fresnelBase = 1.0-max(0.0,dot(fNormal, fView));
    float clearcoatMask = fresnelBase*clearcoat;

    vec3 flakeNormal = normalize(texture(flakesNormal, UV0*150.0).rgb*2.0-1.0);
    float flakeFresnel = max(0.0,dot(flakeNormal,fView));
    float flakeMask = smoothstep(0.9,1.0,dot(fNormal,flakeNormal))*flakes*max(0.0,(1.0-fresnelBase))*flakeFresnel;
    fNormal = mix(mix(fNormal, flakeNormal,flakeMask),fNormal,clearcoatMask);
    fNormal = normalize(fNormal);
    float fresnel = fresnelBase;
    FRESNEL_POWER = 5.0;
    fresnel = pow(fresnel,FRESNEL_POWER);

    NORMAL  = fNormal;

    float specVal = mix(mix(mix(mix(fresnel*specular,specular,specular),1.0,metalness),1.0,clearcoatMask),1.0,flakeMask);
    SPECULAR_AMOUNT = specVal*vColor.r;
    vec4 albedo = mix(baseColor, secondaryColor,fresnelBase);
    albedo = mix(albedo, vec4(1.0), flakeMask);
    BASE_COLOR = albedo*vec4(vColor.rrr,1.0);

    vec3 vNormalWsDdx = dFdx(fNormal.xyz);
    vec3 vNormalWsDdy = dFdy(fNormal.xyz);
    float flGeometricRoughnessFactor = pow(clamp(max(dot(vNormalWsDdx, vNormalWsDdx), dot(vNormalWsDdy, vNormalWsDdy)), 0.0, 1.0),0.333);
    METALNESS = mix(mix(metalness,1.0,flakeMask),0.0,clearcoatMask);
    ROUGHNESS = mix(mix(mix(mix(roughness,0.0,fresnel),0.0,clearcoatMask),0.0,flakeMask),1.0,flGeometricRoughnessFactor);
}
