// Copyright (C) 2017 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
import QtQuick

//! [rectangle]
Rectangle {
     width: 200; height: 200

    ListModel {
        id: fruitModel
        property string language: "en"
        ListElement {
            name: "Apple"
            cost: 2.45
        }
        ListElement {
            name: "Orange"
            cost: 3.25
        }
        ListElement {
            name: "Banana"
            cost: 1.95
        }
    }

    Component {
        id: fruitDelegate
        Row {
            id: fruit
            required property string name
            required property real cost
            Text {
                text: " Fruit: " + fruit.name
                color: fruit.ListView.view.fruit_color
            }
            Text {
                text: " Cost: $" + fruit.cost
            }
            Text {
                text: " Language: " + fruit.ListView.view.model.language
            }
        }
    }

    ListView {
        property color fruit_color: "green"
        model: fruitModel
        delegate: fruitDelegate
        anchors.fill: parent
    }
}
//! [rectangle]
