/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class MultipartWrapper {
    private boolean isOverallInit = false;
    private boolean isOverallFinalized = false;
    private boolean isMultipartSectionOpen = false;
    private boolean isRequestExecuted = false;
    protected OutputStream currentSectionOutputStream = null;
    private InputStream responseInputStream = null;

    protected MultipartWrapper() {
    }

    public void initOverallMultipart() throws IOException {
        if (this.isOverallInit) {
            return;
        }
        this.innerInitOverallMultipart();
        this.isOverallInit = true;
    }

    public OutputStream addMultipartBinarySection(String name, String filename) throws IOException {
        OutputStream out;
        if (this.isOverallFinalized) {
            throw new IOException("Unable to add multipart section after the multipart body has been finalized!");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null nor empty!");
        }
        if (!this.isOverallInit) {
            this.initOverallMultipart();
        }
        if (this.isMultipartSectionOpen) {
            this.finalizeMultipartSection();
        }
        this.currentSectionOutputStream = out = this.innerAddMultipartBinarySection(name, filename);
        this.isMultipartSectionOpen = true;
        return out;
    }

    public void finalizeMultipartSection() throws IOException {
        if (!this.isMultipartSectionOpen) {
            return;
        }
        this.currentSectionOutputStream.flush();
        this.innerFinalizeMultipartSection();
        this.currentSectionOutputStream = null;
        this.isMultipartSectionOpen = false;
    }

    public void finalizeOverallMultipart() throws IOException {
        if (this.isOverallFinalized) {
            return;
        }
        if (this.isMultipartSectionOpen) {
            this.finalizeMultipartSection();
        }
        if (!this.isOverallFinalized) {
            this.innerFinalizeOverallMultipart();
        }
        this.isOverallFinalized = true;
    }

    public void finalizeRequestExecution() throws IOException {
        if (this.isRequestExecuted) {
            return;
        }
        if (!this.isOverallFinalized) {
            this.finalizeOverallMultipart();
        }
        this.innerFinalizeRequestExecution();
        this.isRequestExecuted = true;
    }

    public InputStream getResponseInputStream() throws IOException {
        if (!this.isRequestExecuted) {
            this.finalizeRequestExecution();
        }
        if (this.responseInputStream == null) {
            this.responseInputStream = this.innerGetResponseInputStream();
        }
        return this.responseInputStream;
    }

    protected abstract void innerInitOverallMultipart() throws IOException;

    protected abstract OutputStream innerAddMultipartBinarySection(String var1, String var2) throws IOException;

    protected abstract void innerFinalizeMultipartSection() throws IOException;

    protected abstract void innerFinalizeOverallMultipart() throws IOException;

    public abstract int getResponseCode() throws IOException;

    protected abstract void innerFinalizeRequestExecution() throws IOException;

    public abstract InputStream innerGetResponseInputStream() throws IOException;
}

