/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class FileUtils {
    public static void copyfile(File file, File file2) throws FileNotFoundException, IOException {
        Files.copy(file.toPath(), file2.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void a(File[] fileArray, File file) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            File[] fileArray2 = fileArray[i];
            if (fileArray2.isDirectory() && !Files.isSymbolicLink(fileArray2.toPath())) {
                file2 = new File(file.getAbsolutePath() + File.separator + fileArray2.getName());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                fileArray2 = fileArray2.listFiles();
                FileUtils.a(fileArray2, file2);
                continue;
            }
            file2 = new File(file.getAbsolutePath() + File.separator + fileArray2.getName());
            FileUtils.copyfile((File)fileArray2, file2);
        }
    }

    public static void copyDirAll(File fileArray, File file) throws FileNotFoundException, IOException {
        if (fileArray.isDirectory() && file.isDirectory() && !Files.isSymbolicLink(fileArray.toPath()) && !Files.isSymbolicLink(file.toPath())) {
            fileArray = fileArray.listFiles();
            FileUtils.a(fileArray, file);
            return;
        }
        throw new IOException("Only Directory support");
    }

    public static boolean emptyDir(File file, boolean bl) {
        boolean bl2 = true;
        if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
            File[] fileArray = file.listFiles();
            File[] fileArray2 = fileArray;
            fileArray2 = fileArray;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray2[i];
                bl2 = FileUtils.emptyDir(file2, true);
                if (bl2) continue;
                return false;
            }
            if (bl) {
                file.delete();
            }
        } else if (!file.getAbsoluteFile().getName().endsWith("update.tmp") && !file.getAbsoluteFile().getName().endsWith("tmp.txt")) {
            bl2 = file.delete();
        }
        return bl2;
    }

    public static void emptyDirExcept(File fileArray, List<File> list, Logger logger) throws IOException {
        if (fileArray.isDirectory() && !Files.isSymbolicLink(fileArray.toPath())) {
            File[] fileArray2 = fileArray.listFiles();
            fileArray = fileArray2;
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                Object object = list;
                File file2 = file;
                boolean bl = false;
                object = object.iterator();
                while (!bl && object.hasNext()) {
                    if (!((File)object.next()).getAbsolutePath().equals(file2.getAbsolutePath())) continue;
                    bl = true;
                }
                if (bl) continue;
                if (file.isDirectory()) {
                    FileUtils.emptyDir(file, true);
                    continue;
                }
                file.delete();
            }
            return;
        }
        throw new IOException(fileArray.getAbsolutePath() + " is not directory");
    }

    public static boolean removeDirSkip(File file, boolean bl, List<String> list) {
        boolean bl2 = true;
        if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                bl2 = FileUtils.removeDirSkip(fileArray[i], true, list);
                if (bl2) continue;
                return false;
            }
            if (bl) {
                file.delete();
            }
        } else if (!file.getAbsoluteFile().getName().endsWith("update.tmp") && !file.getAbsoluteFile().getName().endsWith("tmp.txt")) {
            boolean bl3 = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(0).equals(file.getAbsoluteFile().getName())) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                bl2 = file.delete();
            }
        }
        return bl2;
    }

    public static boolean isWritablePath(File file) {
        boolean bl = true;
        file = new File(file.getAbsolutePath() + File.separator + "dummy.info");
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            file.delete();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean contentEquals(File object, File object2) throws IOException, CapiException {
        if (!((File)object).exists() || !((File)object2).exists()) {
            throw new IOException("Uno o entrambi dei seguenti file non esiste: " + ((File)object).getCanonicalPath() + " " + ((File)object2).getAbsolutePath());
        }
        object = Util.readFile(((File)object).getAbsolutePath());
        object2 = Util.readFile(((File)object2).getAbsolutePath());
        boolean bl = Arrays.equals((byte[])object, (byte[])object2);
        return bl;
    }

    public static boolean areIdenticalFile(File object, File object2) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        boolean bl;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            fileInputStream2 = new FileInputStream((File)object2);
            object = Utils.calculateDigest(fileInputStream, Constants.SHA256);
            object2 = Utils.calculateDigest(fileInputStream2, Constants.SHA256);
            bl = ((String)object).equals(object2);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fileInputStream);
            Util.closeQuietly(fileInputStream2);
            throw throwable;
        }
        Util.closeQuietly(fileInputStream);
        Util.closeQuietly(fileInputStream2);
        return bl;
    }

    public static String getMD5(File object) throws IOException {
        MD5Digest mD5Digest = new MD5Digest();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            mD5Digest.reset();
            object = new byte[4096];
            int n = fileInputStream.read((byte[])object);
            while (n != -1) {
                mD5Digest.update((byte[])object, 0, n);
                n = fileInputStream.read((byte[])object);
            }
            object = new byte[mD5Digest.getDigestSize()];
            mD5Digest.doFinal((byte[])object, 0);
            object = new String(Hex.encode((byte[])object));
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            throw throwable;
        }
        fileInputStream.close();
        return object;
    }

    public static void unZipIt(File object, String string, Logger logger) throws IOException {
        logger.info("Unzip " + ((File)object).getAbsolutePath());
        byte[] byArray = new byte[4096];
        try {
            Object object2 = new File(string);
            if (!((File)object2).exists()) {
                ((File)object2).mkdir();
            }
            object = new ZipInputStream(new FileInputStream((File)object));
            object2 = ((ZipInputStream)object).getNextEntry();
            while (object2 != null) {
                object2 = ((ZipEntry)object2).getName();
                File file = new File(string + File.separator + (String)object2);
                logger.info("file unzip : " + file.getAbsoluteFile());
                if (((String)object2).endsWith("/")) {
                    file.mkdirs();
                } else {
                    int n;
                    object2 = new File(file.getParent());
                    if (!((File)object2).exists()) {
                        ((File)object2).mkdirs();
                    }
                    object2 = new FileOutputStream(file);
                    while ((n = ((FilterInputStream)object).read(byArray)) > 0) {
                        ((FileOutputStream)object2).write(byArray, 0, n);
                    }
                    ((FileOutputStream)object2).close();
                }
                object2 = ((ZipInputStream)object).getNextEntry();
            }
            ((ZipInputStream)object).closeEntry();
            ((ZipInputStream)object).close();
            logger.info("Done");
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }
}

