/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticsInfoUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAResponseValidator;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.Hex;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.slf4j.Logger;

public class TSAUtil {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static String b = null;
    private static String c = null;
    private static long d = 0L;
    private static Gson e = new Gson();

    public static void clearStatus() {
        b = null;
        c = null;
        d = 0L;
    }

    public static String getCurrentUrl() {
        return b;
    }

    public static String getAlternativeUrl() {
        return c;
    }

    @Deprecated
    public static TimeStampResponse getMarkFromRequest(TimeStampRequest timeStampRequest, ConfigParameter configParameter) throws IOException, TSAException {
        return TSAUtil.getMarkFromRequest(timeStampRequest, configParameter.getRequestTsaUrl(), configParameter.getTSAData(), configParameter.getNetConf());
    }

    public static TimeStampResponse getMarkFromRequest(TimeStampRequest timeStampRequest, TSAData tSAData, NetworkConfig networkConfig) throws TSAException, IOException {
        return TSAUtil.getMarkFromRequest(timeStampRequest, tSAData.getTSAUrl(), tSAData, networkConfig);
    }

    public static TimeStampResponse getMarkFromRequest(TimeStampRequest timeStampRequest, String string, TSAData tSAData, NetworkConfig networkConfig) throws TSAException, IOException {
        return TSAUtil.getMarkFromRequest(timeStampRequest, string, tSAData, networkConfig, null);
    }

    public static TimeStampResponse getMarkFromRequest(TimeStampRequest timeStampRequest, String object, TSAData tSAData, NetworkConfig networkConfig, TSAResponseValidator tSAResponseValidator) throws TSAException, IOException {
        StatisticsInfoUtils.start(StatisticKeyEnum.MARK_TIME);
        try {
            TimeStampResponse timeStampResponse;
            UrlReturn urlReturn;
            Object object2;
            networkConfig = new UrlClient(networkConfig, a);
            RequestData requestData = new RequestData();
            requestData.setType("TSA");
            requestData.setPostdata(timeStampRequest.getEncoded());
            Date date = new Date();
            if (a.isDebugEnabled()) {
                a.debug("Richiesta TSA id: " + date.getTime());
            }
            long l = new Date().getTime();
            boolean bl = true;
            if (Util.isNullOrEmpty((String)object)) {
                if (b == null) {
                    b = tSAData.getTSAUrl();
                    if (!Util.isNullOrEmpty(tSAData.getTSAAlternativeUrl())) {
                        c = tSAData.getTSAAlternativeUrl();
                    }
                } else if (!b.equals(tSAData.getTSAUrl())) {
                    bl = false;
                    if (!Util.isNullOrEmpty(tSAData.getTSAAlternativeUrl()) && l - d > 900000L) {
                        if (a.isDebugEnabled()) {
                            a.debug("Riprovo sul primario");
                        }
                        b = tSAData.getTSAUrl();
                        d = 0L;
                        c = tSAData.getTSAAlternativeUrl();
                    }
                }
                object2 = TSAUtil.a(b, tSAData);
                urlReturn = networkConfig.downloadUrl(b, requestData, object2);
            } else {
                object2 = new URLCredentials(tSAData.getTSAUser(), tSAData.getTSAPassword(), null, null);
                urlReturn = networkConfig.downloadUrl((String)object, requestData, object2);
            }
            object2 = tSAResponseValidator != null ? tSAResponseValidator.validateTSAResponse(urlReturn) : TSAUtil.a(urlReturn);
            if (object2 != null && (object2 == TSAMessageEnum.INTERNAL_ERROR || object2 == TSAMessageEnum.SERVICE_UNAVAILABLE || object2 == TSAMessageEnum.RESOURCE_NOT_FOUND) && !Util.isNullOrEmpty(c) && Util.isNullOrEmpty((String)object)) {
                if (a.isDebugEnabled()) {
                    a.debug("URL TSA Primario non ha risposto tento sul secondario.");
                }
                if ((urlReturn = networkConfig.downloadUrl(c, requestData, (URLCredentials)(object = TSAUtil.a(c, tSAData)))) != null && urlReturn.getStatus().equals("OK")) {
                    d = l;
                    String string = b;
                    b = c;
                    c = string;
                }
                object2 = tSAResponseValidator != null ? tSAResponseValidator.validateTSAResponse(urlReturn) : TSAUtil.a(urlReturn);
            } else if (bl) {
                d = 0L;
            }
            if (object2 != null) {
                throw new TSAException((TSAMessageEnum)object2);
            }
            try {
                timeStampResponse = new TimeStampResponse(urlReturn.getData());
                if (timeStampResponse.getFailInfo() != null) {
                    throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
                }
            }
            catch (TSPException tSPException) {
                throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, (Exception)((Object)tSPException));
            }
            object = new Date();
            if (a.isDebugEnabled()) {
                a.debug("Richiesta TSA id :" + date.getTime() + " Terminiata in " + (((Date)object).getTime() - date.getTime()) + " millisecondi");
            }
            return timeStampResponse;
        }
        finally {
            StatisticsInfoUtils.end(StatisticKeyEnum.MARK_TIME);
        }
    }

    public static TimeStampRequest generateMarkRequest(String string, BigInteger bigInteger, byte[] byArray, String string2, boolean bl) throws TSAException {
        string = new TimeStampRequestGenerator();
        if (string2 != null && !string2.trim().equals("")) {
            try {
                string.setReqPolicy(string2);
            }
            catch (Exception exception) {
                throw new TSAException(TSAMessageEnum.BAD_TSQ);
            }
        }
        string.setCertReq(bl);
        return string.generate(TSPAlgorithms.SHA256, byArray);
    }

    @Deprecated
    public static TimeStampRequest generateMarkRequest(String string, BigInteger bigInteger, InputStream inputStream, String string2, boolean bl) throws IOException, TSAException {
        return TSAUtil.generateMarkRequest(inputStream, string2, bl);
    }

    public static TimeStampRequest generateMarkRequest(InputStream inputStream, String string, boolean bl) throws IOException, TSAException {
        SHA256Digest sHA256Digest = new SHA256Digest();
        sHA256Digest.reset();
        byte[] byArray = new byte[sHA256Digest.getDigestSize()];
        byte[] byArray2 = new byte[4096];
        int n = inputStream.read(byArray2);
        while (n != -1) {
            sHA256Digest.update(byArray2, 0, n);
            n = inputStream.read(byArray2);
        }
        sHA256Digest.doFinal(byArray, 0);
        if (a.isDebugEnabled()) {
            a.debug("Hash da marcare: " + Hex.getHex(byArray));
        }
        inputStream = TSAUtil.generateMarkRequest("SHA-256", null, byArray, string, bl);
        return inputStream;
    }

    @Deprecated
    public static void getMark(String string, String object, ConfigParameter configParameter) throws IOException, TSPException, TSAException {
        FileInputStream fileInputStream = new FileInputStream(string);
        if (a.isDebugEnabled()) {
            a.debug("File in :" + string);
            a.debug("File out :" + (String)object);
        }
        string = TSAUtil.getMark("SHA-256", null, (InputStream)fileInputStream, configParameter.getTSAPolicy(), configParameter, true);
        fileInputStream.close();
        object = new FileOutputStream((String)object);
        ((FileOutputStream)object).write(string.getEncoded());
        ((FileOutputStream)object).close();
    }

    @Deprecated
    public static void getMark(InputStream inputStream, OutputStream outputStream, String string, String string2, String string3, String string4) throws IOException, TSPException, TSAException {
        ConfigParameter configParameter = new ConfigParameter(1);
        configParameter.setTSAUrl(string);
        configParameter.setTSAUser(string2);
        configParameter.setTSAPassword(string3);
        configParameter.setTSAPolicy(string4);
        inputStream = TSAUtil.getMark("SHA-256", null, inputStream, string4, configParameter, true);
        outputStream.write(inputStream.getEncoded());
    }

    @Deprecated
    public static TimeStampResponse getMark(String string, BigInteger bigInteger, InputStream inputStream, String string2, ConfigParameter configParameter, boolean bl) throws IOException, TSPException, TSAException {
        SHA256Digest sHA256Digest = new SHA256Digest();
        sHA256Digest.reset();
        byte[] byArray = new byte[sHA256Digest.getDigestSize()];
        byte[] byArray2 = new byte[4096];
        int n = inputStream.read(byArray2);
        while (n != -1) {
            sHA256Digest.update(byArray2, 0, n);
            n = inputStream.read(byArray2);
        }
        sHA256Digest.doFinal(byArray, 0);
        if (a.isDebugEnabled()) {
            a.debug("Hash da marcare :" + Hex.getHex(byArray));
        }
        string = TSAUtil.generateMarkRequest(string, bigInteger, byArray, string2, bl);
        string = TSAUtil.getMarkFromRequest((TimeStampRequest)string, configParameter);
        return string;
    }

    @Deprecated
    public static TimeStampResponse getMark(String string, BigInteger bigInteger, InputStream inputStream, boolean bl, TSAData tSAData, NetworkConfig networkConfig) throws IOException, TSPException, TSAException {
        string = TSAUtil.generateMarkRequest(string, bigInteger, inputStream, tSAData.getTSAPolicy(), bl);
        return TSAUtil.getMarkFromRequest((TimeStampRequest)string, tSAData, networkConfig);
    }

    public static TimeStampResponse getMark(InputStream inputStream, boolean bl, TSAData tSAData, NetworkConfig networkConfig) throws IOException, TSPException, TSAException {
        return TSAUtil.getMark(inputStream, bl, tSAData, networkConfig, null);
    }

    public static TimeStampResponse getMark(InputStream inputStream, boolean bl, TSAData tSAData, NetworkConfig networkConfig, TSAResponseValidator tSAResponseValidator) throws IOException, TSPException, TSAException {
        inputStream = TSAUtil.generateMarkRequest(inputStream, tSAData.getTSAPolicy(), bl);
        return TSAUtil.getMarkFromRequest((TimeStampRequest)inputStream, tSAData.getTSAUrl(), tSAData, networkConfig, tSAResponseValidator);
    }

    private static TSAMessageEnum a(UrlReturn urlReturn) {
        TSAMessageEnum tSAMessageEnum = null;
        if (urlReturn == null || urlReturn.getStatus() == null || !urlReturn.getStatus().equals("OK") || urlReturn.getData() == null) {
            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
            if (urlReturn != null && urlReturn.getStatus() != null && !urlReturn.getStatus().equals("OK")) {
                if (urlReturn.getStatus_code() == -1 && urlReturn.getStatus().equals("KO")) {
                    return TSAMessageEnum.NETWORK_ERROR;
                }
                int n = TSAUtil.b(urlReturn);
                if (n != 0) {
                    for (TSAMessageEnum tSAMessageEnum2 : TSAMessageEnum.values()) {
                        if (tSAMessageEnum2.getStatusCode() != urlReturn.getStatus_code() || !tSAMessageEnum2.getErrCode().equals("" + n)) continue;
                        return tSAMessageEnum2;
                    }
                }
            }
        }
        return tSAMessageEnum;
    }

    private static int b(UrlReturn urlReturn) {
        int n = 0;
        try {
            urlReturn = (JsonElement)e.fromJson(new String(urlReturn.getErrordata()), JsonElement.class);
            if (urlReturn.isJsonObject()) {
                n = urlReturn.getAsJsonObject().get("code").getAsInt();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public static TSAData getTSAData(ConfigParameter configParameter) {
        if (configParameter == null) {
            return null;
        }
        TSAData tSAData = new TSAData();
        tSAData.setTSAUrl(configParameter.getTSAUrl());
        tSAData.setTSAUser(configParameter.getTSAUser());
        tSAData.setTSAPassword(configParameter.getTSAPassword());
        tSAData.setTSAAlternativeUrl(configParameter.getTSAAlternativeUrl());
        tSAData.setTSAAlternativeUser(configParameter.getTSAAlternativeUser());
        tSAData.setTSAAlternativePassword(configParameter.getTSAAlternativePassword());
        tSAData.setTSAPolicy(configParameter.getTSAPolicy());
        return tSAData;
    }

    private static URLCredentials a(String string, TSAData tSAData) {
        String string2 = tSAData.getTSAUser();
        String string3 = tSAData.getTSAPassword();
        if (string != null && tSAData.getTSAAlternativeUrl() != null && string.equalsIgnoreCase(tSAData.getTSAAlternativeUrl())) {
            string2 = tSAData.getTSAAlternativeUser();
            string3 = tSAData.getTSAAlternativePassword();
        }
        return new URLCredentials(string2, string3, null, null);
    }
}

