/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class TokenHelper {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static TokenSpi initToken(String string, String[] stringArray) throws CapiException {
        Object object = null;
        Object object2 = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        object2 = ((ServiceLoader)object2).iterator();
        try {
            while (object2.hasNext()) {
                object = (TokenManager)object2.next();
                if ((object = object.initToken(string)) == null) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            throw new CapiException(throwable.getMessage(), 10010);
        }
        if (stringArray == null) {
            a.error("null arguments!");
        } else {
            if (stringArray[0] == null) {
                a.error("first argument null!");
            } else {
                a.info("first argument = " + stringArray[0]);
            }
            if (stringArray[1] == null) {
                a.error("second argument null!");
            } else {
                a.info("second argument = " + stringArray[1]);
            }
        }
        if (object == null) {
            throw new CapiException(string + " not initialized!", 10010);
        }
        ((TokenSpi)object).initializeLib(stringArray);
        return object;
    }

    public static TokenSpi initToken(String string, TokenParameters tokenParameters) throws CapiException {
        Object object = null;
        Object object2 = ServiceLoader.load(TokenManager.class, TokenManager.class.getClassLoader());
        object2 = ((ServiceLoader)object2).iterator();
        try {
            while (object2.hasNext()) {
                object = (TokenManager)object2.next();
                if ((object = object.initToken(string)) == null) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            throw new CapiException(throwable.getMessage(), 10010);
        }
        if (tokenParameters == null) {
            a.error("null arguments!");
        }
        if (object == null) {
            throw new CapiException(string + " not initialized!", 10010);
        }
        ((TokenSpi)object).initializeLib(tokenParameters);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(TokenSpi tokenSpi) {
        TokenSpi tokenSpi2 = tokenSpi;
        synchronized (tokenSpi2) {
            a.debug("destroy");
            if (tokenSpi != null) {
                long l = System.currentTimeMillis();
                a.debug("finalize starting at TlastDestroyTM: " + l + " ms");
                tokenSpi.finalizeLib();
                l = System.currentTimeMillis();
                a.debug("finalize ok at TlastDestroyTM: " + l + " ms");
            }
            return;
        }
    }

    public static void openPublicSession(TokenSpi tokenSpi) throws CapiException {
        a.debug("openPublicSession");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tokenSpi.openPublicSession();
        a.debug("openPublicSession OK");
    }

    public static void logout(TokenSpi tokenSpi) throws CapiException {
        a.debug("logout");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tokenSpi.closeSession();
    }

    public static String[] listObjects(TokenSpi tokenSpi, String string, byte by) throws CapiException {
        a.debug("listObjects");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (!TokenHelper.isLogged(tokenSpi)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tokenSpi.listObjects(string, by);
    }

    public static String getObjectID(TokenSpi tokenSpi, String string) throws CapiException {
        a.debug("getObjectType (alias= " + string + ")");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!TokenHelper.isLogged(tokenSpi)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tokenSpi.getObjectID(string);
    }

    public static String getCertificate(TokenSpi tokenSpi, String string) throws CapiException {
        a.debug("getCertificate (alias= " + string + ")");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!TokenHelper.isLogged(tokenSpi)) {
            throw new CapiException("Session not opened", 10013);
        }
        return tokenSpi.getCert(string);
    }

    public static boolean isLogged(TokenSpi tokenSpi) throws CapiException {
        a.debug("isLogged");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tokenSpi.isSessionOpen();
    }

    public static void login(TokenSpi tokenSpi) throws CapiException {
        a.debug("login");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tokenSpi.openSessionAuthPath(false);
        a.debug("login OK");
    }

    public static void login(TokenSpi tokenSpi, String string) throws CapiException {
        a.debug("login");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        tokenSpi.openSession(false, string);
        a.debug("login OK");
    }

    public static byte[] doSign(TokenSpi tokenSpi, byte[] byArray, String string, int n) throws CapiException {
        a.debug("login");
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (byArray == null || byArray.length == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        return tokenSpi.doSign(byArray, string, n);
    }

    public static byte[] doVerifiedSignature(Actalis_PrivateKey actalis_PrivateKey, byte[] byArray, int n) throws CapiException {
        a.debug("login");
        if (actalis_PrivateKey == null && actalis_PrivateKey instanceof Actalis_PrivateKey) {
            throw new CapiException("invalid not initialized", 10003);
        }
        if (byArray == null || byArray.length == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = actalis_PrivateKey.getCryptoDev();
        if (tokenSpi instanceof VerifiedSignatureToken) {
            if (n == 0) {
                return ((VerifiedSignatureToken)((Object)tokenSpi)).verifiedSignature(byArray, actalis_PrivateKey.getAlias());
            }
            if (n == 1) {
                return ((VerifiedSignatureToken)((Object)tokenSpi)).xmlVerifiedSignature(byArray, actalis_PrivateKey.getAlias());
            }
            throw new CapiException("Token non support verified signature interface", 1004);
        }
        throw new CapiException("Token non support verified signature interface", 1004);
    }

    public static PrivateKey getPrivateKeyByAlias(TokenSpi tokenSpi, String string) throws CapiException {
        return tokenSpi.getPrivateKey(string);
    }
}

