/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.CertificateValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=35)
@StepContext(formats={ValidationSignatureFormats.CADES, ValidationSignatureFormats.PADES, ValidationSignatureFormats.XADES}, profiles={ValidationProfile.CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE})
public class StepX509CnsOid
extends CertificateValidationStep {
    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        try {
            if (validationContextParameters.getSignerCertificate().getCert().isCNSAuthentication()) {
                this.logger.debug("authentication done by CNS");
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0020_CERT_IS_CNS_COMPLIANT, ValidationProfile.CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
            if (validationContextParameters.getSignerCertificate().getCert().isCIEAuthentication()) {
                this.logger.debug("authentication done by CIE");
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0020_CERT_IS_CNS_COMPLIANT, ValidationProfile.CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0024_CERT_IS_NOT_CNS_COMPLIANT, ValidationProfile.CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
    }
}

