/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.generator;

import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.generator.ASiCSignData;
import it.actalis.ellips.capi.asic.utils.ASiCCommonUtils;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public class ASiCUpdater {
    protected static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void update(SignatureOptions object) throws CapiException {
        try {
            ASiCSignData aSiCSignData = ASiCUpdater.a((SignatureOptions)object);
            ByteArrayOutputStream byteArrayOutputStream = ASiCUpdater.a(aSiCSignData, (SignatureOptions)object);
            Object object2 = byteArrayOutputStream;
            object2 = object;
            object = byteArrayOutputStream;
            ZipInputStream zipInputStream = new ZipInputStream(object2.getInput().getInputAsNewStream());
            Throwable throwable = null;
            try {
                object2 = new ZipOutputStream(object2.getOutput().getAsOutputStream());
                Throwable throwable2 = null;
                try {
                    Object object3;
                    while ((object3 = zipInputStream.getNextEntry()) != null) {
                        ZipEntry zipEntry;
                        if (((ZipEntry)object3).getName().equals(aSiCSignData.getSignatureEntryName())) {
                            zipEntry = new ZipEntry((ZipEntry)object3);
                            zipEntry.setSize(((ByteArrayOutputStream)object).size());
                            object3 = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                        } else {
                            zipEntry = object3;
                            object3 = zipInputStream;
                        }
                        ((ZipOutputStream)object2).putNextEntry(zipEntry);
                        Util.copyStream((InputStream)object3, (OutputStream)object2);
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable4 = throwable3;
                        throwable2 = throwable3;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 != null) {
                            try {
                                ((ZipOutputStream)object2).close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ((ZipOutputStream)object2).close();
                        }
                        throw throwable5;
                    }
                }
                ((ZipOutputStream)object2).close();
            }
            catch (Throwable throwable7) {
                try {
                    object2 = throwable7;
                    throwable = throwable7;
                    throw object2;
                }
                catch (Throwable throwable8) {
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        zipInputStream.close();
                    }
                    throw throwable8;
                }
            }
            zipInputStream.close();
        }
        catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException(exception.getClass().getName() + " occurred.", 1003, (Throwable)exception);
        }
    }

    private static ASiCSignData a(SignatureOptions object) throws CapiException, IOException {
        ASiCFormat aSiCFormat = ASiCCommonUtils.getFormatFromMime(object.getInput());
        ASiCSignData aSiCSignData = new ASiCSignData();
        object = new ZipInputStream(object.getInput().getInputAsNewStream());
        Throwable throwable = null;
        try {
            ZipEntry zipEntry = ((ZipInputStream)object).getNextEntry();
            if (zipEntry == null) {
                throw new CapiException("Container is empty.", 50023);
            }
            while (zipEntry != null && (aSiCSignData.getSignature() == null || aSiCSignData.getSignedDataEntryName() == null)) {
                if (!zipEntry.isDirectory()) {
                    boolean bl = zipEntry.getName().startsWith("META-INF/");
                    boolean bl2 = ASiCCommonUtils.isValidManifestFilename(zipEntry.getName());
                    boolean bl3 = ASiCCommonUtils.isValidSignatureFilename(zipEntry.getName(), aSiCFormat);
                    if (bl) {
                        if (bl3) {
                            aSiCSignData.setSignatureEntryName(zipEntry.getName());
                            aSiCSignData.setSignature(ASiCUpdater.a((ZipInputStream)object));
                        } else if (bl2) {
                            aSiCSignData.setSignedDataEntryName(zipEntry.getName());
                        }
                    } else if (!"mimetype".equals(zipEntry.getName()) && ASiCFormat.SIMPLE.equals((Object)aSiCFormat)) {
                        aSiCSignData.setSignedDataEntryName(zipEntry.getName());
                    }
                }
                zipEntry = ((ZipInputStream)object).getNextEntry();
            }
            if (aSiCSignData.getSignature() == null) {
                throw new CapiException("Signature not found", 50040);
            }
            if (aSiCSignData.getSignedDataEntryName() == null) {
                throw new CapiException("Signed data not found", 50040);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((ZipInputStream)object).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((ZipInputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((ZipInputStream)object).close();
        return aSiCSignData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteArrayOutputStream a(ASiCSignData object, SignatureOptions object2) throws CapiException, IOException, FileNotFoundException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        CadesSignatureGenerator cadesSignatureGenerator;
        CadesSignatureOptions cadesSignatureOptions;
        String string;
        Object object3 = new ZipInputStream(object2.getInput().getInputAsNewStream());
        String string2 = ((ASiCSignData)object).getSignatureEntryName();
        if (string2.equals("META-INF/signature.p7s") || string2.matches("META-INF/.*signature.*[.]p7s")) {
            string = "CADES";
        } else {
            if (!string2.equals("META-INF/signature.p7s")) {
                if (!string2.matches("META-INF/.*signatures.*[.]xml")) throw new CapiException("Asic signature type not supported", 50023);
            }
            string = "XADES";
        }
        if ("CADES".equals(string)) {
            cadesSignatureOptions = new CadesSignatureOptions();
            cadesSignatureGenerator = new CadesSignatureGenerator();
        } else {
            cadesSignatureOptions = new XadesSignatureOptions();
            cadesSignatureGenerator = new XadesSignatureGenerator();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputHandler inputHandler = DataHandlerBuilder.get().setBytes(((ASiCSignData)object).getSignature()).buildInput();
        Throwable throwable = null;
        try {
            block27: {
                object = ASiCUpdater.a((ZipInputStream)object3, ((ASiCSignData)object).getSignedDataEntryName());
                object3 = null;
                try {
                    block26: {
                        OutputHandler outputHandler = DataHandlerBuilder.get().setOutputStream((OutputStream)byteArrayOutputStream).buildOutput();
                        Throwable throwable2 = null;
                        try {
                            cadesSignatureOptions.setDetachedContent((InputHandler)object);
                            cadesSignatureOptions.setInput(inputHandler);
                            cadesSignatureOptions.setOutput(outputHandler);
                            Object object4 = object2;
                            string2 = cadesSignatureOptions;
                            string2.setCertdb(object4.getCertdb());
                            string2.setNetworkConfig(object4.getNetworkConfig());
                            string2.setSignatureLevel(object4.getSignatureLevel());
                            string2.setSignatureMode(object4.getSignatureMode());
                            string2.setSignaturePath(object4.getSignaturePath());
                            string2.setSignatureProfile(object4.getSignatureProfile());
                            string2.setSignatureType(object4.getSignatureType());
                            string2.setTimeStampOptions(object4.getTimeStampOptions());
                            cadesSignatureGenerator.updateSign((SignatureOptions)cadesSignatureOptions);
                            if (outputHandler == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            try {
                                Throwable throwable4 = throwable3;
                                throwable2 = throwable3;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (outputHandler == null) throw throwable5;
                                if (throwable2 == null) {
                                    outputHandler.close();
                                    throw throwable5;
                                }
                                try {
                                    outputHandler.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        outputHandler.close();
                    }
                    if (object == null) break block27;
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        object3 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        if (object == null) throw throwable9;
                        if (object3 == null) {
                            object.close();
                            throw throwable9;
                        }
                        try {
                            object.close();
                            throw throwable9;
                        }
                        catch (Throwable throwable10) {
                            ((Throwable)object3).addSuppressed(throwable10);
                            throw throwable9;
                        }
                    }
                }
                object.close();
            }
            if (inputHandler == null) return byteArrayOutputStream;
        }
        catch (Throwable throwable11) {
            try {
                object = throwable11;
                throwable = throwable11;
                throw object;
            }
            catch (Throwable throwable12) {
                if (inputHandler == null) throw throwable12;
                if (throwable == null) {
                    inputHandler.close();
                    throw throwable12;
                }
                try {
                    inputHandler.close();
                    throw throwable12;
                }
                catch (Throwable throwable13) {
                    throwable.addSuppressed(throwable13);
                    throw throwable12;
                }
            }
        }
        inputHandler.close();
        return byteArrayOutputStream;
    }

    private static InputHandler a(ZipInputStream zipInputStream, String string) throws IOException, CapiException, FileNotFoundException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return DataHandlerBuilder.get().setInputStream((InputStream)zipInputStream).buildInput();
        }
        return null;
    }

    private static byte[] a(ZipInputStream object) throws CapiException, IOException {
        Object object2 = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int n;
            while ((n = ((ZipInputStream)object).read()) >= 0) {
                ((ByteArrayOutputStream)object2).write((byte)n);
            }
            object = ((ByteArrayOutputStream)object2).toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((ByteArrayOutputStream)object2).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((ByteArrayOutputStream)object2).close();
                    }
                    throw throwable4;
                }
            }
            catch (IOException iOException) {
                object2 = iOException;
                throw iOException;
            }
        }
        ((ByteArrayOutputStream)object2).close();
        return object;
    }
}

