/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.slf4j.Logger;

public class CadesSignedAttributeGenerator
implements CMSAttributeTableGenerator {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CadesSignatureOptions b;
    private X509Certificate c;

    public CadesSignedAttributeGenerator(CadesSignatureOptions cadesSignatureOptions, X509Certificate x509Certificate) {
        this.b = cadesSignatureOptions;
        this.c = x509Certificate;
    }

    public AttributeTable getAttributes(Map object) throws CMSAttributeTableGenerationException {
        try {
            Attribute attribute;
            object = (byte[])object.get("digest");
            if (this.b.getDetachedContent() != null && this.b.getSignatureMode().equals((Object)SignatureMode.DETACHED)) {
                object = Utils.toByteArray((InputStream)this.b.getDetachedContent().getInputAsNewStream());
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)this.c))), new ASN1Integer(this.c.getSerialNumber()));
            if (this.b.getDigestAlgorithm().getId().compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                a.debug("using SHA1 digest ...");
                attribute = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                issuerSerial = new ESSCertID(attribute.digest(this.c.getEncoded()), issuerSerial);
                attribute = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate((ESSCertID)issuerSerial)));
                aSN1EncodableVector.add((ASN1Encodable)attribute);
            } else {
                a.debug("using V2 digest ...");
                attribute = MessageDigest.getInstance(this.b.getDigestAlgorithm().getId(), ProvUtils.bcProvider);
                issuerSerial = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.b.getDigestAlgorithm().getId())), attribute.digest(this.c.getEncoded()), issuerSerial);
                ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[1];
                attribute = eSSCertIDv2Array;
                eSSCertIDv2Array[0] = issuerSerial;
                issuerSerial = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2((ESSCertIDv2[])attribute)));
                aSN1EncodableVector.add((ASN1Encodable)issuerSerial);
            }
            if (!(!Util.isNullOrEmpty((String)this.b.getSignaturePath()) || this.b instanceof CadesSignatureOptions && this.b.isCounterSignature())) {
                attribute = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
                aSN1EncodableVector.add((ASN1Encodable)attribute);
            }
            if (this.b.isIncludeSigningTime()) {
                a.debug("time is always true, including SigningTime!!");
                if (this.b.getSigningTime() != null) {
                    attribute = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(this.b.getSigningTime())));
                    aSN1EncodableVector.add((ASN1Encodable)attribute);
                } else {
                    attribute = new Date();
                    issuerSerial = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time((Date)attribute)));
                    aSN1EncodableVector.add((ASN1Encodable)issuerSerial);
                }
            }
            attribute = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])object)));
            aSN1EncodableVector.add((ASN1Encodable)attribute);
            object = new AttributeTable(aSN1EncodableVector);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)certificateEncodingException);
        }
        catch (IOException iOException) {
            a.error("Unable to generate signed attribute");
            throw new CMSAttributeTableGenerationException("Unable to generate signed attribute", (Exception)iOException);
        }
        return object;
    }
}

