/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core;

import esecurity.dsd.core.ReadablePropertyContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface DomainProvider {
    public Set<String> availableDomains() throws Exception;

    public ReadablePropertyContainer getDomainProperties(String var1) throws Exception;

    default public Map<String, Object> lookup(String domainName, String ... keys) throws Exception {
        HashMap<String, Object> value = new HashMap<String, Object>(keys.length);
        ReadablePropertyContainer domainProperties = this.getDomainProperties(domainName);
        if (domainProperties != null) {
            for (String k : keys) {
                Object v;
                if (!domainProperties.keySet().contains(k) || (v = domainProperties.getValue(k)) == null) continue;
                value.put(k, v);
            }
        }
        return value;
    }

    default public Optional<Object> lookupValue(String domainName, String key) throws Exception {
        Map<String, Object> values = this.lookup(domainName, key);
        if (values != null && values.containsKey(key)) {
            return Optional.ofNullable(values.get(key));
        }
        return Optional.empty();
    }
}

