/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider.apache;

import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class ApacheHttpClientMultipartWrapper
extends MultipartWrapper {
    private HttpPost post = null;
    private HttpClient client = null;
    private URL url = null;
    private List<SectionInfo> sectionOutputStreams = null;
    private HttpEntity multipartEntity = null;
    private HttpResponse lastResponse = null;

    public ApacheHttpClientMultipartWrapper(HttpClient client, URL url) throws URISyntaxException {
        this.client = client;
        this.url = url;
    }

    protected void innerInitOverallMultipart() throws IOException {
        try {
            this.post = new HttpPost(this.url.toURI().toString());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        this.sectionOutputStreams = new ArrayList<SectionInfo>();
    }

    protected OutputStream innerAddMultipartBinarySection(String name, String filename) throws IOException {
        CacheOutputStream out = new CacheOutputStream();
        SectionInfo secInfo = new SectionInfo();
        secInfo.name = name;
        secInfo.fileName = filename;
        secInfo.sectionStream = out;
        this.sectionOutputStreams.add(secInfo);
        return out;
    }

    protected void innerFinalizeMultipartSection() throws IOException {
        this.currentSectionOutputStream.flush();
    }

    public void innerFinalizeOverallMultipart() throws IOException {
        MultipartEntityBuilder entBuilder = MultipartEntityBuilder.create();
        for (SectionInfo section : this.sectionOutputStreams) {
            entBuilder.addBinaryBody(section.name, section.sectionStream.getCache(), ContentType.APPLICATION_OCTET_STREAM, section.fileName);
        }
        this.multipartEntity = entBuilder.build();
    }

    protected void innerFinalizeRequestExecution() throws IOException {
        this.post.setEntity(this.multipartEntity);
        this.lastResponse = this.client.execute((HttpUriRequest)this.post);
        for (SectionInfo section : this.sectionOutputStreams) {
            section.sectionStream.close();
        }
        this.sectionOutputStreams = null;
    }

    public int getResponseCode() throws IOException {
        return this.lastResponse != null ? this.lastResponse.getStatusLine().getStatusCode() : -1;
    }

    public InputStream innerGetResponseInputStream() throws IOException {
        return this.lastResponse != null ? this.lastResponse.getEntity().getContent() : null;
    }

    private class SectionInfo {
        private String name = null;
        private String fileName = null;
        private CacheOutputStream sectionStream = null;

        private SectionInfo() {
        }
    }
}

