/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDtsTimeStampOptions;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.slf4j.Logger;

public class PadesDtsGenerator
extends BaseGenerator<PadesDtsTimeStampOptions> {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private SignatureOptions b;

    public void validateOptions(PadesDtsTimeStampOptions padesDtsTimeStampOptions) throws CapiException {
        if (padesDtsTimeStampOptions == null) {
            throw new CapiException("Invalid Signature Options", 1001);
        }
        if (padesDtsTimeStampOptions.getInput() == null) {
            throw new CapiException("Invalid Input NULL", 1001);
        }
        if (padesDtsTimeStampOptions.getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (padesDtsTimeStampOptions.getTSAClient() == null) {
            throw new CapiException("Invalid TSA Client", 1001);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGenerate() throws CapiException {
        ScratchFile scratchFile = null;
        Object object = null;
        try {
            scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            Object object2 = ((PadesDtsTimeStampOptions)((Object)this.options)).getInput().getInputAsNewStream();
            ((PadesDtsTimeStampOptions)((Object)this.options)).getInput().getTotalSize();
            OutputStream outputStream = ((PadesDtsTimeStampOptions)((Object)this.options)).getOutput().getAsOutputStream();
            Object object3 = object2 = scratchFile.createBuffer((InputStream)object2);
            boolean bl = false;
            Object object4 = new byte[5];
            if (object3.read((byte[])object4, 0, 5) != -1) {
                String string = new String((byte[])object4);
                object4 = string;
                bl = string.startsWith("%FDF-") || ((String)object4).startsWith("%PDF-");
            }
            object3.seek(0L);
            if (!bl) {
                throw new IOException("Il file che stato sottoposto alla firma non \u00e8 di tipo PDF");
            }
            Object object52222222 = object2;
            object2 = scratchFile;
            object3 = (PadesDtsTimeStampOptions)((Object)this.options);
            object4 = null;
            if (((PadesDtsTimeStampOptions)((Object)object3)).getOwnerPassword() == null) {
                a.debug("[initialize] decrypting password is null...");
            } else {
                a.debug("[initialize] decrypting password is not null...");
                object4 = ((PadesDtsTimeStampOptions)((Object)object3)).getOwnerPassword();
            }
            object4 = object4 != null ? new PDFParser((RandomAccessRead)object52222222, (String)object4, null, null, (ScratchFile)object2) : new PDFParser((RandomAccessRead)object52222222, (ScratchFile)object2);
            object4 = object4.parse();
            if (object4.getCurrentAccessPermission() != null && !object4.getCurrentAccessPermission().canModify() && !object4.getCurrentAccessPermission().canModifyAnnotations()) {
                throw new CapiException("Cannot decrypt PDF, the password is incorrect", 50004);
            }
            object = object4;
            object2 = new LinkedList();
            if (object.getDocumentCatalog().getAcroForm() != null) {
                if (PadesUtils.isBlockedPdf((PDDocument)object)) {
                    if (a.isDebugEnabled()) {
                        a.debug("Document certified and no changes allowed");
                    }
                    throw new CapiException("Document is certified and no changes are allowed.", 50026);
                }
                for (Object object52222222 : object.getDocumentCatalog().getAcroForm().getFields()) {
                    object2.addAll(PadesUtils.parseEmptyField((PDField)object52222222));
                }
            }
            object52222222 = (PadesDtsTimeStampOptions)((Object)this.options);
            object2 = object;
            object3 = this;
            object4 = PadesUtils.retrieveNotEmptySignatures((PDDocument)object2);
            if (object4 != null && ((LinkedList)object4).size() == 0 && object2.getDocumentCatalog().getAcroForm() != null && object2.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
                object2.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
            }
            object4 = new PDSignature();
            object4.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            object4.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
            ((PadesDtsGenerator)((Object)object3)).b = new SignatureOptions();
            object2.addSignature((PDSignature)object4, (SignatureInterface)new a((PadesDtsGenerator)((Object)object3), (PadesDtsTimeStampOptions)((Object)object52222222)), ((PadesDtsGenerator)((Object)object3)).b);
            object.saveIncremental(outputStream);
            outputStream.flush();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            try {
                throw new CapiException(invalidPasswordException.getMessage(), 50004, (Throwable)invalidPasswordException);
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    if (iOException.getCause() != null && iOException2.getCause() instanceof TSAException) {
                        throw (TSAException)iOException2.getCause();
                    }
                    if (iOException2.getCause() != null && iOException2.getCause() instanceof CapiException) {
                        throw (CapiException)iOException2.getCause();
                    }
                    throw new CapiException("Pades generation IOException: " + iOException2.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(scratchFile);
                Util.closeQuietly(object);
                Util.closeQuietly(null);
                Util.closeQuietly(null);
                IOUtils.closeQuietly((Closeable)this.b);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)scratchFile);
        Util.closeQuietly((Closeable)object);
        Util.closeQuietly(null);
        Util.closeQuietly(null);
        IOUtils.closeQuietly((Closeable)this.b);
    }

    private final class a
    implements SignatureInterface {
        private TimeStampOptions a;

        public a(PadesDtsGenerator padesDtsGenerator, PadesDtsTimeStampOptions padesDtsTimeStampOptions) {
            this.a = padesDtsTimeStampOptions;
        }

        public final byte[] sign(InputStream object) throws IOException {
            try {
                object = this.a.getTSAClient().stampEx((InputStream)object, this.a);
            }
            catch (TSAException tSAException) {
                a.debug("Unable save envelope! Got an exception " + tSAException.getMessage());
                throw new IOException("Unable save envelope! Got an exception " + tSAException.getMessage(), tSAException);
            }
            return object;
        }
    }
}

