/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils;

import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;

public class CertificateUtils {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final I18N b = I18N.getInstance("esecurity/crypto/gui/theme/i18n/i18n");

    public static void exportCertificate(Certificate object, View object2) {
        if (object != null) {
            object2 = new FileDialog((View)object2, b.get("certificate_details_form_save_certificate_as", new Object[0]), new String[]{".cer", ".*"});
            ((FileDialog)object2).setInitialFileName(object.getName() + ".cer");
            ((FileDialog)object2).setInitialDirectory(System.getProperty("user.home"));
            object2 = ((FileDialog)object2).showSaveDialog();
            if (object2 == null) {
                return;
            }
            try {
                object2 = new FileOutputStream((File)object2);
                Throwable throwable = null;
                try {
                    ((FileOutputStream)object2).write(object.getInternalCert().getEncoded());
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((FileOutputStream)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((FileOutputStream)object2).close();
                        }
                        throw throwable3;
                    }
                }
                ((FileOutputStream)object2).close();
            }
            catch (IOException | CertificateEncodingException exception) {
                a.error("error in exporting certificate: ", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    public static boolean isCipherCertificate(Certificate certificate) {
        byte by = (byte)(certificate.getKeyUsageBits() % 256);
        return (by & 0xC) > 0;
    }
}

