/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.OsCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SWTLoader {
    private static final Logger logger = LoggerFactory.getLogger(SWTLoader.class);
    private static final List<String> resources = new ArrayList<String>();
    URLClassLoader cl = null;

    public SWTLoader() throws IOException {
        URL[] urls = this.getLibs().toArray(new URL[0]);
        this.cl = URLClassLoader.newInstance(urls, SWTLoader.class.getClassLoader().getParent());
    }

    private List<URL> getLibs() {
        ArrayList<URL> ret = new ArrayList<URL>();
        File libFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + "swt-utils");
        String bitness = System.getProperty("sun.arch.data.model");
        String os = "";
        switch (OsCheck.getOperatingSystemType()) {
            case Windows: {
                os = bitness.equals("32") ? "win32" : "win64";
                break;
            }
            case Linux: {
                os = bitness.equals("32") ? "linux32" : "linux64";
                break;
            }
            case MacOS: {
                os = "osx";
            }
        }
        try {
            for (String lib : resources) {
                String libRes = MessageFormat.format(lib, os);
                URL libUrl = SWTLoader.class.getResource(libRes);
                MessageDigest digestEngine = MessageDigest.getInstance("SHA-256");
                if (libUrl == null) continue;
                String fileName = libRes.substring(libRes.lastIndexOf("/") + 1);
                if (!libFolder.exists()) {
                    libFolder.mkdirs();
                }
                try (InputStream is = libUrl.openStream();){
                    int read;
                    byte[] buff = new byte[8192];
                    while ((read = is.read(buff)) != -1) {
                        digestEngine.update(buff, 0, read);
                    }
                }
                byte[] contentHash = digestEngine.digest();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < contentHash.length; ++i) {
                    String s;
                    int b = contentHash[i];
                    if (b < 0) {
                        b += 256;
                    }
                    if ((s = Integer.toHexString(b)).length() % 2 != 0) {
                        sb.append('0');
                    }
                    sb.append(s);
                }
                String fileHashName = sb.toString();
                File hashFile = new File(String.format("%s%s%s_%s.jar", libFolder, File.separator, fileName.replace(".jar", ""), fileHashName));
                if (!hashFile.exists()) {
                    try (InputStream is = libUrl.openStream();){
                        Files.copy(is, hashFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                ret.add(hashFile.toURI().toURL());
            }
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    public Class getClass(String className, boolean tryParent) throws ClassNotFoundException {
        Class<?> objReturn = null;
        try {
            if (tryParent) {
                objReturn = this.cl.getParent().loadClass(className);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        if (objReturn == null) {
            return this.cl.loadClass(className);
        }
        return objReturn;
    }

    public Object getProxy(String className, InvocationHandler ih) {
        try {
            Class[] classess = new Class[]{this.cl.loadClass(className)};
            return Proxy.newProxyInstance(this.cl, classess, ih);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.cl != null) {
                this.cl = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        resources.add("/swt/{0}/swt.jar");
        resources.add("/swt/BrowserFunction.jar");
    }
}

