/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Control;
import esecurity.desktop.swt.DropTargetEvent;
import esecurity.desktop.swt.DropTargetListener;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import esecurity.desktop.swt.Transfer;
import esecurity.desktop.swt.Widget;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DropTarget
extends Widget {
    private static final Logger logger = LoggerFactory.getLogger(DropTarget.class);

    public DropTarget(Control control, int style) {
        try {
            this.innerObject = SWTClass.DropTarget.getRef();
            this.innerObject.init(control.innerObject.getObj(), style);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setTransfer(Transfer ... transferAgents) {
        try {
            Object array = Array.newInstance(SWTClass.Transfer.getClss(), transferAgents.length);
            for (int i = 0; i < transferAgents.length; ++i) {
                Array.set(array, i, transferAgents[i].innerObject.getObj());
            }
            this.innerObject.callMethod("setTransfer", array);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void addDropListener(final DropTargetListener listener) {
        try {
            Object p = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.DropTargetListener.getClss()}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    switch (method.getName()) {
                        case "drop": {
                            listener.drop(new DropTargetEvent(args[0]));
                            break;
                        }
                        case "dragEnter": {
                            listener.dragEnter(new DropTargetEvent(args[0]));
                            break;
                        }
                        case "dragLeave": {
                            listener.dragLeave(new DropTargetEvent(args[0]));
                            break;
                        }
                        case "dragOperationChanged": {
                            listener.dragOperationChanged(new DropTargetEvent(args[0]));
                            break;
                        }
                        case "dragOver": {
                            listener.dragOver(new DropTargetEvent(args[0]));
                            break;
                        }
                        case "dropAccept": {
                            listener.dropAccept(new DropTargetEvent(args[0]));
                        }
                    }
                    return null;
                }
            });
            this.innerObject.callMethod("addDropListener", p);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }
}

